/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.desktop;

import com.mathworks.ide.desktop.DTApplication;
import com.mathworks.ide.desktop.DTClient;
import com.mathworks.ide.desktop.DTDockManager;
import com.mathworks.ide.desktop.DTDockPath;
import com.mathworks.ide.desktop.DTMainFrame;
import com.mathworks.ide.desktop.DTMenuBar;
import com.mathworks.mwt.MWCheckboxMenuItem;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandCenterOwner;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.services.Prefs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class Desktop
implements MWCommandCenterOwner,
MWCommandTarget {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.desktop.resources.RES_Desktop");
    protected DTMainFrame fDTMainFrame;
    private DTDockManager fDockManager;
    protected MWCommandCenter fCenter;
    protected Vector fClients;
    protected String fDTName;
    private String fErrorString;

    public Desktop(String string, boolean bl) {
        if (!this.isDesktopAllowed()) {
            throw new IllegalStateException("Cannot create a MATLAB Desktop.");
        }
        this.fCenter = new MWCommandCenter((MWCommandTarget)this);
        try {
            this.setDesktop();
        }
        catch (Exception exception) {
            return;
        }
        this.startSplash();
        this.fDockManager = new DTDockManager(this);
        this.fDTMainFrame = this.createMainFrame(string);
        this.fClients = new Vector(10);
        this.fDTName = string;
        this.stopSplash();
        if (!this.restoreDesktop(Prefs.getPropertyDirectory(), this.fDTName)) {
            this.setDefaultDesktop();
        }
        this.fDTMainFrame.setVisible(true);
        ((Component)((Object)this.fDTMainFrame)).repaint();
    }

    public DTClient addClient(DTClient dTClient, boolean bl) {
        dTClient.setDesktop(this);
        dTClient.setInitialVisibility(bl);
        if (dTClient.isViewMenuEntry()) {
            MWCheckboxMenuItem mWCheckboxMenuItem = this.fDTMainFrame.addClient(dTClient, bl);
            dTClient.setMenuItem(mWCheckboxMenuItem);
        }
        this.fClients.addElement(dTClient);
        return dTClient;
    }

    public DTClient addClient(Component component, String string, String string2, boolean bl) {
        return this.addClient(component, new DTDockPath(this.fDTMainFrame.getDTContainer(), string), string2, bl);
    }

    public DTClient addClient(Component component, DTDockPath dTDockPath, String string, boolean bl) {
        DTClient dTClient = new DTClient(this, component, string, dTDockPath);
        this.addClient(dTClient, bl);
        if (bl) {
            dTClient.restore(true);
        }
        return dTClient;
    }

    public static DTClient addClient(Component component, DTDockPath dTDockPath, String string) {
        DTClient dTClient = new DTClient(null, component, string, dTDockPath);
        dTClient.restore(true);
        return dTClient;
    }

    public int removeClient(DTClient dTClient) {
        int n = dTClient.undock(true);
        if (n == 0) {
            MWCheckboxMenuItem mWCheckboxMenuItem = dTClient.getMenuItem();
            if (mWCheckboxMenuItem != null) {
                this.fDTMainFrame.removeClient(mWCheckboxMenuItem);
                dTClient.setMenuItem(null);
            }
            this.fClients.removeElement(dTClient);
            dTClient.setDesktop(null);
        }
        return n;
    }

    protected void setDesktop() throws Exception {
    }

    public int shutdownDesktop() {
        this.saveDesktop(this.fDTName, Prefs.getPropertyDirectory());
        this.fDTMainFrame.shutdownFrame();
        return this.getDockManager().terminateNotify();
    }

    public boolean showClient(String string) {
        boolean bl = false;
        DTClient dTClient = this.getDTClient(string);
        if (dTClient != null) {
            dTClient.restore(true);
            bl = true;
        }
        return bl;
    }

    public DTClient getDTClient(String string) {
        DTClient dTClient = null;
        if (this.fClients != null) {
            int n = 0;
            while (n < this.fClients.size()) {
                dTClient = (DTClient)this.fClients.elementAt(n);
                if (string.equals(dTClient.getTitle())) break;
                dTClient = null;
                ++n;
            }
        }
        return dTClient;
    }

    public Component getClient(String string) {
        Component component = null;
        DTClient dTClient = this.getDTClient(string);
        if (dTClient != null) {
            component = dTClient.getClientComponent();
        }
        return component;
    }

    DTDockManager getDockManager() {
        return this.fDockManager;
    }

    public int getDesktopVersion() {
        return 0;
    }

    public void setStatusText(String string) {
        if (this.fDTMainFrame != null) {
            this.fDTMainFrame.setStatusText(string);
        }
    }

    public void setDefaultMainFrameSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.fDTMainFrame.setSize(dimension.width * 3 / 4, dimension.height * 3 / 4);
        ((Component)((Object)this.fDTMainFrame)).setLocation(dimension.width / 8, dimension.height / 8);
    }

    public static void ensureFrameVisible(MWFrame mWFrame) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = mWFrame.getRestoredSize();
        if (dimension2.width > dimension.width || dimension2.height > dimension.height) {
            dimension2.width = dimension.width * 3 / 4;
            dimension2.height = dimension.height * 3 / 4;
            mWFrame.setRestoredSize(dimension2.width, dimension2.height);
        }
        Point point = mWFrame.getRestoredLocation();
        if (point.x > dimension.width || point.y > dimension.height || point.x < 0 || point.y < 0) {
            point.y = 10;
            point.x = 10;
            mWFrame.setRestoredLocation(point.x, point.y);
        }
    }

    public void setDefaultDesktop() {
        if (this.clearDesktop() == 0) {
            this.setDefaultMainFrameSize();
            this.fDTMainFrame.restoreMenuBar(null);
            this.setStatusText(sRes.getString("status.Ready"));
        }
    }

    public boolean reconfigureDesktop(String string, String string2) {
        boolean bl = false;
        if (this.clearDesktop() == 0 && !(bl = this.restoreDesktop(string, string2))) {
            this.setDefaultDesktop();
        }
        this.fDTMainFrame.restoreMenuBar(null);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.fDTMainFrame.setSize(dimension.width * 3 / 4, dimension.height * 3 / 4);
        ((Component)((Object)this.fDTMainFrame)).setLocation(dimension.width / 8, dimension.height / 8);
        ((Component)((Object)this.fDTMainFrame)).repaint();
        this.setStatusText(sRes.getString("status.Ready"));
        return bl;
    }

    public int clearDesktop() {
        int n = 0;
        try {
            if (this.fClients != null) {
                if (this.getDockManager().terminateNotify() == 0) {
                    Vector vector = (Vector)this.fClients.clone();
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        DTClient dTClient = (DTClient)enumeration.nextElement();
                        if (this.removeClient(dTClient) != 1) continue;
                        n = 1;
                    }
                } else {
                    n = 1;
                }
            }
        }
        catch (Exception exception) {
            this.fClients.removeAllElements();
        }
        DTMenuBar.resetNextCommandID();
        return n;
    }

    protected DTMainFrame createMainFrame(String string) {
        return new DTMainFrame(this, string);
    }

    public DTMainFrame getMainFrame() {
        return this.fDTMainFrame;
    }

    public void doCommand(int n) {
        if (this.fCenter.getCommandEnabled(n)) {
            DTClient dTClient;
            DTClient dTClient2 = null;
            int n2 = 0;
            while (n2 < this.fClients.size()) {
                dTClient = (DTClient)this.fClients.elementAt(n2);
                if (n == dTClient.getCommandID()) {
                    dTClient2 = dTClient;
                    break;
                }
                ++n2;
            }
            if (dTClient2 != null && dTClient2.toggleViewState() == 1 && (dTClient = dTClient2.getMenuItem()) != null) {
                dTClient.setEnabled(true);
            }
        }
    }

    public MWCommandCenter getCommandCenter() {
        return this.fCenter;
    }

    void startSplash() {
    }

    void stopSplash() {
    }

    Component createComponentFromClass(String string) {
        Component component = null;
        try {
            Class<?> clazz = Class.forName(string);
            component = (Component)clazz.newInstance();
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{string};
            System.out.println(MessageFormat.format(sRes.getString("error.UnableToCreateClass"), objectArray));
        }
        return component;
    }

    public void saveDesktop(String string, String string2) {
        Object object;
        int n;
        Serializable serializable;
        Object object2;
        Vector<Object> vector = new Vector<Object>(this.fClients.size());
        String string3 = System.getProperties().getProperty("user.name");
        if (string3 != null && string3.equals("batserve")) {
            return;
        }
        DTDockPath.resetContainerMaps();
        int n2 = 0;
        while (n2 < this.fClients.size()) {
            object2 = (DTClient)this.fClients.elementAt(n2);
            serializable = ((DTClient)object2).getClientComponent();
            n = 1;
            if (serializable instanceof DTApplication) {
                n = ((DTApplication)((Object)serializable)).desktopSaveAction();
            }
            if (n == 1) {
                vector.addElement(object2);
            }
            ++n2;
        }
        object2 = this.fDockManager.getRestorationOrder();
        serializable = (Vector)((Vector)object2).clone();
        n = 0;
        while (n < ((Vector)serializable).size()) {
            object = ((Vector)serializable).elementAt(n);
            if (!vector.contains(object)) {
                ((Vector)object2).removeElement(object);
            }
            ++n;
        }
        serializable = null;
        try {
            object = new File(string2, String.valueOf(string) + ".ini");
            FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(Integer.toString(this.getDesktopVersion()));
            bufferedWriter.newLine();
            Point point = this.fDTMainFrame.getRestoredLocation();
            Dimension dimension = this.fDTMainFrame.getRestoredSize();
            bufferedWriter.write(Integer.toString(point.x));
            bufferedWriter.newLine();
            bufferedWriter.write(Integer.toString(point.y));
            bufferedWriter.newLine();
            bufferedWriter.write(Integer.toString(dimension.width));
            bufferedWriter.newLine();
            bufferedWriter.write(Integer.toString(dimension.height));
            bufferedWriter.newLine();
            Boolean bl = new Boolean(this.fDTMainFrame.isMaximized());
            bufferedWriter.write(bl.toString());
            bufferedWriter.newLine();
            bl = new Boolean(this.fDTMainFrame.isMinimized());
            bufferedWriter.write(bl.toString());
            bufferedWriter.newLine();
            bufferedWriter.write(Integer.toString(vector.size()));
            bufferedWriter.newLine();
            bufferedWriter.write(Integer.toString(((Vector)object2).size()));
            bufferedWriter.newLine();
            int n3 = 0;
            while (n3 < ((Vector)object2).size()) {
                bufferedWriter.write(Integer.toString(vector.indexOf(((Vector)object2).elementAt(n3))));
                bufferedWriter.newLine();
                ++n3;
            }
            int n4 = 0;
            while (n4 < vector.size()) {
                DTClient dTClient = (DTClient)vector.elementAt(n4);
                dTClient.saveDesktopClient(bufferedWriter, fileOutputStream);
                ++n4;
            }
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
                return;
            }
        }
        catch (Exception exception) {
            System.out.println(sRes.getString("error.FailureDuringSave"));
        }
    }

    public boolean restoreDesktop(String string, String string2) {
        boolean bl = false;
        File file = null;
        FileInputStream fileInputStream = null;
        String string3 = System.getProperties().getProperty("user.name");
        if (string3 != null && string3.equals("batserve")) {
            return bl;
        }
        try {
            file = new File(string, String.valueOf(string2) + ".ini");
            fileInputStream = new FileInputStream(file);
        }
        catch (Exception exception) {
            return bl;
        }
        try {
            DTClient dTClient = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            n4 = Integer.parseInt(bufferedReader.readLine());
            if (n4 != this.getDesktopVersion()) {
                throw new Exception();
            }
            n = Integer.parseInt(bufferedReader.readLine());
            n2 = Integer.parseInt(bufferedReader.readLine());
            this.fDTMainFrame.setRestoredLocation(n, n2);
            n = Integer.parseInt(bufferedReader.readLine());
            n2 = Integer.parseInt(bufferedReader.readLine());
            this.fDTMainFrame.setRestoredSize(n, n2);
            Desktop.ensureFrameVisible(this.fDTMainFrame);
            Boolean.valueOf(bufferedReader.readLine()).booleanValue();
            Boolean.valueOf(bufferedReader.readLine()).booleanValue();
            n3 = Integer.parseInt(bufferedReader.readLine());
            int n5 = Integer.parseInt(bufferedReader.readLine());
            int[] nArray = new int[n5];
            int n6 = 0;
            while (n6 < n5) {
                nArray[n6] = Integer.parseInt(bufferedReader.readLine());
                ++n6;
            }
            int n7 = 0;
            while (n7 < n3) {
                dTClient = DTClient.createDesktopClient(this, bufferedReader);
                if (dTClient == null) {
                    throw new Exception();
                }
                ++n7;
            }
            this.restoreAllClients(n5, nArray);
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
            System.out.println(sRes.getString("error.ConfigFileMissingOrOld"));
        }
        return bl;
    }

    private void restoreAllClients(int n, int[] nArray) {
        DTClient dTClient = null;
        int n2 = 0;
        while (n2 < n) {
            dTClient = (DTClient)this.fClients.elementAt(nArray[n2]);
            dTClient.restore(false);
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            dTClient = (DTClient)this.fClients.elementAt(nArray[n3]);
            dTClient.postRestoreFixup();
            ++n3;
        }
        this.fDockManager.makeAllFramesVisible();
    }

    protected boolean isDesktopAllowed() {
        return true;
    }
}

