/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.desktop;

import com.mathworks.ide.desktop.DTClientFrame;
import com.mathworks.ide.desktop.DTDockManager;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWImageResource;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWToolTip;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;

class DTTitleBar
extends MWPanel {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.desktop.resources.RES_Desktop");
    private MWButton fCloseButton;
    private MWButton fPopOutButton;
    private MWLabel fTitleBarLabel;
    private DTClientFrame fClientFrame;

    public DTTitleBar(DTClientFrame dTClientFrame) {
        MWImageResource mWImageResource = null;
        Rectangle rectangle = null;
        ((Container)((Object)this)).setLayout(null);
        this.setInsets(new Insets(0, 0, 1, 0));
        this.setOpaqueInsets(false);
        this.fClientFrame = dTClientFrame;
        this.fTitleBarLabel = new MWLabel();
        ((Container)((Object)this)).add((Component)this.fTitleBarLabel);
        if (PlatformInfo.getAppearance() != 0) {
            this.fTitleBarLabel.setFont(new Font("Dialog", 1, 10));
        } else {
            this.fTitleBarLabel.setFont(new Font("SansSerif", 1, 10));
        }
        mWImageResource = new MWImageResource("/com/mathworks/mwt/resources/undock.gif");
        this.fPopOutButton = new MWButton(mWImageResource);
        this.fPopOutButton.setActionCommand("pop out");
        this.fPopOutButton.addActionListener((ActionListener)dTClientFrame);
        this.fPopOutButton.setFocusBehavior(false);
        this.fPopOutButton.setName("popoutbutton");
        ((Container)((Object)this)).add((Component)this.fPopOutButton);
        rectangle = this.fPopOutButton.getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        new MWToolTip((Component)this.fPopOutButton, sRes.getString("tooltip.UndockfromDesktop"), rectangle);
        mWImageResource = new MWImageResource("/com/mathworks/mwt/resources/closebox.gif");
        this.fCloseButton = new MWButton(mWImageResource);
        this.fCloseButton.setActionCommand("close");
        this.fCloseButton.addActionListener((ActionListener)dTClientFrame);
        this.fCloseButton.setFocusBehavior(false);
        this.fCloseButton.setName("closebutton");
        ((Container)((Object)this)).add((Component)this.fCloseButton);
        rectangle = this.fCloseButton.getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        new MWToolTip((Component)this.fCloseButton, sRes.getString("tooltip.Close"), rectangle);
        this.setActive(false);
    }

    public void addDockListeners() {
        DTDockManager dTDockManager;
        if (this.fClientFrame != null && (dTDockManager = this.fClientFrame.getDTContainer().getDTDockManager()) != null) {
            this.fTitleBarLabel.addMouseListener(dTDockManager);
            this.fTitleBarLabel.addMouseMotionListener(dTDockManager);
            ((Component)((Object)this)).addMouseListener(dTDockManager);
            ((Component)((Object)this)).addMouseMotionListener(dTDockManager);
        }
    }

    public void removeDockListeners() {
        DTDockManager dTDockManager;
        if (this.fClientFrame != null && (dTDockManager = this.fClientFrame.getDTContainer().getDTDockManager()) != null) {
            this.fTitleBarLabel.removeMouseListener(dTDockManager);
            this.fTitleBarLabel.removeMouseMotionListener(dTDockManager);
            ((Component)((Object)this)).removeMouseListener(dTDockManager);
            ((Component)((Object)this)).removeMouseMotionListener(dTDockManager);
        }
    }

    public void setActive(boolean bl) {
        if (bl) {
            Color color = Decorations.getColor((int)15);
            super.setBackground(color);
            this.fTitleBarLabel.setBackground(color);
            this.fTitleBarLabel.setForeground(Decorations.getColor((int)16));
        } else {
            Color color = Decorations.getColor((int)17);
            super.setBackground(color);
            this.fTitleBarLabel.setBackground(color);
            this.fTitleBarLabel.setForeground(Decorations.getColor((int)18));
        }
        ((Component)((Object)this)).repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 20);
    }

    public void setTitle(String string) {
        this.fTitleBarLabel.setText(string);
        ((Component)((Object)this)).repaint();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.layout(n3, n4);
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.layout(n, n2);
    }

    private void layout(int n, int n2) {
        this.fTitleBarLabel.setBounds(3, 3, n - n2 - n2 - 3 - 3 - 3, n2 - 3 - 3 - 3);
        this.fPopOutButton.setBounds(n - n2 - n2 + 2, 2, n2 - 3, n2 - 5);
        this.fCloseButton.setBounds(n - n2 + 1, 2, n2 - 3, n2 - 5);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = ((Component)((Object)this)).getSize();
        graphics.setColor(Decorations.getColor((int)6));
        graphics.drawLine(0, dimension.height - 1, dimension.width, dimension.height - 1);
    }
}

