/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.desktop;

import com.mathworks.ide.CommandHistory;
import com.mathworks.ide.browsers.FileBrowser;
import com.mathworks.ide.desktop.DTClient;
import com.mathworks.ide.desktop.DTContainer;
import com.mathworks.ide.desktop.DTDockManager;
import com.mathworks.ide.desktop.DTExternalFrame;
import com.mathworks.ide.desktop.DTMainFrame;
import com.mathworks.ide.desktop.DTMenu;
import com.mathworks.ide.desktop.MLDesktop;
import com.mathworks.ide.editor.EditorApplication;
import com.mathworks.ide.editor.EditorMRUFiles;
import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.ide.prefs.PrefsDialog;
import com.mathworks.ide.workspace.WorkspaceBrowser;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mwt.MWCheckboxMenuItem;
import com.mathworks.mwt.MWClipboardListener;
import com.mathworks.mwt.MWClipboardMonitor;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWFrameProxy;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWMenuComponent;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandSource;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.dialog.MWAlert;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.mwt.window.WindowRegistry;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;

public class DTMenuBar
implements MWCommandTarget,
MWClipboardListener {
    public static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.desktop.resources.RES_Desktop");
    public static final int IDNEWMFILE = 100;
    public static final int IDNEWFIG = 110;
    public static final int IDNEWMODEL = 120;
    public static final int IDNEWGUI = 125;
    public static final int IDOPEN = 130;
    public static final int IDCLOSE = 135;
    public static final int IDIMPORT = 450;
    public static final int IDSAVEWORKSPACE = 460;
    public static final int IDPATHBROWSER = 500;
    public static final int IDPREFS = 510;
    public static final int IDPRINT = 550;
    public static final int IDPRINTSEL = 560;
    public static final int IDCLOSEWINDOW = 700;
    public static final int IDQUIT = 701;
    public static final int IDUNDO = 800;
    public static final int IDREDO = 810;
    public static final int IDCUT = 900;
    public static final int IDCOPY = 910;
    public static final int IDPASTE = 920;
    public static final int IDPASTESPECIAL = 930;
    public static final int IDSELECTALL = 1060;
    public static final int IDDELETE = 1070;
    public static final int IDCLEAR_CW = 1250;
    public static final int IDCLEAR_CH = 1260;
    public static final int IDCLEAR_WS = 1270;
    public static final int IDDEFCONFIG = 2000;
    public static final int IDMOLERMODE = 2001;
    public static final int IDSIMPLECONFIG = 2002;
    public static final int IDSHORTCONFIG = 2003;
    public static final int IDTALLCONFIG = 2004;
    public static final int ID5PANELCONFIG = 2005;
    public static final int IDUNDOCK = 2010;
    public static final int IDDOCK = 2020;
    public static final int IDWEBSITE = 3000;
    public static final int IDTECHSUPP = 3001;
    public static final int IDNEWPROD = 3002;
    public static final int IDJOINACCESS = 3004;
    public static final int IDHELPBROWSER = 4000;
    public static final int IDFULLPRODHELP = 4001;
    public static final int IDMATLABHELP = 4002;
    public static final int IDHELPDESKTOP = 4050;
    public static final int IDHELPONCOMPONENT = 4051;
    public static final int IDDEMOS = 4100;
    public static final int IDABOUTML = 4200;
    public static final int IDSIMULINK = 70;
    private static int sNextCommandID = 2100;
    private static Matlab sMatlab = new Matlab(new MWLooper("DTMenuBar"));
    private MWCommandCenter fCenter;
    private DTExternalFrame fExternalFrame;
    private boolean fDesktopExists;
    private boolean fIsMainFrame = false;
    private boolean fViewMenuItemsAdded = false;
    private MWMenuBar fMenubar;
    private MWFrameProxy fFrameProxy;
    private String fName = "";
    private static Vector fComponentMenuItemVector = new Vector();
    private DTMenu fFileBrowserViewMenu;
    private DTMenu fWorkspaceBrowserViewMenu;
    private static boolean sMatlabReady;

    public DTMenuBar(MWCommandCenter mWCommandCenter, boolean bl, boolean bl2) {
        if (mWCommandCenter == null) {
            mWCommandCenter = new MWCommandCenter((MWCommandTarget)this);
        }
        this.fMenubar = new MWMenuBar(mWCommandCenter);
        this.fCenter = mWCommandCenter;
        this.fDesktopExists = bl;
        this.fIsMainFrame = bl2;
        MWClipboardMonitor.addListener((MWClipboardListener)this);
    }

    public static DTMenuBar createComponentMenubar(MWFrameProxy mWFrameProxy) {
        DTMenuBar dTMenuBar = new DTMenuBar(null, false, false);
        dTMenuBar.fFrameProxy = mWFrameProxy;
        dTMenuBar.fName = mWFrameProxy.getTitle();
        dTMenuBar.createMenubar(null);
        return dTMenuBar;
    }

    public static DTMenuBar createDesktopMenubar(DTExternalFrame dTExternalFrame, MWCommandCenter mWCommandCenter) {
        boolean bl = false;
        if (dTExternalFrame != null && dTExternalFrame instanceof DTMainFrame) {
            bl = true;
        }
        DTMenuBar dTMenuBar = new DTMenuBar(mWCommandCenter, true, bl);
        dTMenuBar.createMenubar(dTExternalFrame);
        return dTMenuBar;
    }

    public MWMenuBar getMenubar() {
        return this.fMenubar;
    }

    public boolean isMainFrame() {
        return this.fIsMainFrame;
    }

    public MWMenuBar createMenubar(DTExternalFrame dTExternalFrame) {
        DTMenu dTMenu;
        this.fExternalFrame = dTExternalFrame;
        if (dTExternalFrame != null) {
            this.fName = this.getClientName(dTExternalFrame);
        }
        DTMenu dTMenu2 = new DTMenu(sRes.getString("menu.File"), this.fCenter);
        if (!EditorApplication.isStandalone()) {
            dTMenu = DTMenuBar.createNewSubmenu(this.fCenter, true);
            dTMenu2.insert((MWMenuComponent)dTMenu, 0);
        } else {
            dTMenu2.addMenuItem(sRes.getString("menuitem.NewMfile"), 100);
        }
        dTMenu2.addMenuItem(sRes.getString("menuitem.Open"), 130);
        dTMenu2.addMenuItem(String.valueOf(sRes.getString("menuitem.Close")) + this.fName, 135);
        dTMenu2.addMenuItem(sRes.getString("menuitem.Preferences"), 510);
        if (MLDesktop.getMLDesktop() != null) {
            this.fCenter.setCommandEnabled(510, sMatlabReady);
        }
        if (!EditorApplication.isStandalone()) {
            dTMenu2.addMenuItem(DTMenuBar.getMenuLabel(460), 460);
            dTMenu2.addMenuItem(DTMenuBar.getMenuLabel(450), 450);
            dTMenu2.addMenuItem(sRes.getString("menuitem.SetPath"), 500);
        }
        dTMenu2.addMenuItem(DTMenuBar.getMenuLabel(550), 550);
        dTMenu2.addMenuItem(DTMenuBar.getMenuLabel(560), 560);
        this.fCenter.setCommandEnabled(560, false);
        this.fCenter.setCommandEnabled(550, false);
        EditorMRUFiles.addToMenu(dTMenu2);
        dTMenu2.addMenuItem(sRes.getString("menuitem.ExitMATLAB"), 701);
        this.fMenubar.add((MWMenuComponent)dTMenu2);
        dTMenu2 = new DTMenu(sRes.getString("menu.Edit"), this.fCenter);
        this.createDefaultEditMenu(dTMenu2);
        this.fMenubar.add((MWMenuComponent)dTMenu2);
        this.fCenter.setCommandEnabled(800, false);
        this.fCenter.setCommandEnabled(810, false);
        this.fCenter.setCommandEnabled(900, false);
        this.fCenter.setCommandEnabled(910, false);
        this.fCenter.setCommandEnabled(920, false);
        this.fCenter.setCommandEnabled(1060, false);
        this.fCenter.setCommandEnabled(1070, false);
        if (!PlatformInfo.isUnix()) {
            this.fCenter.setCommandEnabled(930, Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this) != null);
        }
        if (MLDesktop.getMLDesktop() != null) {
            dTMenu2 = new DTMenu(sRes.getString("menu.View"), this.fCenter);
            this.addViewMenuItems(dTMenu2);
            dTMenu = new DTMenu(sRes.getString("menu.DesktopLayout"), this.fCenter);
            dTMenu.addMenuItem(sRes.getString("menuitem.Default"), 2000);
            dTMenu.addMenuItem(sRes.getString("menuitem.CommandWindowOnly"), 2001);
            dTMenu.addMenuItem(sRes.getString("menuitem.Simple"), 2002);
            dTMenu.addMenuItem(sRes.getString("menuitem.ShortHistory"), 2003);
            dTMenu.addMenuItem(sRes.getString("menuitem.TallHistory"), 2004);
            dTMenu.addMenuItem(sRes.getString("menuitem.FivePanel"), 2005);
            dTMenu2.insert((MWMenuComponent)dTMenu, 0);
            this.fMenubar.add((MWMenuComponent)dTMenu2);
        }
        if (!EditorApplication.isStandalone()) {
            dTMenu2 = new DTMenu(sRes.getString("menu.Web"), this.fCenter);
            dTMenu2.addMenuItem(sRes.getString("menuitem.TheMathWorksWebSite"), 3000);
            dTMenu2.addMenuItem(sRes.getString("menuitem.TechnicalSupportKnowledgeBase"), 3001);
            dTMenu2.addMenuItem(sRes.getString("menuitem.Products"), 3002);
            if (Matlab.isStudentVersion()) {
                dTMenu2.addMenuItem(sRes.getString("menuitem.StudentVersionRegistration"), 3004);
            } else {
                dTMenu2.addMenuItem(sRes.getString("menuitem.Membership"), 3004);
            }
            this.fMenubar.add((MWMenuComponent)dTMenu2);
        }
        if (this.fDesktopExists) {
            this.fMenubar.add((MWMenuComponent)WindowRegistry.getRegistry().getWindowMenu((MWWindowOwner)dTExternalFrame));
        }
        dTMenu2 = new DTMenu(sRes.getString("menu.Help"), this.fCenter);
        if (!EditorApplication.isStandalone()) {
            dTMenu2.addMenuItem(sRes.getString("menuitem.MATLABHelp"), 4002);
            dTMenu2.addMenuItem(sRes.getString("menuitem.Demos"), 4100);
            if (this.fIsMainFrame) {
                dTMenu2.addMenuItem(sRes.getString("menuitem.FullProductFamilyHelp"), 4001);
                dTMenu2.addMenuItem(sRes.getString("menuitem.UsingtheDesktop"), 4050);
            }
            this.addContextSpecificHelpMenu(dTMenu2);
        }
        dTMenu2.addMenuItem(sRes.getString("menuitem.AboutMATLAB"), 4200);
        if (MLDesktop.getMLDesktop() != null) {
            this.fCenter.setCommandEnabled(4200, sMatlabReady);
        }
        this.fMenubar.add((MWMenuComponent)dTMenu2);
        return this.fMenubar;
    }

    public void reset() {
        this.fName = this.getClientName(this.fExternalFrame);
        int n = 0;
        while (n < this.fMenubar.getMenuCount()) {
            MWMenu mWMenu = this.fMenubar.getMenu(n);
            if (mWMenu instanceof DTMenu) {
                DTMenu dTMenu = (DTMenu)mWMenu;
                if (dTMenu.getLabel().equals(sRes.getString("menu.File"))) {
                    Object[] objectArray = new Object[]{this.fName};
                    dTMenu.addMenuItem(MessageFormat.format(sRes.getString("menuitem.CloseThisComponent"), objectArray), 135);
                    this.fCenter.setCommandEnabled(135, !this.fName.equals(""));
                    dTMenu.remove(0);
                    if (!EditorApplication.isStandalone()) {
                        DTMenu dTMenu2 = DTMenuBar.createNewSubmenu(this.fCenter, true);
                        dTMenu.addMenu(dTMenu2);
                    } else {
                        dTMenu.addMenuItem(sRes.getString("menuitem.NewMfile"), 100);
                    }
                    dTMenu.addMenuItem(DTMenuBar.getMenuLabel(550), 550);
                    dTMenu.addMenuItem(DTMenuBar.getMenuLabel(560), 560);
                } else if (dTMenu.getLabel().equals(sRes.getString("menu.Edit"))) {
                    this.createDefaultEditMenu(dTMenu);
                } else if (dTMenu.getLabel().equals(sRes.getString("menu.View"))) {
                    this.addViewMenuItems(dTMenu);
                } else if (dTMenu.getLabel().equals(sRes.getString("menu.Help"))) {
                    this.addContextSpecificHelpMenu(dTMenu);
                }
            }
            ++n;
        }
    }

    private void createDefaultEditMenu(DTMenu dTMenu) {
        dTMenu.addMenuItem(DTMenuBar.getMenuLabel(800), 800);
        dTMenu.addMenuItem(DTMenuBar.getMenuLabel(810), 810);
        dTMenu.addMenuItem(DTMenuBar.getMenuLabel(900), 900);
        dTMenu.addMenuItem(DTMenuBar.getMenuLabel(910), 910);
        dTMenu.addMenuItem(DTMenuBar.getMenuLabel(920), 920);
        dTMenu.addMenuItem(DTMenuBar.getMenuLabel(930), 930);
        dTMenu.addMenuItem(DTMenuBar.getMenuLabel(1060), 1060);
        dTMenu.addMenuItem(DTMenuBar.getMenuLabel(1070), 1070);
        if (!EditorApplication.isStandalone()) {
            dTMenu.addMenuItem(DTMenuBar.getMenuLabel(1250), 1250);
            dTMenu.addMenuItem(DTMenuBar.getMenuLabel(1260), 1260);
            dTMenu.addMenuItem(DTMenuBar.getMenuLabel(1270), 1270);
        }
    }

    private void addContextSpecificHelpMenu(DTMenu dTMenu) {
        Object[] objectArray = new Object[]{this.fName};
        String string = MessageFormat.format(sRes.getString("menuitem.UsingThis"), objectArray);
        if (this.fName.equals(sRes.getString("Help"))) {
            string = sRes.getString("menuitem.UsingHelp");
        } else if (this.fName.equals(sRes.getString("CurrentDirectory"))) {
            string = sRes.getString("menuitem.UsingtheCurrentDirectoryBrowser");
        } else if (this.fName.equals(sRes.getString("Workspace"))) {
            string = sRes.getString("menuitem.UsingtheWorkspaceBrowser");
        } else if (this.fName.startsWith("Array Editor")) {
            string = sRes.getString("menuitem.UsingtheArrayEditor");
        } else if (this.fName.equals("")) {
            string = sRes.getString("menuitem.UsingtheCurrentWindow");
        }
        dTMenu.addMenuItem(string, 4051);
        this.fCenter.setCommandEnabled(4051, !this.fName.equals(""));
    }

    public static MWCheckboxMenuItem addComponentToViewMenu(String string, boolean bl) {
        MWCheckboxMenuItem mWCheckboxMenuItem = new MWCheckboxMenuItem(string, bl);
        mWCheckboxMenuItem.setCommand(sNextCommandID);
        MLDesktop.getMLDesktop().getCommandCenter().addCommandSource((MWCommandSource)mWCheckboxMenuItem, sNextCommandID++);
        fComponentMenuItemVector.addElement(mWCheckboxMenuItem);
        return mWCheckboxMenuItem;
    }

    public static void removeComponentFromViewMenu(MWCheckboxMenuItem mWCheckboxMenuItem) {
        fComponentMenuItemVector.removeElement(mWCheckboxMenuItem);
        MLDesktop.getMLDesktop().getCommandCenter().removeCommandSource((MWCommandSource)mWCheckboxMenuItem, mWCheckboxMenuItem.getCommand());
    }

    static void resetNextCommandID() {
        sNextCommandID = 2100;
    }

    public static DTMenu createNewSubmenu(MWCommandCenter mWCommandCenter, boolean bl) {
        DTMenu dTMenu = new DTMenu(sRes.getString("menuitem.New"), mWCommandCenter);
        if (bl) {
            dTMenu.addMenuItem(sRes.getString("menuitem.Mfile"), 100);
        } else {
            dTMenu.addMenuItem(sRes.getString("menuitem.Mfile"), 100, -1);
        }
        dTMenu.addMenuItem(sRes.getString("menuitem.Figure"), 110);
        dTMenu.addMenuItem(sRes.getString("menuitem.Model"), 120);
        dTMenu.addMenuItem(sRes.getString("menuitem.GUI"), 125);
        return dTMenu;
    }

    public void autoAddSeparators() {
        int n = 0;
        while (n < this.fMenubar.getMenuCount()) {
            MWMenu mWMenu = this.fMenubar.getMenu(n);
            if (mWMenu instanceof DTMenu) {
                DTMenu dTMenu = (DTMenu)mWMenu;
                dTMenu.autoAddSeparators();
            }
            ++n;
        }
    }

    public MWCommandCenter getCommandCenter() {
        return this.fCenter;
    }

    public static String getMenuLabel(int n) {
        switch (n) {
            case 800: {
                return sRes.getString("menuitem.Undo");
            }
            case 810: {
                return sRes.getString("menuitem.Redo");
            }
            case 900: {
                return sRes.getString("menuitem.Cut");
            }
            case 910: {
                return sRes.getString("menuitem.Copy");
            }
            case 920: {
                return sRes.getString("menuitem.Paste");
            }
            case 930: {
                return sRes.getString("menuitem.PasteSpecial");
            }
            case 1060: {
                return sRes.getString("menuitem.SelectAll");
            }
            case 1070: {
                return sRes.getString("menuitem.Delete");
            }
            case 450: {
                return sRes.getString("menuitem.ImportData");
            }
            case 550: {
                return sRes.getString("menuitem.Print");
            }
            case 560: {
                return sRes.getString("menuitem.PrintSelection");
            }
            case 460: {
                return sRes.getString("menuitem.SaveWorkspaceAs");
            }
            case 1250: {
                return sRes.getString("menuitem.ClearCommandWindow");
            }
            case 1260: {
                return sRes.getString("menuitem.ClearCommandHistory");
            }
            case 1270: {
                return sRes.getString("menuitem.ClearWorkspace");
            }
        }
        return "";
    }

    private void addViewMenuItems(DTMenu dTMenu) {
        DTMenu dTMenu2;
        Object object;
        Object[] objectArray = new Object[]{this.fName};
        if (this.fIsMainFrame) {
            dTMenu.addMenuItem(MessageFormat.format(sRes.getString("menuitem.Undock"), objectArray), 2010);
            this.fCenter.setCommandEnabled(2010, !this.fName.equals(""));
        } else if (MLDesktop.getMLDesktop() != null) {
            dTMenu.addMenuItem(MessageFormat.format(sRes.getString("menuitem.Dock"), objectArray), 2020);
        }
        if (!this.fViewMenuItemsAdded && fComponentMenuItemVector != null && fComponentMenuItemVector.size() > 0) {
            int n = 0;
            while (n < fComponentMenuItemVector.size()) {
                object = (MWCheckboxMenuItem)fComponentMenuItemVector.elementAt(n);
                dTMenu2 = new MWCheckboxMenuItem(object.getLabel(), object.getState());
                dTMenu.addCheckboxMenuItem((MWCheckboxMenuItem)dTMenu2, object.getCommand());
                MLDesktop.getMLDesktop().getCommandCenter().addCommandSource((MWCommandSource)dTMenu2, object.getCommand());
                ++n;
            }
            this.fViewMenuItemsAdded = true;
        }
        if (this.fIsMainFrame) {
            FileBrowser fileBrowser = FileBrowser.getFileBrowser();
            if (fileBrowser != null) {
                if (fileBrowser.isVisible()) {
                    object = fileBrowser.getViewMenu();
                    if (object != null && this.fFileBrowserViewMenu == null) {
                        dTMenu.addMenu((MWMenu)object);
                        this.fFileBrowserViewMenu = object;
                    }
                } else if (this.fFileBrowserViewMenu != null) {
                    dTMenu.remove((MWMenuComponent)this.fFileBrowserViewMenu);
                    this.fFileBrowserViewMenu = null;
                }
            }
            if ((object = WorkspaceBrowser.getWorkspaceBrowserIfExists()) != null) {
                if (object.isVisible()) {
                    dTMenu2 = object.getViewMenu();
                    if (dTMenu2 != null && this.fWorkspaceBrowserViewMenu == null) {
                        dTMenu.addMenu(dTMenu2);
                        this.fWorkspaceBrowserViewMenu = dTMenu2;
                    }
                } else if (this.fWorkspaceBrowserViewMenu != null) {
                    dTMenu.remove((MWMenuComponent)this.fWorkspaceBrowserViewMenu);
                    this.fWorkspaceBrowserViewMenu = null;
                }
            }
            if (dTMenu.getItem(dTMenu.getItemCount() - 1).getLabel().equals("-")) {
                dTMenu.remove(dTMenu.getItemCount() - 1);
            }
        }
    }

    static void setMatlabReady() {
        DTDockManager dTDockManager;
        sMatlabReady = true;
        MLDesktop mLDesktop = MLDesktop.getMLDesktop();
        if (mLDesktop != null && (dTDockManager = mLDesktop.getDockManager()) != null) {
            Vector vector = dTDockManager.getDTContainerList();
            if (dTDockManager != null) {
                int n = 0;
                while (n < vector.size()) {
                    DTExternalFrame dTExternalFrame;
                    DTContainer dTContainer = (DTContainer)vector.elementAt(n);
                    if (dTContainer != null && (dTExternalFrame = dTContainer.getContainingFrame()) != null) {
                        dTExternalFrame.enableCommand(4200, true);
                        dTExternalFrame.enableCommand(510, true);
                    }
                    ++n;
                }
            }
        }
    }

    static void setViewMenuItemState(MWCheckboxMenuItem mWCheckboxMenuItem, boolean bl) {
        Vector vector;
        int n = 0;
        while (n < fComponentMenuItemVector.size()) {
            vector = (MWCheckboxMenuItem)fComponentMenuItemVector.elementAt(n);
            if (vector.getLabel().equals(mWCheckboxMenuItem.getLabel())) {
                vector.setState(bl);
                break;
            }
            ++n;
        }
        vector = MLDesktop.getMLDesktop().getDockManager().getDTContainerList();
        int n2 = 0;
        while (n2 < vector.size()) {
            DTContainer dTContainer = (DTContainer)vector.elementAt(n2);
            MWFrame mWFrame = (MWFrame)dTContainer.getFrame();
            if (mWFrame != null) {
                MWMenuBar mWMenuBar = mWFrame.getMWMenuBar();
                int n3 = 0;
                while (n3 < mWMenuBar.getMenuCount()) {
                    MWMenu mWMenu = mWMenuBar.getMenu(n3);
                    if (mWMenu.getLabel().equals(sRes.getString("menu.View"))) {
                        int n4 = 0;
                        while (n4 < mWMenu.getItemCount()) {
                            MWCheckboxMenuItem mWCheckboxMenuItem2;
                            MWMenuComponent mWMenuComponent = mWMenu.getItem(n4);
                            if (mWMenuComponent instanceof MWCheckboxMenuItem && (mWCheckboxMenuItem2 = (MWCheckboxMenuItem)mWMenuComponent).getLabel().equals(mWCheckboxMenuItem.getLabel())) {
                                mWCheckboxMenuItem2.setState(bl);
                                break;
                            }
                            ++n4;
                        }
                    }
                    ++n3;
                }
            } else {
                System.out.println("error: frame is null");
            }
            ++n2;
        }
    }

    public void clearViewMenuItems() {
        this.fViewMenuItemsAdded = false;
    }

    private String getClientName(DTExternalFrame dTExternalFrame) {
        DTClient dTClient;
        String string = "";
        if (dTExternalFrame != null && (dTClient = dTExternalFrame.getDTContainer().getActiveClient()) != null) {
            string = dTClient.getShortName();
        }
        return string;
    }

    public void doCommand(int n) {
        MLDesktop mLDesktop = null;
        if (this.fCenter.getCommandEnabled(n)) {
            switch (n) {
                case 100: {
                    if (EditorApplication.isStandalone()) {
                        EditorApplication.newDocument();
                        return;
                    }
                    sMatlab.evalConsoleOutput("edit");
                    return;
                }
                case 110: {
                    sMatlab.evalConsoleOutput("figure");
                    return;
                }
                case 120: {
                    sMatlab.evalConsoleOutput("open_system(new_system);");
                    return;
                }
                case 125: {
                    sMatlab.evalConsoleOutput("guide");
                    return;
                }
                case 130: {
                    sMatlab.evalConsoleOutput("uiopen");
                    return;
                }
                case 135: {
                    if (this.fExternalFrame != null) {
                        DTClient dTClient = this.fExternalFrame.fDTContainer.getActiveClient();
                        if (dTClient != null) {
                            dTClient.undock(true);
                            return;
                        }
                    } else {
                        if (this.fFrameProxy == null) break;
                        this.fFrameProxy.setVisible(false);
                    }
                    return;
                }
                case 450: {
                    sMatlab.evalConsoleOutput("uiimport -file");
                    return;
                }
                case 460: {
                    sMatlab.evalConsoleOutput("uisave");
                    return;
                }
                case 510: {
                    this.doPrefs();
                    return;
                }
                case 700: {
                    if (this.fFrameProxy == null) break;
                    this.fFrameProxy.setVisible(false);
                    return;
                }
                case 1250: {
                    sMatlab.evalConsoleOutput("clc");
                    return;
                }
                case 1270: {
                    MWAlert mWAlert = new MWAlert((Frame)((Object)this.fExternalFrame), sRes.getString("MATLAB"), sRes.getString("msg.ClearWorkspace"), 3);
                    if (mWAlert.getReply() != 1) break;
                    sMatlab.evalConsoleOutput("clear");
                    return;
                }
                case 1260: {
                    MWAlert mWAlert = new MWAlert((Frame)((Object)this.fExternalFrame), sRes.getString("MATLAB"), CommandHistory.sRes.getString("AreYouSureDeleteEntireHistory"), 3);
                    if (mWAlert.getReply() != 1) break;
                    CommandHistory.deleteAllHistory();
                    return;
                }
                case 930: {
                    sMatlab.evalConsoleOutput("uiimport('-pastespecial')");
                    return;
                }
                case 500: {
                    sMatlab.evalConsoleOutput("pathtool;");
                    return;
                }
                case 701: {
                    sMatlab.evalConsoleOutput("exit");
                    return;
                }
                case 2000: {
                    mLDesktop = MLDesktop.getMLDesktop();
                    if (mLDesktop == null) break;
                    mLDesktop.setDefaultDesktop();
                    return;
                }
                case 2001: {
                    mLDesktop = MLDesktop.getMLDesktop();
                    if (mLDesktop == null) break;
                    mLDesktop.setMolerMode();
                    return;
                }
                case 2002: {
                    mLDesktop = MLDesktop.getMLDesktop();
                    if (mLDesktop == null) break;
                    mLDesktop.setSimpleLayout();
                    return;
                }
                case 2003: {
                    mLDesktop = MLDesktop.getMLDesktop();
                    if (mLDesktop == null) break;
                    mLDesktop.setShortLayout();
                    return;
                }
                case 2004: {
                    mLDesktop = MLDesktop.getMLDesktop();
                    if (mLDesktop == null) break;
                    mLDesktop.setTallLayout();
                    return;
                }
                case 2005: {
                    mLDesktop = MLDesktop.getMLDesktop();
                    if (mLDesktop == null) break;
                    mLDesktop.set5PanelLayout();
                    return;
                }
                case 3000: {
                    this.sendUrlToExternalBrowser("http://www.mathworks.com");
                    return;
                }
                case 3001: {
                    this.sendUrlToExternalBrowser("http://www.mathworks.com/support");
                    return;
                }
                case 3002: {
                    this.sendUrlToExternalBrowser("http://www.mathworks.com/products");
                    return;
                }
                case 3004: {
                    if (Matlab.isStudentVersion()) {
                        this.sendUrlToExternalBrowser("http://www.mathworks.com/student");
                        return;
                    }
                    this.sendUrlToExternalBrowser("http://www.mathworks.com/membership");
                    return;
                }
                case 4000: {
                    sMatlab.evalConsoleOutput("helpbrowser;");
                    return;
                }
                case 4001: {
                    sMatlab.evalConsoleOutput("doc;");
                    return;
                }
                case 4051: {
                    this.showHelpForComponent();
                    return;
                }
                case 4002: {
                    sMatlab.evalNoOutput("doc matlab/;");
                    return;
                }
                case 4100: {
                    sMatlab.evalConsoleOutput("demo;");
                    return;
                }
                case 4200: {
                    if (this.fExternalFrame == null) break;
                    int n2 = 0;
                    if (PlatformInfo.isWindows()) {
                        n2 = NativeJava.hWndFromComponent((Component)((Object)this.fExternalFrame));
                        NativeMatlab.nativeDisplayAboutBox((int)n2);
                        return;
                    }
                    Matlab.whenMatlabReady((Runnable)new doAboutBox());
                    return;
                }
            }
        }
    }

    private void sendUrlToExternalBrowser(String string) {
        Object[] objectArray = new Object[]{string, "-browser"};
        try {
            sMatlab.feval("web", objectArray);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void clipboardContentTypeChanged(Transferable transferable) {
        this.fCenter.setCommandEnabled(930, transferable != null);
    }

    private void showHelpForComponent() {
        String string = this.fName;
        if (string.startsWith("Array Editor")) {
            string = "Array Editor";
        }
        String string2 = "matlabenvironment_desktop";
        if (string.equals(sRes.getString("LaunchPad"))) {
            string2 = "matlabenvironment_productexplorer";
        } else if (string.equals(MLDesktop.getCommandWindowName())) {
            string2 = "matlabenvironment_commands";
        } else if (string.equals(sRes.getString("CommandHistory"))) {
            string2 = "matlabenvironment_commandhistory";
        } else if (string.equals(sRes.getString("Help"))) {
            string2 = "matlabenvironment_helpbrowser";
        } else if (string.equals(sRes.getString("Workspace"))) {
            string2 = "matlabenvironment_workspacebrowser";
        } else if (string.equals("Array Editor")) {
            string2 = "matlabenvironment_arrayeditor";
        } else if (string.equals(sRes.getString("CurrentDirectory"))) {
            string2 = "matlabenvironment_filebrowser";
        }
        HelpBrowser.getHelpBrowser().displayTopic(null, "matlab_env", string2, (Frame)((Object)this.fExternalFrame));
    }

    private void doPrefs() {
        String string = this.fName;
        if (string.equals("")) {
            PrefsDialog.showPrefsDialog();
            return;
        }
        if (string.startsWith("Array Editor")) {
            string = "Array Editor";
        }
        PrefsDialog.showPrefsDialog(string);
    }

    class doAboutBox
    implements Runnable {
        public void run() {
            NativeMatlab.nativeDisplayAboutBox((int)0);
        }

        doAboutBox() {
            DTMenuBar.this = DTMenuBar.this;
        }
    }
}

