/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.desktop;

import com.mathworks.ide.desktop.DTClient;
import com.mathworks.ide.desktop.DTContainer;
import com.mathworks.ide.desktop.DTDockManager;
import com.mathworks.ide.desktop.DTMainFrame;
import com.mathworks.ide.desktop.DTMenuBar;
import com.mathworks.ide.desktop.Desktop;
import com.mathworks.ide.editor.EditorViewContainer;
import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.mwt.MWCheckboxMenuItem;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWStatusBar;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandCenterOwner;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.util.NativeEvent;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.WindowListener;

public class DTExternalFrame
extends MWFrame
implements MWCommandCenterOwner,
MWCommandTarget,
MWWindowOwner {
    protected Desktop fDesktop;
    protected MWCommandCenter fCenter;
    protected DTContainer fDTContainer;
    protected MWPanel fDeskPanel;
    protected MWStatusBar fStatusBar;
    protected boolean fUpdate = true;
    protected boolean bWindowActivation = false;
    private boolean fFirstVisible = true;
    protected DTMenuBar fDesktopMenuBar;

    public DTExternalFrame(Desktop desktop, String string) {
        super(string);
        if (PlatformInfo.isWindows()) {
            this.setSize(500, 200);
        }
        if (desktop == null) {
            this.fDTContainer = new DTContainer(null);
        } else {
            this.fDesktop = desktop;
            this.fDTContainer = new DTContainer(this.fDesktop.getDockManager());
        }
        this.setVisible(false);
        this.addNotify();
        try {
            this.fDeskPanel = new MWPanel();
            this.fDeskPanel.setLayout(new BorderLayout());
            ((Container)((Object)this)).add("Center", (Component)this.fDeskPanel);
            this.fDeskPanel.setOpaque(false);
            this.fCenter = new MWCommandCenter((MWCommandTarget)this);
            this.restoreMenuBar(null);
            this.fStatusBar = new MWStatusBar();
            this.fDeskPanel.add("South", (Component)this.fStatusBar);
            this.fDeskPanel.add("Center", (Component)((Object)this.fDTContainer));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ((Window)((Object)this)).addWindowListener((WindowListener)new MWWindowActivater((Component)((Object)this)));
        if (!(this instanceof DTMainFrame) || PlatformInfo.getPlatform() == 1) {
            this.addFrameDragListener();
        }
    }

    public DTContainer getDTContainer() {
        return this.fDTContainer;
    }

    public MWCheckboxMenuItem addClient(DTClient dTClient, boolean bl) {
        return DTMenuBar.addComponentToViewMenu(dTClient.getShortName(), bl);
    }

    public void removeClient(MWCheckboxMenuItem mWCheckboxMenuItem) {
        DTMenuBar.removeComponentFromViewMenu(mWCheckboxMenuItem);
    }

    public void restoreMenuBar(DTClient dTClient) {
        Component component;
        int n;
        this.fUpdate = false;
        boolean bl = false;
        if (this instanceof DTMainFrame) {
            bl = true;
        }
        if (dTClient != null && this.fDesktopMenuBar != null) {
            n = this.fDesktopMenuBar.getMenubar().getMenuCount();
            component = dTClient.getClientComponent();
            if (component instanceof EditorViewContainer) {
                if (n != 9) {
                    this.fDesktopMenuBar = null;
                }
            } else if (component instanceof HelpBrowser) {
                if (n != 7) {
                    this.fDesktopMenuBar = null;
                }
            } else if (n != 6) {
                this.fDesktopMenuBar = null;
            }
        }
        n = 0;
        if (this.fDesktopMenuBar == null) {
            this.fDesktopMenuBar = DTMenuBar.createDesktopMenubar(this, this.fCenter);
            n = 1;
        } else {
            this.fDesktopMenuBar.reset();
        }
        component = this.fDesktopMenuBar.getMenubar();
        if (dTClient != null) {
            component = dTClient.mergeMenus((MWMenuBar)component);
        }
        if (component != null) {
            this.fDesktopMenuBar.autoAddSeparators();
            if (n != 0) {
                component.attachTo(this);
            }
        }
        this.fUpdate = true;
    }

    void updateClientTitle(String string) {
        ((Frame)((Object)this)).setTitle(string);
    }

    boolean destroyOnLastClient() {
        this.dispose();
        return true;
    }

    public void setStatusText(String string) {
        this.fStatusBar.setStatusText(string);
    }

    public void setSize(int n, int n2) {
        if (this.fUpdate) {
            super.setSize(n, n2);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.fUpdate) {
            super.setBounds(n, n2, n3, n4);
        }
    }

    public void update(Graphics graphics) {
        if (this.fUpdate) {
            super.update(graphics);
        }
    }

    public int closeWindow() {
        return this.fDTContainer.undockAllClients(false);
    }

    public void setVisible(boolean bl) {
        if (this.fFirstVisible && bl && PlatformInfo.isWindows()) {
            int n = NativeJava.hWndFromComponent((Component)((Object)this));
            NativeJava.addToUpList((int)n);
            this.fFirstVisible = false;
        }
        super.setVisible(bl);
    }

    public void setActive(boolean bl) {
        this.bWindowActivation = true;
        if (bl) {
            this.fDTContainer.containerActivated();
        } else {
            this.fDTContainer.containerDeactivated();
        }
        this.bWindowActivation = false;
    }

    public void activeClientChanged(DTClient dTClient) {
        if (!(this.bWindowActivation || dTClient == null && this.getMWMenuBar() != null)) {
            this.restoreMenuBar(dTClient);
        }
    }

    public void enableCommand(int n, boolean bl) {
        this.fCenter.setCommandEnabled(n, bl);
    }

    public String getShortName() {
        return ((Frame)((Object)this)).getTitle();
    }

    public String getLongName() {
        return ((Frame)((Object)this)).getTitle();
    }

    public MWCommandCenter getCommandCenter() {
        return this.fCenter;
    }

    public void doCommand(int n) {
        if (this.fCenter.getCommandEnabled(n)) {
            switch (n) {
                case 135: {
                    DTClient dTClient = this.fDTContainer.getActiveClient();
                    if (dTClient == null) break;
                    dTClient.undock(true);
                    return;
                }
                case 2020: {
                    DTClient dTClient = this.fDTContainer.getActiveClient();
                    dTClient.moveIntoDesktop();
                    return;
                }
                case 700: {
                    this.closeWindow();
                    return;
                }
                default: {
                    if (this.fDesktopMenuBar == null) break;
                    this.fDesktopMenuBar.doCommand(n);
                }
            }
        }
    }

    protected void addFrameDragListener() {
        if (PlatformInfo.isWindows()) {
            if (PlatformInfo.getVendor() == 3) {
                NativeJava.addFrameDragListener((DTExternalFrame)this, (int)NativeJava.hWndFromComponent((Component)((Object)this)), null);
                return;
            }
            if (this.fDesktop != null) {
                NativeJava.addFrameDragListener((DTExternalFrame)this, (int)NativeJava.hWndFromComponent((Component)((Object)this)), (DTDockManager)this.fDesktop.getDockManager());
            }
        }
    }

    protected void processNativeEvent(NativeEvent nativeEvent) {
        DTDockManager dTDockManager = this.fDesktop.getDockManager();
        int n = nativeEvent.getNativeMessage();
        if (NativeEvent.JM_FRAMEENTERED == n) {
            dTDockManager.frameEntered(this, nativeEvent.getWParam(), nativeEvent.getLParam());
            return;
        }
        if (NativeEvent.JM_FRAMEEXITED == n) {
            dTDockManager.frameExited(this, nativeEvent.getWParam(), nativeEvent.getLParam());
            return;
        }
        if (NativeEvent.JM_FRAMEPRESSED == n) {
            dTDockManager.framePressed(this, nativeEvent.getWParam(), nativeEvent.getLParam());
            return;
        }
        if (NativeEvent.JM_FRAMEDRAGGED == n) {
            dTDockManager.frameDragged(this, nativeEvent.getWParam(), nativeEvent.getLParam());
            return;
        }
        if (NativeEvent.JM_FRAMERELEASED == n) {
            dTDockManager.frameReleased(this, nativeEvent.getWParam(), nativeEvent.getLParam());
            return;
        }
        super.processNativeEvent(nativeEvent);
    }
}

