/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.desktop;

import com.mathworks.ide.desktop.DTContainer;
import com.mathworks.ide.desktop.DTDockManager;
import com.mathworks.ide.desktop.DTExternalFrame;
import com.mathworks.ide.desktop.Desktop;
import com.mathworks.mwt.MWFrameProxy;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.util.Vector;

public class DTDockPath
implements Cloneable {
    private DTContainer fDTContainer;
    public static final int sMAIN = 0;
    static final int sEXTERNAL = -1;
    private static int sNextContainerID = 1;
    private int fContainerID = 0;
    private String fPath = "T";
    private Point fFrameLocation;
    private Dimension fFrameSize;
    private boolean fStartMaximized = false;
    private boolean fStartMinimized = false;
    private static Vector fOldMap = null;
    private static Vector fNewMap = null;
    private static int fNextID = 1;
    private boolean fDeferred = false;

    public DTDockPath(String string) {
        this.fPath = string;
        this.fFrameLocation = new Point(0, 0);
        this.fFrameSize = new Dimension(0, 0);
    }

    public DTDockPath(DTContainer dTContainer, String string) {
        this.fPath = string;
        this.fDTContainer = dTContainer;
        this.fContainerID = dTContainer.getContainerID();
        DTExternalFrame dTExternalFrame = this.fDTContainer.getContainingFrame();
        this.fFrameLocation = dTExternalFrame.getRestoredLocation();
        this.fFrameSize = dTExternalFrame.getRestoredSize();
    }

    public DTDockPath(int n, int n2, int n3, int n4) {
        this.fContainerID = -1;
        this.fFrameLocation = new Point(n, n2);
        this.fFrameSize = new Dimension(n3, n4);
    }

    public DTDockPath(MWFrameProxy mWFrameProxy) {
        this("T");
        if (mWFrameProxy == null) {
            this.fContainerID = -1;
            this.fDeferred = true;
            return;
        }
        this.fContainerID = -1;
        this.fFrameLocation = mWFrameProxy.getFrameLocation();
        this.fFrameSize = mWFrameProxy.getFrameSize();
    }

    public DTDockPath cloneIt() {
        try {
            return (DTDockPath)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    public int getPathStringLength() {
        return this.fPath.length();
    }

    public int getContainerID() {
        return this.fContainerID;
    }

    public Rectangle getFrameBounds() {
        Rectangle rectangle = null;
        if (this.fFrameLocation != null && this.fFrameSize != null) {
            rectangle = new Rectangle(this.fFrameLocation.x, this.fFrameLocation.y, this.fFrameSize.width, this.fFrameSize.height);
        }
        return rectangle;
    }

    public String getPathString() {
        return this.fPath;
    }

    public String getPathSubString(int n, int n2) {
        return this.fPath.substring(n, n2);
    }

    public int getDockStateAt(int n) {
        if (n < this.fPath.length()) {
            return DTDockPath.pathToDockState(this.fPath.charAt(n));
        }
        return 0;
    }

    private DTContainer getDTContainer(Desktop desktop) {
        if (desktop != null) {
            DTDockManager dTDockManager = desktop.getDockManager();
            this.fDTContainer = dTDockManager.getContainerFromID(this.fContainerID);
        }
        return this.fDTContainer;
    }

    public int resolveDockingCollision(int n, int n2) {
        int n3 = 5;
        int n4 = n2;
        n3 = n4 == this.getPathStringLength() - 1 ? 5 : this.getDockStateAt(n4 + 1);
        return n3;
    }

    public DTContainer realizeDockPath(Desktop desktop, String string) {
        DTContainer dTContainer = this.getDTContainer(desktop);
        if (dTContainer == null) {
            if (desktop != null && this.fContainerID == 0) {
                this.fDTContainer = desktop.getMainFrame().getDTContainer();
            } else {
                DTExternalFrame dTExternalFrame = new DTExternalFrame(desktop, string);
                this.fDTContainer = dTExternalFrame.getDTContainer();
                if (this.fContainerID == -1) {
                    this.fDTContainer.setContainerID(sNextContainerID++);
                } else {
                    if (this.fContainerID >= sNextContainerID) {
                        sNextContainerID = this.fContainerID + 1;
                    }
                    this.fDTContainer.setContainerID(this.fContainerID);
                }
                dTExternalFrame.setRestoredLocation(this.fFrameLocation.x, this.fFrameLocation.y);
                dTExternalFrame.setRestoredSize(this.fFrameSize);
                Desktop.ensureFrameVisible(dTExternalFrame);
            }
        }
        return this.fDTContainer;
    }

    public boolean isDeferred() {
        return this.fDeferred;
    }

    protected static int pathToDockState(char c) {
        int n = 0;
        switch (c) {
            case 'N': {
                n = 1;
                break;
            }
            case 'S': {
                n = 2;
                break;
            }
            case 'E': {
                n = 3;
                break;
            }
            case 'W': {
                n = 4;
                break;
            }
            case 'T': {
                n = 5;
                break;
            }
        }
        return n;
    }

    public static DTDockPath readDockPath(BufferedReader bufferedReader) throws Exception {
        DTDockPath dTDockPath = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            string = bufferedReader.readLine();
            bl = Boolean.valueOf(bufferedReader.readLine());
            n5 = Integer.parseInt(bufferedReader.readLine());
            n = Integer.parseInt(bufferedReader.readLine());
            n2 = Integer.parseInt(bufferedReader.readLine());
            n3 = Integer.parseInt(bufferedReader.readLine());
            n4 = Integer.parseInt(bufferedReader.readLine());
            bl2 = Boolean.valueOf(bufferedReader.readLine());
            bl3 = Boolean.valueOf(bufferedReader.readLine());
            if (bl) {
                dTDockPath = new DTDockPath(null);
            } else {
                dTDockPath = new DTDockPath(string);
                dTDockPath.fContainerID = n5;
                if (n5 >= sNextContainerID) {
                    sNextContainerID = n5 + 1;
                }
                dTDockPath.fFrameLocation = new Point(n, n2);
                dTDockPath.fFrameSize = new Dimension(n3, n4);
                dTDockPath.fStartMaximized = bl2;
                dTDockPath.fStartMinimized = bl3;
            }
        }
        catch (Exception exception) {}
        return dTDockPath;
    }

    public void writeDockPath(BufferedWriter bufferedWriter) throws Exception {
        Boolean bl = new Boolean(this.fDeferred);
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.fDTContainer != null && this.fDTContainer.getContainingFrame() != null) {
            bl2 = this.fDTContainer.getContainingFrame().isMaximized();
            bl3 = this.fDTContainer.getContainingFrame().isMinimized();
        }
        Boolean bl4 = new Boolean(bl2);
        Boolean bl5 = new Boolean(bl3);
        bufferedWriter.write(this.fPath);
        bufferedWriter.newLine();
        bufferedWriter.write(bl.toString());
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.remapContainerID(this.fContainerID)));
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.fFrameLocation.x));
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.fFrameLocation.y));
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.fFrameSize.width));
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.fFrameSize.height));
        bufferedWriter.newLine();
        bufferedWriter.write(bl4.toString());
        bufferedWriter.newLine();
        bufferedWriter.write(bl5.toString());
        bufferedWriter.newLine();
    }

    private int remapContainerID(int n) {
        int n2 = n;
        boolean bl = false;
        if (n != 0 && n != -1) {
            if (fOldMap == null || fNewMap == null) {
                fOldMap = new Vector(10);
                fNewMap = new Vector(10);
            }
            int n3 = 0;
            while (n3 < fOldMap.size()) {
                if ((Integer)fOldMap.elementAt(n3) == n) {
                    n2 = (Integer)fNewMap.elementAt(n3);
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                n2 = fNextID++;
                fOldMap.addElement(new Integer(n));
                fNewMap.addElement(new Integer(n2));
            }
        }
        return n2;
    }

    public static void resetContainerMaps() {
        fOldMap = null;
        fNewMap = null;
    }
}

