/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.desktop;

import com.mathworks.ide.desktop.DTClient;
import com.mathworks.ide.desktop.DTContainer;
import com.mathworks.ide.desktop.DTDockSource;
import com.mathworks.ide.desktop.DTDockTarget;
import com.mathworks.ide.desktop.DTExternalFrame;
import com.mathworks.ide.desktop.DTExternalTarget;
import com.mathworks.ide.desktop.Desktop;
import com.mathworks.mwt.MWUtils;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ResourceBundle;
import java.util.Vector;

public class DTDockManager
implements MouseListener,
MouseMotionListener {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.desktop.resources.RES_Desktop");
    private Desktop fDesktop;
    private Vector fDTContainers;
    private int fDragMode = 0;
    private static final int DRAGNONE = 0;
    private static final int DRAGMOVE = 1;
    private DTDockSource fDockSource;
    private DTDockTarget fDockTarget;
    private DTContainer fDTContainer;
    private int fDropState = 0;
    private int fLastDropState = 0;
    private int fOldX;
    private int fOldY;
    private Point fRawOutlineLocation;
    private Dimension fRawOutlineSize;
    private Point fOutlineLocation;
    private Dimension fOutlineSize;
    private Point fStartLocation;
    private static final int fDeadZone = 15;
    private static final float fDockSensitivity = 0.15f;
    private static final int fDragSensitivity = 2;
    private static boolean bDraw = true;

    public DTDockManager(Desktop desktop) {
        this.fDesktop = desktop;
        this.fRawOutlineLocation = new Point();
        this.fRawOutlineSize = new Dimension();
        this.fStartLocation = new Point();
        this.fDTContainers = new Vector(5);
    }

    public void addDTContainer(DTContainer dTContainer) {
        this.fDTContainers.addElement(dTContainer);
    }

    public void removeDTContainer(DTContainer dTContainer) {
        this.fDTContainers.removeElement(dTContainer);
    }

    Vector getDTContainerList() {
        return this.fDTContainers;
    }

    void makeAllFramesVisible() {
        DTContainer dTContainer = null;
        DTClient dTClient = null;
        int n = this.fDTContainers.size() - 1;
        while (n >= 0) {
            dTContainer = (DTContainer)this.fDTContainers.elementAt(n);
            DTExternalFrame dTExternalFrame = dTContainer.getContainingFrame();
            if (dTExternalFrame != null) {
                dTExternalFrame.setVisible(true);
                dTClient = dTContainer.getActiveClient();
                if (dTClient != null) {
                    dTClient.activate();
                }
                if (PlatformInfo.isUnix()) {
                    ((Component)((Object)dTExternalFrame)).repaint();
                }
            }
            --n;
        }
    }

    Vector getRestorationOrder() {
        Vector vector = new Vector(6);
        int n = 0;
        while (n < this.fDTContainers.size()) {
            DTContainer dTContainer = (DTContainer)this.fDTContainers.elementAt(n);
            dTContainer.getRestorationOrder(vector);
            ++n;
        }
        return vector;
    }

    public int terminateNotify() {
        int n = 0;
        DTContainer dTContainer = null;
        int n2 = 0;
        while (n2 < this.fDTContainers.size()) {
            dTContainer = (DTContainer)this.fDTContainers.elementAt(n2);
            if (dTContainer.undockAllClients(true) == 1) {
                n = 1;
            }
            ++n2;
        }
        return n;
    }

    public DTContainer getContainerFromID(int n) {
        DTContainer dTContainer = null;
        int n2 = 0;
        while (n2 < this.fDTContainers.size()) {
            dTContainer = (DTContainer)this.fDTContainers.elementAt(n2);
            if (n == dTContainer.getContainerID()) break;
            dTContainer = null;
            ++n2;
        }
        return dTContainer;
    }

    private void setDragOutline(int n, int n2, int n3, int n4) {
        this.fOutlineLocation.x = n;
        this.fOutlineLocation.y = n2;
        this.fOutlineSize.width = n3;
        this.fOutlineSize.height = n4;
    }

    private void drawDragOutline(int n) {
        Point point = new Point(this.fOutlineLocation.x, this.fOutlineLocation.y);
        Point point2 = null;
        point2 = PlatformInfo.isWindows() ? MWUtils.mapFromComponentToScreen((Point)point, (Component)((Object)this.fDTContainer)) : point;
        Graphics graphics = ((Component)((Object)this.fDTContainer)).getGraphics();
        graphics.setXORMode(Color.gray);
        if (n == 5) {
            int[] nArray = new int[9];
            int[] nArray2 = new int[9];
            int n2 = 70;
            int n3 = 20;
            int n4 = 4;
            int n5 = 10;
            nArray[0] = point2.x;
            nArray2[0] = point2.y;
            nArray[1] = point2.x + this.fOutlineSize.width;
            nArray2[1] = point2.y;
            nArray[2] = point2.x + this.fOutlineSize.width;
            nArray2[2] = point2.y + this.fOutlineSize.height - n3;
            nArray[3] = point2.x + n5 + n2;
            nArray2[3] = point2.y + this.fOutlineSize.height - n3;
            nArray[4] = point2.x + n5 + n2 - n4;
            nArray2[4] = point2.y + this.fOutlineSize.height;
            nArray[5] = point2.x + n5 + n4;
            nArray2[5] = point2.y + this.fOutlineSize.height;
            nArray[6] = point2.x + n5;
            nArray2[6] = point2.y + this.fOutlineSize.height - n3;
            nArray[7] = point2.x;
            nArray2[7] = point2.y + this.fOutlineSize.height - n3;
            nArray[8] = point2.x;
            nArray2[8] = point2.y;
            int n6 = 0;
            while (n6 < 3) {
                int n7 = 0;
                while (n7 < nArray.length) {
                    int n8 = n7;
                    nArray[n8] = nArray[n8] - 1;
                    int n9 = n7++;
                    nArray2[n9] = nArray2[n9] - 1;
                }
                if (PlatformInfo.isWindows()) {
                    NativeJava.drawScreenPolygon((int[])nArray, (int[])nArray2);
                } else {
                    graphics.drawPolygon(nArray, nArray2, nArray.length);
                }
                ++n6;
            }
        } else {
            int[] nArray = new int[5];
            int[] nArray3 = new int[5];
            nArray[0] = point2.x;
            nArray3[0] = point2.y;
            nArray[1] = point2.x + this.fOutlineSize.width;
            nArray3[1] = point2.y;
            nArray[2] = point2.x + this.fOutlineSize.width;
            nArray3[2] = point2.y + this.fOutlineSize.height;
            nArray[3] = point2.x;
            nArray3[3] = point2.y + this.fOutlineSize.height;
            nArray[4] = point2.x;
            nArray3[4] = point2.y;
            int n10 = 0;
            while (n10 < 3) {
                int n11 = 0;
                while (n11 < nArray.length) {
                    int n12 = n11;
                    nArray[n12] = nArray[n12] - 1;
                    int n13 = n11++;
                    nArray3[n13] = nArray3[n13] - 1;
                }
                if (PlatformInfo.isWindows()) {
                    NativeJava.drawScreenPolygon((int[])nArray, (int[])nArray3);
                } else {
                    graphics.drawPolygon(nArray, nArray3, nArray.length);
                }
                ++n10;
            }
        }
        graphics.dispose();
    }

    private void initDragState(int n, int n2) {
        this.fDragMode = 1;
        this.fStartLocation.x = n;
        this.fStartLocation.y = n2;
        this.fDropState = 0;
        this.fLastDropState = 0;
        this.fOutlineLocation = this.fDockSource.getOutlineLocation();
        this.fOutlineSize = this.fDockSource.getSize();
        this.setDragOutline(this.fOutlineLocation.x, this.fOutlineLocation.y, this.fOutlineSize.width, this.fOutlineSize.height);
        this.fRawOutlineLocation.x = this.fOutlineLocation.x;
        this.fRawOutlineLocation.y = this.fOutlineLocation.y;
        this.fRawOutlineSize.width = this.fOutlineSize.width;
        this.fRawOutlineSize.height = this.fOutlineSize.height;
        this.fOldX = n;
        this.fOldY = n2;
    }

    private void updateFlyby(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = sRes.getString("status.ReleasetoNorth");
                break;
            }
            case 2: {
                string = sRes.getString("status.ReleasetoSouth");
                break;
            }
            case 3: {
                string = sRes.getString("status.ReleasetoEast");
                break;
            }
            case 4: {
                string = sRes.getString("status.ReleasetoWest");
                break;
            }
            case 5: {
                string = sRes.getString("status.ReleasetoTab");
                break;
            }
            case 6: {
                string = sRes.getString("status.ReleasetoOutside");
                break;
            }
            case 0: {
                string = sRes.getString("status.MovetoBorder");
                break;
            }
        }
        if (this.fDockSource != null) {
            this.fDockSource.getDTContainer().setStatusText(string);
        }
    }

    private DTDockTarget findDockTargetandDropState(Component component, int n, int n2) {
        DTDockTarget dTDockTarget = null;
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.fDTContainers.size() && n3 < 1) {
            DTContainer dTContainer = (DTContainer)this.fDTContainers.elementAt(n3);
            Point point = MWUtils.mapFromComponentToComponent((Point)new Point(n, n2), (Component)component, (Component)((Object)dTContainer));
            DTExternalFrame dTExternalFrame = dTContainer.getContainingFrame();
            Dimension dimension = ((Component)((Object)dTContainer)).getSize();
            if (!dTExternalFrame.isFrameActive() || point.x < 0 || point.x > dimension.width || point.y < 0 || point.y > dimension.height) {
                bl = true;
            } else {
                dTDockTarget = dTContainer.getDockTargetAt(point, 0.15f);
                if (dTDockTarget != null && !this.fDockSource.rejectDockTarget(dTDockTarget)) {
                    this.fDockTarget = dTDockTarget;
                    this.fDropState = dTDockTarget.getDropState();
                    break;
                }
                this.fDropState = 0;
            }
            ++n3;
        }
        if (bl && (dTDockTarget == null || this.fDropState == 0)) {
            dTDockTarget = new DTExternalTarget(this.fDesktop);
            this.fDropState = 6;
        }
        return dTDockTarget;
    }

    public void frameEntered(DTExternalFrame dTExternalFrame, int n, int n2) {
        this.mouseEntered(new MouseEvent((Component)((Object)dTExternalFrame), 0, 0L, 0, n, n2, 0, false));
    }

    public void framePressed(DTExternalFrame dTExternalFrame, int n, int n2) {
        this.mousePressed(new MouseEvent((Component)((Object)dTExternalFrame), 0, 0L, 0, n, n2, 0, false));
    }

    public void frameDragged(DTExternalFrame dTExternalFrame, int n, int n2) {
        this.mouseDragged(new MouseEvent((Component)((Object)dTExternalFrame), 0, 0L, 0, n, n2, 0, false));
    }

    public void frameReleased(DTExternalFrame dTExternalFrame, int n, int n2) {
        this.mouseReleased(new MouseEvent((Component)((Object)dTExternalFrame), 0, 0L, 0, n, n2, 0, false));
    }

    public void frameExited(DTExternalFrame dTExternalFrame, int n, int n2) {
        this.mouseExited(new MouseEvent((Component)((Object)dTExternalFrame), 0, 0L, 0, n, n2, 0, false));
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Component component = mouseEvent.getComponent();
        if (this.fDragMode == 0) {
            this.fDockSource = DTDockSource.dockSourceFactory(component, n, n2);
            if (this.fDockSource != null && this.fDockSource.isDragHotspot(n, n2)) {
                this.fDockSource.getDTContainer().setStatusText(sRes.getString("status.toMove"));
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.fDockSource != null && this.fDragMode == 0 && this.fDockSource.isDragHotspot(mouseEvent.getX(), mouseEvent.getY())) {
            this.fDockSource.getDTContainer().setStatusText(sRes.getString("status.BeginDrag"));
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.fDockSource != null && this.fDragMode == 0) {
            if (this.fDockSource.isDragHotspot(mouseEvent.getX(), mouseEvent.getY())) {
                this.fDockSource.getDTContainer().setStatusText(sRes.getString("status.HeretoMove"));
                return;
            }
            this.fDockSource.getDTContainer().setStatusText(sRes.getString("status.Ready"));
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.fDockSource != null && this.fDragMode == 0) {
            this.fDockSource.getDTContainer().setStatusText(sRes.getString("status.Ready"));
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.fDragMode == 0) {
            bDraw = false;
            this.fDockSource = DTDockSource.dockSourceFactory(mouseEvent.getComponent(), n, n2);
            if (this.fDockSource != null) {
                this.fDTContainer = this.fDockSource.getDTContainer();
                this.initDragState(n, n2);
            }
        } else {
            if (Math.abs(n - this.fStartLocation.x) < 15 && Math.abs(n2 - this.fStartLocation.y) < 15 && !bDraw) {
                return;
            }
            this.updateFlyby(this.fDropState);
            if (bDraw) {
                this.drawDragOutline(this.fLastDropState);
            } else {
                bDraw = true;
            }
        }
        if (this.fDragMode == 1) {
            this.fOutlineLocation.x += n - this.fOldX;
            this.fOutlineLocation.y += n2 - this.fOldY;
            this.fRawOutlineLocation.x += n - this.fOldX;
            this.fRawOutlineLocation.y += n2 - this.fOldY;
            this.fDockTarget = this.findDockTargetandDropState(mouseEvent.getComponent(), n, n2);
            if (this.fDockTarget != null && this.fDropState != 0) {
                Rectangle rectangle = this.fDockTarget.getDockingOutline(this.fDockSource.getSize(), this.fDropState, this.fRawOutlineLocation.x, this.fRawOutlineLocation.y, this.fDTContainer);
                this.setDragOutline(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else if (this.fLastDropState != 0) {
                this.setDragOutline(this.fRawOutlineLocation.x, this.fRawOutlineLocation.y, this.fRawOutlineSize.width, this.fRawOutlineSize.height);
            }
        }
        if (bDraw) {
            this.drawDragOutline(this.fDropState);
        }
        this.fOldX = n;
        this.fOldY = n2;
        this.fLastDropState = this.fDropState;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.fDragMode == 1 && bDraw) {
            this.drawDragOutline(this.fLastDropState);
            if ((Math.abs(n - this.fStartLocation.x) > 15 || Math.abs(n2 - this.fStartLocation.y) > 15) && this.fDropState != 0) {
                Point point = MWUtils.mapFromComponentToScreen((Point)new Point(this.fOutlineLocation.x, this.fOutlineLocation.y), (Component)((Object)this.fDTContainer));
                if (this.fDockSource != null) {
                    this.fDockSource.getDTContainer().setStatusText(sRes.getString("status.Ready"));
                }
                this.fDockSource.dockClients(this.fDockTarget, this.fDropState, point.x, point.y, this.fOutlineSize);
            }
        } else if (this.fDockSource != null) {
            this.fDockSource.getDTContainer().setStatusText(sRes.getString("status.Ready"));
        }
        this.fDragMode = 0;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

