/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.desktop;

import com.mathworks.ide.desktop.DTClient;
import com.mathworks.ide.desktop.DTContainer;
import com.mathworks.ide.desktop.DTContainerTarget;
import com.mathworks.ide.desktop.DTDockManager;
import com.mathworks.ide.desktop.DTDockPath;
import com.mathworks.ide.desktop.DTDockTarget;
import com.mathworks.ide.desktop.DTTitleBar;
import com.mathworks.mwt.MWFocusChain;
import com.mathworks.mwt.MWSplitter;
import com.mathworks.mwt.MWTabPanel;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.decorations.Decorations;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;

class DTClientFrame
extends DTContainerTarget
implements ActionListener,
MWFocusChain,
ItemListener {
    private Insets INSETS = new Insets(3, 3, 3, 3);
    private DTContainer fDTContainer;
    private Vector fDTClients;
    private DTTitleBar fTitleBar;
    private MWTabPanel fTabPanel;
    private Component fFirstLayer;
    private DTDockPath fDockPath;
    private boolean bUpdateList = true;

    public DTClientFrame(DTClient dTClient, DTContainer dTContainer) {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.setDTContainer(dTContainer);
        this.addTitleBar(dTClient.getTitle());
        this.fDTClients = new Vector(1);
        this.fDTClients.addElement(dTClient);
        this.fFirstLayer = dTClient.getFirstLayer();
        Dimension dimension = this.fFirstLayer.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            dimension = this.fFirstLayer.getPreferredSize();
        }
        ((Container)((Object)this)).add(this.fFirstLayer, "Center");
        ((Component)((Object)this)).setSize(dimension.width + this.INSETS.left + this.INSETS.right, dimension.height + this.INSETS.top + this.INSETS.bottom);
        this.setDockPath(dTClient.getDockPath());
        dTClient.setClientFrame(this);
    }

    public void dockClient(DTClient dTClient, int n, int n2, int n3, Dimension dimension) {
        if (n == 5) {
            this.fDTClients.addElement(dTClient);
            dTClient.setClientFrame(this);
            this.addTabPanel(dTClient);
            return;
        }
        DTClientFrame dTClientFrame = new DTClientFrame(dTClient, this.getDTContainer());
        this.dockClientFrame(dTClientFrame, n, n2, n3, dimension);
    }

    public void undockClient(DTClient dTClient) {
        if (this.isTabbed()) {
            this.removeTabPanel(dTClient);
        } else {
            if (this.fTitleBar != null) {
                this.fTitleBar.removeDockListeners();
            }
            this.getDTContainer().undockClientFrame(this, true);
            ((Container)((Object)this)).remove(this.fFirstLayer);
        }
        if (this.bUpdateList) {
            this.fDTClients.removeElement(dTClient);
        }
        if (this.fTabPanel != null) {
            this.fTabPanel.selectPanel(this.fTabPanel.getSelectedIndex());
        } else if (this.fDTClients.size() > 0) {
            this.resetTitle((DTClient)this.fDTClients.elementAt(0));
        }
        dTClient.setClientFrame(null);
    }

    public void dockClientFrame(DTClientFrame dTClientFrame, int n, int n2, int n3, Dimension dimension) {
        boolean bl = false;
        MWSplitter mWSplitter = null;
        MWSplitter mWSplitter2 = null;
        Dimension dimension2 = ((Component)((Object)this)).getSize();
        if (((Component)((Object)this)).getParent() instanceof MWSplitter) {
            mWSplitter2 = (MWSplitter)((Component)((Object)this)).getParent();
            ((Component)((Object)dTClientFrame)).setVisible(true);
            bl = mWSplitter2.getFirstComponent() == this;
            mWSplitter = this.setupSplitter(n, (Component)((Object)this), (Component)((Object)dTClientFrame), dimension2, dimension);
            if (bl) {
                mWSplitter2.setFirstComponent((Component)mWSplitter);
            } else {
                mWSplitter2.setSecondComponent((Component)mWSplitter);
            }
            dTClientFrame.setDTContainer(this.getDTContainer());
            dTClientFrame.setTitleBar(true);
            dTClientFrame.refreshDockPath();
            return;
        }
        this.fDTContainer.dockClientFrame(dTClientFrame, n, n2, n3, dimension);
    }

    public int undockAllClients(boolean bl) {
        int n = 0;
        Vector vector = (Vector)this.fDTClients.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DTClient dTClient = (DTClient)enumeration.nextElement();
            if (bl) {
                if (dTClient.notifyClose() != 1) continue;
                n = 1;
                continue;
            }
            if (dTClient.toggleViewState() != 1) continue;
            n = 1;
        }
        return n;
    }

    public void addClientsToTarget(DTDockTarget dTDockTarget, int n, Dimension dimension) {
        DTClient dTClient;
        this.bUpdateList = false;
        int n2 = 0;
        while (n2 < this.fDTClients.size()) {
            dTClient = (DTClient)this.fDTClients.elementAt(n2);
            dTClient.undock(false);
            dTDockTarget.dockClient(dTClient, n, 0, 0, dimension);
            ++n2;
        }
        dTClient = this.getActiveClient();
        if (dTClient != null) {
            dTClient.activate();
        }
        this.bUpdateList = true;
        this.fDTClients.removeAllElements();
    }

    public void showClient(DTClient dTClient, boolean bl) {
        if (this.isTabbed()) {
            int n = 0;
            while (n < this.fDTClients.size()) {
                DTClient dTClient2 = (DTClient)this.fDTClients.elementAt(n);
                if (dTClient == dTClient2) {
                    if (n == this.fTabPanel.getSelectedIndex()) break;
                    dTClient.getFirstLayer().setVisible(false);
                    this.fTabPanel.selectPanel(n);
                    break;
                }
                ++n;
            }
        }
        if (bl) {
            this.getDTContainer().toFront();
        }
    }

    public void focusMousePressed(MouseEvent mouseEvent) {
        DTClient dTClient = this.getActiveClient();
        dTClient.activate();
    }

    public void focusEvent(FocusEvent focusEvent) {
    }

    public void focusSwitch(KeyEvent keyEvent) {
    }

    public void setActive(boolean bl) {
        if (this.fTitleBar != null) {
            this.fTitleBar.setActive(bl);
        }
    }

    Vector getClientList() {
        return this.fDTClients;
    }

    public DTClient getActiveClient() {
        DTClient dTClient = null;
        dTClient = this.isTabbed() ? (DTClient)this.fDTClients.elementAt(this.fTabPanel.getSelectedIndex()) : (DTClient)this.fDTClients.elementAt(0);
        return dTClient;
    }

    public void setActiveClient(DTClient dTClient) {
        this.getDTContainer().setActiveClient(dTClient);
    }

    private DTClient getNextClient(DTClient dTClient) {
        DTClient dTClient2 = null;
        if (this.isTabbed()) {
            int n = 0;
            while (n < this.fDTClients.size()) {
                dTClient2 = (DTClient)this.fDTClients.elementAt(n);
                if (dTClient2 == dTClient) {
                    dTClient2 = (DTClient)this.fDTClients.elementAt(n + 1);
                    break;
                }
                ++n;
            }
        } else {
            dTClient2 = dTClient;
        }
        return dTClient2;
    }

    private DTClient getPreviousClient(DTClient dTClient) {
        DTClient dTClient2 = null;
        if (this.isTabbed()) {
            int n = this.fDTClients.size() - 1;
            while (n >= 0) {
                dTClient2 = (DTClient)this.fDTClients.elementAt(n);
                if (dTClient2 == dTClient) {
                    dTClient2 = (DTClient)this.fDTClients.elementAt(n - 1);
                    break;
                }
                --n;
            }
        } else {
            dTClient2 = dTClient;
        }
        return dTClient2;
    }

    public void activateNextClient(DTClient dTClient) {
        if (dTClient == null) {
            DTClient dTClient2 = (DTClient)this.fDTClients.elementAt(0);
            this.showClient(dTClient2, false);
            dTClient2.activate();
            return;
        }
        if (dTClient == (DTClient)this.fDTClients.elementAt(this.fDTClients.size() - 1)) {
            this.getDTContainer().activateNextClientFrame(this);
            return;
        }
        DTClient dTClient3 = this.getNextClient(dTClient);
        this.showClient(dTClient3, false);
        dTClient3.activate();
    }

    public void activatePreviousClient(DTClient dTClient) {
        if (dTClient == null) {
            DTClient dTClient2 = (DTClient)this.fDTClients.elementAt(this.fDTClients.size() - 1);
            this.showClient(dTClient2, false);
            dTClient2.activate();
            return;
        }
        if (dTClient == (DTClient)this.fDTClients.elementAt(0)) {
            this.getDTContainer().activatePreviousClientFrame(this);
            return;
        }
        DTClient dTClient3 = this.getPreviousClient(dTClient);
        this.showClient(dTClient3, false);
        dTClient3.activate();
    }

    public int getDropState() {
        return this.getDTContainer().getDropState();
    }

    protected void addTabPanel(DTClient dTClient) {
        if (!this.isTabbed()) {
            Component component = ((DTClient)this.fDTClients.elementAt(0)).getFirstLayer();
            this.fTabPanel = new MWTabPanel(3, 0, false);
            this.fTabPanel.setShowBevel(false);
            this.fTabPanel.setMargins(new Insets(0, 0, 2, 0));
            this.fTabPanel.addPanelNoSelect(((DTClient)this.fDTClients.elementAt(0)).getShortName(), component);
            this.fTabPanel.addItemListener((ItemListener)this);
            this.fTabPanel.setScrollable(true);
            DTDockManager dTDockManager = this.fDTContainer.getDTDockManager();
            if (dTDockManager != null) {
                this.fTabPanel.addTabMouseAndMotionListener((MouseListener)dTDockManager);
            }
            this.setFirstLayer((Component)this.fTabPanel);
        }
        this.fTabPanel.addPanel(dTClient.getShortName(), dTClient.getFirstLayer());
        ((Container)((Object)this)).invalidate();
        if (((Component)((Object)this)).getParent() != null) {
            ((Component)((Object)this)).getParent().validate();
        }
    }

    protected void removeTabPanel(DTClient dTClient) {
        Object object;
        int n = 0;
        while (n < this.fDTClients.size()) {
            object = (DTClient)this.fDTClients.elementAt(n);
            if (object == dTClient) {
                this.fTabPanel.removeItemListener((ItemListener)this);
                this.fTabPanel.removePanel(n);
                this.fTabPanel.addItemListener((ItemListener)this);
                break;
            }
            ++n;
        }
        if (this.fTabPanel.getPanelCount() == 1) {
            this.fTabPanel.removeItemListener((ItemListener)this);
            object = this.fDTContainer.getDTDockManager();
            if (object != null) {
                this.fTabPanel.addTabMouseAndMotionListener((MouseListener)object);
            }
            this.setFirstLayer(this.fTabPanel.getPanel(0));
            this.fTabPanel = null;
        }
        ((Container)((Object)this)).invalidate();
        if (((Component)((Object)this)).getParent() != null) {
            ((Component)((Object)this)).getParent().validate();
        }
    }

    private void resetTitle(DTClient dTClient) {
        dTClient.activate();
        this.updateTitle(dTClient);
        ((Container)((Object)this)).invalidate();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this.fTabPanel) {
            int n = this.fTabPanel.getSelectedIndex();
            DTClient dTClient = (DTClient)this.fDTClients.elementAt(n);
            dTClient.activate();
            this.updateTitle(dTClient);
            ((Container)((Object)this)).invalidate();
        }
    }

    public void setDTContainer(DTContainer dTContainer) {
        this.fDTContainer = dTContainer;
    }

    public DTContainer getDTContainer() {
        return this.fDTContainer;
    }

    public DTDockPath getDockPath() {
        this.refreshDockPath();
        return this.fDockPath.cloneIt();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("close")) {
            this.getActiveClient().undock(true);
            return;
        }
        if (string.equals("pop out")) {
            this.getActiveClient().moveOutOfDesktop();
        }
    }

    private void addTitleBar(String string) {
        if (this.fTitleBar == null) {
            this.fTitleBar = new DTTitleBar(this);
            this.fTitleBar.setTitle(string);
            this.fTitleBar.addDockListeners();
            ((Container)((Object)this)).add((Component)((Object)this.fTitleBar), "North");
        }
    }

    public void setTitleBar(boolean bl) {
        if (bl) {
            DTClient dTClient;
            if (this.fTitleBar == null && (dTClient = this.getActiveClient()) != null) {
                this.addTitleBar(dTClient.getTitle());
                return;
            }
        } else if (this.fTitleBar != null) {
            ((Container)((Object)this)).remove((Component)((Object)this.fTitleBar));
            this.fTitleBar = null;
        }
    }

    public void updateTitle(DTClient dTClient) {
        boolean bl = false;
        if (this.fTabPanel != null) {
            int n = 0;
            while (n < this.fDTClients.size()) {
                DTClient dTClient2 = (DTClient)this.fDTClients.elementAt(n);
                if (dTClient2 == dTClient) {
                    this.fTabPanel.setPanelName(dTClient.getShortName(), n);
                    if (n == this.fTabPanel.getSelectedIndex()) {
                        bl = true;
                    }
                    break;
                }
                ++n;
            }
        } else {
            bl = true;
        }
        if (bl) {
            if (this.fTitleBar != null) {
                this.fTitleBar.setTitle(dTClient.getTitle());
            }
            if (this.fDTContainer != null) {
                this.fDTContainer.updateTitle(dTClient);
            }
        }
    }

    public String getTitle() {
        int n = 0;
        if (this.fTabPanel != null) {
            n = this.fTabPanel.getSelectedIndex();
        }
        return ((DTClient)this.fDTClients.elementAt(n)).getTitle();
    }

    public Insets getInsets() {
        if (this.fTitleBar != null) {
            return this.INSETS;
        }
        return super.getInsets();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    protected boolean isTabbed() {
        return this.fTabPanel != null;
    }

    protected void setFirstLayer(Component component) {
        if (this.fFirstLayer != null) {
            ((Container)((Object)this)).remove(this.fFirstLayer);
        }
        ((Container)((Object)this)).add(component, "Center");
        this.fFirstLayer = component;
    }

    private void setDockPath(DTDockPath dTDockPath) {
        this.fDockPath = dTDockPath;
    }

    private void refreshDockPath() {
        String string = "";
        Container container = null;
        Object object = this;
        if (this.getDTContainer() == null) {
            return;
        }
        if (this.isTabbed()) {
            string = "T";
        }
        while ((container = ((Component)object).getParent()) != null) {
            if (container instanceof DTContainer) {
                if (((Component)((Object)this)).getParent() != container) break;
                string = this.fDockPath.getPathSubString(0, 1);
                break;
            }
            if (container instanceof MWSplitter) {
                MWSplitter mWSplitter = (MWSplitter)container;
                string = object == mWSplitter.getFirstComponent() ? (mWSplitter.getOrientation() == 1 ? "N" + string : "W" + string) : (mWSplitter.getOrientation() == 1 ? "S" + string : "E" + string);
            }
            object = container;
        }
        this.setDockPath(new DTDockPath(this.getDTContainer(), string));
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.fTitleBar != null) {
            Rectangle rectangle = graphics.getClipBounds();
            Rectangle rectangle2 = ((Component)((Object)this)).getBounds();
            try {
                rectangle = MWUtils.mapFromComponentToComponent((Rectangle)rectangle, (Component)((Object)this), (Component)((Component)((Object)this)).getParent());
                rectangle2.x += this.INSETS.left;
                rectangle2.y += this.INSETS.top;
                rectangle2.width -= this.INSETS.left + this.INSETS.right - 1;
                rectangle2.height -= this.INSETS.top + this.INSETS.bottom - 1;
                if (!rectangle2.contains(rectangle.x, rectangle.y) || !rectangle2.contains(rectangle.x + rectangle.width, rectangle.y + rectangle.height)) {
                    Dimension dimension = ((Component)((Object)this)).getSize();
                    Rectangle rectangle3 = new Rectangle(0, 0, dimension.width, dimension.height);
                    Decorations.drawDesktopFrame((Graphics)graphics, (Rectangle)rectangle3, (int)3);
                }
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }
}

