/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.desktop;

import com.mathworks.ide.arrayeditor.ArrayEditor;
import com.mathworks.ide.browsers.FileBrowser;
import com.mathworks.ide.desktop.DTApplication;
import com.mathworks.ide.desktop.DTClientFrame;
import com.mathworks.ide.desktop.DTContainer;
import com.mathworks.ide.desktop.DTDockPath;
import com.mathworks.ide.desktop.DTExternalFrame;
import com.mathworks.ide.desktop.DTMainFrame;
import com.mathworks.ide.desktop.DTMenuBar;
import com.mathworks.ide.desktop.Desktop;
import com.mathworks.ide.editor.EditorViewContainer;
import com.mathworks.ide.workspace.WorkspaceBrowser;
import com.mathworks.mwt.MWCheckboxMenuItem;
import com.mathworks.mwt.MWFrameProxy;
import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWSplitter;
import com.mathworks.mwt.window.MWWindowOwner;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class DTClient
implements MWWindowOwner {
    private Desktop fDesktop;
    private Component fComponent;
    private String fTitle;
    private MWFrameProxy fFrameProxy;
    private DTClientFrame fClientFrame;
    private MWCheckboxMenuItem fMenuItem;
    private DTDockPath fDockPath;
    private DTDockPath fLastInternalDockPath;
    private DTDockPath fLastExternalDockPath;
    private String fClassName;
    private int fInitialWidth;
    private int fInitialHeight;
    private int fInitialSplitterLocation;
    protected boolean fOnTop = false;
    private boolean fInitialVisibility = false;
    private byte[] fInitialData;

    public DTClient(Desktop desktop, Component component, String string, DTDockPath dTDockPath) {
        this.fComponent = component;
        this.initDockPaths(dTDockPath);
        this.fTitle = string;
        this.setDesktop(desktop);
        if (component != null) {
            this.realizeClient(component);
        }
    }

    public DTClient(Desktop desktop, String string, String string2, DTDockPath dTDockPath, DTDockPath dTDockPath2, DTDockPath dTDockPath3, int n, int n2, byte[] byArray) {
        this(desktop, null, string2, dTDockPath);
        if (dTDockPath2 != null) {
            this.setLastInternalDockPath(dTDockPath2);
        }
        if (dTDockPath3 != null) {
            this.setLastExternalDockPath(dTDockPath3);
        }
        this.fClassName = string;
        this.fInitialWidth = n;
        this.fInitialHeight = n2;
        this.fInitialData = byArray;
    }

    private void realizeClient(Component component) {
        Object object;
        MWFrameProxy mWFrameProxy = null;
        Dimension dimension = null;
        if (component == null) {
            this.fComponent = this.fDesktop.createComponentFromClass(this.fClassName);
            if (this.fComponent instanceof DTApplication && this.fInitialData != null) {
                try {
                    object = new ByteArrayInputStream(this.fInitialData);
                    DataInputStream dataInputStream = new DataInputStream((InputStream)object);
                    DTApplication dTApplication = (DTApplication)((Object)this.fComponent);
                    dTApplication.restoreState(dataInputStream);
                    dataInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.fComponent != null) {
            if (this.getFrameProxy() == null) {
                object = this.fComponent.getParent();
                if (object != null && object instanceof MWFrameProxy) {
                    mWFrameProxy = (MWFrameProxy)object;
                } else {
                    if (this.fTitle == null) {
                        this.fTitle = this.fComponent.getClass().getName();
                        this.fTitle = this.fTitle.substring(1 + this.fTitle.lastIndexOf(46));
                    }
                    mWFrameProxy = new MWFrameProxy((MWWindowOwner)this, this.fTitle);
                    mWFrameProxy.add(this.fComponent, "Center");
                }
                this.setFrameProxy(mWFrameProxy);
                if (this.fInitialHeight != 0 || this.fInitialWidth != 0) {
                    dimension = new Dimension(this.fInitialWidth, this.fInitialHeight);
                } else {
                    dimension = this.fComponent.getSize();
                    if (dimension.width == 0 || dimension.height == 0) {
                        dimension = this.fComponent.getPreferredSize();
                    }
                }
                this.getFrameProxy().setSize(dimension.width, dimension.height);
                this.fComponent.setSize(dimension.width, dimension.height);
            }
            if (this.fDockPath.isDeferred()) {
                this.initDockPaths(new DTDockPath(this.fFrameProxy));
            }
            this.fFrameProxy.setDTClient(this);
            this.fFrameProxy.setVisible(true);
        }
    }

    private void initDockPaths(DTDockPath dTDockPath) {
        if (dTDockPath != null) {
            this.fDockPath = dTDockPath;
            if (this.fDockPath.getContainerID() != 0) {
                if (this.fLastExternalDockPath == null) {
                    this.setLastExternalDockPath(this.fDockPath);
                }
                if (this.fLastInternalDockPath == null) {
                    this.setLastInternalDockPath(new DTDockPath("EN"));
                    return;
                }
            } else {
                if (this.fLastInternalDockPath == null) {
                    this.setLastInternalDockPath(this.fDockPath);
                }
                if (this.fLastExternalDockPath == null) {
                    this.setLastExternalDockPath(new DTDockPath(10, 10, 400, 400));
                }
            }
        }
    }

    public int undock(boolean bl) {
        DTMainFrame dTMainFrame;
        int n = 0;
        DTClientFrame dTClientFrame = this.getClientFrame();
        if (dTClientFrame != null) {
            if (bl) {
                n = this.notifyClose();
            }
            if (n == 0) {
                this.removeFromClientFrame();
                if (this.fDockPath.getContainerID() != 0) {
                    this.setLastExternalDockPath(this.fDockPath);
                } else {
                    this.setLastInternalDockPath(this.fDockPath);
                }
            }
        }
        if (this.fDesktop != null && this.fComponent != null && (this.fComponent instanceof FileBrowser || this.fComponent instanceof WorkspaceBrowser) && (dTMainFrame = this.fDesktop.getMainFrame()) != null) {
            dTMainFrame.restoreMenuBar(dTMainFrame.getDTContainer().getActiveClient());
        }
        return n;
    }

    public void restore(boolean bl) {
        DTClientFrame dTClientFrame;
        DTExternalFrame dTExternalFrame = null;
        DTContainer dTContainer = null;
        this.realizeClient(this.fComponent);
        if (this.fComponent == null) {
            return;
        }
        if (!this.isDocked()) {
            dTContainer = this.fDockPath.realizeDockPath(this.fDesktop, this.getTitle());
            dTContainer.restoreClient(this);
        }
        if (bl && (dTClientFrame = this.getClientFrame()) != null && (dTContainer = dTClientFrame.getDTContainer()) != null) {
            DTMainFrame dTMainFrame;
            dTExternalFrame = dTContainer.getContainingFrame();
            if (!((Component)((Object)dTExternalFrame)).isVisible()) {
                dTExternalFrame.setVisible(true);
            }
            dTClientFrame.showClient(this, true);
            this.activate();
            if (this.fDesktop != null && (this.fComponent instanceof FileBrowser || this.fComponent instanceof WorkspaceBrowser) && (dTMainFrame = this.fDesktop.getMainFrame()) != null) {
                dTMainFrame.restoreMenuBar(dTMainFrame.getDTContainer().getActiveClient());
            }
        }
    }

    private void removeFromClientFrame() {
        DTClientFrame dTClientFrame = this.getClientFrame();
        if (dTClientFrame != null) {
            try {
                this.getDockPath();
            }
            catch (Exception exception) {
                this.fDockPath = new DTDockPath("E");
            }
            dTClientFrame.undockClient(this);
        }
        this.setClientFrame(null);
    }

    int toggleViewState() {
        int n = 0;
        if (this.isDocked()) {
            n = this.undock(true);
        } else {
            this.restore(true);
        }
        return n;
    }

    public void destroyAndRemove() {
        this.removeFromClientFrame();
        if (this.fDesktop != null) {
            this.fDesktop.removeClient(this);
            return;
        }
        this.undock(false);
    }

    public int notifyClose() {
        int n = 0;
        if (this.fComponent instanceof MWWindowOwner && (this.fComponent instanceof EditorViewContainer || this.fComponent instanceof WorkspaceBrowser || this.fComponent instanceof ArrayEditor)) {
            MWWindowOwner mWWindowOwner = (MWWindowOwner)this.fComponent;
            n = mWWindowOwner.closeWindow();
        }
        return n;
    }

    void moveOutOfDesktop() {
        this.undock(false);
        this.fDockPath = this.fLastExternalDockPath;
        this.restore(true);
    }

    void moveIntoDesktop() {
        this.undock(false);
        this.fDockPath = this.fLastInternalDockPath;
        this.restore(true);
    }

    MWMenuBar mergeMenus(MWMenuBar mWMenuBar) {
        if (this.fComponent instanceof DTApplication) {
            return ((DTApplication)((Object)this.fComponent)).mergeMenus(mWMenuBar);
        }
        return mWMenuBar;
    }

    public DTClientFrame getClientFrame() {
        return this.fClientFrame;
    }

    void setClientFrame(DTClientFrame dTClientFrame) {
        this.fClientFrame = dTClientFrame;
        if (this.fDesktop != null && this.fMenuItem != null) {
            DTMenuBar.setViewMenuItemState(this.fMenuItem, this.fClientFrame != null);
            this.fMenuItem.setState(this.fClientFrame != null);
        }
    }

    public DTDockPath getDockPath() {
        if (this.getClientFrame() != null) {
            this.fDockPath = this.getClientFrame().getDockPath();
        }
        return this.fDockPath.cloneIt();
    }

    public void setDockPath(DTDockPath dTDockPath) {
        this.undock(true);
        this.fDockPath = dTDockPath;
    }

    public DTDockPath getLastInternalDockPath() {
        return this.fLastInternalDockPath;
    }

    public void setLastInternalDockPath(DTDockPath dTDockPath) {
        this.fLastInternalDockPath = dTDockPath;
    }

    public DTDockPath getLastExternalDockPath() {
        return this.fLastExternalDockPath;
    }

    public void setLastExternalDockPath(DTDockPath dTDockPath) {
        this.fLastExternalDockPath = dTDockPath;
    }

    MWFrameProxy getFrameProxy() {
        return this.fFrameProxy;
    }

    void setFrameProxy(MWFrameProxy mWFrameProxy) {
        this.fFrameProxy = mWFrameProxy;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public void setTitle(String string) {
        DTClientFrame dTClientFrame = null;
        this.fTitle = string;
        dTClientFrame = this.getClientFrame();
        if (dTClientFrame != null) {
            dTClientFrame.updateTitle(this);
        }
        if (this.fMenuItem != null) {
            this.fMenuItem.setLabel(this.getShortName());
        }
    }

    MWCheckboxMenuItem getMenuItem() {
        return this.fMenuItem;
    }

    void setMenuItem(MWCheckboxMenuItem mWCheckboxMenuItem) {
        this.fMenuItem = mWCheckboxMenuItem;
    }

    boolean getInitialVisibility() {
        return this.fInitialVisibility;
    }

    void setInitialVisibility(boolean bl) {
        this.fInitialVisibility = bl;
    }

    protected int getSplitterDividerLocation() {
        Container container;
        int n = 0;
        if (this.fClientFrame != null && (container = ((Component)((Object)this.fClientFrame)).getParent()) instanceof MWSplitter) {
            MWSplitter mWSplitter = (MWSplitter)container;
            n = mWSplitter.getDividerLocation();
        }
        return n;
    }

    boolean isViewMenuEntry() {
        boolean bl = true;
        Component component = this.getClientComponent();
        if (component != null) {
            DTApplication dTApplication;
            if (component instanceof DTApplication && (dTApplication = (DTApplication)((Object)component)).getApplicationType() == 2) {
                bl = false;
            }
        } else if (this.fClassName != null && this.fClassName.endsWith("EditorViewContainer")) {
            bl = false;
        }
        return bl;
    }

    protected void setPostProcessState(int n, boolean bl) {
        this.fInitialSplitterLocation = n;
        this.fOnTop = bl;
    }

    int getCommandID() {
        if (this.fMenuItem != null) {
            return this.fMenuItem.getCommand();
        }
        return 0;
    }

    Component getFirstLayer() {
        return this.fFrameProxy;
    }

    public Component getClientComponent() {
        return this.fComponent;
    }

    void setDesktop(Desktop desktop) {
        this.fDesktop = desktop;
    }

    public void setStatusText(String string) {
        if (this.getClientFrame() != null) {
            this.getClientFrame().getDTContainer().setStatusText(string);
        }
    }

    public boolean isDocked() {
        return this.fClientFrame != null;
    }

    void postRestoreFixup() {
        if (this.fClientFrame != null) {
            Container container = ((Component)((Object)this.fClientFrame)).getParent();
            if (container instanceof MWSplitter) {
                MWSplitter mWSplitter = (MWSplitter)container;
                mWSplitter.setDividerLocation(this.fInitialSplitterLocation);
                this.getClientComponent().repaint();
            }
            if (this.fOnTop) {
                this.fClientFrame.showClient(this, false);
            }
        }
    }

    public int closeWindow() {
        int n = 0;
        if (this.isDocked()) {
            n = this.toggleViewState();
        }
        return n;
    }

    public void activate() {
        Component component = this.getClientComponent();
        if (component != null) {
            component.requestFocus();
        }
        this.setActive(true);
    }

    public void setActive(boolean bl) {
        if (this.fComponent instanceof MWWindowOwner) {
            ((MWWindowOwner)this.fComponent).setActive(bl);
        }
        if (this.fFrameProxy != null) {
            this.fFrameProxy.setActive(bl);
        }
        if (this.fClientFrame != null) {
            this.fClientFrame.setActive(bl);
            if (bl) {
                this.fClientFrame.setActiveClient(this);
            }
        }
    }

    public void activateNextClient(boolean bl) {
        if (bl) {
            this.fClientFrame.activateNextClient(this);
            return;
        }
        this.fClientFrame.activatePreviousClient(this);
    }

    public String getShortName() {
        DTApplication dTApplication;
        String string;
        String string2 = this.fTitle;
        if (this.fComponent instanceof DTApplication && (string = (dTApplication = (DTApplication)((Object)this.fComponent)).getShortName()) != null) {
            string2 = string;
        }
        return string2;
    }

    public String getLongName() {
        return this.fTitle;
    }

    public void saveDesktopClient(BufferedWriter bufferedWriter, FileOutputStream fileOutputStream) throws Exception {
        Object object;
        Object object2;
        Serializable serializable;
        if (this.fComponent == null) {
            bufferedWriter.write(this.fClassName);
            bufferedWriter.newLine();
            bufferedWriter.write(this.fTitle);
            bufferedWriter.newLine();
            bufferedWriter.write(Integer.toString(this.fInitialWidth));
            bufferedWriter.newLine();
            bufferedWriter.write(Integer.toString(this.fInitialHeight));
            bufferedWriter.newLine();
        } else {
            serializable = this.fComponent.getSize();
            bufferedWriter.write(this.fComponent.getClass().getName());
            bufferedWriter.newLine();
            bufferedWriter.write(this.fTitle);
            bufferedWriter.newLine();
            bufferedWriter.write(Integer.toString(((Dimension)serializable).width));
            bufferedWriter.newLine();
            bufferedWriter.write(Integer.toString(((Dimension)serializable).height));
            bufferedWriter.newLine();
        }
        this.getDockPath().writeDockPath(bufferedWriter);
        this.fLastInternalDockPath.writeDockPath(bufferedWriter);
        this.fLastExternalDockPath.writeDockPath(bufferedWriter);
        serializable = new Boolean(this.isDocked());
        bufferedWriter.write(((Boolean)serializable).toString());
        bufferedWriter.newLine();
        boolean bl = false;
        if (this.isDocked() && (object2 = this.getClientFrame()) != null && this == (object = ((DTClientFrame)object2).getActiveClient())) {
            bl = true;
        }
        bufferedWriter.write(new Boolean(bl).toString());
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.getSplitterDividerLocation()));
        bufferedWriter.newLine();
        if (this.fComponent != null && this.fComponent instanceof DTApplication) {
            object2 = new ByteArrayOutputStream();
            object = new DataOutputStream((OutputStream)object2);
            DTApplication dTApplication = (DTApplication)((Object)this.fComponent);
            dTApplication.saveState((DataOutputStream)object);
            ((DataOutputStream)object).flush();
            int n = ((DataOutputStream)object).size();
            bufferedWriter.write(Integer.toString(n));
            bufferedWriter.newLine();
            bufferedWriter.flush();
            if (n > 0) {
                fileOutputStream.write(((ByteArrayOutputStream)object2).toByteArray());
                bufferedWriter.newLine();
                bufferedWriter.flush();
            }
            ((FilterOutputStream)object).close();
            return;
        }
        bufferedWriter.write("0");
        bufferedWriter.newLine();
        bufferedWriter.flush();
    }

    public static DTClient createDesktopClient(Desktop desktop, BufferedReader bufferedReader) {
        DTClient dTClient = null;
        String string = null;
        String string2 = null;
        DTDockPath dTDockPath = null;
        DTDockPath dTDockPath2 = null;
        DTDockPath dTDockPath3 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = null;
        try {
            string = bufferedReader.readLine();
            string2 = bufferedReader.readLine();
            n = Integer.parseInt(bufferedReader.readLine());
            n2 = Integer.parseInt(bufferedReader.readLine());
            dTDockPath = DTDockPath.readDockPath(bufferedReader);
            dTDockPath2 = DTDockPath.readDockPath(bufferedReader);
            dTDockPath3 = DTDockPath.readDockPath(bufferedReader);
            bl = Boolean.valueOf(bufferedReader.readLine());
            bl2 = Boolean.valueOf(bufferedReader.readLine());
            n4 = Integer.valueOf(bufferedReader.readLine());
            n3 = Integer.parseInt(bufferedReader.readLine());
            if (n3 != 0) {
                byArray = new byte[n3];
                char[] cArray = new char[n3];
                bufferedReader.read(cArray, 0, n3);
                int n5 = 0;
                while (n5 < n3) {
                    byArray[n5] = (byte)cArray[n5];
                    ++n5;
                }
                bufferedReader.skip(System.getProperty("line.separator").length());
            }
            dTClient = new DTClient(desktop, string, string2, dTDockPath, dTDockPath2, dTDockPath3, n, n2, byArray);
            dTClient.setPostProcessState(n4, bl2);
            desktop.addClient(dTClient, bl);
        }
        catch (Exception exception) {
            dTClient = null;
        }
        return dTClient;
    }
}

