/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.browsers;

import com.mathworks.ide.browsers.FileView;
import com.mathworks.ide.browsers.ProjectView;
import com.mathworks.ide.editor.MWReplaceDialog;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWCheckboxMenuItem;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWSplitter;
import com.mathworks.mwt.MWTList;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.MWToolbar;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.dialog.MWAlert;
import com.mathworks.mwt.dialog.MWDialog;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.message.MWMessage;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ResLoader;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class PathViewer
extends MWPanel
implements MWCommandTarget,
MWWindowOwner {
    private static final int WHICH_MESSAGE = 1;
    private static final int PIC_COUNT = 7;
    private static final int DISK_PIC = 0;
    private static final int FOLDER_PIC = 1;
    private static final int DOC_PIC = 2;
    private static final int M_PIC = 3;
    private static final int MAT_PIC = 4;
    private static final int MEX_PIC = 5;
    private static final int P_PIC = 6;
    private static final int NEW_PROJECT = 1;
    private static final int FINDINFILES = 2;
    private static final int SHOW_FILES = 3;
    private static final int SHOW_DESCRIPTIONS = 4;
    public static final int REMOVE_CURRENT_TAB = 5;
    private static final int INTEREST_REPLY = 1;
    private static final int CWD_REPLY = 2;
    private static final String MY_NAME = "MATLAB Path Viewer";
    private static String fSeparator = PlatformInfo.getPlatform() == 2 ? "/" : "\\";
    transient ItemListener fItemListener;
    private static PathViewer fPathViewer;
    private FileView fFilePanel;
    private int fSaveDividerLocation;
    private int fNextID;
    private boolean fShowFiles = true;
    private boolean fShowHelp = false;
    private MWPanel fCenterPanel;
    private MWCommandCenter fCenter;
    private Image[] fFilePic;
    private MWFrame fMyFrame;
    private PopupMenu fPopupMenu = new PopupMenu();
    private TextField fFileViewTextField;
    private int fNewItemID = -1;
    private MWButton fAddToPathButton = new MWButton("...");
    private MWTList fPathList = new MWTList(true, false, 2);
    private MWTList fPathListNoHelp = new MWTList(true, false);
    private MWToolbar fToolbar;
    private MWCheckboxMenuItem fShowFilesMenuItem;
    private MWCheckboxMenuItem fShowDescriptionMenuItem;
    private MWCheckbox fMatchCaseCheckbox;
    private MWCheckbox fWholeWordOnlyCheckbox;
    private MWPanel fPathPanel;
    private MWPanel fSplitterPanel;
    private MWSplitter fSplitter;
    private MyItemListener fDirectoryItemListener;
    private Matlab fMatlab;
    private WorkspaceCallback fCallback;
    private CwdCallback fCwdCallback;
    private Image[] fIcon = new Image[2];
    private ResLoader resources = new ResLoader((Component)((Object)this));
    static /* synthetic */ Class class$java$lang$Integer;

    public PathViewer() {
        fPathViewer = this;
        this.loadResources();
        this.fMyFrame = new MWFrame(MY_NAME);
        this.fNextID = 0;
        this.setOpaque(false);
        this.fMatlab = new Matlab(new MWLooper("PathViewer - path manipulation"));
        this.fCenter = new MWCommandCenter((MWCommandTarget)this);
        String[] stringArray = new String[]{"Directories on MATLAB's path:", "Description"};
        this.fPathList.setHeader(stringArray);
        this.fPathList.setWholeItemSelect(true);
        this.fPathList.setMultiSelection(true);
        this.fPathListNoHelp.setHeader(stringArray[0]);
        this.fPathListNoHelp.setWholeItemSelect(true);
        this.fPathListNoHelp.setWholeItemHilite(true);
        this.fPathListNoHelp.setMultiSelection(true);
        this.buildPathList();
        this.resources.waitForPendingImages();
        ((Component)((Object)this)).repaint();
        this.fPathList.selectItem(0);
        this.fPathListNoHelp.selectItem(0);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.fDirectoryItemListener = new MyItemListener();
        this.fPathPanel = new MWPanel((LayoutManager)new BorderLayout());
        this.fPathPanel.add((Component)this.fPathListNoHelp, "Center");
        this.fPathPanel.setOpaque(false);
        this.fPathList.setOpaque(false);
        this.fPathListNoHelp.setOpaque(false);
        this.setInsets(new Insets(5, 5, 5, 5));
        if (this.fShowFiles) {
            this.fPathList.addItemListener((ItemListener)this.fDirectoryItemListener);
            this.fPathListNoHelp.addItemListener((ItemListener)this.fDirectoryItemListener);
        }
        boolean bl = true;
        boolean bl2 = false;
        this.fFilePanel = new FileView(bl, bl2);
        ((Component)((Object)this.fFilePanel)).setVisible(true);
        MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel.setBackground(Color.red);
        this.fSplitter = new MWSplitter((Component)this.fPathPanel, (Component)((Object)this.fFilePanel), 0);
        this.fSplitter.setOrientation(0);
        this.fSplitter.setDividerLocation(0.33);
        this.fSplitter.setOpaque(false);
        this.fCenterPanel = new MWPanel((LayoutManager)new BorderLayout());
        this.fCenterPanel.setOpaque(false);
        this.fCenterPanel.add((Component)this.fSplitter, "Center");
        ((Container)((Object)this)).add((Component)this.fSplitter, "Center");
        Font font = new Font("Courier New", 0, 10);
        this.fPathList.setFont(font);
        this.fPathListNoHelp.setFont(font);
        this.createPopupMenu();
        ((Component)((Object)this)).setVisible(true);
        this.fPathList.invalidate();
        ((Container)((Object)this)).validate();
        MWReplaceDialog mWReplaceDialog = MWReplaceDialog.getReplaceDialog();
        if (mWReplaceDialog != null) {
            mWReplaceDialog.addSearchFilters(2);
        }
        this.registerWorkspaceInterests();
    }

    private void loadResources() {
        this.resources = new ResLoader((Component)((Object)this));
        this.fIcon[0] = this.resources.loadImage("/com/mathworks/mwt/resources/folder.gif");
        this.fIcon[1] = this.resources.loadImage("/com/mathworks/mwt/resources/folderwin.gif");
        this.fFilePic = new Image[14];
        this.fFilePic[0] = this.resources.loadImage("/com/mathworks/mwt/resources/disk.gif");
        this.fFilePic[1] = this.resources.loadImage("/com/mathworks/mwt/resources/folder.gif");
        this.fFilePic[2] = this.resources.loadImage("/com/mathworks/mwt/resources/document.gif");
        this.fFilePic[3] = this.resources.loadImage("/com/mathworks/mwt/resources/m.gif");
        this.fFilePic[4] = this.resources.loadImage("/com/mathworks/mwt/resources/mat.gif");
        this.fFilePic[5] = this.resources.loadImage("/com/mathworks/mwt/resources/mex.gif");
        this.fFilePic[6] = this.resources.loadImage("/com/mathworks/mwt/resources/p.gif");
        this.fFilePic[7] = this.resources.loadImage("/com/mathworks/mwt/resources/mdl.gif");
        this.fFilePic[8] = this.resources.loadImage("/com/mathworks/mwt/resources/tlc.gif");
        this.fFilePic[9] = this.resources.loadImage("/com/mathworks/mwt/resources/diskwin.gif");
        this.fFilePic[10] = this.resources.loadImage("/com/mathworks/mwt/resources/folderwin.gif");
        this.fFilePic[11] = this.resources.loadImage("/com/mathworks/mwt/resources/documentwin.gif");
        this.fFilePic[12] = this.resources.loadImage("/com/mathworks/mwt/resources/mwin.gif");
        this.fFilePic[13] = this.resources.loadImage("/com/mathworks/mwt/resources/matwin.gif");
    }

    private MWTList getPathList() {
        if (this.fShowHelp) {
            return this.fPathList;
        }
        return this.fPathListNoHelp;
    }

    public static PathViewer getPathViewer() {
        return fPathViewer;
    }

    public Object[] getSelectedDirectories() {
        MWTList mWTList = this.getPathList();
        Object[] objectArray = new Object[mWTList.getRows()];
        objectArray = mWTList.getSelectedObjects();
        int n = mWTList.getFirstSelectedItem();
        int n2 = 0;
        while (n != -1) {
            objectArray[n2++] = n == 0 ? this.getCurrentDirectoryName() : mWTList.getItemString(n);
            n = mWTList.getNextSelectedItem(n);
        }
        return objectArray;
    }

    public Object[] getSelectedFiles() {
        return this.fFilePanel.getSelectedFiles();
    }

    private void buildPathList() {
        this.fMatlab.eval("matlabpath", (CompletionObserver)new PathCallback());
    }

    private void createMasterToolbar() {
        String string = PlatformInfo.getAppearance() == 1 ? "_win.gif" : ".gif";
        this.fToolbar = new MWToolbar();
        this.fToolbar.addImageButton("/com/mathworks/mwt/resources/find" + string, 2, "Find in Files", this.fCenter);
        ((Container)((Object)this)).add((Component)this.fToolbar, "North");
    }

    private MWToolbar createPathPanelToolbar() {
        String string = PlatformInfo.getAppearance() == 1 ? "_win.gif" : ".gif";
        MWToolbar mWToolbar = new MWToolbar();
        mWToolbar.addImageButton("/com/mathworks/mwt/resources/mwin.gif", 3, "Show Files", this.fCenter);
        mWToolbar.addSpacer();
        mWToolbar.addImageButton("/com/mathworks/mwt/resources/find" + string, 2, "Find in Files", this.fCenter);
        mWToolbar.addSpacer();
        mWToolbar.addComponent((Component)new MWLabel("Find function:   "));
        MWTextField mWTextField = new MWTextField(10);
        mWToolbar.addComponent((Component)mWTextField);
        mWTextField.addActionListener((ActionListener)new WhichActionListener());
        return mWToolbar;
    }

    private void dontShowFiles() {
        this.fSaveDividerLocation = this.fSplitter.getDividerLocation();
        this.fSplitterPanel.remove((Component)this.fSplitter);
        this.fSplitterPanel.add((Component)this.fPathPanel);
        ((Container)((Object)this)).validate();
        this.fShowFiles = false;
        if (this.fShowFilesMenuItem != null) {
            this.fShowFilesMenuItem.setState(false);
        }
        this.fPathList.removeItemListener((ItemListener)this.fDirectoryItemListener);
        this.fPathListNoHelp.removeItemListener((ItemListener)this.fDirectoryItemListener);
        this.fFilePanel.setShowHelp(this.fShowHelp);
    }

    private void doShowFiles() {
        this.fSplitterPanel.remove((Component)this.getPathList());
        this.fPathPanel.add((Component)this.getPathList(), "Center");
        this.fSplitter = new MWSplitter((Component)this.fPathPanel, (Component)((Object)this.fFilePanel));
        this.fSplitterPanel.add((Component)this.fSplitter);
        ((Container)((Object)this)).validate();
        this.fSplitter.setDividerLocation(this.fSaveDividerLocation);
        this.fShowFiles = true;
        if (this.fShowFilesMenuItem != null) {
            this.fShowFilesMenuItem.setState(true);
        }
        this.fPathList.addItemListener((ItemListener)this.fDirectoryItemListener);
        this.fPathListNoHelp.addItemListener((ItemListener)this.fDirectoryItemListener);
        this.fFilePanel.setShowHelp(this.fShowHelp);
    }

    private void showHelp(boolean bl) {
        int n = this.getPathList().getFirstSelectedItem();
        int n2 = this.getPathList().getTopItem();
        this.fPathPanel.remove((Component)this.getPathList());
        this.fShowHelp = bl;
        this.fPathPanel.add((Component)this.getPathList());
        this.getPathList().unselectAll();
        this.getPathList().selectItem(n);
        this.getPathList().setTopItem(n2);
        ((Container)((Object)this)).validate();
        if (bl) {
            int[] nArray = new int[]{250, 550};
            this.fPathList.setColumnWidths(nArray);
            this.fMyFrame.setSize(700, this.fMyFrame.getSize().height);
        } else {
            this.fMyFrame.setSize(700, this.fMyFrame.getSize().height);
        }
        if (this.fShowFiles) {
            this.fFilePanel.setShowHelp(bl);
        }
    }

    public void doCommand(int n) {
        boolean bl = true;
        if (this.fCenter.getCommandEnabled(n)) {
            switch (n) {
                case 1: {
                    this.createNewProject();
                    return;
                }
                case 2: {
                    MWReplaceDialog.invoke(this.getFrame(), 2, null, "", 0);
                    return;
                }
                case 3: {
                    if (!this.fShowFiles) {
                        this.doShowFiles();
                        return;
                    }
                    this.dontShowFiles();
                    return;
                }
                case 4: {
                    this.showHelp(!this.fShowHelp);
                    return;
                }
                case -103: {
                    this.getFrame().dispose();
                    return;
                }
            }
            bl = false;
            return;
        }
    }

    private void createNewProject() {
        ProjectView projectView = new ProjectView();
        projectView.setShowHelp(false);
        MWFrame mWFrame = new MWFrame("Project Browser");
        mWFrame.add((Component)((Object)projectView), "Center");
        mWFrame.addWindowListener((WindowListener)new MWWindowActivater((Component)((Object)projectView)));
        mWFrame.setLocation(20, 40);
        mWFrame.setSize(310, 300);
        mWFrame.show();
    }

    public static String getToolTipText(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        String string2 = null;
        int n = 1;
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        if (file.isDirectory()) {
            string2 = String.valueOf(string) + fSeparator + "Contents.m";
            object = new File(string2);
            if (!((File)object).exists()) {
                return "<Contents.m does not exist>";
            }
        } else {
            if (file.getName().equals("Contents.m")) {
                return "Description of this directory.";
            }
            if (string.endsWith(".m")) {
                string2 = string;
                n = 2;
            } else {
                return "";
            }
        }
        if (string2 == null) {
            return null;
        }
        object = null;
        String string3 = null;
        try {
            object = new BufferedReader(new FileReader(string2));
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (object != null) {
            try {
                while (!((string3 = ((BufferedReader)object).readLine()) == null || string3.length() != 0 && string3.charAt(0) == '%' || string3 == null && string3.length() == 0 && string3.charAt(0) == '%')) {
                }
                ((BufferedReader)object).close();
                if (string3 == null || string3.length() == 0 || string3.charAt(0) != '%') {
                    return "<No help found>";
                }
            }
            catch (IOException iOException) {}
        }
        if (string3 == null) {
            return null;
        }
        if (string3.length() == 0) {
            return string3;
        }
        String string4 = string3.substring(1, string3.length());
        return string4.trim();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void createPopupMenu() {
        this.fPopupMenu.add("Insert Directory in Path...");
        this.fPopupMenu.add("Delete Directory from Path");
        this.fPathListNoHelp.add(this.fPopupMenu);
        this.fPopupMenu.addActionListener(new 1());
    }

    private void addToPath() {
        int n = this.fPathListNoHelp.getFirstSelectedItem();
        this.fNewItemID = this.fNextID++;
        this.fPathListNoHelp.unselectAll();
        this.fPathListNoHelp.insertBefore(n, this.fNewItemID, "", this.fFilePic[10], false);
        this.fPathListNoHelp.invalidate();
        ((Container)((Object)this)).validate();
        this.fPathListNoHelp.repaint();
        this.fFileViewTextField = new TextField("", 20);
        this.fPathListNoHelp.add(this.fFileViewTextField);
        Rectangle rectangle = this.fPathListNoHelp.getItemRect(this.fNewItemID, 0);
        rectangle.x += 20;
        rectangle.width = 150;
        this.fFileViewTextField.setBounds(rectangle);
        this.fFileViewTextField.setVisible(true);
        this.fFileViewTextField.requestFocus();
        this.fFileViewTextField.setFont(this.fPathListNoHelp.getFont());
        this.fFileViewTextField.addActionListener(new AddToPathTextFieldListener());
        this.fPathListNoHelp.add((Component)this.fAddToPathButton);
        rectangle.x += 152;
        rectangle.width = 30;
        this.fAddToPathButton.setBounds(rectangle);
        this.fAddToPathButton.setVisible(true);
        this.fAddToPathButton.addMouseListener(new AddToPathButtonListener());
        this.fPathListNoHelp.invalidate();
        ((Container)((Object)this)).validate();
    }

    public void refresh() {
        this.fMatlab.eval("cd", (CompletionObserver)this.fCwdCallback);
    }

    private void registerWorkspaceInterests() {
        this.fCallback = new WorkspaceCallback(1);
        this.fCwdCallback = new CwdCallback(2);
        this.fMatlab.registerInterest(2, 0x40000000, (CompletionObserver)this.fCallback);
        this.fMatlab.registerInterest(2, Integer.MIN_VALUE, (CompletionObserver)this.fCallback);
        this.refresh();
    }

    /*
     * Unable to fully structure code
     */
    private void buildPathListReply(String var1_1) {
        var2_2 = new String[2];
        if (var1_1 == null) {
            return;
        }
        var4_3 = var1_1.length();
        if (var4_3 == 0) {
            return;
        }
        var3_4 = 1;
        while (var3_4 < var4_3 && var1_1.charAt(var3_4) != '\n' && var1_1.charAt(var3_4) != '\r') {
            ++var3_4;
        }
        while (var3_4 < var4_3 && (var1_1.charAt(var3_4) == '\n' || var1_1.charAt(var3_4) == '\r')) {
            ++var3_4;
        }
        var6_5 = this.getPathList();
        var7_6 = this.getCurrentDirectoryName();
        var8_7 = var6_5.getItemString(var6_5.getFirstSelectedItem());
        this.fPathList.removeAll();
        this.fPathListNoHelp.removeAll();
        this.fNextID = 0;
        var9_8 = true;
        while (true) {
            block10: {
                if (!var9_8) ** GOTO lbl26
                var2_2[0] = var7_6;
                break block10;
lbl-1000:
                // 1 sources

                {
                    ++var3_4;
lbl26:
                    // 2 sources

                    ** while (var3_4 < var4_3 && var1_1.charAt((int)var3_4) == ' ' || var1_1.charAt((int)var3_4) == '\t')
                }
lbl27:
                // 1 sources

                var5_9 = var3_4;
                while (var3_4 < var4_3 && var1_1.charAt(var3_4) != '\n' && var1_1.charAt(var3_4) != '\r') {
                    ++var3_4;
                }
                var2_2[0] = var1_1.substring(var5_9, var3_4);
            }
            var10_10 = PathViewer.getToolTipText(var2_2[0]);
            var2_2[1] = var10_10 != null ? var10_10 : "<Directory does not exist>";
            this.fPathList.add(-1, this.fNextID, var2_2, this.fIcon[1], false);
            this.fPathListNoHelp.add(-1, this.fNextID++, var2_2[0], this.fIcon[1], false);
            if (!var9_8 && (++var3_4 >= var4_3 || var1_1.charAt(var3_4) == '\n' || var1_1.charAt(var3_4) == '\r')) break;
            var9_8 = false;
        }
        this.fPathList.setItemString(0, 0, String.valueOf(var7_6) + " (Current Directory)");
        this.fPathListNoHelp.setItemString(0, String.valueOf(var7_6) + " (Current Directory)");
        if (var8_7 == null) {
            var6_5.selectItem(0);
            return;
        }
        var3_4 = 0;
        while (var3_4 < var6_5.getRows()) {
            if (var6_5.getItemString(var3_4).equals(var8_7)) {
                var6_5.selectItem(var3_4);
                return;
            }
            ++var3_4;
        }
    }

    public Object[] getSelectedObjects() {
        if (this.fPathList.getFirstSelectedItem() != -1) {
            Object[] objectArray = new Object[]{this.fPathList.getItemString(this.fPathList.getFirstSelectedItem())};
            return objectArray;
        }
        return null;
    }

    public void addItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.add(this.fItemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.remove(this.fItemListener, itemListener);
    }

    private String getCurrentDirectoryName() {
        if (this.getPathList().getRows() == 0) {
            return null;
        }
        String string = this.getPathList().getItemString(0);
        if (string.length() > 20) {
            string = string.substring(0, string.length() - 20);
        }
        return string;
    }

    private String getSelectedDirectoryName() {
        int n = this.getPathList().getFirstSelectedItem();
        String string = this.getPathList().getItemString(n);
        if (n == 0) {
            string = this.getCurrentDirectoryName();
        }
        return string;
    }

    public static void main(String[] stringArray) {
        PathViewer pathViewer = new PathViewer();
        pathViewer.fMyFrame.add((Component)((Object)pathViewer), "Center");
        pathViewer.fMyFrame.addWindowListener((WindowListener)new MWWindowActivater((Component)((Object)pathViewer)));
        pathViewer.fMyFrame.setLocation(20, 40);
        pathViewer.fMyFrame.setSize(700, 500);
        pathViewer.fMyFrame.show();
    }

    public Image getFileIcon(String string, int n) {
        if (string.endsWith(".m") || string.endsWith(".cdr")) {
            return this.fFilePic[3 + n];
        }
        if (string.endsWith(".mat")) {
            return this.fFilePic[4 + n];
        }
        if (string.endsWith(".mex")) {
            return this.fFilePic[5 + n];
        }
        if (string.endsWith(".p")) {
            return this.fFilePic[6 + n];
        }
        return this.fFilePic[2 + n];
    }

    public static String xlate(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            if (cArray[n] == '%' && n < cArray.length - 2 && cArray[n + 1] == '2' && cArray[n + 2] == '0') {
                cArray[n2++] = 32;
                n += 2;
            } else {
                cArray[n2++] = cArray[n];
            }
            ++n;
        }
        return String.valueOf(cArray, 0, n2);
    }

    private int selectTextInList(String string) {
        MWTList mWTList = this.getPathList();
        int n = mWTList.getFirstItem();
        while (n != -1) {
            if (mWTList == this.getPathList() && n == 0) {
                if (this.getCurrentDirectoryName().equals(string)) {
                    mWTList.selectItem(n);
                    break;
                }
            } else if (mWTList.getItemString(n).equals(string)) {
                mWTList.selectItem(n);
                break;
            }
            n = mWTList.getNextItem();
        }
        if (this.fShowFiles) {
            this.fFilePanel.setPathName(string);
        }
        return n;
    }

    public int closeWindow() {
        MWReplaceDialog mWReplaceDialog = MWReplaceDialog.getReplaceDialog();
        if (mWReplaceDialog != null) {
            mWReplaceDialog.removeSearchFilters(2);
        }
        this.getFrame().dispose();
        this.fMyFrame = null;
        fPathViewer = null;
        return 0;
    }

    public String getShortName() {
        return MY_NAME;
    }

    public String getLongName() {
        return MY_NAME;
    }

    public void setActive(boolean bl) {
    }

    static /* synthetic */ TextField access$3(PathViewer pathViewer) {
        return pathViewer.fFileViewTextField;
    }

    static /* synthetic */ int access$7() {
        return 2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ int access$14() {
        return 1;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() == "Insert Directory in Path...") {
                PathViewer.this.addToPath();
            }
        }

        /* synthetic */ 1() {
        }
    }

    private class AddToPathButtonListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            FileView fileView = new FileView(true, true);
            MWDialog mWDialog = new MWDialog(PathViewer.this.getFrame(), "Add to Path", true);
            mWDialog.add((Component)((Object)fileView), "Center");
            MWPanel mWPanel = new MWPanel((LayoutManager)new FlowLayout(1));
            mWPanel.add((Component)new MWButton("Add to Path"));
            mWPanel.add((Component)new MWButton("Cancel"));
            fileView.setPathName("g:\\v5\\java\\src");
            mWDialog.add((Component)mWPanel, "South");
            mWDialog.addWindowListener((WindowListener)new MWWindowActivater((Component)mWDialog));
            mWDialog.setLocation(20, 40);
            mWDialog.setSize(600, 400);
            mWDialog.setVisible(true);
        }

        AddToPathButtonListener() {
            PathViewer.this = PathViewer.this;
        }
    }

    private class AddToPathTextFieldListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            TextField textField = (TextField)actionEvent.getSource();
            String string = textField.getText();
            File file = new File(string);
            if (file.isDirectory()) {
                textField.setVisible(false);
                PathViewer.this.fAddToPathButton.setVisible(false);
                textField.removeActionListener(this);
                PathViewer.this.fPathListNoHelp.remove(textField);
                PathViewer.this.fFileViewTextField = null;
                PathViewer.this.fPathListNoHelp.setItemString(PathViewer.this.fNewItemID, string);
                PathViewer.this.fPathListNoHelp.unselectAll();
                PathViewer.this.fPathListNoHelp.selectItem(PathViewer.this.fNewItemID);
                PathViewer.this.fPathListNoHelp.requestFocus();
                return;
            }
            new MWAlert(PathViewer.this.getFrame(), "Error", "Cannot add to path: Directory does not exist.", 1);
        }

        AddToPathTextFieldListener() {
            PathViewer.this = PathViewer.this;
        }
    }

    class PathCallback
    implements CompletionObserver {
        int fReplyType;

        public PathCallback() {
            PathViewer.this = PathViewer.this;
        }

        public void completed(int n, Object object) {
            PathViewer.this.buildPathListReply((String)object);
        }
    }

    class CwdCallback
    implements CompletionObserver {
        int fReplyType;

        public CwdCallback(int n) {
            PathViewer.this = PathViewer.this;
            this.fReplyType = n;
        }

        public void completed(int n, Object object) {
            if (this.fReplyType == PathViewer.access$7()) {
                String string = (String)object;
                String string2 = string.trim();
                PathViewer.this.fPathList.setItemString(0, 0, String.valueOf(string2) + " (Current Directory)");
                PathViewer.this.fPathList.setItemString(0, 1, PathViewer.getToolTipText(string2));
                PathViewer.this.fPathListNoHelp.setItemString(0, 0, String.valueOf(string2) + " (Current Directory)");
                PathViewer.this.fFilePanel.setPathName(PathViewer.this.getSelectedDirectoryName());
            }
        }
    }

    class WorkspaceCallback
    implements CompletionObserver {
        int fReplyType;

        public WorkspaceCallback(int n) {
            PathViewer.this = PathViewer.this;
            this.fReplyType = n;
        }

        public void completed(int n, Object object) {
            MWMessage mWMessage = (MWMessage)object;
            Integer n2 = (Integer)mWMessage.findData("eventid", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PathViewer.class$("java.lang.Integer")));
            if (n2 == 0x40000000) {
                PathViewer.this.refresh();
                return;
            }
            if (n2 == Integer.MIN_VALUE) {
                PathViewer.this.buildPathList();
            }
        }
    }

    private class MenuListMouseAdapter
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            this.doStuff(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.doStuff(mouseEvent);
        }

        public void doStuff(MouseEvent mouseEvent) {
            MWTList mWTList = (MWTList)mouseEvent.getSource();
            if (mouseEvent.isPopupTrigger()) {
                PathViewer.this.fPopupMenu.show((Component)mWTList, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        MenuListMouseAdapter() {
            PathViewer.this = PathViewer.this;
        }
    }

    class WhichActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MWTextField mWTextField = (MWTextField)actionEvent.getSource();
            String string = mWTextField.getText();
            if (string.equals("")) {
                return;
            }
            PathViewer.this.fMatlab.eval("which " + string, (CompletionObserver)new CwdCallback2(PathViewer.access$14()));
        }

        WhichActionListener() {
            PathViewer.this = PathViewer.this;
        }
    }

    class MyItemListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            PathViewer.this.fFilePanel.setPathName(PathViewer.this.getSelectedDirectoryName());
        }

        MyItemListener() {
            PathViewer.this = PathViewer.this;
        }
    }

    class MyCheckboxItemListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                PathViewer.this.doShowFiles();
                return;
            }
            PathViewer.this.dontShowFiles();
        }

        MyCheckboxItemListener() {
            PathViewer.this = PathViewer.this;
        }
    }

    class MyCheckboxItemListener2
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                PathViewer.this.showHelp(true);
                return;
            }
            PathViewer.this.showHelp(false);
        }

        MyCheckboxItemListener2() {
            PathViewer.this = PathViewer.this;
        }
    }

    class CwdCallback2
    implements CompletionObserver {
        private int fMessageType;

        public CwdCallback2(int n) {
            PathViewer.this = PathViewer.this;
            this.fMessageType = n;
        }

        public void completed(int n, Object object) {
            String string = (String)object;
            if (this.fMessageType == PathViewer.access$14()) {
                int n2 = string.length() - 1;
                while (n2 >= 0) {
                    if (string.charAt(n2) == fSeparator.charAt(0)) break;
                    --n2;
                }
                if (n2 == -1) {
                    new MWAlert(PathViewer.this.getFrame(), "MATLAB File Browser", string, 1);
                    return;
                }
                String string2 = string.substring(0, n2);
                String string3 = string.substring(n2 + 1, string.length() - 1);
                PathViewer.this.getPathList().unselectAll();
                if (PathViewer.this.selectTextInList(string2) != -1) {
                    PathViewer.this.fPathList.showFirstSelectedItem();
                    if (!PathViewer.this.fShowFiles) {
                        PathViewer.this.fShowFilesMenuItem.setState(true);
                        PathViewer.this.doShowFiles();
                    }
                    PathViewer.this.fFilePanel.selectFilename(string3);
                }
            }
        }
    }

    private class MyMWTextField
    extends MWTextField {
        public MyMWTextField(String string, int n) {
            super(string, n);
            PathViewer.this = PathViewer.this;
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.fWidth, this.fHeight);
        }
    }
}

