/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.browsers;

import com.mathworks.ide.browsers.PathBrowser;
import com.mathworks.ide.browsers.PathHandler;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWListbox;
import com.mathworks.mwt.dialog.MWAlert;
import com.mathworks.mwt.dialog.MWFileDialog;
import com.mathworks.mwt.dialog.MWFileFilter;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.message.MWMessage;
import com.mathworks.mwt.table.LabeledImageResource;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ResLoader;
import com.mathworks.util.StringUtils;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ResourceBundle;
import java.util.Vector;

public class PathListbox
extends MWListbox
implements KeyListener {
    private ResLoader resources;
    private Image fIcon;
    private Matlab fMatlab;
    private PathCallback fCallback;
    private String fCurrentPath;
    private String fOrigPath;
    private static final int INTEREST_REPLY = 1;
    private static final String SEPARATOR = System.getProperty("path.separator");
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final int NOT_MOVING = -3;
    private boolean fPrepending = false;
    private boolean fAppending = false;
    private boolean fRemoving = false;
    private boolean fUndoingAllChanges = false;
    private boolean fShowConfirmations = true;
    private volatile boolean fRevertEventsRequired = false;
    private volatile boolean fFirstPathChangeDone = false;
    private int fMovingTo = -3;
    private StringBuffer fRecursiveBuffer;
    private ActionListener fLocalActionListener;
    private static final int SAVE_PATH_REPLY = 200;
    private static ResourceBundle fRes = ResourceBundle.getBundle("com.mathworks.ide.browsers.resources.RES_PathBrowser");
    static /* synthetic */ Class class$java$lang$Integer;

    public PathListbox() {
        ((Component)((Object)this)).addKeyListener(this);
        this.resources = new ResLoader((Component)((Object)this));
        this.fIcon = PlatformInfo.isMacintosh() ? this.resources.loadImage("/com/mathworks/mwt/resources/folder.gif") : this.resources.loadImage("/com/mathworks/mwt/resources/folderwin.gif");
        this.registerPathInterests();
        if (Matlab.isMatlabAvailable()) {
            this.fMatlab.eval("disp(matlabpath)", (CompletionObserver)new FullPathCallback());
        }
    }

    private void registerPathInterests() {
        this.fMatlab = new Matlab(new MWLooper("PathListbox"));
        this.fCallback = new PathCallback(1);
        if (Matlab.isMatlabAvailable()) {
            this.fMatlab.registerInterest(2, Integer.MIN_VALUE, (CompletionObserver)this.fCallback);
        }
    }

    public static PathListbox test() {
        PathListbox pathListbox = new PathListbox();
        MWFrame mWFrame = new MWFrame("PathListbox test");
        mWFrame.setSize(400, 600);
        pathListbox.setSize(400, 600);
        mWFrame.add((Component)((Object)pathListbox));
        mWFrame.setVisible(true);
        return pathListbox;
    }

    public void remove() {
        this.setBusyCursor(true);
        this.fRemoving = true;
        String string = this.getSelectedItem();
        if (Matlab.isMatlabAvailable()) {
            this.fMatlab.evalNoOutput("rmpath('" + PathBrowser.quoteQuotes(string) + "');");
        }
    }

    public void removeWithConfirmation() {
        this.remove();
    }

    public void prepend() {
        this.prepend(this.getSelectedItem());
    }

    public void prepend(String string) {
        if (this.methodPrivateCheck(string)) {
            this.setBusyCursor(true);
            this.fPrepending = true;
            if (Matlab.isMatlabAvailable()) {
                this.fMatlab.evalNoOutput("addpath('" + PathBrowser.quoteQuotes(string) + "', '-begin');");
            }
        }
    }

    public void prependRecursively(String string) {
        File file;
        if (this.methodPrivateCheck(string) && (file = new File(string)).isDirectory()) {
            this.fRecursiveBuffer = new StringBuffer("");
            this.recurse(file);
            this.prepend(this.fRecursiveBuffer.toString());
            this.fRecursiveBuffer = null;
        }
    }

    private void recurse(File file) {
        String string = file.getName();
        if (string.indexOf(64) != 0 && !string.equals("private")) {
            this.fRecursiveBuffer.append(file.getAbsolutePath());
            this.fRecursiveBuffer.append(SEPARATOR);
            String[] stringArray = file.list();
            File file2 = null;
            int n = 0;
            while (n < stringArray.length) {
                file2 = new File(file, stringArray[n]);
                if (file2.isDirectory()) {
                    this.recurse(file2);
                }
                ++n;
            }
        }
    }

    public void append() {
        this.append(this.getSelectedItem());
    }

    public void append(String string) {
        this.setBusyCursor(true);
        this.fAppending = true;
        if (Matlab.isMatlabAvailable()) {
            this.fMatlab.evalNoOutput("addpath('" + PathBrowser.quoteQuotes(string) + "', '-end');");
        }
    }

    public void promote() {
        int n = this.getSelectedIndex();
        if (n != -2 && n > 0) {
            this.moveTo(n - 1);
        }
    }

    public void demote() {
        int n = this.getSelectedIndex();
        if (n != -2 && n < this.getItemCount() - 1) {
            this.moveTo(n + 1);
        }
    }

    public void moveTo(int n) {
        this.setBusyCursor(true);
        int n2 = this.getSelectedIndex();
        int n3 = this.getItemCount();
        if (n2 != n && n != -2 && n < n3) {
            int n4 = n2 < n ? n2 : n;
            int n5 = n2 < n ? n : n2;
            StringBuffer stringBuffer = new StringBuffer("");
            StringBuffer stringBuffer2 = new StringBuffer(this.getItem(n5));
            stringBuffer2.append(SEPARATOR);
            stringBuffer2.append(this.getItem(n4));
            stringBuffer2.append(SEPARATOR);
            int n6 = 0;
            while (n6 < n4) {
                stringBuffer.append(this.getItem(n6));
                stringBuffer.append(SEPARATOR);
                ++n6;
            }
            if (n < n2) {
                stringBuffer.append((Object)stringBuffer2);
            }
            int n7 = n4 + 1;
            while (n7 < n5) {
                stringBuffer.append(this.getItem(n7));
                stringBuffer.append(SEPARATOR);
                ++n7;
            }
            if (n > n2) {
                stringBuffer.append((Object)stringBuffer2);
            }
            int n8 = n5 + 1;
            while (n8 < n3) {
                stringBuffer.append(this.getItem(n8));
                stringBuffer.append(SEPARATOR);
                ++n8;
            }
            this.fMovingTo = n;
            if (Matlab.isMatlabAvailable()) {
                this.fMatlab.evalNoOutput("matlabpath('" + PathBrowser.quoteQuotes(stringBuffer.toString()) + "');");
            }
        }
    }

    public void revertAllChanges() {
        this.fRevertEventsRequired = false;
        this.setBusyCursor(true);
        this.fUndoingAllChanges = true;
        if (Matlab.isMatlabAvailable()) {
            this.fMatlab.evalNoOutput("matlabpath('" + PathBrowser.quoteQuotes(this.fOrigPath) + "');");
        }
    }

    public void save() {
        this.saveAs(null);
    }

    public void saveAs(String string) {
        Object[] objectArray = string != null ? new Object[]{string} : new Object[]{};
        this.fMatlab.feval("path2rc", objectArray, (CompletionObserver)new PathCallback(200));
    }

    private boolean methodPrivateCheck(String string) {
        boolean bl;
        new File(string);
        boolean bl2 = bl = string.indexOf(String.valueOf(FILE_SEPARATOR) + "@") == -1 && string.indexOf(String.valueOf(FILE_SEPARATOR) + "private" + FILE_SEPARATOR) == -1 && !string.endsWith(String.valueOf(FILE_SEPARATOR) + "private");
        if (!bl && this.fShowConfirmations) {
            new MWAlert(this.getFrame(), fRes.getString("listbox.dialog.generic.title"), fRes.getString("listbox.dialog.method.message"), 1);
        }
        return bl;
    }

    public void restoreDefaultPath() {
        int n = 1;
        if (this.fShowConfirmations) {
            MWAlert mWAlert = new MWAlert(this.getFrame(), fRes.getString("listbox.dialog.restore.title"), fRes.getString("listbox.dialog.restore.message"), 3);
            n = mWAlert.getReply();
        }
        if (n == 1) {
            PathHandler.restoreDefaultPath();
        }
    }

    public void setShowConfirm(boolean bl) {
        this.fShowConfirmations = bl;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        super.addActionListener(actionListener);
        this.fLocalActionListener = AWTEventMulticaster.add(this.fLocalActionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        super.addActionListener(actionListener);
        this.fLocalActionListener = AWTEventMulticaster.remove(this.fLocalActionListener, actionListener);
    }

    public void processActionEvent(ActionEvent actionEvent) {
        if (this.fLocalActionListener != null) {
            this.fLocalActionListener.actionPerformed(actionEvent);
        }
    }

    void fireAction(String string) {
        this.processActionEvent(new ActionEvent(this, 0, string));
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127) {
            this.removeWithConfirmation();
        }
    }

    private void setBusyCursor(boolean bl) {
        Cursor cursor = bl ? Cursor.getPredefinedCursor(3) : Cursor.getPredefinedCursor(0);
        ((Component)((Object)this)).setCursor(cursor);
        if (bl) {
            this.fireAction("BUSY_CURSOR");
            return;
        }
        this.fireAction("FREE_CURSOR");
    }

    private void updateListbox(String string) {
        int n;
        int n2 = this.getSelectedIndex();
        string = "X" + string;
        Vector<String> vector = new Vector<String>(32);
        int n3 = 0;
        while (n3 != -1) {
            n = string.indexOf(SEPARATOR, n3 + 1);
            if (n != -1) {
                vector.addElement(string.substring(n3 + 1, n));
            } else {
                vector.addElement(string.substring(n3 + 1));
            }
            n3 = n;
        }
        n = vector.size();
        this.removeAllItems();
        int n4 = 0;
        while (n4 < n) {
            this.addItem(new LabeledImageResource(this.fIcon, (String)vector.elementAt(n4)));
            ++n4;
        }
        if (this.fPrepending) {
            this.setSelectedIndex(0);
            this.fPrepending = false;
        } else if (this.fAppending) {
            this.setSelectedIndex(this.getItemCount() - 1);
            this.scrollToCell(this.getItemCount() - 1, 0);
            this.fAppending = false;
        } else if (this.fUndoingAllChanges) {
            this.fUndoingAllChanges = false;
        } else if (this.fRemoving) {
            if (n2 >= this.getItemCount()) {
                n2 = this.getItemCount() - 1;
            }
            this.setSelectedIndex(n2);
            this.scrollToCell(n2, 0);
        } else if (this.fMovingTo != -3) {
            this.setSelectedIndex(this.fMovingTo);
            this.scrollToCell(this.fMovingTo, 0);
            this.fMovingTo = -3;
        }
        this.setBusyCursor(false);
        if (!this.fFirstPathChangeDone) {
            this.fFirstPathChangeDone = true;
        } else {
            this.fireAction("PATH_CHANGED");
        }
        if (this.fRevertEventsRequired) {
            this.fireAction("ENABLE_REVERSION");
            return;
        }
        this.fRevertEventsRequired = true;
    }

    private void evaluateSaveResults(double d) {
        if (d == 0.0) {
            this.fRevertEventsRequired = false;
            this.fOrigPath = this.fCurrentPath;
            this.fireAction("PATH_SAVED");
            return;
        }
        if (d == 1.0) {
            MWAlert mWAlert = new MWAlert(this.getFrame(), fRes.getString("listbox.dialog.generic.title"), fRes.getString("listbox.dialog.save.alternate.message"), 3);
            if (mWAlert.getReply() == 1) {
                MWFileDialog mWFileDialog = new MWFileDialog(this.getFrame(), fRes.getString("listbox.dialog.select.title"), 1, new MWFileFilter());
                mWFileDialog.setFile("pathdef.m");
                mWFileDialog.show();
                String string = mWFileDialog.getFile();
                File file = new File(mWFileDialog.getDirectory());
                File file2 = string == null || string.equals("") ? new File(file, "pathdef.m") : new File(file, string);
                this.saveAs(StringUtils.fromJavaPath((String)file2.getAbsolutePath()));
                return;
            }
        } else {
            new MWAlert(this.getFrame(), fRes.getString("listbox.dialog.generic.title"), fRes.getString("listbox.dialog.save.failed.message"), 1);
        }
    }

    static /* synthetic */ String access$2(PathListbox pathListbox) {
        return pathListbox.fCurrentPath;
    }

    static /* synthetic */ int access$5() {
        return 200;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PathCallback
    implements CompletionObserver {
        int fReplyType;

        public PathCallback(int n) {
            PathListbox.this = PathListbox.this;
            this.fReplyType = n;
        }

        public void completed(int n, Object object) {
            if (this.fReplyType == PathListbox.access$5()) {
                double[] dArray = (double[])object;
                PathListbox.this.evaluateSaveResults(dArray[0]);
                return;
            }
            MWMessage mWMessage = (MWMessage)object;
            Integer n2 = (Integer)mWMessage.findData("eventid", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = PathListbox.class$("java.lang.Integer")));
            if (n2 == Integer.MIN_VALUE) {
                PathListbox.this.fMatlab.eval("disp(matlabpath)", (CompletionObserver)new FullPathCallback());
            }
        }
    }

    class FullPathCallback
    implements CompletionObserver {
        int fReplyType;

        public FullPathCallback() {
            PathListbox.this = PathListbox.this;
        }

        public void completed(int n, Object object) {
            String string = (String)object;
            int n2 = string.indexOf(10);
            if (string.indexOf(13) > n2) {
                n2 = string.indexOf(13);
            }
            if (n2 > -1) {
                string = string.substring(0, n2);
            }
            if (PathListbox.this.fOrigPath == null) {
                PathListbox.this.fOrigPath = string;
            }
            PathListbox.this.fCurrentPath = string;
            PathListbox.this.updateListbox(string);
        }
    }
}

