/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.browsers;

import com.mathworks.ide.browsers.PathBrowser;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.util.PlatformInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class PathHandler {
    private static Vector sMatlabPhls;
    private static Vector sSimulinkPhls;
    private static Vector sStateflowPhls;
    private static Vector sRtwPhls;
    private static Vector sToolboxPhls;
    private static String sMatlabroot;
    private static File sToolboxDir;
    private static File sPathDir;
    private static boolean sInstalled;
    private static int PATH_ARGUMENT;
    private static Matlab fMatlab;

    public static boolean setPath(String string) {
        boolean bl = false;
        if (Matlab.isMatlabAvailable() && string != null && !string.equals("")) {
            if (fMatlab == null) {
                fMatlab = new Matlab(new MWLooper("PathDefault - path control"));
            }
            String string2 = "path('" + PathBrowser.quoteQuotes(string) + "');";
            fMatlab.evalNoOutput(string2);
            bl = true;
        }
        return bl;
    }

    public static boolean restoreDefaultPath() {
        return PathHandler.setPath(PathHandler.getDefaultPathArgument());
    }

    public static String getDefaultPathArgument() {
        String string = null;
        StringBuffer stringBuffer = PathHandler.getAllData();
        if (stringBuffer != null) {
            stringBuffer = PathHandler.removeDups(stringBuffer);
            string = stringBuffer.toString();
        }
        return string;
    }

    private static StringBuffer getAllData() {
        if (!Matlab.isMatlabAvailable()) {
            return null;
        }
        if (sMatlabroot == null) {
            sMatlabroot = Matlab.matlabRoot();
            sToolboxDir = new File(sMatlabroot, "toolbox");
            sPathDir = new File(new File(sToolboxDir, "local"), "path");
        }
        sMatlabPhls = new Vector(25);
        sSimulinkPhls = new Vector(10);
        sStateflowPhls = new Vector(10);
        sRtwPhls = new Vector(10);
        sToolboxPhls = new Vector(10);
        if (sPathDir.exists()) {
            PathHandler.getPhlFiles(sPathDir);
        } else {
            PathHandler.getDeepPhlFiles(sToolboxDir);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < sMatlabPhls.size()) {
            File file = (File)sMatlabPhls.elementAt(n);
            stringBuffer.append(PathHandler.readPhlFile(file));
            ++n;
        }
        int n2 = 0;
        while (n2 < sSimulinkPhls.size()) {
            File file = (File)sSimulinkPhls.elementAt(n2);
            stringBuffer.append(PathHandler.readPhlFile(file));
            ++n2;
        }
        int n3 = 0;
        while (n3 < sStateflowPhls.size()) {
            File file = (File)sStateflowPhls.elementAt(n3);
            stringBuffer.append(PathHandler.readPhlFile(file));
            ++n3;
        }
        int n4 = 0;
        while (n4 < sRtwPhls.size()) {
            File file = (File)sRtwPhls.elementAt(n4);
            stringBuffer.append(PathHandler.readPhlFile(file));
            ++n4;
        }
        int n5 = 0;
        while (n5 < sToolboxPhls.size()) {
            File file = (File)sToolboxPhls.elementAt(n5);
            stringBuffer.append(PathHandler.readPhlFile(file));
            ++n5;
        }
        return stringBuffer;
    }

    private static void getDeepPhlFiles(File file) {
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(sToolboxDir, stringArray[n]);
            if (file2.isDirectory()) {
                PathHandler.getPhlFiles(file2);
            }
            ++n;
        }
    }

    private static void getPhlFiles(File file) {
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].endsWith(".phl")) {
                File file2 = new File(file, stringArray[n]);
                if (stringArray[n].startsWith("matlab")) {
                    sMatlabPhls.addElement(file2);
                } else if (stringArray[n].startsWith("simulink")) {
                    sSimulinkPhls.addElement(file2);
                } else if (stringArray[n].startsWith("stateflow")) {
                    sStateflowPhls.addElement(file2);
                } else if (stringArray[n].startsWith("rtw")) {
                    sRtwPhls.addElement(file2);
                } else {
                    sToolboxPhls.addElement(file2);
                }
            }
            ++n;
        }
    }

    private static String readPhlFile(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {}
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                File file2;
                string = string.trim();
                if (PlatformInfo.isWindows()) {
                    string = string.replace('/', '\\');
                }
                if (!(file2 = new File(sMatlabroot, string)).isDirectory() || string.equals("")) continue;
                stringBuffer.append(String.valueOf(file2.getAbsolutePath()) + "\n");
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {}
        return stringBuffer.toString();
    }

    private static StringBuffer removeDups(StringBuffer stringBuffer) {
        int n = 0;
        int n2 = 0;
        String[] stringArray = new String[200];
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = stringBuffer.toString();
        int n3 = string.indexOf(10, 0);
        while (n3 != -1) {
            stringArray[n2] = string.substring(n, n3);
            ++n2;
            n = n3 + 1;
            n3 = string.indexOf(10, n);
        }
        --n2;
        int n4 = 0;
        while (n4 <= n2) {
            if (stringArray[n4] != null) {
                int n5 = n4 + 1;
                while (n5 <= n2) {
                    if (stringArray[n4].equalsIgnoreCase(stringArray[n5])) {
                        stringArray[n5] = null;
                    }
                    ++n5;
                }
            }
            ++n4;
        }
        int n6 = 0;
        while (n6 <= n2) {
            if (stringArray[n6] != null) {
                stringBuffer2.append(String.valueOf(stringArray[n6]) + System.getProperty("path.separator"));
            }
            ++n6;
        }
        return stringBuffer2;
    }

    static {
        sMatlabroot = null;
        sToolboxDir = null;
        sPathDir = null;
        PATH_ARGUMENT = 1;
        fMatlab = null;
    }
}

