/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.browsers;

import com.mathworks.ide.browsers.PathListbox;
import com.mathworks.ide.help.CSHelpTopicMap;
import com.mathworks.ide.help.HelpBrowser;
import com.mathworks.ide.help.HelpPrefs;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCenterLayout;
import com.mathworks.mwt.MWComponent;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.dialog.MWAlert;
import com.mathworks.mwt.dialog.MWDirectoryDialog;
import com.mathworks.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ResourceBundle;

public class PathBrowser
implements ActionListener,
ItemListener,
WindowListener {
    private static PathBrowser sThis;
    private static final Insets INSETS;
    private PathListbox fList;
    private MWButton fAdd;
    private MWButton fAddSubs;
    private MWButton fToTop;
    private MWButton fUp;
    private MWButton fRemove;
    private MWButton fDown;
    private MWButton fToBottom;
    private MWButton fRestore;
    private MWButton fSave;
    private MWButton fRevert;
    private MWButton fClose;
    private MWButton fHelp;
    private MWFrame fFrame;
    private boolean fShowConfirmations = true;
    private boolean fTrySaveOnExit = false;
    private boolean fAddRecursive;
    private static ResourceBundle fRes;

    public static PathBrowser getPathBrowser() {
        if (sThis != null) {
            PathBrowser.sThis.fFrame.toFront();
            return sThis;
        }
        return new PathBrowser();
    }

    private PathBrowser() {
        sThis = this;
        this.fFrame = new MWFrame(fRes.getString("pathbrowser.title"));
        this.fFrame.addWindowListener(this);
        this.fFrame.setLocation(50, 50);
        this.fFrame.setSize(500, 400);
        MWPanel mWPanel = new MWPanel((LayoutManager)new GridLayout(0, 1, 0, 8));
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new GridLayout(0, 1, 0, 8));
        mWPanel2.setInsets(INSETS);
        MWPanel mWPanel3 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel3.setInsets(INSETS);
        MWPanel mWPanel4 = new MWPanel((LayoutManager)new GridLayout(0, 4, 8, 8));
        MWPanel mWPanel5 = new MWPanel((LayoutManager)new GridLayout(0, 1, 8, 8));
        mWPanel3.add((Component)mWPanel4, "West");
        mWPanel3.add((Component)mWPanel5, "East");
        new MWPanel((LayoutManager)new BorderLayout());
        MWPanel mWPanel6 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel6.setInsets(INSETS);
        MWPanel mWPanel7 = new MWPanel((LayoutManager)new MWCenterLayout(0, 4, 0, 4));
        MWPanel mWPanel8 = new MWPanel((LayoutManager)new MWCenterLayout(0, 4, 0, 4));
        this.fAdd = new MWButton(fRes.getString("button.add"));
        this.fAdd.setEnabled(true);
        this.fAdd.addActionListener((ActionListener)this);
        this.fAdd.setActionCommand("Add");
        this.fAdd.setName("Add");
        this.fAddSubs = new MWButton(fRes.getString("button.addsubs"));
        this.fAddSubs.setEnabled(true);
        this.fAddSubs.addActionListener((ActionListener)this);
        this.fAddSubs.setActionCommand("AddSubs");
        this.fAddSubs.setName("AddSubs");
        this.fToTop = new MWButton(fRes.getString("button.top"));
        this.fToTop.addActionListener((ActionListener)this);
        this.fToTop.setActionCommand("Top");
        this.fToTop.setName("Top");
        this.fUp = new MWButton(fRes.getString("button.up"));
        this.fUp.addActionListener((ActionListener)this);
        this.fUp.setActionCommand("Up");
        this.fUp.setName("Up");
        this.fRemove = new MWButton(fRes.getString("button.remove"));
        this.fRemove.addActionListener((ActionListener)this);
        this.fRemove.setActionCommand("Remove");
        this.fRemove.setName("Remove");
        this.fDown = new MWButton(fRes.getString("button.down"));
        this.fDown.addActionListener((ActionListener)this);
        this.fDown.setActionCommand("Down");
        this.fDown.setName("Down");
        this.fToBottom = new MWButton(fRes.getString("button.bottom"));
        this.fToBottom.addActionListener((ActionListener)this);
        this.fToBottom.setActionCommand("Bottom");
        this.fToBottom.setName("Bottom");
        this.fClose = new MWButton(fRes.getString("button.close"));
        this.fClose.setEnabled(true);
        this.fClose.addActionListener((ActionListener)this);
        this.fClose.setActionCommand("Close");
        this.fClose.setName("Close");
        this.fRevert = new MWButton(fRes.getString("button.revert"));
        this.fRevert.setEnabled(false);
        this.fRevert.addActionListener((ActionListener)this);
        this.fRevert.setActionCommand("Revert");
        this.fRevert.setName("Revert");
        this.fSave = new MWButton(fRes.getString("button.save"));
        this.fSave.setEnabled(true);
        this.fSave.addActionListener((ActionListener)this);
        this.fSave.setActionCommand("Save");
        this.fSave.setName("Save");
        this.fRestore = new MWButton(fRes.getString("button.default"));
        this.fRestore.setEnabled(true);
        this.fRestore.addActionListener((ActionListener)this);
        this.fRestore.setActionCommand("Restore");
        this.fRestore.setName("Restore");
        this.fHelp = new MWButton(fRes.getString("button.help"));
        this.fHelp.setEnabled(true);
        this.fHelp.addActionListener((ActionListener)this);
        this.fHelp.setActionCommand("Help");
        this.fHelp.setName("Help");
        this.setOrderButtonsEnabled(false);
        mWPanel.add((Component)this.fAdd);
        mWPanel.add((Component)this.fAddSubs);
        mWPanel2.add((Component)this.fToTop);
        mWPanel2.add((Component)this.fUp);
        mWPanel2.add((Component)this.fRemove);
        mWPanel2.add((Component)this.fDown);
        mWPanel2.add((Component)this.fToBottom);
        mWPanel5.add((Component)this.fHelp);
        mWPanel4.add((Component)this.fSave);
        mWPanel4.add((Component)this.fClose);
        mWPanel4.add((Component)this.fRevert);
        mWPanel4.add((Component)this.fRestore);
        MWLabel mWLabel = new MWLabel(fRes.getString("label.immediate"));
        MWPanel mWPanel9 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel9.setInsets(INSETS);
        mWPanel9.add((Component)mWLabel, "West");
        this.fList = new PathListbox();
        this.fList.addItemListener(this);
        this.fList.addActionListener(this);
        mWPanel7.add((Component)mWPanel2);
        mWPanel8.add((Component)mWPanel);
        MWPanel mWPanel10 = new MWPanel((LayoutManager)new BorderLayout());
        MWPanel mWPanel11 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel10.setInsets(INSETS);
        mWPanel10.add((Component)mWPanel8, "North");
        mWPanel10.add((Component)mWPanel7, "Center");
        mWPanel11.add((Component)new MWLabel(" "), "North");
        mWPanel11.add((Component)mWPanel10, "Center");
        this.fFrame.add((Component)mWPanel9, "North");
        this.fFrame.add((Component)mWPanel11, "West");
        this.fFrame.add((Component)mWPanel3, "South");
        mWPanel6.add((Component)new MWLabel(fRes.getString("label.list")), "North");
        mWPanel6.add((Component)((Object)this.fList), "Center");
        this.fFrame.add((Component)mWPanel6, "Center");
        this.fFrame.setVisible(true);
    }

    private void resetOrderButtonsEnabled() {
        if (this.fList != null) {
            this.setOrderButtonsEnabled(this.fList.getSelectedIndex() != -2);
        }
    }

    private void setOrderButtonsEnabled(boolean bl) {
        this.fToTop.setEnabled(bl);
        this.fUp.setEnabled(bl);
        this.fRemove.setEnabled(bl);
        this.fDown.setEnabled(bl);
        this.fToBottom.setEnabled(bl);
    }

    private void setSaveButtonEnabled(boolean bl) {
        this.fSave.setEnabled(bl);
    }

    private void setBusyIndicators(boolean bl) {
        Cursor cursor;
        if (bl) {
            cursor = Cursor.getPredefinedCursor(3);
            this.setOrderButtonsEnabled(false);
        } else {
            cursor = Cursor.getPredefinedCursor(0);
            this.resetOrderButtonsEnabled();
        }
        this.fFrame.setCursor(cursor);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (actionEvent.getSource() == this.fList) {
            if (string.equals("BUSY_CURSOR")) {
                this.setBusyIndicators(true);
                return;
            }
            if (string.equals("FREE_CURSOR")) {
                this.setBusyIndicators(false);
                return;
            }
            if (string.equals("ENABLE_REVERSION")) {
                this.enableRevert();
                return;
            }
            if (string.equals("PATH_CHANGED")) {
                this.fTrySaveOnExit = true;
                this.resetOrderButtonsEnabled();
                this.setSaveButtonEnabled(true);
                return;
            }
            if (string.equals("PATH_SAVED")) {
                this.fTrySaveOnExit = false;
                this.setSaveButtonEnabled(false);
                return;
            }
        } else {
            if (string.equals("Add")) {
                this.fAddRecursive = false;
                MWDirectoryDialog.browseForFolder((MWComponent)this.fAdd, (ActionListener)this, (String)fRes.getString("dialog.add.title"), null);
                return;
            }
            if (string.equals("AddSubs")) {
                this.fAddRecursive = true;
                MWDirectoryDialog.browseForFolder((MWComponent)this.fAdd, (ActionListener)this, (String)fRes.getString("dialog.addsubs.title"), null);
                return;
            }
            if (string.equals("Top")) {
                this.fList.prepend();
                return;
            }
            if (string.equals("Up")) {
                this.fList.promote();
                return;
            }
            if (string.equals("Remove")) {
                this.fList.remove();
                return;
            }
            if (string.equals("Down")) {
                this.fList.demote();
                return;
            }
            if (string.equals("Bottom")) {
                this.fList.append();
                return;
            }
            if (string.equals("Close")) {
                this.closeMe();
                return;
            }
            if (string.equals("Revert")) {
                this.fRevert.setEnabled(false);
                this.fList.revertAllChanges();
                return;
            }
            if (string.equals("Save")) {
                this.fList.save();
                return;
            }
            if (string.equals("Restore")) {
                this.fList.restoreDefaultPath();
                return;
            }
            if (string.equals("Help")) {
                HelpBrowser helpBrowser = HelpBrowser.getHelpBrowser();
                File file = new File(new File(HelpPrefs.getDocRoot(), "mapfiles"), "matlab_env.map");
                if (file.exists()) {
                    CSHelpTopicMap cSHelpTopicMap = new CSHelpTopicMap(file);
                    String string2 = cSHelpTopicMap.mapID("matlabenvironment_pathbrowser");
                    helpBrowser.setCurrentLocation(string2);
                    return;
                }
                helpBrowser.setCurrentLocation(String.valueOf(Matlab.matlabRoot()) + "/toolbox/local/helperr.html");
                return;
            }
            if (string.indexOf(47) != -1 || string.indexOf(92) != -1 || string.indexOf(58) != -1) {
                this.addPath(PathBrowser.toJavaPath(string));
            }
        }
    }

    private void addPath(String string) {
        if (this.fAddRecursive) {
            this.fList.prependRecursively(string);
            return;
        }
        this.fList.prepend(string);
    }

    private void closeMe() {
        if (this.fTrySaveOnExit) {
            int n = 2;
            if (this.fShowConfirmations) {
                MWAlert mWAlert = new MWAlert((Frame)this.fFrame, fRes.getString("dialog.save.title"), fRes.getString("dialog.save.message"), 3);
                n = mWAlert.getReply();
            }
            if (n == 1) {
                this.fList.save();
            }
        }
        this.fFrame.dispose();
        this.fList = null;
        sThis = null;
    }

    private void enableRevert() {
        this.fRevert.setEnabled(true);
    }

    public void setShowConfirm(boolean bl) {
        this.fShowConfirmations = bl;
        this.fList.setShowConfirm(bl);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.resetOrderButtonsEnabled();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.closeMe();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public static String quoteQuotes(String string) {
        return StringUtils.quoteSingleQuotes((String)string);
    }

    public static String toJavaPath(String string) {
        return StringUtils.toJavaPath((String)string);
    }

    public static String fromJavaPath(String string) {
        return StringUtils.fromJavaPath((String)string);
    }

    static {
        INSETS = new Insets(8, 8, 8, 8);
        fRes = ResourceBundle.getBundle("com.mathworks.ide.browsers.resources.RES_PathBrowser");
    }
}

