/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.browsers;

import com.mathworks.ide.widgets.MatlabCommandWidget;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWClipboardMonitor;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.XSelection;
import ice.htmlbrowser.Browser;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;

public class HTMLBrowser
extends Browser
implements MouseListener,
MWCommandTarget {
    public static final int GO_BACK = 1;
    public static final int GO_FORWARD = 2;
    public static final int RELOAD = 3;
    public static final int EVAL_SELECTION = 4;
    public static final int OPEN_SELECTION = 5;
    public static final int HELP_SELECTION = 6;
    private MWMenu fBrowserPopupMenu;
    private MWCommandCenter fCenter;
    private Matlab fMatlab = new Matlab(new MWLooper("HTMLBrowser"));
    private static final String RESDIR = "com.mathworks.ide.browsers.resources.";
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.browsers.resources.RES_HTMLBrowser");

    public HTMLBrowser() {
        this(null);
    }

    public HTMLBrowser(MWCommandCenter mWCommandCenter) {
        this.fCenter = mWCommandCenter != null ? mWCommandCenter : new MWCommandCenter((MWCommandTarget)this);
        this.createPopupMenu();
        ((Component)((Object)this)).addMouseListener(this);
        this.fCenter.setCommandEnabled(4, false);
        this.fCenter.setCommandEnabled(5, false);
        this.fCenter.setCommandEnabled(6, false);
        this.fCenter.setCommandEnabled(910, false);
    }

    private void createPopupMenu() {
        this.fBrowserPopupMenu = new MWMenu("", this.fCenter);
        this.fBrowserPopupMenu.addMenuItem(sRes.getString("htmlbrowser.evalsel"), 4);
        this.fBrowserPopupMenu.addMenuItem(sRes.getString("htmlbrowser.opensel"), 5);
        this.fBrowserPopupMenu.addMenuItem(sRes.getString("htmlbrowser.helponsel"), 6);
        this.fBrowserPopupMenu.addSeparator();
        this.fBrowserPopupMenu.addMenuItem(sRes.getString("htmlbrowser.back"), 1);
        this.fBrowserPopupMenu.addMenuItem(sRes.getString("htmlbrowser.forward"), 2);
        this.fBrowserPopupMenu.addMenuItem(sRes.getString("htmlbrowser.reload"), 3);
        this.fBrowserPopupMenu.addSeparator();
        this.fBrowserPopupMenu.addMenuItem(sRes.getString("htmlbrowser.copy"), 910);
        this.fBrowserPopupMenu.attachTo((Component)((Object)this));
    }

    public void doCommand(int n) {
        if (this.fCenter.getCommandEnabled(n)) {
            switch (n) {
                case 1: {
                    this.goBack();
                    return;
                }
                case 2: {
                    this.goForward();
                    return;
                }
                case 3: {
                    this.reload();
                    return;
                }
                case 910: {
                    this.doCopy();
                    return;
                }
                case 4: {
                    this.doEvalSelection();
                    return;
                }
                case 5: {
                    this.doOpenSelection();
                    return;
                }
                case 6: {
                    this.doHelpOnSelection();
                    return;
                }
            }
        }
    }

    public void doCopy() {
        String string = this.getSelectedText(false);
        if (string.length() > 1 && string.charAt(string.length() - 1) == '\n') {
            string = string.substring(0, string.length() - 1);
        }
        if (PlatformInfo.isUnix()) {
            XSelection.setSelection((String)string);
            return;
        }
        StringSelection stringSelection = new StringSelection(string);
        ((Component)((Object)this)).getToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        MWClipboardMonitor.dataPlacedOnClipboard();
    }

    public void doEvalSelection() {
        MatlabCommandWidget.executeCommand(this.getSelectedText(false));
    }

    public void doOpenSelection() {
        String string = this.getSelectedText(false);
        Object[] objectArray = new Object[]{string};
        if (Matlab.isMatlabAvailable()) {
            this.fMatlab.fevalConsoleOutput("open", objectArray, 1, null);
        }
    }

    public void doHelpOnSelection() {
        Object[] objectArray = new Object[]{this.getSelectedText(false)};
        if (Matlab.isMatlabAvailable()) {
            this.fMatlab.feval("doc", objectArray, null);
        }
    }

    public String getSelectedText(boolean bl) {
        String string;
        block2: {
            string = "";
            try {
                string = super.getSelectedText(bl);
            }
            catch (Exception exception) {
                if (!(exception instanceof NullPointerException)) break block2;
                return string;
            }
        }
        char c = '\u00c3';
        string = string.replace(c, ' ');
        c = '\u0082';
        string = string.replace(c, ' ');
        c = '\u00c2';
        string = string.replace(c, ' ');
        c = '\u00a0';
        string = string.replace(c, ' ');
        return string;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (PlatformInfo.getPlatform() == 2) {
            this.processPopup(mouseEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.enableDisableEvents();
        if (PlatformInfo.isUnix() && (mouseEvent.getModifiers() & 0x10) == 16) {
            this.doCopy();
            return;
        }
        this.processPopup(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void processPopup(MouseEvent mouseEvent) {
        Object object;
        if (mouseEvent.isPopupTrigger() && (object = mouseEvent.getSource()) instanceof Component) {
            this.fBrowserPopupMenu.show((Component)object, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void enableDisableEvents() {
        this.fCenter.setCommandEnabled(1, this.getBackHistory().size() != 0);
        this.fCenter.setCommandEnabled(2, this.getForwardHistory().size() != 0);
        boolean bl = !this.getSelectedText(false).equals("");
        this.fCenter.setCommandEnabled(4, bl && Matlab.isMatlabAvailable());
        this.fCenter.setCommandEnabled(5, bl && Matlab.isMatlabAvailable());
        this.fCenter.setCommandEnabled(6, bl && Matlab.isMatlabAvailable());
        this.fCenter.setCommandEnabled(910, bl);
    }

    static {
        if (PlatformInfo.isUnix()) {
            XSelection.initXSelectionManager();
        }
    }
}

