/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.browsers;

import com.mathworks.ide.browsers.FileView;
import com.mathworks.ide.editor.EditorApplication;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWCloseBox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWListbox;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.table.LabeledImageResource;
import com.mathworks.mwt.table.Style;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.QSortAlgorithm;
import com.mathworks.util.ResLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class FindView
extends MWPanel
implements MWCommandTarget {
    public static final int WHICHALL = 1;
    public static final int FINDINFILES = 2;
    public static final int REMOVE_CURRENT_TAB = 5;
    private int fNextID;
    private int fNextFileID;
    private MWMenu fPopupMenu;
    private ResLoader resources = new ResLoader((Component)((Object)this));
    private Image fMFilePic;
    private Image fUnknownFilePic;
    private String fSeparator = PlatformInfo.getPlatform() == 2 ? "/" : "\\";
    private MWListbox fFileList;
    private MWCommandCenter fParentCenter;
    private MWCommandCenter fCenter;
    private String fSearchStr;
    private int fFindType;
    private MWCheckbox fShowFullPathname;
    private boolean fInterruptFind = false;
    private MWLabel fLabel = new MWLabel(" ");
    private MWLabel fSearchText = new MWLabel(" ");
    private MWTextField fResultsText;
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.browsers.resources.RES_FindView");

    public FindView(int n, MWCommandCenter mWCommandCenter) {
        ((Container)((Object)this)).setLayout(new BorderLayout(0, 5));
        this.resources = new ResLoader((Component)((Object)this));
        this.fMFilePic = this.resources.loadImage("/com/mathworks/mwt/resources/mwin.gif");
        this.fUnknownFilePic = this.resources.loadImage("/com/mathworks/mwt/resources/document.gif");
        this.fFindType = n;
        this.fParentCenter = mWCommandCenter;
        this.fCenter = new MWCommandCenter((MWCommandTarget)this);
        this.fFileList = new MWListbox();
        this.fFileList.setColumnCount(4);
        this.fFileList.getColumnOptions().setHeaderVisible(true);
        this.fFileList.getColumnOptions().setResizable(true);
        this.fFileList.setMultiSelection(true);
        this.fFileList.setEditable(false);
        this.fFileList.setResizeZeroWidthColumns(false);
        this.fFileList.addMouseListener(new MenuListMouseAdapter());
        this.fFileList.addKeyListener(new FindViewKeyListener());
        this.fFileList.setColumnWidth(0, 110);
        this.fFileList.setColumnWidth(1, 0);
        this.fFileList.setColumnWidth(2, 40);
        this.fFileList.setColumnWidth(3, 10);
        this.fFileList.setAutoExpandColumn(3);
        String[] stringArray = new String[]{sRes.getString("header.filename"), sRes.getString("header.filename"), sRes.getString("header.line"), sRes.getString("header.text")};
        this.fFileList.setHeaders(stringArray);
        this.fFileList.setFont(Prefs.getFontPref((String)"GeneralFont", (Font)new Font("Monospaced", 0, 10)));
        this.fPopupMenu = new MWMenu("", this.fCenter);
        this.fPopupMenu.addMenuItem(sRes.getString("open"), -102);
        this.fPopupMenu.attachTo((Component)this.fFileList);
        Style style = new Style(256);
        style.setHAlignment(0);
        this.fFileList.setRowStyle(-1, style);
        Insets insets = this.fFileList.getTableStyle().getMargins();
        Style style2 = new Style(128);
        style2.setMargins(insets.top, insets.left + 20, insets.bottom, insets.right);
        this.fFileList.setCellStyle(-1, 0, style2);
        this.fFileList.setCellStyle(-1, 1, style2);
        this.fShowFullPathname = new MWCheckbox(sRes.getString("showfullpathnames"), false);
        this.fShowFullPathname.addItemListener((ItemListener)new MyCheckboxListener());
        MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel.add((Component)this.fShowFullPathname, "West");
        mWPanel.add((Component)new MWCloseBox(this.fParentCenter, 5), "East");
        ((Container)((Object)this)).add((Component)mWPanel, "North");
        ((Container)((Object)this)).add((Component)this.fFileList, "Center");
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new GridLayout(2, 1));
        mWPanel2.add((Component)this.fLabel);
        MWPanel mWPanel3 = new MWPanel((LayoutManager)new BorderLayout());
        mWPanel3.add((Component)this.fSearchText, "West");
        this.fResultsText = new MWTextField(20);
        this.fResultsText.setEditable(false);
        mWPanel3.add((Component)this.fResultsText, "Center");
        this.fResultsText.setVisible(false);
        mWPanel2.add((Component)mWPanel3);
        ((Container)((Object)this)).add((Component)mWPanel2, "South");
        Prefs.addListener((PrefListener)new FontChangeListener(), (String)"GeneralFont");
    }

    public MWListbox getFileListView() {
        return this.fFileList;
    }

    public void setResultsLabel(String string, String string2, String string3) {
        this.fLabel.setText(string);
        this.fSearchText.setText(string2);
        this.fResultsText.setVisible(true);
        this.fResultsText.setText(string3);
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
        this.fResultsText.setSel(0, 0);
    }

    public void setSearchLabel(String string) {
        this.fLabel.setText(string);
        this.fLabel.invalidate();
        ((Container)((Object)this)).validate();
    }

    public int grepFile(String string, String string2, boolean bl, boolean bl2) {
        Object[] objectArray = new Object[]{string};
        String string3 = MessageFormat.format(sRes.getString("searchingstring"), objectArray);
        this.fLabel.setText(string3);
        this.fLabel.invalidate();
        ((Container)((Object)this)).validate();
        int n = 0;
        File file = new File(string);
        String string4 = file.getName();
        BufferedReader bufferedReader = null;
        int n2 = string2.length();
        String string5 = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (bufferedReader != null) {
            try {
                int n3 = 1;
                while ((string5 = bufferedReader.readLine()) != null && !this.fInterruptFind) {
                    int n4 = 0;
                    while (n4 < string5.length() - n2 + 1) {
                        boolean bl3 = string5.regionMatches(!bl, n4, string2, 0, n2);
                        if (bl3 && bl2 && (n4 > 0 && Character.isLetterOrDigit(string5.charAt(n4 - 1)) || n4 + string2.length() < string5.length() && Character.isLetterOrDigit(string5.charAt(n4 + string2.length())))) {
                            bl3 = false;
                        }
                        if (bl3) {
                            if (string5.length() > 200) {
                                string5 = string5.substring(0, 200);
                            }
                            Object[] objectArray2 = new String[]{string4, string, Integer.toString(n3), string5};
                            Image image = this.fUnknownFilePic;
                            if (string4.endsWith(".m")) {
                                image = this.fMFilePic;
                            }
                            this.fFileList.addItem(objectArray2);
                            this.fFileList.setCellData(this.fFileList.getItemCount() - 1, 0, (Object)new LabeledImageResource(image, (String)objectArray2[0]));
                            this.fFileList.setCellData(this.fFileList.getItemCount() - 1, 1, (Object)new LabeledImageResource(image, (String)objectArray2[1]));
                            ++n;
                            break;
                        }
                        ++n4;
                    }
                    ++n3;
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        this.resources.waitForPendingImages();
        ((Component)((Object)this)).repaint();
        return n;
    }

    public void setPathCheckboxEnabled(boolean bl) {
        this.fShowFullPathname.setEnabled(bl);
    }

    public int findInFiles(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        File file;
        Object[] objectArray = new Object[]{string};
        String string3 = MessageFormat.format(sRes.getString("searchingstring"), objectArray);
        this.fLabel.setText(string3);
        this.fLabel.invalidate();
        ((Container)((Object)this)).validate();
        if (bl) {
            this.fFileList.removeAllItems();
        }
        if (!(file = new File(string)).exists()) {
            return 0;
        }
        QSortAlgorithm qSortAlgorithm = new QSortAlgorithm();
        String[] stringArray = file.list();
        if (PlatformInfo.getPlatform() != 0) {
            qSortAlgorithm.sort(stringArray);
        }
        int n2 = 0;
        while (n2 < stringArray.length && !this.fInterruptFind) {
            File file2 = new File(string, stringArray[n2]);
            String string4 = FileView.xlate(stringArray[n2]);
            String string5 = String.valueOf(string) + this.fSeparator + string4;
            if (bl4 && file2.isDirectory()) {
                n = this.findInFiles(string5, string2, false, bl2, bl3, bl4, n);
            }
            if (!(file2.isDirectory() || string4.endsWith(".exe") || string4.endsWith(".dll") || string4.endsWith(".mat") || this.grepFile(string5, string2, bl2, bl3) <= 0)) {
                ++n;
            }
            ++n2;
        }
        this.resources.waitForPendingImages();
        ((Component)((Object)this)).repaint();
        return n;
    }

    private void sendSelectedFilesToEditor() {
        int[] nArray = this.fFileList.getSelectedIndexes();
        if (nArray.length > 0) {
            int n = 0;
            while (n < nArray.length) {
                String string = this.fFileList.getItem(nArray[n], 1);
                Integer n2 = new Integer(this.fFileList.getItem(nArray[n], 2));
                EditorApplication.openDocumentToLine(string, n2, true, true);
                ++n;
            }
        }
    }

    public void interruptFind() {
        this.fInterruptFind = true;
    }

    public void doCommand(int n) {
        boolean bl = true;
        if (this.fCenter.getCommandEnabled(n)) {
            switch (n) {
                case -102: {
                    this.sendSelectedFilesToEditor();
                    return;
                }
            }
            bl = false;
            return;
        }
    }

    private class MenuListMouseAdapter
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (PlatformInfo.getPlatform() == 2) {
                this.doStuff(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (PlatformInfo.getPlatform() != 2) {
                this.doStuff(mouseEvent);
            }
        }

        public void doStuff(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                FindView.this.fPopupMenu.show((Component)FindView.this.fFileList, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            if (mouseEvent.getClickCount() == 2) {
                FindView.this.sendSelectedFilesToEditor();
            }
        }

        MenuListMouseAdapter() {
            FindView.this = FindView.this;
        }
    }

    private class MyCheckboxListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            MWCheckbox mWCheckbox = (MWCheckbox)itemEvent.getItem();
            if (!mWCheckbox.getState()) {
                int n = FindView.this.fFileList.getColumnWidth(1);
                FindView.this.fFileList.setColumnWidth(1, 0);
                FindView.this.fFileList.setColumnWidth(0, n);
                return;
            }
            int n = FindView.this.fFileList.getColumnWidth(0);
            FindView.this.fFileList.setColumnWidth(0, 0);
            FindView.this.fFileList.setColumnWidth(1, n);
        }

        MyCheckboxListener() {
            FindView.this = FindView.this;
        }
    }

    private class FontChangeListener
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getEventType() == 1) {
                FindView.this.fFileList.setFont(Prefs.getFontPref((String)"GeneralFont"));
                ((Component)((Object)FindView.this)).repaint();
            }
        }

        FontChangeListener() {
            FindView.this = FindView.this;
        }
    }

    private class FindViewKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                FindView.this.sendSelectedFilesToEditor();
            }
        }

        FindViewKeyListener() {
            FindView.this = FindView.this;
        }
    }
}

