/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.browsers;

import com.mathworks.ide.browsers.FileBrowserMenubar;
import com.mathworks.ide.editor.MWReplaceDialog;
import com.mathworks.ide.widgets.CwdDisplayPanel;
import com.mathworks.ide.widgets.SyntaxTextArea;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWFrameProxy;
import com.mathworks.mwt.MWListbox;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWMenuComponent;
import com.mathworks.mwt.MWMenuItem;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWSplitter;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.MWToolbar;
import com.mathworks.mwt.MWToolbarSpacer;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandSource;
import com.mathworks.mwt.dialog.MWAlert;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.message.MWMessage;
import com.mathworks.mwt.table.Cell;
import com.mathworks.mwt.table.CellImageResource;
import com.mathworks.mwt.table.LabeledImageResource;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.table.TableAdapter;
import com.mathworks.mwt.table.TableEvent;
import com.mathworks.mwt.table.TableListener;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.util.DDQSortAlgorithm;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.QSortAlgorithm;
import com.mathworks.util.ResLoader;
import com.mathworks.util.StringUtils;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;

public class FileView
extends MWPanel {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.browsers.resources.RES_CurrentDirectory");
    protected static String fSeparator = System.getProperty("file.separator");
    transient ItemListener fItemListener;
    private static final int GET_PATH_REPLY = 1;
    private static final int INTEREST_MESSAGE = 2;
    private static final int PIC_COUNT = 8;
    private static final int DISK_PIC = 0;
    private static final int FOLDER_PIC = 10;
    private static final int DOC_PIC = 2;
    private static final int M_PIC = 12;
    private static final int MAT_PIC = 4;
    private static final int MEX_PIC = 5;
    private static final int P_PIC = 6;
    private static final int MDL_PIC = 7;
    private static final int TLC_PIC = 8;
    private static final int HTML_PIC = 14;
    private static final int DATA_PIC = 15;
    private static final int DIRECTORIES = 1;
    private static final int M_FILES = 2;
    private static final int MAT_FILES = 3;
    private static final int MEX_FILES = 4;
    private static final int MDL_FILES = 5;
    private static final int FIG_FILES = 6;
    private static final int P_FILES = 7;
    private static final int STATEFLOW_FILES = 8;
    private static final int REALTIME_FILES = 9;
    private static final int NON_ML_FILES = 10;
    private static final int INTEREST_REPLY = 1;
    private static final int CWD_REPLY = 2;
    private static final int WHICH_MESSAGE = 3;
    public static FileView sFileView = null;
    private boolean fIsInitialPathSet = false;
    private boolean fDoNotChangeDirectory = false;
    private MWPanel fFilePanel;
    protected MWListbox fFileList;
    private SyntaxTextArea fCommentDisplay;
    private MWSplitter fFileSplitter;
    private int[] fColumnWidths = new int[]{150, 100, 100, 400};
    protected boolean fShowHelp = true;
    private boolean fShowCommentBlock = false;
    private boolean fFollowPathSelection = true;
    private boolean fShowModifiedDates = true;
    private boolean fAlwaysShowCWD = true;
    private boolean fShowFileTypes = true;
    private boolean fShowMFiles = true;
    private boolean fShowMexFiles = false;
    private boolean fShowMatFiles = false;
    private boolean fShowMdlFiles = false;
    private boolean fShowFigFiles = false;
    private boolean fShowPFiles = false;
    private boolean fShowStateflowFiles = false;
    private boolean fShowRealtimeFiles = false;
    private boolean fShowAllFiles = false;
    private boolean fShowMatlabFiles = false;
    private boolean fShowDirectories = true;
    private boolean fStopRequested = false;
    private int fNextID;
    private MWMenu fFilePopupMenu;
    private MWMenu fFilterPopupMenu;
    private MWMenu fFilterSubmenu;
    private MWMenu fNewMenu;
    private MWMenuItem fShowMFilesMenuItem;
    private MWMenuItem fShowMatFilesMenuItem;
    private MWMenuItem fShowMexFilesMenuItem;
    private MWMenuItem fShowMdlFilesMenuItem;
    private MWMenuItem fShowFigFilesMenuItem;
    private MWMenuItem fShowPFilesMenuItem;
    private MWMenuItem fShowStateflowFilesMenuItem;
    private MWMenuItem fShowRealtimeFilesMenuItem;
    private MWMenuItem fShowMatlabFilesMenuItem;
    private MWMenuItem fShowAllFilesMenuItem;
    private MWMenuItem fShowDirectoriesMenuItem;
    private WhosCallback fWhosCallback;
    protected MWCommandCenter fCenter;
    protected Image[] fFilePic;
    private String fPathName = "";
    private String fCurrentMatlabDirectory = "";
    private static final String sRootDirName = PlatformInfo.getPlatform() == 1 ? sRes.getString("MyComputer") : fSeparator;
    private static final String sCwdString = sRes.getString("CurrentWorkingDirectory");
    protected ResLoader resources = new ResLoader((Component)((Object)this));
    private MyItemListener fFileItemListener;
    private Font theFont = new Font("Courier New", 0, 10);
    private Image[] fIcon = new Image[4];
    private Matlab fMatlab;
    private MWPanel fDirPanel;
    private Image fMatlabIcon;
    private boolean fNavigationEnabled;
    private Object fWorkspaceInterests;
    private Vector fFileClipboard = new Vector();
    private int fCurrentEditOperation;
    private String fCurrentFilename;
    private CwdDisplayPanel fCwdDisplayPanel;
    private int fCurrentKeyColumn;
    private boolean fSortedInReverse = false;
    private boolean fDoNotRefresh = false;
    private boolean fSimulinkInstalled = false;
    private Component fLastFocusOwner;
    private LoadNewDirectoryThread fLoadNewDirThread;
    private DateFormat df = DateFormat.getDateTimeInstance(3, 3);
    static /* synthetic */ Class class$com$mathworks$mwt$table$LabeledImageResource;
    static /* synthetic */ Class class$java$lang$Integer;

    public FileView() {
        this(true, true);
    }

    public FileView(boolean bl, boolean bl2) {
        this(null, bl, bl2, -1, null);
    }

    public FileView(MWCommandCenter mWCommandCenter, boolean bl, boolean bl2, int n, int[] nArray) {
        Object object;
        if (Matlab.isMatlabAvailable()) {
            this.fMatlab = new Matlab(new MWLooper("FileView"));
        }
        this.fShowFileTypes = (n & 0x200) != 0;
        this.fShowModifiedDates = (n & 0x40) != 0;
        this.fShowHelp = (n & 0x80) != 0;
        this.fShowMFiles = (n & 1) != 0;
        this.fShowMatFiles = (n & 4) != 0;
        this.fShowMexFiles = (n & 2) != 0;
        this.fShowMdlFiles = (n & 8) != 0;
        this.fShowFigFiles = (n & 0x400) != 0;
        this.fShowPFiles = (n & 0x800) != 0;
        this.fShowStateflowFiles = (n & 0x2000) != 0;
        this.fShowRealtimeFiles = (n & 0x4000) != 0;
        this.fShowMatlabFiles = (n & 0x1000) != 0;
        this.fShowAllFiles = (n & 0x10) != 0;
        this.fShowDirectories = (n & 0x20) != 0;
        this.fShowCommentBlock = (n & 0x100) != 0;
        this.fAlwaysShowCWD = true;
        this.fCenter = mWCommandCenter;
        if (nArray != null) {
            System.arraycopy(nArray, 0, this.fColumnWidths, 0, 4);
        }
        this.df.setTimeZone(TimeZone.getDefault());
        sFileView = this;
        this.fNavigationEnabled = bl2;
        this.loadResources();
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.fFileItemListener = new MyItemListener();
        this.fCommentDisplay = new SyntaxTextArea();
        this.fCommentDisplay.setSyntaxHighlightingEnabled(true);
        this.fCommentDisplay.setEditable(false);
        this.fCommentDisplay.setGutterWidth(5);
        this.resources.waitForPendingImages();
        if (bl) {
            ((Container)((Object)this)).add((Component)this.createToolbar(), "North");
        }
        this.fFileList = new MWListbox();
        this.fFileList.setFont(this.theFont);
        this.fFileList.setColumnCount(4);
        this.fFileList.getColumnOptions().setHeaderVisible(true);
        this.fFileList.getColumnOptions().setResizable(true);
        this.fFileList.setMultiSelection(true);
        this.fFileList.setEditable(false);
        this.fFileList.setResizeZeroWidthColumns(false);
        this.fFileList.addMouseListener(new FileListMouseAdapter());
        this.fFileList.addItemListener((ItemListener)this.fFileItemListener);
        this.fFileList.addKeyListener(new FileViewKeyListener());
        this.fFileList.addTableListener((TableListener)new FileViewValueListener());
        this.fFileList.addFocusListener(new FileViewFocusListener());
        this.fFileList.registerCellType(class$com$mathworks$mwt$table$LabeledImageResource != null ? class$com$mathworks$mwt$table$LabeledImageResource : (class$com$mathworks$mwt$table$LabeledImageResource = FileView.class$("com.mathworks.mwt.table.LabeledImageResource")), (Cell)new MyCellText((Table)this.fFileList));
        this.fFileList.setContextTriggerAware(true);
        Insets insets = this.fFileList.getTableStyle().getMargins();
        Style style = new Style(384);
        style.setFont(this.theFont);
        style.setMargins(insets.top, insets.left + 2, insets.bottom, insets.right);
        style.setHAlignment(0);
        this.fFileList.setRowStyle(-1, style);
        Style style2 = new Style(128);
        style2.setMargins(insets.top, insets.left + 5, insets.bottom, insets.right);
        this.fFileList.setCellStyle(-1, 0, style2);
        this.setColumnWidths(true);
        this.setColumnHeaders();
        this.createPopupMenus();
        this.fFilePanel = new MWPanel((LayoutManager)new BorderLayout());
        this.fFilePanel.add((Component)this.fFileList, "Center");
        this.fWhosCallback = new WhosCallback();
        if (this.fShowCommentBlock) {
            this.fFileSplitter = new MWSplitter((Component)this.fFilePanel, (Component)((Object)this.fCommentDisplay));
            ((Container)((Object)this)).add((Component)this.fFileSplitter, "Center");
            this.fFileSplitter.setDividerLocation(0.8);
        } else {
            ((Container)((Object)this)).add((Component)this.fFilePanel, "Center");
        }
        if (this.fMatlab != null) {
            object = new Object[]{"simulink"};
            this.fMatlab.feval("exist", (Object[])object, (CompletionObserver)new SimulinkAvailableObserver());
        }
        if ((object = System.getProperty("user.dir")) != null && !((String)object).equals("")) {
            this.setPathName((String)object, true);
        }
        this.registerWorkspaceInterests();
        this.registerPathManagerInterest();
    }

    public static FileView getFileView() {
        return sFileView;
    }

    public void requestFocus() {
        if (!this.fCwdDisplayPanel.getCwdDisplay().hasFocus()) {
            this.fFileList.requestFocus();
        }
    }

    public String getCurrentDirectory() {
        return this.fPathName;
    }

    public Object[] getSelectedFiles() {
        int[] nArray = this.fFileList.getSelectedIndexes();
        Object[] objectArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            objectArray[n] = String.valueOf(this.fPathName) + fSeparator + this.fFileList.getItem(nArray[n]);
            ++n;
        }
        return objectArray;
    }

    private void sortByColumn(int n) {
        this.sortByColumn(this.createTempSortVector(), n, true);
    }

    private void sortByColumn(Vector vector, int n, boolean bl) {
        this.fFileList.removeAllItems();
        this.fFileList.getData().setHeight(vector.size());
        this.fNextID = 0;
        boolean bl2 = this.fSortedInReverse;
        if (bl) {
            bl2 = false;
            if (this.fCurrentKeyColumn == n) {
                bl2 = !this.fSortedInReverse;
            } else if (n == 2) {
                bl2 = true;
            }
        }
        if (n == 1) {
            if (!bl2) {
                this.addFileTypeToView(vector, sRes.getString("ftype.Folder"));
                this.addFileTypeToView(vector, sRes.getString("ftype.Mfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.MATfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.MEXfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.MEXfile.alpha"));
                this.addFileTypeToView(vector, sRes.getString("ftype.MEXfile.hp700"));
                this.addFileTypeToView(vector, sRes.getString("ftype.MEXfile.ibm"));
                this.addFileTypeToView(vector, sRes.getString("ftype.MEXfile.glnx86"));
                this.addFileTypeToView(vector, sRes.getString("ftype.MEXfile.sgi"));
                this.addFileTypeToView(vector, sRes.getString("ftype.MEXfile.sol2"));
                this.addFileTypeToView(vector, sRes.getString("ftype.MEXfile.win32"));
                this.addFileTypeToView(vector, sRes.getString("ftype.Figurefile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.Pfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.SimulinkModel"));
                this.addFileTypeToView(vector, sRes.getString("ftype.CDRfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.RTWfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.TMFfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.TLCfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.Cfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.Hfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.ADBfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.ADSfile"));
                this.addFileTypeToView(vector, "");
            } else {
                this.addFileTypeToView(vector, "");
                this.addFileTypeToView(vector, sRes.getString("ftype.ADSfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.ADBfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.Hfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.Cfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.TLCfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.TMFfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.RTWfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.CDRfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.SimulinkModel"));
                this.addFileTypeToView(vector, sRes.getString("ftype.Pfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.Figurefile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.MEXfile.win32"));
                this.addFileTypeToView(vector, sRes.getString("ftype.MEXfile.sol2"));
                this.addFileTypeToView(vector, sRes.getString("ftype.MEXfile.sgi"));
                this.addFileTypeToView(vector, sRes.getString("ftype.MEXfile.glnx86"));
                this.addFileTypeToView(vector, sRes.getString("ftype.MEXfile.ibm"));
                this.addFileTypeToView(vector, sRes.getString("ftype.MEXfile.hp700"));
                this.addFileTypeToView(vector, sRes.getString("ftype.MEXfile.alpha"));
                this.addFileTypeToView(vector, sRes.getString("ftype.MEXfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.MATfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.Mfile"));
                this.addFileTypeToView(vector, sRes.getString("ftype.Folder"));
            }
        } else {
            String[][] stringArray = this.createTable(vector, n);
            this.addSortedFilesToView(stringArray, vector, bl2);
        }
        this.fCurrentKeyColumn = n;
        this.fSortedInReverse = bl2;
    }

    private String[][] createTable(Vector vector, int n) {
        String[] stringArray;
        int n2 = vector.size();
        Object[][] objectArray = new String[n2][2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray = (String[])vector.elementAt(n3);
            if (n == 2) {
                File file = new File(this.fPathName, stringArray[0]);
                objectArray[n3][0] = String.valueOf(file.lastModified());
            } else {
                objectArray[n3][0] = stringArray[n];
            }
            objectArray[n3][1] = String.valueOf(n3);
            ++n3;
        }
        stringArray = new DDQSortAlgorithm();
        stringArray.sort(objectArray, 2, 0);
        return objectArray;
    }

    private void addSortedFilesToView(String[][] stringArray, Vector vector, boolean bl) {
        int n = stringArray.length;
        int n2 = 0;
        int n3 = n;
        int n4 = 1;
        if (bl) {
            n2 = n - 1;
            n3 = -1;
            n4 = -1;
        }
        int n5 = 1;
        while (n5 < 3) {
            int n6 = n2;
            while (n6 != n3 && !this.fStopRequested) {
                Integer n7 = new Integer(stringArray[n6][1]);
                String[] stringArray2 = (String[])vector.elementAt(n7);
                if (n5 == 1 && stringArray2[1].equals(sRes.getString("ftype.Folder")) || n5 != 1 && !stringArray2[1].equals(sRes.getString("ftype.Folder"))) {
                    File file = new File(this.fPathName, stringArray2[0]);
                    this.addFileToView(-2, this.fPathName, stringArray2[0], this.getFileIcon(file), false);
                }
                n6 += n4;
            }
            ++n5;
        }
    }

    private Vector createTempSortVector() {
        int n = this.fFileList.getItemCount();
        Vector<String[]> vector = new Vector<String[]>();
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray = new String[]{this.fFileList.getItem(n2, 0), this.fFileList.getItem(n2, 1), this.fFileList.getItem(n2, 2), this.fFileList.getItem(n2, 3)};
            vector.addElement(stringArray);
            ++n2;
        }
        return vector;
    }

    private void addFileTypeToView(Vector vector, String string) {
        int n = 0;
        while (n < vector.size()) {
            String[] stringArray = (String[])vector.elementAt(n);
            File file = new File(this.fPathName, stringArray[0]);
            if (stringArray[1].equals(string)) {
                this.addFileToView(-2, this.fPathName, stringArray[0], this.getFileIcon(file), false);
                vector.removeElement(vector.elementAt(n));
                --n;
            }
            ++n;
        }
    }

    private void addFilterMenus(MWMenu mWMenu) {
        mWMenu.removeAll();
        mWMenu.add((MWMenuComponent)this.fShowMFilesMenuItem);
        mWMenu.add((MWMenuComponent)this.fShowMatFilesMenuItem);
        mWMenu.add((MWMenuComponent)this.fShowMexFilesMenuItem);
        mWMenu.add((MWMenuComponent)this.fShowFigFilesMenuItem);
        mWMenu.add((MWMenuComponent)this.fShowPFilesMenuItem);
        mWMenu.add((MWMenuComponent)this.fShowMdlFilesMenuItem);
        mWMenu.add((MWMenuComponent)this.fShowStateflowFilesMenuItem);
        mWMenu.add((MWMenuComponent)this.fShowRealtimeFilesMenuItem);
        mWMenu.addSeparator();
        mWMenu.add((MWMenuComponent)this.fShowMatlabFilesMenuItem);
        mWMenu.add((MWMenuComponent)this.fShowAllFilesMenuItem);
        mWMenu.addSeparator();
        mWMenu.add((MWMenuComponent)this.fShowDirectoriesMenuItem);
    }

    private void createPopupMenus() {
        this.fFilePopupMenu = new MWMenu("", this.fCenter);
        this.fFilePopupMenu.addMenuItem(sRes.getString("action.Open"), 140);
        this.fFilePopupMenu.addMenuItem(sRes.getString("action.Run"), 10);
        this.fFilePopupMenu.addMenuItem(sRes.getString("action.Help"), 14);
        this.fFilePopupMenu.addMenuItem(sRes.getString("action.EditasText"), 16);
        this.fFilePopupMenu.addMenuItem(String.valueOf(sRes.getString("action.ImportData")) + "...", 11);
        this.fFilePopupMenu.addSeparator();
        this.fNewMenu = new MWMenu(sRes.getString("action.New"), this.fCenter);
        this.fNewMenu.addMenuItem(sRes.getString("action.File"), -101);
        this.fNewMenu.addMenuItem(sRes.getString("action.Model"), 17);
        this.fNewMenu.addMenuItem(sRes.getString("action.Folder"), 15);
        this.fFilePopupMenu.add((MWMenuComponent)this.fNewMenu);
        this.fFilePopupMenu.addMenuItem(sRes.getString("action.Rename"), 13);
        this.fFilePopupMenu.addMenuItem(sRes.getString("action.Delete"), 1070);
        this.fFilePopupMenu.addSeparator();
        this.fFilePopupMenu.addMenuItem(sRes.getString("action.Cut"), 900);
        this.fFilePopupMenu.addMenuItem(sRes.getString("action.Copy"), 910);
        this.fFilePopupMenu.addMenuItem(sRes.getString("action.Paste"), 920);
        this.fFilePopupMenu.addSeparator();
        this.fFilterSubmenu = new MWMenu(sRes.getString("action.Filter"), this.fCenter);
        this.fFilePopupMenu.add((MWMenuComponent)this.fFilterSubmenu);
        MWMenu mWMenu = new MWMenu(sRes.getString("action.AddToPath"), this.fCenter);
        mWMenu.addMenuItem(sRes.getString("action.AddCurrentDirectoryToPath"), 30);
        mWMenu.addMenuItem(sRes.getString("action.AddSelectedFoldersToPath"), 31);
        mWMenu.addMenuItem(sRes.getString("action.AddSelectedFoldersWithSubfoldersToPath"), 32);
        this.fFilePopupMenu.add((MWMenuComponent)mWMenu);
        this.fFilePopupMenu.addSeparator();
        this.fFilePopupMenu.addMenuItem(sRes.getString("action.Refresh"), 9);
        this.fFilePopupMenu.attachTo((Component)this.fFileList);
        this.fFilterPopupMenu = new MWMenu(sRes.getString("action.Filter"), this.fCenter);
        this.fShowMFilesMenuItem = this.addCheckboxMenuItemToPopupMenu(2220, this.fShowMFiles);
        this.fShowMatFilesMenuItem = this.addCheckboxMenuItemToPopupMenu(2222, this.fShowMatFiles);
        this.fShowMexFilesMenuItem = this.addCheckboxMenuItemToPopupMenu(2221, this.fShowMexFiles);
        this.fShowFigFilesMenuItem = this.addCheckboxMenuItemToPopupMenu(2223, this.fShowFigFiles);
        this.fShowPFilesMenuItem = this.addCheckboxMenuItemToPopupMenu(2224, this.fShowPFiles);
        this.fShowMdlFilesMenuItem = this.addCheckboxMenuItemToPopupMenu(2225, this.fShowMdlFiles);
        this.fShowStateflowFilesMenuItem = this.addCheckboxMenuItemToPopupMenu(2226, this.fShowStateflowFiles);
        this.fShowRealtimeFilesMenuItem = this.addCheckboxMenuItemToPopupMenu(2227, this.fShowRealtimeFiles);
        this.fFilterPopupMenu.addSeparator();
        this.fShowMatlabFilesMenuItem = this.addCheckboxMenuItemToPopupMenu(2228, this.fShowMatlabFiles);
        this.fShowAllFilesMenuItem = this.addCheckboxMenuItemToPopupMenu(2229, this.fShowAllFiles);
        this.fFilterPopupMenu.addSeparator();
        this.fShowDirectoriesMenuItem = this.addCheckboxMenuItemToPopupMenu(2230, this.fShowDirectories);
        this.fFilterPopupMenu.attachTo((Component)this.fFileList);
        this.fCenter.setCommandEnabled(900, false);
        this.fCenter.setCommandEnabled(910, false);
        this.fCenter.setCommandEnabled(920, false);
    }

    private MWMenuItem addCheckboxMenuItemToPopupMenu(int n, boolean bl) {
        MWMenuItem mWMenuItem = this.fFilterPopupMenu.addCheckboxMenuItem(FileBrowserMenubar.getMenuLabel(n, false), n);
        mWMenuItem.setState(bl);
        this.fCenter.addCommandSource((MWCommandSource)mWMenuItem, n);
        return mWMenuItem;
    }

    public void setPathName(String string, boolean bl, boolean bl2, boolean bl3) {
        this.fShowHelp = bl;
        this.setPathName(string, null);
    }

    private boolean comparePaths(String string, String string2) {
        if (PlatformInfo.getPlatform() == 1) {
            return string.equalsIgnoreCase(string2);
        }
        return string.equals(string2);
    }

    private void setPathName(String string, boolean bl) {
        this.setPathName(string, null, false, bl);
    }

    public void setPathName(String string) {
        this.setPathName(string, null);
    }

    public void setPathName(String string, String string2) {
        this.setPathName(string, string2, false, false);
    }

    public void setPathName(String string, String string2, boolean bl) {
        this.setPathName(string, string2, bl, false);
    }

    public void setPathName(String string, String string2, boolean bl, boolean bl2) {
        if (!bl && this.getCurrentDirectoryName() != null && string != null && string.equals(this.getCurrentDirectoryName())) {
            return;
        }
        if (string.equals("") && PlatformInfo.isUnix()) {
            string = "/";
        }
        this.waitForLoadingThreadToStop(true);
        this.fFileList.commitEdit();
        if (this.fCenter != null) {
            if (PlatformInfo.isUnix() && string.equals("/")) {
                this.fCenter.setCommandEnabled(5, false);
            } else if (PlatformInfo.isWindows() && string.length() == 3 && string.endsWith(":\\")) {
                this.fCenter.setCommandEnabled(5, false);
            } else {
                this.fCenter.setCommandEnabled(5, true);
            }
        }
        this.fPathName = string;
        if (this.fAlwaysShowCWD && !bl2 && this.fMatlab != null && (PlatformInfo.getPlatform() != 1 || string != null)) {
            this.unregisterWorkspaceInterests();
            this.fMatlab.evalNoOutput("cd('" + StringUtils.quoteSingleQuotes((String)this.fPathName) + "')");
            this.fCurrentMatlabDirectory = this.fPathName;
            this.registerWorkspaceInterests();
        }
        if (this.fCenter != null) {
            this.fCenter.setCommandEnabled(140, false);
        }
        this.fLoadNewDirThread = new LoadNewDirectoryThread(this.fPathName, string2);
        this.fLoadNewDirThread.start();
    }

    public void addNotify() {
        super.addNotify();
        if (!this.fIsInitialPathSet) {
            this.setPathToCwd();
        }
    }

    private void waitForLoadingThreadToStop(boolean bl) {
        if (this.fLoadNewDirThread != null && this.fLoadNewDirThread.isAlive()) {
            if (bl) {
                this.fStopRequested = true;
            }
            try {
                this.fLoadNewDirThread.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fFileList.setFont(font);
        this.fCommentDisplay.setFont(font);
        this.fCwdDisplayPanel.setFont(font);
        ((Container)((Object)this.fCwdDisplayPanel)).invalidate();
        ((Container)((Object)this)).validate();
        ((Component)((Object)this)).repaint();
    }

    public void setDisplayedColumns(boolean bl, boolean bl2, boolean bl3) {
        int n = this.fFileList.getFirstRow();
        int[] nArray = this.fFileList.getSelectedIndexes();
        this.fShowHelp = bl;
        this.fShowModifiedDates = bl2;
        this.fShowFileTypes = bl3;
        this.updateNewDirectory(this.getCurrentDirectoryName());
        this.fFileList.setFirstRow(n);
        this.fFileList.setSelectedIndexes(nArray);
        this.setColumnWidths(false);
    }

    public void setShowHelp(boolean bl) {
        int n = this.fFileList.getFirstRow();
        int[] nArray = this.fFileList.getSelectedIndexes();
        this.fShowHelp = bl;
        this.updateNewDirectory(this.getCurrentDirectoryName());
        this.fFileList.setFirstRow(n);
        this.fFileList.setSelectedIndexes(nArray);
        this.setColumnWidths(false);
    }

    public void setShowModifiedDates(boolean bl) {
        int n = this.fFileList.getFirstRow();
        int[] nArray = this.fFileList.getSelectedIndexes();
        this.fShowModifiedDates = bl;
        this.updateNewDirectory(this.getCurrentDirectoryName());
        this.fFileList.setFirstRow(n);
        this.fFileList.setSelectedIndexes(nArray);
        this.setColumnWidths(false);
    }

    public void setShowFileTypes(boolean bl) {
        int n = this.fFileList.getFirstRow();
        int[] nArray = this.fFileList.getSelectedIndexes();
        this.fShowFileTypes = bl;
        this.updateNewDirectory(this.getCurrentDirectoryName());
        this.fFileList.setFirstRow(n);
        this.fFileList.setSelectedIndexes(nArray);
        this.setColumnWidths(false);
    }

    public boolean getShowHelp() {
        return this.fShowHelp;
    }

    public boolean getShowCommentBlock() {
        return this.fShowCommentBlock;
    }

    public boolean getShowLastModifiedDate() {
        return this.fShowModifiedDates;
    }

    public boolean getAlwaysShowCWD() {
        return this.fAlwaysShowCWD;
    }

    public boolean getFollowPathSelection() {
        return this.fFollowPathSelection;
    }

    public void setPathToCwd() {
        if (this.fMatlab != null) {
            this.fMatlab.eval("cd", (CompletionObserver)new CwdCallback(2));
        }
    }

    public void showCommentBlock(boolean bl) {
        if (bl) {
            ((Container)((Object)this)).remove((Component)this.fFilePanel);
            this.fFileSplitter = new MWSplitter((Component)this.fFilePanel, (Component)((Object)this.fCommentDisplay));
            ((Container)((Object)this)).add((Component)this.fFileSplitter, "Center");
            this.fFileSplitter.setDividerLocation(0.7);
            ((Container)((Object)this)).validate();
            this.fShowCommentBlock = true;
            this.updateCommentBlock();
            return;
        }
        ((Container)((Object)this)).remove((Component)this.fFileSplitter);
        ((Container)((Object)this)).add((Component)this.fFilePanel);
        ((Container)((Object)this)).validate();
        this.fShowCommentBlock = false;
    }

    private void registerWorkspaceInterests() {
        if (this.fMatlab != null) {
            this.fWorkspaceInterests = this.fMatlab.registerInterest(2, 0x40000000, (CompletionObserver)new WorkspaceCallback(1));
        }
    }

    private void unregisterWorkspaceInterests() {
        if (this.fMatlab != null) {
            this.fMatlab.unregisterInterest(this.fWorkspaceInterests);
        }
    }

    private void registerPathManagerInterest() {
        if (this.fMatlab != null) {
            this.fMatlab.evalNoOutput("system_dependent('RegisterPathInterest')");
        }
    }

    public void selectFilename(String string) {
        this.fFileList.setSelectedIndex(-2);
        int n = -2;
        int n2 = 0;
        while (n2 < this.fFileList.getItemCount()) {
            if (this.fFileList.getItem(n2).equals(string)) {
                this.fFileList.setSelectedIndex(n2);
                this.updateCommentBlock();
                n = n2;
                break;
            }
            ++n2;
        }
        if (n != -2) {
            this.fFileList.setFirstRow(n);
        }
        this.fFileList.requestFocus();
    }

    private void loadResources() {
        this.fMatlabIcon = this.resources.loadImage("/com/mathworks/mwt/resources/matlabicon.gif");
        this.fIcon[0] = this.resources.loadImage("/com/mathworks/mwt/resources/folder.gif");
        this.fIcon[1] = this.resources.loadImage("/com/mathworks/mwt/resources/folderwin.gif");
        this.fIcon[2] = this.resources.loadImage("/com/mathworks/ide/browsers/resources/onpathfolder.gif");
        this.fIcon[3] = this.resources.loadImage("/com/mathworks/ide/browsers/resources/downarrow.gif");
        this.fFilePic = new Image[16];
        this.fFilePic[0] = this.resources.loadImage("/com/mathworks/mwt/resources/disk.gif");
        this.fFilePic[1] = this.resources.loadImage("/com/mathworks/mwt/resources/folder.gif");
        this.fFilePic[2] = this.resources.loadImage("/com/mathworks/mwt/resources/document.gif");
        this.fFilePic[3] = this.resources.loadImage("/com/mathworks/mwt/resources/m.gif");
        this.fFilePic[4] = this.resources.loadImage("/com/mathworks/mwt/resources/mat.gif");
        this.fFilePic[5] = this.resources.loadImage("/com/mathworks/mwt/resources/mex.gif");
        this.fFilePic[6] = this.resources.loadImage("/com/mathworks/mwt/resources/p.gif");
        this.fFilePic[7] = this.resources.loadImage("/com/mathworks/mwt/resources/mdl.gif");
        this.fFilePic[8] = this.resources.loadImage("/com/mathworks/mwt/resources/tlc.gif");
        this.fFilePic[9] = this.resources.loadImage("/com/mathworks/mwt/resources/diskwin.gif");
        this.fFilePic[10] = this.resources.loadImage("/com/mathworks/mwt/resources/folderwin.gif");
        this.fFilePic[11] = this.resources.loadImage("/com/mathworks/mwt/resources/documentwin.gif");
        this.fFilePic[12] = this.resources.loadImage("/com/mathworks/mwt/resources/mwin.gif");
        this.fFilePic[13] = this.resources.loadImage("/com/mathworks/mwt/resources/matwin.gif");
        this.fFilePic[14] = this.resources.loadImage("/com/mathworks/mwt/resources/htmlicon.gif");
        this.fFilePic[15] = this.resources.loadImage("/com/mathworks/mwt/resources/data.gif");
    }

    private MWToolbar createToolbar() {
        if (PlatformInfo.getAppearance() == 1) {
            String string = "_win.gif";
        } else {
            String string = ".gif";
        }
        int n = 6;
        if (PlatformInfo.isWindows()) {
            n = 4;
        }
        MWToolbar mWToolbar = new MWToolbar(null, (LayoutManager)new MyToolbarLayout(n));
        this.fCwdDisplayPanel = new CwdDisplayPanel(false, this.fCenter);
        this.fCwdDisplayPanel.getCwdDisplay().addFocusListener(new CwdFocusListener());
        mWToolbar.addComponent((Component)((Object)this.fCwdDisplayPanel));
        mWToolbar.addSpacer();
        mWToolbar.addImageButton("/com/mathworks/mwt/resources/dirupwin.gif", 5, sRes.getString("action.GoUpaDirectory"), this.fCenter);
        mWToolbar.addImageButton("/com/mathworks/mwt/resources/newdir.gif", 15, sRes.getString("action.NewDirectory"), this.fCenter);
        mWToolbar.addSpacer();
        mWToolbar.addImageButton("/com/mathworks/mwt/resources/find_win.gif", 2, sRes.getString("action.FindinFiles"), this.fCenter);
        return mWToolbar;
    }

    private void showFiles() {
    }

    public void viewHelpForSelectedMFile() {
        String string;
        if (this.fMatlab != null && this.fileExists(string = this.fFileList.getItem(this.fFileList.getSelectedIndex()))) {
            if (FileView.isMFile(string)) {
                string = string.substring(0, string.length() - 2);
            }
            this.fMatlab.evalNoOutput("doc('" + StringUtils.quoteSingleQuotes((String)string) + "')");
        }
    }

    private void getSelectedFilesForEditOperation() {
        this.fFileClipboard.removeAllElements();
        String string = this.getCurrentDirectoryName();
        if (PlatformInfo.getPlatform() == 1 && string.equals(sRootDirName)) {
            string = "";
        }
        if (!string.endsWith(fSeparator) && !string.equals("")) {
            string = String.valueOf(string) + fSeparator;
        }
        int[] nArray = this.fFileList.getSelectedIndexes();
        int n = 0;
        while (n < nArray.length) {
            String string2 = this.fFileList.getItem(nArray[n]);
            if (this.fileExists(string2)) {
                String string3 = String.valueOf(string) + string2;
                File file = new File(string3);
                if (this.fCurrentEditOperation == 910 && file.isDirectory()) {
                    Object[] objectArray = new Object[]{file.getPath()};
                    new MWAlert(this.getFrame(), sRes.getString("CurrentDirectory"), MessageFormat.format(sRes.getString("error.CannotCopyFolders"), objectArray), 1);
                } else {
                    this.fFileClipboard.addElement(file);
                }
            }
            ++n;
        }
        this.fCenter.setCommandEnabled(920, true);
    }

    public void doCut() {
        if (this.fLastFocusOwner == this.fCwdDisplayPanel) {
            this.fCwdDisplayPanel.getCwdDisplay().doCommand(900);
            return;
        }
        this.fCurrentEditOperation = 900;
        this.getSelectedFilesForEditOperation();
    }

    public void doCopy() {
        if (this.fLastFocusOwner == this.fCwdDisplayPanel) {
            this.fCwdDisplayPanel.getCwdDisplay().doCommand(910);
            return;
        }
        this.fCurrentEditOperation = 910;
        this.getSelectedFilesForEditOperation();
    }

    public void doPaste() {
        File file;
        Object object;
        if (this.fLastFocusOwner == this.fCwdDisplayPanel) {
            this.fCwdDisplayPanel.getCwdDisplay().doCommand(920);
            return;
        }
        Object object2 = this.getCurrentDirectoryName();
        int[] nArray = this.fFileList.getSelectedIndexes();
        if (nArray.length == 1) {
            String string = this.fFileList.getItem(this.fFileList.getSelectedIndex());
            object = StringUtils.fromJavaPath((String)(String.valueOf(this.getCurrentDirectoryName()) + "/" + string));
            file = new File((String)object);
            if (file.isDirectory()) {
                object2 = object;
            }
        }
        int n = 0;
        while (n < this.fFileClipboard.size()) {
            Object[] objectArray;
            object = (File)this.fFileClipboard.elementAt(n);
            file = new File((String)object2, ((File)object).getName());
            if (this.fCurrentEditOperation == 910) {
                Object object3;
                if (file.exists()) {
                    if (file.isDirectory()) {
                        objectArray = new Object[]{((File)object).getPath()};
                        new MWAlert(this.getFrame(), sRes.getString("CurrentDirectory"), MessageFormat.format(sRes.getString("error.CannotCopyFolders"), objectArray), 1);
                    } else if (((File)object).equals(file)) {
                        int n2 = 1;
                        while (file.exists()) {
                            object3 = "";
                            if (n2 > 1) {
                                object3 = "-" + n2;
                            }
                            Object[] objectArray2 = new Object[]{object3, file.getName()};
                            file = new File((String)object2, MessageFormat.format(sRes.getString("NextName"), objectArray2));
                            ++n2;
                        }
                    } else {
                        this.handleExistingFile((File)object, file);
                    }
                }
                if (!file.exists()) {
                    try {
                        objectArray = new FileInputStream((File)object);
                        object3 = new FileOutputStream(file);
                        StreamCopier.copy((InputStream)objectArray, (OutputStream)object3);
                        objectArray.close();
                        ((FileOutputStream)object3).close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {}
                }
            } else {
                if (file.exists()) {
                    if (file.isDirectory()) {
                        objectArray = new Object[]{((File)object).getPath()};
                        new MWAlert(this.getFrame(), sRes.getString("CurrentDirectory"), MessageFormat.format(sRes.getString("error.DirectoryExists"), objectArray), 1);
                    } else if (!((File)object).equals(file)) {
                        this.handleExistingFile((File)object, file);
                    }
                }
                if (!file.exists()) {
                    ((File)object).renameTo(file);
                }
            }
            ++n;
        }
        if (this.fCurrentEditOperation == 900) {
            this.fCenter.setCommandEnabled(920, false);
            this.fFileClipboard.removeAllElements();
        }
        this.refreshDirectory(false);
    }

    public void doRename() {
        String string = this.fFileList.getItem(this.fFileList.getSelectedIndex());
        if (this.fileExists(string)) {
            this.fCurrentEditOperation = 13;
            this.renameItem(this.fFileList.getSelectedIndex());
        }
    }

    private void handleExistingFile(File file, File file2) {
        if (file2.exists()) {
            boolean bl;
            if (file2.isDirectory()) {
                Object[] objectArray = new Object[]{file2.getPath()};
                new MWAlert(this.getFrame(), sRes.getString("CurrentDirectory"), MessageFormat.format(sRes.getString("error.DirectoryExists"), objectArray), 1);
                return;
            }
            Object[] objectArray = new Object[]{file2.getPath()};
            MWAlert mWAlert = new MWAlert(this.getFrame(), sRes.getString("CurrentDirectory"), MessageFormat.format(sRes.getString("error.DirExistsOverwrite"), objectArray), 3);
            int n = mWAlert.getReply();
            if (n == 1 && !(bl = file2.delete())) {
                Object[] objectArray2 = new Object[]{file2.getPath()};
                new MWAlert(this.getFrame(), sRes.getString("CurrentDirectory"), MessageFormat.format(sRes.getString("error.CannotOverwriteDir"), objectArray2), 1);
            }
        }
    }

    public void runSelectedMFile() {
        String string = this.fFileList.getItem(this.fFileList.getSelectedIndex());
        if (this.fileExists(string) && this.fMatlab != null && FileView.isMatlabRunnableFile(string)) {
            int n = string.length() - 1;
            while (n > 0) {
                if (string.charAt(n) == '.') {
                    String string2 = string.substring(0, n);
                    this.fMatlab.evalConsoleOutput(string2);
                }
                --n;
            }
        }
    }

    public void loadSelectedFile() {
        if (this.fMatlab == null) {
            return;
        }
        String string = this.getCurrentDirectoryName();
        if (PlatformInfo.getPlatform() == 1 && string.equals(sRootDirName)) {
            string = "";
        }
        if (!string.endsWith(fSeparator) && !string.equals("")) {
            string = String.valueOf(string) + fSeparator;
        }
        int[] nArray = this.fFileList.getSelectedIndexes();
        String string2 = this.fFileList.getItem(nArray[0]);
        String string3 = String.valueOf(string) + string2;
        File file = new File(string3);
        if (this.fileExists(string2) && file.isFile()) {
            this.fMatlab.evalConsoleOutput("uiimport('" + StringUtils.quoteSingleQuotes((String)string3) + "')");
        }
    }

    public void editSelectedFile() {
        if (this.fMatlab == null) {
            return;
        }
        String string = this.getCurrentDirectoryName();
        if (PlatformInfo.getPlatform() == 1 && string.equals(sRootDirName)) {
            string = "";
        }
        if (!string.endsWith(fSeparator) && !string.equals("")) {
            string = String.valueOf(string) + fSeparator;
        }
        int[] nArray = this.fFileList.getSelectedIndexes();
        int n = 0;
        while (n < nArray.length) {
            String string2 = this.fFileList.getItem(nArray[n]);
            String string3 = String.valueOf(string) + string2;
            File file = new File(string3);
            if (this.fileExists(string2) && file.isFile()) {
                this.fMatlab.evalConsoleOutput("edit('" + StringUtils.quoteSingleQuotes((String)string3) + "')");
            }
            ++n;
        }
    }

    public void addCurrentDirectoryToPath(MWFrameProxy mWFrameProxy) {
        if (this.fMatlab != null) {
            this.fMatlab.evalNoOutput("addpath('" + StringUtils.quoteSingleQuotes((String)this.getCurrentDirectoryName()) + "')");
            Object[] objectArray = new Object[]{this.getCurrentDirectory()};
            mWFrameProxy.setStatusText(MessageFormat.format(sRes.getString("msg.FolderAddedToPath"), objectArray));
        }
    }

    public void addSelectedFoldersToPath(MWFrameProxy mWFrameProxy, boolean bl) {
        if (this.fMatlab != null) {
            int[] nArray = this.fFileList.getSelectedIndexes();
            boolean bl2 = false;
            int n = 0;
            while (n < nArray.length) {
                String string = this.fFileList.getItem(nArray[n]);
                String string2 = StringUtils.fromJavaPath((String)(String.valueOf(this.getCurrentDirectoryName()) + "/" + string));
                File file = new File(string2);
                if (this.fileExists(string) && file.isDirectory()) {
                    this.fMatlab.evalNoOutput("addpath('" + StringUtils.quoteSingleQuotes((String)string2) + "')");
                    if (bl) {
                        this.addSubfoldersToPath(file);
                    }
                    bl2 = true;
                }
                ++n;
            }
            if (bl2) {
                if (bl) {
                    mWFrameProxy.setStatusText(sRes.getString("msg.SelectedFoldersAndSubfoldersAddedToPath"));
                    return;
                }
                mWFrameProxy.setStatusText(sRes.getString("msg.SelectedFoldersAddedToPath"));
                return;
            }
            mWFrameProxy.setStatusText(sRes.getString("msg.NoFoldersSelected"));
        }
    }

    private void addSubfoldersToPath(File file) {
        String[] stringArray = file.list();
        String string = file.getAbsolutePath();
        if (stringArray == null) {
            return;
        }
        if (PlatformInfo.getPlatform() != 0) {
            QSortAlgorithm qSortAlgorithm = new QSortAlgorithm();
            qSortAlgorithm.sort(stringArray);
        }
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(string, stringArray[n]);
            if (file2.isDirectory()) {
                this.fMatlab.evalNoOutput("addpath('" + StringUtils.quoteSingleQuotes((String)file2.getAbsolutePath()) + "')");
                this.addSubfoldersToPath(file2);
            }
            ++n;
        }
    }

    public void removeCurrentDirectoryFromPath() {
        if (this.fMatlab != null) {
            this.fMatlab.evalNoOutput("rmpath('" + StringUtils.quoteSingleQuotes((String)this.getCurrentDirectoryName()) + "')");
        }
    }

    public void setCWDToDisplayedDirectory() {
        if (this.fMatlab != null) {
            this.unregisterWorkspaceInterests();
            this.fMatlab.evalNoOutput("cd('" + StringUtils.quoteSingleQuotes((String)this.getCurrentDirectoryName()) + "')");
            this.registerWorkspaceInterests();
            this.fCurrentMatlabDirectory = this.getCurrentDirectoryName();
        }
    }

    public void showCWD() {
        this.setPathName(this.fCurrentMatlabDirectory);
    }

    public int[] getColumnWidths() {
        int n = this.fFileList.getColumnWidth(0);
        int n2 = this.fFileList.getColumnWidth(1);
        int n3 = this.fFileList.getColumnWidth(2);
        int n4 = this.fFileList.getColumnWidth(3);
        if (n != 0) {
            this.fColumnWidths[0] = n;
        }
        if (n2 != 0) {
            this.fColumnWidths[1] = n2;
        }
        if (n3 != 0) {
            this.fColumnWidths[2] = n3;
        }
        if (n4 != 0) {
            this.fColumnWidths[3] = n4;
        }
        return this.fColumnWidths;
    }

    private void setColumnWidths(boolean bl) {
        int n = this.fFileList.getColumnWidth(0);
        int n2 = this.fFileList.getColumnWidth(1);
        int n3 = this.fFileList.getColumnWidth(2);
        int n4 = this.fFileList.getColumnWidth(3);
        if (bl) {
            n = this.fColumnWidths[0];
            n2 = this.fColumnWidths[1];
            n3 = this.fColumnWidths[2];
            n4 = this.fColumnWidths[3];
        }
        if (!this.fShowFileTypes) {
            if (n2 != 0) {
                this.fColumnWidths[1] = n2;
            }
            n2 = 0;
        } else if (n2 == 0) {
            n2 = this.fColumnWidths[1];
        }
        if (!this.fShowModifiedDates) {
            if (n3 != 0) {
                this.fColumnWidths[2] = n3;
            }
            n3 = 0;
        } else if (n3 == 0) {
            n3 = this.fColumnWidths[2];
        }
        if (!this.fShowHelp) {
            if (n4 != 0) {
                this.fColumnWidths[3] = n4;
            }
            n4 = 0;
        } else if (n4 == 0) {
            n4 = this.fColumnWidths[3];
        }
        this.fFileList.setColumnWidth(0, n);
        this.fFileList.setColumnWidth(1, n2);
        this.fFileList.setColumnWidth(2, n3);
        this.fFileList.setColumnWidth(3, n4);
        if (!this.fShowHelp) {
            if (this.fShowModifiedDates) {
                this.fFileList.setAutoExpandColumn(2);
            } else {
                if (this.fShowFileTypes) {
                    this.fFileList.setAutoExpandColumn(1);
                } else {
                    this.fFileList.setAutoExpandColumn(0);
                    this.fFileList.setColumnWidth(1, 0);
                }
                this.fFileList.setColumnWidth(2, 0);
            }
            this.fFileList.setColumnWidth(3, 0);
            return;
        }
        this.fFileList.setAutoExpandColumn(3);
    }

    public void setColumnWidths(int[] nArray) {
        System.arraycopy(nArray, 0, this.fColumnWidths, 0, 4);
        this.setColumnWidths(false);
    }

    public void createNewMFile() {
        this.createNewFile(-101);
    }

    public void createNewModel() {
        this.createNewFile(17);
    }

    public void createNewDirectory() {
        this.createNewFile(15);
    }

    private void createNewFile(int n) {
        File file = new File(this.getCurrentDirectoryName());
        if (!file.canWrite()) {
            new MWAlert(this.getFrame(), sRes.getString("CurrentDirectory"), sRes.getString("error.NoWritePermission"), 1);
            return;
        }
        String string = null;
        Image image = null;
        int n2 = 1;
        if (n == -101) {
            string = "Untitled1.m";
            while (new File(this.getCurrentDirectory(), string).exists()) {
                string = "Untitled" + n2++ + ".m";
            }
            image = this.fFilePic[12];
        } else if (n == 17) {
            string = "Untitled1.mdl";
            while (new File(this.getCurrentDirectory(), string).exists()) {
                string = "Untitled" + n2++ + ".mdl";
            }
            image = this.fFilePic[7];
        } else {
            string = "NewFolder1";
            while (new File(this.getCurrentDirectory(), string).exists()) {
                string = "NewFolder" + n2++;
            }
            image = this.fFilePic[10];
        }
        this.fCurrentEditOperation = n;
        this.fFileList.scrollToCell(this.fFileList.getItemCount(), 0);
        this.fFileList.addItem(string);
        this.fFileList.setCellData(this.fFileList.getItemCount() - 1, 0, (Object)new LabeledImageResource(image, string));
        this.renameItem(this.fFileList.getItemCount() - 1);
    }

    private void renameItem(int n) {
        this.fCurrentFilename = this.fFileList.getItem(n);
        this.fFileList.setEditable(true);
        this.fFileList.setSelectedIndex(n);
        this.fFileList.requestFocus();
        this.fFileList.getCell(n, 0).beginEdit(n, 0);
    }

    private void displayNoWritePermissionDialog() {
        new MWAlert(this.getFrame(), sRes.getString("CurrentDirectory"), sRes.getString("error.NoWritePermission"), 1);
    }

    public static String getH1Line(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        String string2 = null;
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        String string3 = Locale.getDefault().getLanguage();
        if (file.isDirectory()) {
            if (!string3.equals("en") && ((File)(object = new File(string, string3))).exists()) {
                string = ((File)object).getPath();
                file = new File(string);
            }
            if (!((File)(object = new File(string2 = String.valueOf(string) + fSeparator + "Contents.m"))).exists()) {
                return "";
            }
        } else {
            if (file.getName().equals("Contents.m")) {
                return sRes.getString("DirectoryDescription");
            }
            if (FileView.isMFile(string)) {
                string = StringUtils.getLocalizedFilename((String)string);
                file = new File(string);
                string2 = string;
            } else {
                return "";
            }
        }
        object = null;
        FileReader fileReader = null;
        String string4 = null;
        try {
            fileReader = new FileReader(string2);
            object = new BufferedReader(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (object != null) {
            try {
                while (!((string4 = ((BufferedReader)object).readLine()) == null || string4.length() != 0 && string4.charAt(0) == '%' || string4 == null && string4.length() == 0 && string4.charAt(0) == '%')) {
                }
                ((BufferedReader)object).close();
                if (string4 == null || string4.length() == 0 || string4.charAt(0) != '%') {
                    return "";
                }
            }
            catch (IOException iOException) {}
        }
        if (string4 == null) {
            return null;
        }
        if (string4.length() == 0) {
            return string4;
        }
        String string5 = string4.substring(1, string4.length());
        return string5.trim();
    }

    public String getCommentBlock(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        String string2 = null;
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        if (file.isDirectory()) {
            string2 = String.valueOf(string) + fSeparator + "Contents.m";
            object = new File(string2);
            if (!((File)object).exists()) {
                return sRes.getString("error.NoContents");
            }
        } else if (FileView.isMFile(string)) {
            string2 = string;
        } else {
            if (FileView.isMatFile(string)) {
                if (this.fMatlab != null) {
                    this.fMatlab.eval("whos('-file','" + StringUtils.quoteSingleQuotes((String)string) + "')", (CompletionObserver)this.fWhosCallback);
                }
                return "";
            }
            return sRes.getString("msg.SelecttoDisplay");
        }
        if (string2 == null) {
            return null;
        }
        object = null;
        String string3 = null;
        try {
            object = new BufferedReader(new FileReader(string2));
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (object != null) {
            try {
                while (!((string3 = ((BufferedReader)object).readLine()) == null || string3.length() != 0 && string3.charAt(0) == '%' || string3 == null && string3.length() == 0 && string3.charAt(0) == '%')) {
                }
                StringBuffer stringBuffer = new StringBuffer();
                while ((string3 = ((BufferedReader)object).readLine()) != null) {
                    if (string3.length() == 0 || string3.charAt(0) != '%') break;
                    stringBuffer.append(string3.substring(1).trim());
                    stringBuffer.append("\n");
                }
                ((BufferedReader)object).close();
                return stringBuffer.toString();
            }
            catch (IOException iOException) {}
        }
        if (string3 == null) {
            return null;
        }
        if (string3.length() == 0) {
            return string3;
        }
        String string4 = string3.substring(1, string3.length());
        return string4.trim();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Object[] getSelectedObjects() {
        if (this.fFileList.getSelectedIndex() != -1) {
            Object[] objectArray = new Object[]{this.fFileList.getItem(this.fFileList.getSelectedIndex())};
            return objectArray;
        }
        return null;
    }

    public void addItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.add(this.fItemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.remove(this.fItemListener, itemListener);
    }

    public void deleteSelectedFiles() {
        int[] nArray;
        int n;
        String string = this.getCurrentDirectoryName();
        int[] nArray2 = this.fFileList.getSelectedIndexes();
        int n2 = 3;
        if (nArray2.length > 1) {
            n2 = 7;
        }
        if ((n = (nArray = this.fFileList.getSelectedIndexes()).length) > 0) {
            boolean bl = false;
            int n3 = 0;
            while (n3 < n) {
                int n4 = nArray[n3];
                String string2 = this.fFileList.getItem(n4);
                File file = new File(string, string2);
                if (this.fileExists(string2)) {
                    Object object;
                    int n5 = 2;
                    if (!bl) {
                        Object[] objectArray = new Object[]{file.getPath()};
                        object = new MWAlert(this.getFrame(), sRes.getString("CurrentDirectory"), MessageFormat.format(sRes.getString("dialog.Delete"), objectArray), n2);
                        n5 = object.getReply();
                    }
                    if (bl || n5 != 2) {
                        boolean bl2 = file.delete();
                        if (bl2) {
                            this.fFileList.removeItem(n4);
                            this.fFileList.deselectAll();
                            object = new int[n - n3 - 1];
                            int n6 = 0;
                            int n7 = n3 + 1;
                            while (n7 < n) {
                                if (nArray[n7] > n4) {
                                    int n8 = n7;
                                    nArray[n8] = nArray[n8] - 1;
                                }
                                object[n6++] = nArray[n7];
                                ++n7;
                            }
                            this.fFileList.setSelectedIndexes((int[])object);
                        } else {
                            object = sRes.getString("msg.MustHaveWritePermission");
                            if (file.isDirectory()) {
                                object = sRes.getString("error.DirectoryMustBeEmpty");
                            }
                            Object[] objectArray = new Object[]{this.fFileList.getItem(n4)};
                            new MWAlert(this.getFrame(), sRes.getString("CurrentDirectory"), String.valueOf(MessageFormat.format(sRes.getString("error.CannotDelete"), objectArray)) + "\n" + (String)object, 1);
                        }
                    }
                    if (n5 == 4) {
                        bl = true;
                    }
                }
                ++n3;
            }
        }
    }

    public void selectAllFiles() {
        if (this.fLastFocusOwner == this.fCwdDisplayPanel) {
            this.fCwdDisplayPanel.getCwdDisplay().doCommand(1060);
            return;
        }
        int[] nArray = new int[this.fFileList.getItemCount()];
        int n = 0;
        while (n < this.fFileList.getItemCount()) {
            nArray[n] = n;
            ++n;
        }
        this.fFileList.setSelectedIndexes(nArray);
    }

    public String getCurrentDirectoryName() {
        return this.fPathName;
    }

    protected void setCurrentDirectoryName(String string) {
        this.fPathName = string;
    }

    protected void updateNewDirectory(String string) {
        this.updateNewDirectory(string, null);
    }

    protected void updateNewDirectory(String string, String string2) {
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
        this.fFileList.deselectAll();
        this.fFileList.removeAllItems();
        this.setColumnHeaders();
        this.addFilesInDirectory(-2, string, string2);
        this.enableCommands();
        ((Component)((Object)this)).setCursor(Cursor.getDefaultCursor());
    }

    private void addFilesInDirectory(int n, String string) {
        this.addFilesInDirectory(n, string, null);
    }

    private void addFilesInDirectory(int n, String string, String string2) {
        if (string.equals("")) {
            return;
        }
        File file = new File(string);
        Object[] objectArray = new String[3];
        if (!file.exists()) {
            objectArray[0] = sRes.getString("error.DirDoesNotExist");
            objectArray[1] = "";
            objectArray[2] = "";
            this.fFileList.addItem(objectArray);
            return;
        }
        QSortAlgorithm qSortAlgorithm = new QSortAlgorithm();
        String[] stringArray = file.list();
        if (stringArray == null) {
            System.out.println(sRes.getString("msg.FileIsNull"));
            return;
        }
        if (PlatformInfo.getPlatform() != 0) {
            qSortAlgorithm.sort(stringArray);
        }
        Vector vector = null;
        if (this.fCurrentKeyColumn != 0 || this.fSortedInReverse) {
            vector = new Vector();
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (this.shouldAddFile(FileView.xlate(stringArray[n3]))) {
                ++n2;
            }
            ++n3;
        }
        this.fFileList.getData().setHeight(n2);
        this.fNextID = 0;
        if (this.fShowDirectories && n == -2 && !this.fStopRequested) {
            this.addFilesToView(n, string, stringArray, string2, 1, vector);
        }
        if (!this.fStopRequested) {
            this.addFilesToView(n, string, stringArray, string2, 2, vector);
        }
        if (vector != null & !this.fStopRequested) {
            this.sortByColumn(vector, this.fCurrentKeyColumn, false);
        }
        this.fFileList.layoutScrollbars();
        this.resources.waitForPendingImages();
        ((Component)((Object)this)).repaint();
    }

    private void addFilesToView(int n, String string, String[] stringArray, String string2, int n2, Vector vector) {
        int n3 = 0;
        while (n3 < stringArray.length) {
            File file = new File(string, stringArray[n3]);
            String string3 = FileView.xlate(stringArray[n3]);
            boolean bl = false;
            if (n2 == 1 && file.isDirectory()) {
                bl = true;
            } else if (n2 != 1 && !file.isDirectory() && this.shouldAddFile(string3)) {
                bl = true;
            }
            if (bl) {
                if (vector != null) {
                    vector.addElement(this.getFileInfo(string, string3));
                } else {
                    this.addFileToView(n, string, string3, this.getFileIcon(file), false);
                }
                if (string2 != null && string3.equals(string2)) {
                    int n4 = this.fFileList.getItemCount() - 1;
                    this.fFileList.setSelectedIndex(n4);
                    this.fFileList.setFirstRow(n4);
                }
            }
            if (this.fStopRequested) {
                return;
            }
            ++n3;
        }
    }

    private boolean shouldAddFile(String string) {
        boolean bl = false;
        File file = new File(string);
        if (file.isDirectory() && this.fShowDirectories) {
            bl = true;
        } else if (this.fShowAllFiles) {
            bl = true;
        } else if (FileView.isMFile(string) && (this.fShowMFiles || this.fShowMatlabFiles)) {
            bl = true;
        } else if (FileView.isMatFile(string) && (this.fShowMatFiles || this.fShowMatlabFiles)) {
            bl = true;
        } else if (FileView.isMdlFile(string) && (this.fShowMdlFiles || this.fShowMatlabFiles)) {
            bl = true;
        } else if (FileView.isFigFile(string) && (this.fShowFigFiles || this.fShowMatlabFiles)) {
            bl = true;
        } else if (FileView.isPFile(string) && (this.fShowPFiles || this.fShowMatlabFiles)) {
            bl = true;
        } else if (FileView.isStateflowFile(string) && (this.fShowStateflowFiles || this.fShowMatlabFiles)) {
            bl = true;
        } else if (FileView.isRealtimeMatlabFile(string) && (this.fShowRealtimeFiles || this.fShowMatlabFiles)) {
            bl = true;
        } else if (FileView.isRealtimeExternalFile(string) && this.fShowRealtimeFiles && !this.fShowMatlabFiles) {
            bl = true;
        } else if ((this.fShowMexFiles || this.fShowMatlabFiles) && FileView.isAMexFile(string)) {
            bl = true;
        }
        return bl;
    }

    private static String getMexFileTypeString(String string) {
        if (FileView.isWinMexFile(string)) {
            if (PlatformInfo.isWindows()) {
                return sRes.getString("ftype.MEXfile");
            }
            return sRes.getString("ftype.MEXfile.win32");
        }
        if (FileView.isSol2MexFile(string)) {
            if (System.getProperty("os.name").equals("Solaris")) {
                return sRes.getString("ftype.MEXfile");
            }
            return sRes.getString("ftype.MEXfile.sol2");
        }
        if (FileView.isLinuxMexFile(string)) {
            if (System.getProperty("os.name").equals("Linux")) {
                return sRes.getString("ftype.MEXfile");
            }
            return sRes.getString("ftype.MEXfile.glnx86");
        }
        if (FileView.isSgiMexFile(string)) {
            if (System.getProperty("os.name").equals("Irix")) {
                return sRes.getString("ftype.MEXfile");
            }
            return sRes.getString("ftype.MEXfile.sgi");
        }
        if (FileView.isAlphaMexFile(string)) {
            if (System.getProperty("os.name").equals("Compaq's Digital UNIX")) {
                return sRes.getString("ftype.MEXfile");
            }
            return sRes.getString("ftype.MEXfile.alpha");
        }
        if (FileView.isAixMexFile(string)) {
            if (System.getProperty("os.name").equals("AIX")) {
                return sRes.getString("ftype.MEXfile");
            }
            return sRes.getString("ftype.MEXfile.ibm");
        }
        if (FileView.isHpMexFile(string)) {
            return sRes.getString("ftype.MEXfile.hp700");
        }
        return "";
    }

    private static boolean isANativeMexFile(String string) {
        return FileView.isAMexFile(string) && FileView.getMexFileTypeString(string).equals(sRes.getString("ftype.MEXfile"));
    }

    private static boolean isAMexFile(String string) {
        return FileView.isWinMexFile(string) || FileView.isSol2MexFile(string) || FileView.isLinuxMexFile(string) || FileView.isSgiMexFile(string) || FileView.isAlphaMexFile(string) || FileView.isAixMexFile(string) || FileView.isHpMexFile(string);
    }

    private String getFileType(File file) {
        String string = file.getName();
        String string2 = "";
        if (file.isDirectory()) {
            string2 = sRes.getString("ftype.Folder");
        } else if (FileView.isMFile(string)) {
            string2 = sRes.getString("ftype.Mfile");
        } else if (FileView.isMatFile(string)) {
            string2 = sRes.getString("ftype.MATfile");
        } else if (FileView.isMdlFile(string)) {
            string2 = sRes.getString("ftype.SimulinkModel");
        } else if (FileView.isFigFile(string)) {
            string2 = sRes.getString("ftype.Figurefile");
        } else if (FileView.isPFile(string)) {
            string2 = sRes.getString("ftype.Pfile");
        } else if (FileView.isStateflowFile(string)) {
            string2 = sRes.getString("ftype.CDRfile");
        } else if (FileView.isRtwFile(string)) {
            string2 = sRes.getString("ftype.RTWfile");
        } else if (FileView.isTmfFile(string)) {
            string2 = sRes.getString("ftype.TMFfile");
        } else if (FileView.isTlcFile(string)) {
            string2 = sRes.getString("ftype.TLCfile");
        } else if (FileView.isCFile(string)) {
            string2 = sRes.getString("ftype.Cfile");
        } else if (FileView.isHFile(string)) {
            string2 = sRes.getString("ftype.Hfile");
        } else if (FileView.isAdbFile(string)) {
            string2 = sRes.getString("ftype.ADBfile");
        } else if (FileView.isAdsFile(string)) {
            string2 = sRes.getString("ftype.ADSfile");
        } else if (FileView.isAMexFile(string)) {
            string2 = FileView.getMexFileTypeString(string);
        }
        return string2;
    }

    private String[] getFileInfo(String string, String string2) {
        String string3;
        String[] stringArray = new String[4];
        stringArray[0] = string2;
        stringArray[1] = this.getFileType(new File(string, string2));
        stringArray[2] = this.getDateAndTimeOfFile(new File(string, string2));
        stringArray[3] = this.fShowHelp ? ((string3 = FileView.getH1Line(String.valueOf(string) + fSeparator + stringArray[0])) != null ? string3 : "") : "";
        return stringArray;
    }

    private void addFileToView(int n, String string, String string2, Image image, boolean bl) {
        Object[] objectArray = this.getFileInfo(string, string2);
        if (bl) {
            this.fFileList.addItem(objectArray);
            this.fFileList.setCellData(this.fFileList.getItemCount() - 1, 0, (Object)new LabeledImageResource(image, (String)objectArray[0]));
            return;
        }
        this.fFileList.setCellData(this.fNextID, 0, (Object)new LabeledImageResource(image, (String)objectArray[0]));
        this.fFileList.setCellData(this.fNextID, 1, objectArray[1]);
        this.fFileList.setCellData(this.fNextID, 2, objectArray[2]);
        this.fFileList.setCellData(this.fNextID++, 3, objectArray[3]);
    }

    protected String getDateAndTimeOfFile(File file) {
        String string = "";
        String string2 = file.getAbsolutePath();
        string = NativeJava.getFileTimestamp((String)string2);
        if (string.equals("")) {
            long l = file.lastModified();
            Date date = new Date(l);
            Locale locale = new Locale("en", "US");
            DateFormat dateFormat = DateFormat.getDateInstance(1, locale);
            String string3 = dateFormat.format(date);
            String string4 = string3.substring(string3.length() - 4);
            DateFormat dateFormat2 = DateFormat.getDateInstance(2, locale);
            dateFormat2.setTimeZone(TimeZone.getDefault());
            String string5 = dateFormat2.format(date);
            string5 = String.valueOf(string5.substring(0, 7)) + string4;
            dateFormat2 = DateFormat.getTimeInstance(3);
            dateFormat2.setTimeZone(TimeZone.getDefault());
            String string6 = dateFormat2.format(date);
            if (string6.length() == 7) {
                string6 = " " + string6;
            }
            string = String.valueOf(string5) + " " + string6;
        }
        return string;
    }

    public Image getFileIcon(File file) {
        String string = file.getName();
        if (file.isDirectory()) {
            return this.fFilePic[10];
        }
        if (FileView.isMFile(string) || FileView.isStateflowFile(string)) {
            return this.fFilePic[12];
        }
        if (FileView.isMatFile(string)) {
            return this.fFilePic[4];
        }
        if (FileView.isPFile(string)) {
            return this.fFilePic[6];
        }
        if (FileView.isMdlFile(string)) {
            return this.fFilePic[7];
        }
        if (FileView.isTlcFile(string)) {
            return this.fFilePic[8];
        }
        if (FileView.isHtmlFile(string)) {
            return this.fFilePic[14];
        }
        if (FileView.isFigFile(string)) {
            return this.fMatlabIcon;
        }
        if (FileView.isAMexFile(string)) {
            return this.fFilePic[5];
        }
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        if (string.endsWith(".gif") || string.endsWith(".cur") || string.endsWith(".hdf") || string.endsWith(".ico") || string.endsWith(".jpg") || string.endsWith(".jpeg") || string.endsWith(".mat") || string.endsWith(".avi") || string.endsWith(".png") || string.endsWith(".au") || string.endsWith(".snd") || string.endsWith(".wav") || string.endsWith(".csv") || string.endsWith(".xls") || string.endsWith(".wk1") || string.endsWith(".tif") || string.endsWith(".tiff") || string.endsWith(".txt") || string.endsWith(".dat") || string.endsWith(".dlm") || string.endsWith(".tab") || string.endsWith(".bmp") || string.endsWith(".pcx")) {
            return this.fFilePic[15];
        }
        return this.fFilePic[2];
    }

    public static String xlate(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            if (cArray[n] == '%' && n < cArray.length - 2 && cArray[n + 1] == '2' && cArray[n + 2] == '0') {
                cArray[n2++] = 32;
                n += 2;
            } else {
                cArray[n2++] = cArray[n];
            }
            ++n;
        }
        return String.valueOf(cArray, 0, n2);
    }

    public void openSelectedFiles() {
        int[] nArray = this.fFileList.getSelectedIndexes();
        String string = this.getCurrentDirectoryName();
        if (nArray.length > 0) {
            boolean bl = false;
            ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
            String[] stringArray = new String[2];
            boolean bl2 = true;
            int n = 0;
            while (n < nArray.length) {
                String string2 = this.fFileList.getItem(nArray[n]);
                if (!string.endsWith(fSeparator)) {
                    string = String.valueOf(string) + fSeparator;
                }
                stringArray[0] = StringUtils.fromJavaPath((String)(String.valueOf(string) + string2));
                stringArray[1] = "1";
                File file = new File(stringArray[0]);
                if (this.fileExists(string2)) {
                    Object object;
                    if (file.isFile() && this.fMatlab != null) {
                        object = "uiopen('" + StringUtils.quoteSingleQuotes((String)stringArray[0]) + "',1)";
                        if (n < nArray.length - 1) {
                            this.fMatlab.evalConsoleOutput((String)object);
                        } else {
                            this.fMatlab.evalConsoleOutput((String)object, (CompletionObserver)new EvalObserver());
                            bl = true;
                        }
                    }
                    if (file.isDirectory() && nArray.length == 1 && bl2) {
                        object = file.list();
                        if (object == null) {
                            new MWAlert(this.getFrame(), sRes.getString("CurrentDirectory"), sRes.getString("error.CannotChangetoDirectory"), 1);
                        } else if (this.fMatlab != null) {
                            this.fMatlab.evalConsoleOutput("cd('" + StringUtils.quoteSingleQuotes((String)stringArray[0]) + "')");
                        }
                        ((Component)((Object)this)).setCursor(Cursor.getDefaultCursor());
                        bl = true;
                    }
                }
                bl2 = false;
                ++n;
            }
            if (!bl) {
                ((Component)((Object)this)).setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private boolean fileExists(String string) {
        boolean bl = true;
        String string2 = StringUtils.fromJavaPath((String)(String.valueOf(this.getCurrentDirectoryName()) + "/" + string));
        File file = new File(string2);
        if (!file.exists()) {
            Object[] objectArray = new Object[]{string2};
            new MWAlert(this.getFrame(), sRes.getString("CurrentDirectory"), MessageFormat.format(sRes.getString("error.FileOrFolderDoesNotExist"), objectArray), 1);
            bl = false;
            this.refreshDirectory(false);
        }
        return bl;
    }

    public void goUpDir() {
        this.fMatlab.evalConsoleOutput("cd ..");
    }

    private void updateCommentBlock() {
        if (this.fShowCommentBlock) {
            int n = this.fFileList.getSelectedIndex();
            if (n != -2) {
                String string = StringUtils.getLocalizedFilename((String)(String.valueOf(this.getCurrentDirectoryName()) + fSeparator + this.fFileList.getItem(n)));
                this.fCommentDisplay.setText(this.getCommentBlock(string));
            } else {
                this.fCommentDisplay.setText(sRes.getString("msg.SelecttoDisplay"));
            }
            this.fCommentDisplay.setSel(0, 0);
        }
    }

    private void enableCommands() {
        if (this.fCenter == null) {
            return;
        }
        int[] nArray = this.fFileList.getSelectedIndexes();
        String string = this.fFileList.getItem(this.fFileList.getSelectedIndex());
        File file = new File(this.getCurrentDirectoryName());
        boolean bl = file.canWrite();
        this.fNewMenu.setEnabled(bl);
        this.fCenter.setCommandEnabled(-101, bl);
        this.fCenter.setCommandEnabled(15, bl);
        if (this.fCwdDisplayPanel.getCwdDisplay().hasFocus()) {
            this.fCenter.setCommandEnabled(920, this.fCwdDisplayPanel.getCwdDisplay().canPaste());
        } else if (this.fLastFocusOwner == this.fFileList) {
            this.fCenter.setCommandEnabled(920, bl && this.fFileClipboard.size() > 0);
        }
        this.fCenter.setCommandEnabled(17, this.fSimulinkInstalled & bl);
        if (nArray.length == 0 || string == null) {
            this.fCenter.setCommandEnabled(140, false);
            this.fCenter.setCommandEnabled(16, false);
            if (this.fLastFocusOwner == this.fFileList) {
                this.fCenter.setCommandEnabled(900, false);
                this.fCenter.setCommandEnabled(910, false);
            }
            this.fCenter.setCommandEnabled(13, false);
            this.fCenter.setCommandEnabled(1070, false);
            this.fCenter.setCommandEnabled(10, false);
            this.fCenter.setCommandEnabled(11, false);
            this.fCenter.setCommandEnabled(14, false);
            this.fCenter.setCommandEnabled(31, false);
            this.fCenter.setCommandEnabled(32, false);
            return;
        }
        this.fCenter.setCommandEnabled(140, true);
        this.fCenter.setCommandEnabled(16, true);
        if (this.fLastFocusOwner == this.fFileList) {
            this.fCenter.setCommandEnabled(910, true);
        }
        this.fCenter.setCommandEnabled(13, false);
        if (bl) {
            if (this.fLastFocusOwner == this.fFileList) {
                this.fCenter.setCommandEnabled(900, true);
            }
            this.fCenter.setCommandEnabled(1070, true);
        }
        File file2 = new File(this.getCurrentDirectoryName(), string);
        if (nArray.length == 1) {
            if (bl) {
                this.fCenter.setCommandEnabled(13, true);
            }
            if (file2.isDirectory() && this.fLastFocusOwner == this.fFileList) {
                this.fCenter.setCommandEnabled(910, false);
            }
        }
        if (nArray.length == 1 && !file2.isDirectory() && FileView.isMatlabRunnableFile(string)) {
            this.fCenter.setCommandEnabled(10, true);
        } else {
            this.fCenter.setCommandEnabled(10, false);
        }
        if (nArray.length == 1 && !file2.isDirectory() && FileView.isMFile(string)) {
            this.fCenter.setCommandEnabled(14, true);
        } else {
            this.fCenter.setCommandEnabled(14, false);
        }
        if (nArray.length == 1 && !file2.isDirectory()) {
            this.fCenter.setCommandEnabled(11, true);
        } else {
            this.fCenter.setCommandEnabled(11, false);
        }
        boolean bl2 = false;
        int n = 0;
        while (n < nArray.length) {
            String string2 = StringUtils.fromJavaPath((String)(String.valueOf(this.getCurrentDirectoryName()) + "/" + this.fFileList.getItem(nArray[n])));
            File file3 = new File(string2);
            if (file3.isDirectory()) {
                bl2 = true;
            }
            ++n;
        }
        if (bl2) {
            this.fCenter.setCommandEnabled(31, true);
            this.fCenter.setCommandEnabled(32, true);
            return;
        }
        this.fCenter.setCommandEnabled(31, false);
        this.fCenter.setCommandEnabled(32, false);
    }

    public void setColumnHeaders() {
        String[] stringArray;
        String string = "";
        if (this.fShowAllFiles) {
            string = sRes.getString("header.Allfiles");
        } else if (this.fShowMatlabFiles) {
            string = sRes.getString("header.MATLABFiles");
        } else {
            stringArray = sRes.getString("ListSeparator");
            boolean bl = true;
            if (this.fShowMFiles) {
                string = "M";
                bl = false;
            }
            if (this.fShowMatFiles) {
                if (!bl) {
                    string = String.valueOf(string) + (String)stringArray;
                }
                string = String.valueOf(string) + "MAT";
                bl = false;
            }
            if (this.fShowMexFiles) {
                if (!bl) {
                    string = String.valueOf(string) + (String)stringArray;
                }
                string = String.valueOf(string) + "MEX";
                bl = false;
            }
            if (this.fShowFigFiles) {
                if (!bl) {
                    string = String.valueOf(string) + (String)stringArray;
                }
                string = String.valueOf(string) + "FIG";
                bl = false;
            }
            if (this.fShowPFiles) {
                if (!bl) {
                    string = String.valueOf(string) + (String)stringArray;
                }
                string = String.valueOf(string) + "P";
                bl = false;
            }
            if (this.fShowMdlFiles) {
                if (!bl) {
                    string = String.valueOf(string) + (String)stringArray;
                }
                string = String.valueOf(string) + "MDL";
                bl = false;
            }
            if (this.fShowStateflowFiles) {
                if (!bl) {
                    string = String.valueOf(string) + (String)stringArray;
                }
                string = String.valueOf(string) + "CDR";
                bl = false;
            }
            if (this.fShowRealtimeFiles) {
                if (!bl) {
                    string = String.valueOf(string) + (String)stringArray;
                }
                string = String.valueOf(string) + "RTW";
                string = String.valueOf(string) + (String)stringArray;
                string = String.valueOf(string) + "TMF";
                string = String.valueOf(string) + (String)stringArray;
                string = String.valueOf(string) + "TLC";
                string = String.valueOf(string) + (String)stringArray;
                string = String.valueOf(string) + "C";
                string = String.valueOf(string) + (String)stringArray;
                string = String.valueOf(string) + "H";
                string = String.valueOf(string) + (String)stringArray;
                string = String.valueOf(string) + "ADB";
                string = String.valueOf(string) + (String)stringArray;
                string = String.valueOf(string) + "ADS";
                bl = false;
            }
            if (!bl) {
                string = String.valueOf(string) + " ";
            }
            string = String.valueOf(string) + sRes.getString("AfterListofTypes");
        }
        stringArray = new String[]{string, sRes.getString("header.FileType"), sRes.getString("header.LastModified"), sRes.getString("header.Description")};
        this.fFileList.setHeaders(stringArray);
    }

    public int getFileFilter() {
        int n = 0;
        if (this.fShowMFiles) {
            n |= 1;
        }
        if (this.fShowMatFiles) {
            n |= 4;
        }
        if (this.fShowMexFiles) {
            n |= 2;
        }
        if (this.fShowMdlFiles) {
            n |= 8;
        }
        if (this.fShowFigFiles) {
            n |= 0x400;
        }
        if (this.fShowPFiles) {
            n |= 0x800;
        }
        if (this.fShowStateflowFiles) {
            n |= 0x2000;
        }
        if (this.fShowRealtimeFiles) {
            n |= 0x4000;
        }
        if (this.fShowMatlabFiles) {
            n |= 0x1000;
        }
        if (this.fShowAllFiles) {
            n |= 0x10;
        }
        if (this.fShowDirectories) {
            n |= 0x20;
        }
        return n;
    }

    public void refreshDirectory(boolean bl) {
        if (!this.fDoNotRefresh) {
            if (bl) {
                this.updateNewDirectory(this.getCurrentDirectoryName());
                return;
            }
            QSortAlgorithm qSortAlgorithm = new QSortAlgorithm();
            String string = this.getCurrentDirectory();
            File file = new File(string);
            String[] stringArray = file.list();
            if (stringArray == null) {
                System.out.println(sRes.getString("msg.FileIsNull"));
                return;
            }
            if (PlatformInfo.getPlatform() != 0) {
                qSortAlgorithm.sort(stringArray);
            }
            int n = 0;
            while (n < this.fFileList.getItemCount()) {
                File file2 = new File(string, this.fFileList.getItem(n));
                if (!file2.exists()) {
                    this.fFileList.removeItem(n--);
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                File file3 = new File(string, stringArray[n2]);
                String string2 = FileView.xlate(stringArray[n2]);
                if (this.shouldAddFile(string2)) {
                    boolean bl2 = true;
                    int n3 = 0;
                    while (n3 < this.fFileList.getItemCount()) {
                        if (string2.equals(this.fFileList.getItem(n3))) {
                            bl2 = false;
                            break;
                        }
                        ++n3;
                    }
                    if (bl2) {
                        this.addFileToView(-2, string, string2, this.getFileIcon(file3), true);
                    }
                }
                ++n2;
            }
            return;
        }
        this.fDoNotRefresh = false;
    }

    public void toggleShowCommentBlock() {
        this.showCommentBlock(!this.fShowCommentBlock);
    }

    public void toggleShowMFiles() {
        this.fShowMFiles = !this.fShowMFiles;
        this.fShowMFilesMenuItem.setState(this.fShowMFiles);
        this.updateInfo();
    }

    public void toggleShowMatFiles() {
        this.fShowMatFiles = !this.fShowMatFiles;
        this.fShowMatFilesMenuItem.setState(this.fShowMatFiles);
        this.updateInfo();
    }

    public void toggleShowMexFiles() {
        this.fShowMexFiles = !this.fShowMexFiles;
        this.fShowMexFilesMenuItem.setState(this.fShowMexFiles);
        this.updateInfo();
    }

    public void toggleShowMdlFiles() {
        this.fShowMdlFiles = !this.fShowMdlFiles;
        this.fShowMdlFilesMenuItem.setState(this.fShowMdlFiles);
        this.updateInfo();
    }

    public void toggleShowFigFiles() {
        this.fShowFigFiles = !this.fShowFigFiles;
        this.fShowFigFilesMenuItem.setState(this.fShowFigFiles);
        this.updateInfo();
    }

    public void toggleShowPFiles() {
        this.fShowPFiles = !this.fShowPFiles;
        this.fShowPFilesMenuItem.setState(this.fShowPFiles);
        this.updateInfo();
    }

    public void toggleShowStateflowFiles() {
        this.fShowStateflowFiles = !this.fShowStateflowFiles;
        this.fShowStateflowFilesMenuItem.setState(this.fShowStateflowFiles);
        this.updateInfo();
    }

    public void toggleShowRealtimeFiles() {
        this.fShowRealtimeFiles = !this.fShowRealtimeFiles;
        this.fShowRealtimeFilesMenuItem.setState(this.fShowRealtimeFiles);
        this.updateInfo();
    }

    public void toggleShowMatlabFiles() {
        this.fShowMatlabFiles = !this.fShowMatlabFiles;
        this.fShowMatlabFilesMenuItem.setState(this.fShowMatlabFiles);
        this.updateInfo();
    }

    public void toggleShowAllFiles() {
        this.fShowAllFiles = !this.fShowAllFiles;
        this.fShowAllFilesMenuItem.setState(this.fShowAllFiles);
        this.updateInfo();
    }

    public void toggleShowDirectories() {
        this.fShowDirectories = !this.fShowDirectories;
        this.fShowDirectoriesMenuItem.setState(this.fShowDirectories);
        this.updateInfo();
    }

    private void updateInfo() {
        this.setColumnHeaders();
        this.updateNewDirectory(this.getCurrentDirectoryName());
    }

    public boolean getShowMFiles() {
        return this.fShowMFiles;
    }

    public boolean getShowMatFiles() {
        return this.fShowMatFiles;
    }

    public boolean getShowMdlFiles() {
        return this.fShowMdlFiles;
    }

    public boolean getShowMexFiles() {
        return this.fShowMexFiles;
    }

    public boolean getShowFigFiles() {
        return this.fShowFigFiles;
    }

    public boolean getShowPFiles() {
        return this.fShowPFiles;
    }

    public boolean getShowStateflowFiles() {
        return this.fShowStateflowFiles;
    }

    public boolean getShowRealtimeFiles() {
        return this.fShowRealtimeFiles;
    }

    public boolean getShowMatlabFiles() {
        return this.fShowMatlabFiles;
    }

    public boolean getShowAllFiles() {
        return this.fShowAllFiles;
    }

    public boolean getShowDirectories() {
        return this.fShowDirectories;
    }

    public void createFileViewFrame(String string) {
        MWFrame mWFrame = new MWFrame(sRes.getString("CurrentDirectory"));
        mWFrame.add((Component)((Object)this), "Center");
        mWFrame.addWindowListener((WindowListener)((Object)new FileViewWindowAdapter((Component)((Object)this))));
        mWFrame.setLocation(20, 40);
        mWFrame.setSize(600, 400);
        mWFrame.setVisible(true);
        ((Component)((Object)this)).setVisible(true);
        if (string != null) {
            this.setPathName(string);
        }
    }

    public static void invoke(String string) {
        if (sFileView == null) {
            FileView fileView = new FileView();
            fileView.createFileViewFrame(string);
            return;
        }
        sFileView.setPathName(string);
    }

    public static void invoke() {
        FileView.invoke(null);
    }

    private static boolean isMFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".m");
    }

    private static boolean isMatFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".mat");
    }

    private static boolean isPFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".p");
    }

    private static boolean isMdlFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".mdl");
    }

    private static boolean isFigFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".fig");
    }

    private static boolean isStateflowFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".cdr");
    }

    private static boolean isHtmlFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".html");
    }

    private static boolean isRtwFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".rtw");
    }

    private static boolean isTmfFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".tmf");
    }

    private static boolean isTlcFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".tlc");
    }

    private static boolean isCFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".c");
    }

    private static boolean isHFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".h");
    }

    private static boolean isAdbFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".adb");
    }

    private static boolean isAdsFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".ads");
    }

    private static boolean isRealtimeMatlabFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".rtw") || string.endsWith(".tmf") || string.endsWith(".tlc");
    }

    private static boolean isRealtimeExternalFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".c") || string.endsWith(".h") || string.endsWith(".adb") || string.endsWith(".ads");
    }

    private static boolean isMatlabRunnableFile(String string) {
        return FileView.isMFile(string) || FileView.isPFile(string) || FileView.isANativeMexFile(string);
    }

    private static boolean isWinMexFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".dll");
    }

    private static boolean isSol2MexFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".mexsol");
    }

    private static boolean isLinuxMexFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".mexglx");
    }

    private static boolean isSgiMexFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".mexsg") || string.endsWith(".mexsg64");
    }

    private static boolean isAlphaMexFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".mexaxp");
    }

    private static boolean isAixMexFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".mexrs6");
    }

    private static boolean isHpMexFile(String string) {
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase();
        }
        return string.endsWith(".mexhp7");
    }

    public static void main(String[] stringArray) {
        FileView.invoke();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ boolean access$0(FileView fileView) {
        return fileView.fStopRequested;
    }

    static /* synthetic */ boolean access$9(FileView fileView) {
        return fileView.fDoNotRefresh;
    }

    static /* synthetic */ int access$16() {
        return 2;
    }

    static /* synthetic */ String access$17(FileView fileView) {
        return fileView.fCurrentMatlabDirectory;
    }

    static /* synthetic */ boolean access$26(FileView fileView) {
        return fileView.fSimulinkInstalled;
    }

    static /* synthetic */ Component access$29(FileView fileView) {
        return fileView.fLastFocusOwner;
    }

    private class FileListMouseAdapter
    extends MouseAdapter {
        private int fX;
        private int fY;

        public void mousePressed(MouseEvent mouseEvent) {
            this.fX = mouseEvent.getX();
            this.fY = mouseEvent.getY();
            if (PlatformInfo.isUnix()) {
                this.doContextMenuStuff(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (PlatformInfo.isWindows()) {
                this.doContextMenuStuff(mouseEvent);
            }
            if (!mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 1) {
                Point point = FileView.this.fFileList.findCell(mouseEvent.getX(), mouseEvent.getY());
                if (point.y == -1 && mouseEvent.getX() == this.fX && mouseEvent.getY() == this.fY) {
                    FileView.this.waitForLoadingThreadToStop(false);
                    if (point.x == 0) {
                        FileView.this.sortByColumn(0);
                        return;
                    }
                    if ((FileView.this.fCurrentKeyColumn != 0 || FileView.this.fSortedInReverse) && FileView.this.fCurrentKeyColumn != point.x) {
                        FileView.this.sortByColumn(0);
                    }
                    FileView.this.sortByColumn(point.x);
                }
            }
        }

        public void doContextMenuStuff(MouseEvent mouseEvent) {
            Point point = FileView.this.fFileList.findCell(mouseEvent.getX(), mouseEvent.getY());
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getModifiers() == 16) {
                if (point.y != -1) {
                    FileView.this.openSelectedFiles();
                    return;
                }
            } else if (mouseEvent.isPopupTrigger()) {
                if (point.y == -1) {
                    FileView.this.addFilterMenus(FileView.this.fFilterPopupMenu);
                    FileView.this.fFilterPopupMenu.show((Component)FileView.this.fFileList, mouseEvent.getX(), mouseEvent.getY());
                    return;
                }
                FileView.this.addFilterMenus(FileView.this.fFilterSubmenu);
                FileView.this.fFilePopupMenu.show((Component)FileView.this.fFileList, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        FileListMouseAdapter() {
            FileView.this = FileView.this;
        }
    }

    class LoadNewDirectoryThread
    extends Thread {
        private String fNewDir;
        private String fFileToSelect;

        LoadNewDirectoryThread(String string, String string2) {
            FileView.this = FileView.this;
            this.fNewDir = string;
            this.fFileToSelect = string2;
            FileView.this.fStopRequested = false;
        }

        public void run() {
            FileView.this.updateNewDirectory(this.fNewDir, this.fFileToSelect);
            if (FileView.this.fCommentDisplay != null) {
                FileView.this.updateCommentBlock();
            }
            FileView.this.fStopRequested = false;
        }
    }

    private static class MyToolbarLayout
    implements LayoutManager {
        private static final int LEFT_MARGIN = 5;
        private static final int RIGHT_MARGIN = 3;
        private static final int DIVIDER_MARGIN = 4;
        private int fMargin;

        MyToolbarLayout(int n) {
            this.fMargin = n;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Serializable serializable;
            Dimension dimension = new Dimension(5, 0);
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                serializable = container.getComponent(n2);
                Dimension dimension2 = ((Component)serializable).getPreferredSize();
                dimension.width += dimension2.width;
                dimension.height = Math.max(dimension.height, dimension2.height);
                ++n2;
            }
            serializable = container.getInsets();
            dimension.width += ((Insets)serializable).left + ((Insets)serializable).right;
            dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom + this.fMargin;
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            Serializable serializable;
            Dimension dimension = new Dimension(5, 0);
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                serializable = container.getComponent(n2);
                Dimension dimension2 = ((Component)serializable).getMinimumSize();
                dimension.width += dimension2.width;
                dimension.height = Math.max(dimension.height, dimension2.height);
                ++n2;
            }
            serializable = container.getInsets();
            dimension.width += ((Insets)serializable).left + ((Insets)serializable).right;
            dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom + this.fMargin;
            return dimension;
        }

        public void layoutContainer(Container container) {
            int n = container.getComponentCount();
            Insets insets = container.getInsets();
            Dimension dimension = container.getSize();
            int n2 = 5;
            int n3 = 0;
            while (n3 < n) {
                Component component = container.getComponent(n3);
                Dimension dimension2 = component.getPreferredSize();
                n2 += dimension2.width;
                ++n3;
            }
            int n4 = dimension.width - insets.right - 3;
            if (n2 < dimension.width) {
                n4 = n2;
            }
            int n5 = dimension.height - insets.top - insets.bottom;
            int n6 = n - 1;
            while (n6 >= 0) {
                Component component = container.getComponent(n6);
                Dimension dimension3 = component.getPreferredSize();
                if (component instanceof MWToolbarSpacer) {
                    dimension3.height = dimension.height - 4;
                }
                int n7 = insets.top + (n5 - dimension3.height) / 2;
                int n8 = n4 - dimension3.width;
                int n9 = dimension3.width;
                if (n8 < 5) {
                    n9 = dimension3.width + n8 - 5;
                    n8 = 5;
                }
                component.setBounds(n8, n7, n9, dimension3.height);
                n4 -= dimension3.width;
                --n6;
            }
        }
    }

    private class FileViewValueListener
    extends TableAdapter {
        public void editCommitted(TableEvent tableEvent) {
            int n = tableEvent.getRow();
            String string = FileView.this.fFileList.getItem(n);
            String string2 = FileView.this.getCurrentDirectoryName();
            File file = new File(string2, string);
            String string3 = String.valueOf(string2) + fSeparator + file.getName();
            if (FileView.this.fCurrentEditOperation == 13 && FileView.this.fCurrentFilename.equals(string)) {
                FileView.this.fFileList.setEditable(false);
                return;
            }
            if (!file.exists()) {
                if (FileView.this.fCurrentEditOperation == -101 || FileView.this.fCurrentEditOperation == 17) {
                    String string4 = "";
                    BufferedWriter bufferedWriter = null;
                    try {
                        bufferedWriter = new BufferedWriter(new FileWriter(string3));
                        if (bufferedWriter != null) {
                            String string5;
                            if (FileView.isMFile(string3)) {
                                string5 = string.substring(0, string.length() - 2);
                                bufferedWriter.write("function [ output_args ] = " + string5 + "( input_args )\n");
                                string4 = String.valueOf(string5.toUpperCase()) + " " + sRes.getString("newm.SummaryHere");
                                bufferedWriter.write("%" + string4 + "\n");
                                bufferedWriter.write("%  " + sRes.getString("newm.DetailsHere") + "\n");
                            }
                            bufferedWriter.close();
                            if (FileView.isMdlFile(string3)) {
                                string5 = file.getName();
                                string5 = string5.substring(0, string5.length() - 4);
                                FileView.this.fDoNotRefresh = true;
                                FileView.this.fMatlab.evalConsoleOutput("save_system(new_system('" + StringUtils.quoteSingleQuotes((String)string5) + "'))");
                            }
                        }
                        FileView.this.fFileList.setCellData(n, 0, (Object)new LabeledImageResource(FileView.this.getFileIcon(file), file.getName()));
                        FileView.this.fFileList.setCellData(n, 1, (Object)FileView.this.getFileType(file));
                        FileView.this.fFileList.setCellData(n, 2, (Object)FileView.this.getDateAndTimeOfFile(file));
                        FileView.this.fFileList.setCellData(n, 3, (Object)string4);
                    }
                    catch (IOException iOException) {
                        FileView.this.displayNoWritePermissionDialog();
                        FileView.this.fFileList.removeItem(FileView.this.fFileList.getItemCount() - 1);
                    }
                    FileView.this.fFileList.setSelectedIndex(n);
                } else if (FileView.this.fCurrentEditOperation == 13) {
                    File file2 = new File(string2, FileView.this.fCurrentFilename);
                    boolean bl = file2.renameTo(file);
                    if (!bl) {
                        FileView.this.displayNoWritePermissionDialog();
                        FileView.this.fFileList.setCellData(n, 0, (Object)new LabeledImageResource(FileView.this.getFileIcon(file2), file2.getName()));
                    } else {
                        FileView.this.fFileList.setCellData(n, 0, (Object)new LabeledImageResource(FileView.this.getFileIcon(file), file.getName()));
                        FileView.this.fFileList.setCellData(n, 1, (Object)FileView.this.getFileType(file));
                    }
                } else if (FileView.this.fCurrentEditOperation == 15) {
                    boolean bl = file.mkdir();
                    if (!bl) {
                        FileView.this.displayNoWritePermissionDialog();
                        FileView.this.fFileList.removeItem(FileView.this.fFileList.getItemCount() - 1);
                    } else {
                        FileView.this.fFileList.setCellData(n, 1, (Object)FileView.this.getFileType(file));
                        FileView.this.fFileList.setCellData(n, 2, (Object)FileView.this.getDateAndTimeOfFile(file));
                    }
                }
                FileView.this.fFileList.setEditable(false);
                return;
            }
            new MWAlert(FileView.this.getFrame(), sRes.getString("CurrentDirectory"), sRes.getString("error.FileAlreadyExists"), 1);
            if (FileView.this.fCurrentEditOperation != 13) {
                FileView.this.renameItem(n);
                return;
            }
            FileView.this.fFileList.setCellData(n, 0, (Object)new LabeledImageResource(FileView.this.getFileIcon(new File(FileView.this.fCurrentFilename)), FileView.this.fCurrentFilename));
        }

        public void editCancelled(TableEvent tableEvent) {
            int n = tableEvent.getRow();
            String string = FileView.this.fFileList.getItem(n);
            String string2 = FileView.this.getCurrentDirectoryName();
            File file = new File(string2, string);
            if (FileView.this.fCurrentEditOperation != 13 && !file.exists()) {
                FileView.this.fFileList.removeItem(n);
            }
            FileView.this.fFileList.setEditable(false);
        }

        FileViewValueListener() {
            FileView.this = FileView.this;
        }
    }

    class FileViewKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 10) {
                FileView.this.openSelectedFiles();
                return;
            }
            if (n == 8) {
                if (FileView.this.fCenter.getCommandEnabled(5)) {
                    FileView.this.goUpDir();
                    return;
                }
            } else if (n == 127) {
                if (FileView.this.fCenter.getCommandEnabled(1070)) {
                    FileView.this.deleteSelectedFiles();
                    return;
                }
            } else {
                if (n == 70 && keyEvent.getModifiers() == 2) {
                    MWReplaceDialog.invoke(FileView.this.getFrame(), 2, null, "", 0);
                    return;
                }
                char c = keyEvent.getKeyChar();
                if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                    boolean bl = false;
                    int n2 = FileView.this.fFileList.getSelectedIndex();
                    if (n2 == -2) {
                        n2 = FileView.this.fFileList.getItemCount() - 1;
                    }
                    boolean bl2 = false;
                    if (n2 < FileView.this.fFileList.getItemCount()) {
                        int n3 = n2 + 1;
                        if (n3 == FileView.this.fFileList.getItemCount()) {
                            n3 = 0;
                            bl2 = true;
                        }
                        while (!bl) {
                            if (bl2 && n3 == n2) break;
                            if (FileView.this.fFileList.getItem(n3).toLowerCase().charAt(0) == c) {
                                FileView.this.fFileList.scrollToCell(n3, 0);
                                FileView.this.fFileList.setSelectedIndex(n3);
                                bl = true;
                                break;
                            }
                            if (n3 == FileView.this.fFileList.getItemCount() - 1 && !bl2) {
                                n3 = -1;
                                bl2 = true;
                            }
                            ++n3;
                        }
                    }
                    if (!bl) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        }

        FileViewKeyListener() {
            FileView.this = FileView.this;
        }
    }

    class MyItemListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (FileView.this.fCommentDisplay != null) {
                FileView.this.updateCommentBlock();
            }
            FileView.this.enableCommands();
        }

        MyItemListener() {
            FileView.this = FileView.this;
        }
    }

    private class MyMWTextField
    extends MWTextField {
        public MyMWTextField(String string, int n) {
            super(string, n);
            FileView.this = FileView.this;
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.fWidth, this.fHeight);
        }
    }

    private class CwdCallback
    implements CompletionObserver {
        int fReplyType;

        public CwdCallback(int n) {
            FileView.this = FileView.this;
            this.fReplyType = n;
        }

        public void completed(int n, Object object) {
            if (object == null) {
                return;
            }
            if (this.fReplyType == FileView.access$16()) {
                String string = (String)object;
                String string2 = string.trim();
                FileView.this.fCurrentMatlabDirectory = string2;
                if (FileView.this.fAlwaysShowCWD || !FileView.this.fIsInitialPathSet) {
                    FileView.this.setPathName(string2, true);
                    FileView.this.fIsInitialPathSet = true;
                }
            }
        }
    }

    private class WorkspaceCallback
    implements CompletionObserver {
        int fReplyType;

        public WorkspaceCallback(int n) {
            FileView.this = FileView.this;
            this.fReplyType = n;
        }

        public void completed(int n, Object object) {
            MWMessage mWMessage = (MWMessage)object;
            Integer n2 = (Integer)mWMessage.findData("eventid", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = FileView.class$("java.lang.Integer")));
            if (n2 == 0x40000000 && !FileView.this.fDoNotChangeDirectory) {
                FileView.this.setPathToCwd();
                FileView.this.fDoNotChangeDirectory = false;
            }
        }
    }

    private class WhosCallback
    implements CompletionObserver {
        public WhosCallback() {
            FileView.this = FileView.this;
        }

        public void completed(int n, Object object) {
            String string = (String)object;
            String string2 = string.trim();
            FileView.this.fCommentDisplay.setText(string2);
        }
    }

    class FileViewWindowAdapter
    extends MWWindowActivater {
        public FileViewWindowAdapter(Component component) {
            super(component);
            FileView.this = FileView.this;
        }

        public void windowClosing(WindowEvent windowEvent) {
            super.windowClosing(windowEvent);
            sFileView = null;
        }
    }

    public static class StreamCopier {
        public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
            InputStream inputStream2 = inputStream;
            synchronized (inputStream2) {
                OutputStream outputStream2 = outputStream;
                synchronized (outputStream2) {
                    int n;
                    byte[] byArray = new byte[256];
                    while ((n = inputStream.read(byArray)) != -1) {
                        outputStream.write(byArray, 0, n);
                    }
                }
                return;
            }
        }
    }

    private class MyCellText
    extends CellImageResource {
        public MyCellText(Table table) {
            super(table);
            FileView.this = FileView.this;
        }

        public void render(Graphics graphics, int n, int n2, Rectangle rectangle, Object object, Style style, boolean bl) {
            if (n2 == 0 && object != null && object instanceof LabeledImageResource) {
                graphics.setFont(style.getFont());
                String string = ((LabeledImageResource)object).getLabel();
                String string2 = MWUtils.shortenString((String)string, (FontMetrics)graphics.getFontMetrics(), (int)(rectangle.width - style.getMargins().right - 20));
                File file = new File(FileView.this.fPathName, string);
                LabeledImageResource labeledImageResource = new LabeledImageResource(FileView.this.getFileIcon(file), string2);
                object = labeledImageResource;
            }
            super.render(graphics, n, n2, rectangle, object, style, bl);
        }
    }

    private class SimulinkAvailableObserver
    implements CompletionObserver {
        public SimulinkAvailableObserver() {
            FileView.this = FileView.this;
        }

        public void completed(int n, Object object) {
            if (Matlab.getExecutionStatus((int)n) == 0 && object instanceof double[]) {
                double[] dArray = (double[])object;
                boolean bl = dArray.length == 1 && dArray[0] == 5.0;
                FileView.this.fCenter.setCommandEnabled(17, bl);
                FileView.this.fSimulinkInstalled = bl;
            }
        }
    }

    private class EvalObserver
    implements CompletionObserver {
        public EvalObserver() {
            FileView.this = FileView.this;
        }

        public void completed(int n, Object object) {
            ((Component)((Object)FileView.this)).setCursor(Cursor.getDefaultCursor());
        }
    }

    private class CwdFocusListener
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            FileView.this.fLastFocusOwner = (Component)((Object)FileView.this.fCwdDisplayPanel);
            FileView.this.enableCommands();
        }

        public void focusLost(FocusEvent focusEvent) {
            FileView.this.enableCommands();
        }

        CwdFocusListener() {
            FileView.this = FileView.this;
        }
    }

    private class FileViewFocusListener
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            FileView.this.fLastFocusOwner = (Component)FileView.this.fFileList;
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        FileViewFocusListener() {
            FileView.this = FileView.this;
        }
    }
}

