/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.browsers;

import com.mathworks.ide.desktop.DTMenu;
import com.mathworks.ide.desktop.DTMenuBar;
import com.mathworks.ide.desktop.MenuUtils;
import com.mathworks.mwt.MWCheckboxMenuItem;
import com.mathworks.mwt.MWFrameProxy;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWMenuComponent;
import com.mathworks.mwt.command.MWCommandCenter;
import java.util.ResourceBundle;
import java.util.Vector;

public class FileBrowserMenubar {
    private DTMenu fMainFrameFilterMenu;
    private Vector fMainFrameFilterVector;
    private MWMenu fViewMenu;
    private MWMenu fFilterMenu;
    private Vector fFilterVector;
    private MWMenuBar fMenubar;
    private MWCommandCenter fCenter;
    private int fOptions;
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.browsers.resources.RES_CurrentDirectory");
    private static final String FILTER_MENU_NAME = sRes.getString("filter.menuname");

    FileBrowserMenubar(MWFrameProxy mWFrameProxy, MWCommandCenter mWCommandCenter, int n) {
        this.fCenter = mWCommandCenter;
        this.fOptions = n;
        DTMenuBar dTMenuBar = DTMenuBar.createComponentMenubar(mWFrameProxy);
        this.fMenubar = dTMenuBar.getMenubar();
        this.fFilterMenu = new MWMenu(FILTER_MENU_NAME);
        this.fFilterVector = new Vector();
        this.createFilterMenu(this.fFilterVector, this.fFilterMenu);
        this.fMainFrameFilterMenu = new DTMenu(FILTER_MENU_NAME, this.fCenter);
        this.fMainFrameFilterVector = new Vector();
        this.createFilterMenu(this.fMainFrameFilterVector, this.fMainFrameFilterMenu);
        this.fMenubar = this.mergeMenus(this.fMenubar);
        dTMenuBar.autoAddSeparators();
    }

    public MWMenuBar getMenubar() {
        return this.fMenubar;
    }

    public static String getMenuLabel(int n) {
        return FileBrowserMenubar.getMenuLabel(n, true);
    }

    public DTMenu getViewMenu() {
        return this.fMainFrameFilterMenu;
    }

    public static String getMenuLabel(int n, boolean bl) {
        if (bl) {
            switch (n) {
                case 2220: {
                    return sRes.getString("filter.Mfiles");
                }
                case 2221: {
                    return sRes.getString("filter.MEXfiles");
                }
                case 2222: {
                    return sRes.getString("filter.MATfiles");
                }
                case 2225: {
                    return sRes.getString("filter.Models");
                }
                case 2224: {
                    return sRes.getString("filter.Pfiles");
                }
                case 2223: {
                    return sRes.getString("filter.Figurefiles");
                }
                case 2226: {
                    return sRes.getString("filter.StateflowFiles");
                }
                case 2227: {
                    return sRes.getString("filter.RealtimeFiles");
                }
                case 2228: {
                    return sRes.getString("filter.MATLABFiles");
                }
                case 2229: {
                    return sRes.getString("filter.AllFiles");
                }
                case 2230: {
                    return sRes.getString("filter.Folders");
                }
            }
            return "";
        }
        switch (n) {
            case 2220: {
                return sRes.getString("ftype.Mfiles");
            }
            case 2221: {
                return sRes.getString("ftype.MEXfiles");
            }
            case 2222: {
                return sRes.getString("ftype.MATfiles");
            }
            case 2225: {
                return sRes.getString("ftype.SimulinkModels");
            }
            case 2224: {
                return sRes.getString("ftype.Pfiles");
            }
            case 2223: {
                return sRes.getString("ftype.Figurefiles");
            }
            case 2226: {
                return sRes.getString("ftype.StateflowFiles");
            }
            case 2227: {
                return sRes.getString("ftype.RealtimeFiles");
            }
            case 2228: {
                return sRes.getString("ftype.MATLABFiles");
            }
            case 2229: {
                return sRes.getString("ftype.AllFiles");
            }
            case 2230: {
                return sRes.getString("ftype.Folders");
            }
        }
        return "";
    }

    private void createFilterMenu(Vector vector, MWMenu mWMenu) {
        this.addFilterMenuItem(vector, mWMenu, 2220);
        this.addFilterMenuItem(vector, mWMenu, 2222);
        this.addFilterMenuItem(vector, mWMenu, 2221);
        this.addFilterMenuItem(vector, mWMenu, 2223);
        this.addFilterMenuItem(vector, mWMenu, 2224);
        this.addFilterMenuItem(vector, mWMenu, 2225);
        this.addFilterMenuItem(vector, mWMenu, 2226);
        this.addFilterMenuItem(vector, mWMenu, 2227);
        MenuUtils.addMenuItem(this.fCenter, mWMenu, "SEPARATOR", -1, -1);
        this.addFilterMenuItem(vector, mWMenu, 2228);
        this.addFilterMenuItem(vector, mWMenu, 2229);
        MenuUtils.addMenuItem(this.fCenter, mWMenu, "SEPARATOR", -1, -1);
        this.addFilterMenuItem(vector, mWMenu, 2230);
        boolean bl = (this.fOptions & 1) != 0;
        boolean bl2 = (this.fOptions & 4) != 0;
        boolean bl3 = (this.fOptions & 2) != 0;
        boolean bl4 = (this.fOptions & 8) != 0;
        boolean bl5 = (this.fOptions & 0x400) != 0;
        boolean bl6 = (this.fOptions & 0x800) != 0;
        boolean bl7 = (this.fOptions & 0x2000) != 0;
        boolean bl8 = (this.fOptions & 0x4000) != 0;
        boolean bl9 = (this.fOptions & 0x1000) != 0;
        boolean bl10 = (this.fOptions & 0x10) != 0;
        boolean bl11 = (this.fOptions & 0x20) != 0;
        ((MWCheckboxMenuItem)vector.elementAt(0)).setState(bl);
        ((MWCheckboxMenuItem)vector.elementAt(1)).setState(bl2);
        ((MWCheckboxMenuItem)vector.elementAt(2)).setState(bl3);
        ((MWCheckboxMenuItem)vector.elementAt(3)).setState(bl5);
        ((MWCheckboxMenuItem)vector.elementAt(4)).setState(bl6);
        ((MWCheckboxMenuItem)vector.elementAt(5)).setState(bl4);
        ((MWCheckboxMenuItem)vector.elementAt(6)).setState(bl7);
        ((MWCheckboxMenuItem)vector.elementAt(7)).setState(bl8);
        ((MWCheckboxMenuItem)vector.elementAt(8)).setState(bl9);
        ((MWCheckboxMenuItem)vector.elementAt(9)).setState(bl10);
        ((MWCheckboxMenuItem)vector.elementAt(10)).setState(bl11);
        if (bl10 || bl9) {
            this.fCenter.setCommandEnabled(2220, false);
            this.fCenter.setCommandEnabled(2222, false);
            this.fCenter.setCommandEnabled(2221, false);
            this.fCenter.setCommandEnabled(2225, false);
            this.fCenter.setCommandEnabled(2223, false);
            this.fCenter.setCommandEnabled(2224, false);
            this.fCenter.setCommandEnabled(2226, false);
            this.fCenter.setCommandEnabled(2227, false);
            if (bl10) {
                this.fCenter.setCommandEnabled(2228, false);
            }
        }
    }

    private void addFilterMenuItem(Vector vector, MWMenu mWMenu, int n) {
        MWCheckboxMenuItem mWCheckboxMenuItem = MenuUtils.addCheckboxMenuItem(this.fCenter, mWMenu, FileBrowserMenubar.getMenuLabel(n), n);
        vector.addElement(mWCheckboxMenuItem);
    }

    public void setCommandCenter(MWCommandCenter mWCommandCenter) {
        this.fCenter = mWCommandCenter;
    }

    public void setShowMFiles(boolean bl) {
        ((MWCheckboxMenuItem)this.fFilterVector.elementAt(0)).setState(bl);
        if (this.fMainFrameFilterVector != null) {
            ((MWCheckboxMenuItem)this.fMainFrameFilterVector.elementAt(0)).setState(bl);
        }
    }

    public void setShowMatFiles(boolean bl) {
        ((MWCheckboxMenuItem)this.fFilterVector.elementAt(1)).setState(bl);
        if (this.fMainFrameFilterVector != null) {
            ((MWCheckboxMenuItem)this.fMainFrameFilterVector.elementAt(1)).setState(bl);
        }
    }

    public void setShowMexFiles(boolean bl) {
        ((MWCheckboxMenuItem)this.fFilterVector.elementAt(2)).setState(bl);
        if (this.fMainFrameFilterVector != null) {
            ((MWCheckboxMenuItem)this.fMainFrameFilterVector.elementAt(2)).setState(bl);
        }
    }

    public void setShowFigFiles(boolean bl) {
        ((MWCheckboxMenuItem)this.fFilterVector.elementAt(3)).setState(bl);
        if (this.fMainFrameFilterVector != null) {
            ((MWCheckboxMenuItem)this.fMainFrameFilterVector.elementAt(3)).setState(bl);
        }
    }

    public void setShowPFiles(boolean bl) {
        ((MWCheckboxMenuItem)this.fFilterVector.elementAt(4)).setState(bl);
        if (this.fMainFrameFilterVector != null) {
            ((MWCheckboxMenuItem)this.fMainFrameFilterVector.elementAt(4)).setState(bl);
        }
    }

    public void setShowMdlFiles(boolean bl) {
        ((MWCheckboxMenuItem)this.fFilterVector.elementAt(5)).setState(bl);
        if (this.fMainFrameFilterVector != null) {
            ((MWCheckboxMenuItem)this.fMainFrameFilterVector.elementAt(5)).setState(bl);
        }
    }

    public void setShowStateflowFiles(boolean bl) {
        ((MWCheckboxMenuItem)this.fFilterVector.elementAt(6)).setState(bl);
        if (this.fMainFrameFilterVector != null) {
            ((MWCheckboxMenuItem)this.fMainFrameFilterVector.elementAt(6)).setState(bl);
        }
    }

    public void setShowRealtimeFiles(boolean bl) {
        ((MWCheckboxMenuItem)this.fFilterVector.elementAt(7)).setState(bl);
        if (this.fMainFrameFilterVector != null) {
            ((MWCheckboxMenuItem)this.fMainFrameFilterVector.elementAt(7)).setState(bl);
        }
    }

    public void setShowMatlabFiles(boolean bl) {
        ((MWCheckboxMenuItem)this.fFilterVector.elementAt(8)).setState(bl);
        if (this.fMainFrameFilterVector != null) {
            ((MWCheckboxMenuItem)this.fMainFrameFilterVector.elementAt(8)).setState(bl);
        }
    }

    public void setShowAllFiles(boolean bl) {
        ((MWCheckboxMenuItem)this.fFilterVector.elementAt(9)).setState(bl);
        if (this.fMainFrameFilterVector != null) {
            ((MWCheckboxMenuItem)this.fMainFrameFilterVector.elementAt(9)).setState(bl);
        }
    }

    public void setShowDirectories(boolean bl) {
        ((MWCheckboxMenuItem)this.fFilterVector.elementAt(10)).setState(bl);
        if (this.fMainFrameFilterVector != null) {
            ((MWCheckboxMenuItem)this.fMainFrameFilterVector.elementAt(10)).setState(bl);
        }
    }

    public MWMenuBar mergeMenus(MWMenuBar mWMenuBar) {
        boolean bl = false;
        int n = 0;
        while (n < mWMenuBar.getMenuCount()) {
            MWMenu mWMenu = mWMenuBar.getMenu(n);
            if (mWMenu instanceof DTMenu) {
                DTMenu dTMenu = (DTMenu)mWMenu;
                if (dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.Edit")) || dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.EditNoAmpersand"))) {
                    dTMenu.addMenuItem(this.fCenter, 900);
                    dTMenu.addMenuItem(this.fCenter, 910);
                    dTMenu.addMenuItem(this.fCenter, 920);
                    dTMenu.addMenuItem(this.fCenter, 1070);
                    dTMenu.addMenuItem(this.fCenter, 1060);
                } else if (dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.View")) || dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.ViewNoAmpersand"))) {
                    int n2 = 0;
                    while (n2 < dTMenu.getItemCount()) {
                        MWMenuComponent mWMenuComponent = dTMenu.getItem(n2);
                        if (mWMenuComponent.getLabel().equals(FILTER_MENU_NAME) || mWMenuComponent.getLabel().equals(sRes.getString("filter.menuname_noampersand"))) {
                            bl = true;
                        }
                        ++n2;
                    }
                    if (!bl) {
                        dTMenu.add((MWMenuComponent)this.fFilterMenu);
                        bl = true;
                    }
                }
            }
            ++n;
        }
        if (!bl) {
            this.fFilterMenu.setLabel(sRes.getString("filter.menuname_external"));
            mWMenuBar.insert((MWMenuComponent)this.fFilterMenu, 2);
        }
        return mWMenuBar;
    }
}

