/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.browsers;

import com.mathworks.ide.browsers.CurrentDirectoryPrefs;
import com.mathworks.ide.browsers.FileBrowserMenubar;
import com.mathworks.ide.browsers.FileView;
import com.mathworks.ide.desktop.DTApplication;
import com.mathworks.ide.desktop.DTMenu;
import com.mathworks.ide.desktop.MLDesktop;
import com.mathworks.ide.editor.MWReplaceDialog;
import com.mathworks.mwt.MWFrameProxy;
import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ResourceBundle;

public class FileBrowser
extends MWPanel
implements MWCommandTarget,
DTApplication {
    static final String SHOW_FILE_TYPES = "ShowFileTypes";
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.browsers.resources.RES_CurrentDirectory");
    private static FileBrowser sFileBrowser = null;
    private FileView fFileView;
    private boolean fIsVisible = false;
    private int fOptions;
    private Font fFont;
    private int[] fColumnWidth = new int[4];
    private MWCommandCenter fCenter;
    private MWFrameProxy fFrame;
    private FileBrowserMenubar fMenubar;
    private FileBrowserWindowOwner fOwner;
    private static final String sTITLE = sRes.getString("CurrentDirectory");
    public static final int SHOW_M_FILES_OPTION = 1;
    public static final int SHOW_MEX_FILES_OPTION = 2;
    public static final int SHOW_MAT_FILES_OPTION = 4;
    public static final int SHOW_MDL_FILES_OPTION = 8;
    public static final int SHOW_ALL_FILES_OPTION = 16;
    public static final int SHOW_DIRECTORIES_OPTION = 32;
    public static final int SHOW_LAST_MODIFIED_OPTION = 64;
    public static final int SHOW_DESCRIPTIONS_OPTION = 128;
    public static final int SHOW_COMMENT_BLOCK_OPTION = 256;
    public static final int SHOW_FILE_TYPES_OPTION = 512;
    public static final int SHOW_FIG_FILES_OPTION = 1024;
    public static final int SHOW_P_FILES_OPTION = 2048;
    public static final int SHOW_MATLAB_FILES_OPTION = 4096;
    public static final int SHOW_STATEFLOW_FILES_OPTION = 8192;
    public static final int SHOW_REALTIME_FILES_OPTION = 16384;
    public static final int NEW_PROJECT = 1;
    public static final int FINDINFILES = 2;
    public static final int SHOW_FILES = 3;
    public static final int GO_UP_DIR = 5;
    public static final int SHOW_DESCRIPTIONS = 6;
    public static final int SHOW_LAST_MODIFIED = 7;
    public static final int SHOW_COMMENT_BLOCK = 8;
    public static final int REFRESH = 9;
    public static final int RUN_M_FILE = 10;
    public static final int LOAD_FILE = 11;
    public static final int RENAME = 13;
    public static final int VIEW_HELP = 14;
    public static final int NEW_DIRECTORY = 15;
    public static final int EDIT_FILE = 16;
    public static final int NEW_MODEL = 17;
    public static final int OPEN_SEL = 140;
    public static final int SHOW_M_FILES = 2220;
    public static final int SHOW_MEX_FILES = 2221;
    public static final int SHOW_MAT_FILES = 2222;
    public static final int SHOW_FIG_FILES = 2223;
    public static final int SHOW_P_FILES = 2224;
    public static final int SHOW_MDL_FILES = 2225;
    public static final int SHOW_STATEFLOW_FILES = 2226;
    public static final int SHOW_REALTIME_FILES = 2227;
    public static final int SHOW_MATLAB_FILES = 2228;
    public static final int SHOW_ALL_FILES = 2229;
    public static final int SHOW_DIRECTORIES = 2230;
    public static final int ADD_TO_PATH = 30;
    public static final int ADD_SELECTED_TO_PATH = 31;
    public static final int ADD_SELECTED_WITH_SUBFOLDERS_TO_PATH = 32;
    public static final int REMOVE_FROM_PATH = 33;
    public static final int SHOW_CWD = 34;
    public static final int SET_CWD = 35;
    public static final int ALWAYS_SHOW_CWD = 36;

    public FileBrowser() {
        sFileBrowser = this;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        boolean bl = true;
        boolean bl2 = true;
        this.loadPrefs();
        this.fCenter = new MWCommandCenter((MWCommandTarget)this);
        this.fOwner = new FileBrowserWindowOwner();
        this.fFrame = new MWFrameProxy((MWWindowOwner)this.fOwner, sTITLE);
        this.fFrame.setFrameSize(400, 400);
        this.fFrame.setFrameLocation(50, 50);
        this.fMenubar = new FileBrowserMenubar(this.fFrame, this.fCenter, this.fOptions);
        MWMenuBar mWMenuBar = this.fMenubar.getMenubar();
        this.fFrame.setMenuBar(mWMenuBar);
        this.fFrame.add((Component)((Object)this));
        this.fFileView = new FileView(this.fCenter, bl, bl2, this.fOptions, this.fColumnWidth);
        ((Container)((Object)this)).add((Component)((Object)this.fFileView), "Center");
        this.setFont(this.fFont);
        ((Component)((Object)this)).setName("Current Directory");
    }

    public void requestFocus() {
        this.fFileView.requestFocus();
    }

    public MWCommandCenter getCommandCenter() {
        return this.fCenter;
    }

    public static FileBrowser getFileBrowser() {
        return sFileBrowser;
    }

    public Object[] getSelectedFiles() {
        return this.fFileView.getSelectedFiles();
    }

    public String getCurrentDirectory() {
        return this.fFileView.getCurrentDirectory();
    }

    public DTMenu getViewMenu() {
        if (this.fMenubar != null && this.fIsVisible) {
            return this.fMenubar.getViewMenu();
        }
        return null;
    }

    public void addNotify() {
        super.addNotify();
        this.fIsVisible = true;
        MWReplaceDialog mWReplaceDialog = MWReplaceDialog.getReplaceDialog();
        if (mWReplaceDialog != null) {
            mWReplaceDialog.addSearchFilters(2);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.fIsVisible = false;
        MWReplaceDialog mWReplaceDialog = MWReplaceDialog.getReplaceDialog();
        if (mWReplaceDialog != null) {
            mWReplaceDialog.removeSearchFilters(2);
        }
    }

    public void loadPrefs() {
        Integer n;
        if (CurrentDirectoryPrefs.getShowFileTypes()) {
            this.fOptions |= 0x200;
        }
        if (CurrentDirectoryPrefs.getShowLastModified()) {
            this.fOptions |= 0x40;
        }
        if (CurrentDirectoryPrefs.getShowDescriptions()) {
            this.fOptions |= 0x80;
        }
        if (CurrentDirectoryPrefs.getShowCommentBlock()) {
            this.fOptions |= 0x100;
        }
        this.fOptions |= Prefs.getIntegerPref((String)"FileBrowserFilter", (int)48);
        String string = Prefs.getStringPref((String)"FileBrowserColumnWidths", (String)"[150 100 150 400]");
        int n2 = 0;
        int n3 = 1;
        int n4 = 1;
        while (n4 < string.length()) {
            if (string.charAt(n4) == ' ') {
                n = new Integer(string.substring(n3, n4));
                this.fColumnWidth[n2++] = n;
                n3 = n4 + 1;
            }
            ++n4;
        }
        n = new Integer(string.substring(n3, string.length() - 1));
        this.fColumnWidth[n2] = n;
        if (n2 == 2) {
            this.fColumnWidth[3] = this.fColumnWidth[2];
            this.fColumnWidth[2] = this.fColumnWidth[1];
            this.fColumnWidth[1] = 100;
        }
        this.fFont = Prefs.getFontPref((String)"GeneralFont", (Font)new Font("Monospaced", 0, 10));
        PrefsListener prefsListener = new PrefsListener();
        Prefs.addListener((PrefListener)prefsListener, (String)"GeneralFont");
        Prefs.addListener((PrefListener)prefsListener, (String)"FileBrowserShowCommentBlock");
    }

    public void setPrefs() {
        Prefs.setIntegerPref((String)"FileBrowserFilter", (int)this.fFileView.getFileFilter());
        int[] nArray = this.fFileView.getColumnWidths();
        String string = "[" + nArray[0] + " " + nArray[1] + " " + nArray[2] + " " + nArray[3] + "]";
        Prefs.setStringPref((String)"FileBrowserColumnWidths", (String)string);
    }

    private void setPathName(String string) {
        this.fFileView.setPathName(string);
    }

    public boolean isVisible() {
        return this.fIsVisible;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fFileView.setFont(font);
        ((Component)((Object)this)).repaint();
    }

    public void doCommand(int n) {
        boolean bl = true;
        if (this.fCenter.getCommandEnabled(n)) {
            switch (n) {
                case -101: {
                    this.fFileView.createNewMFile();
                    return;
                }
                case 17: {
                    this.fFileView.createNewModel();
                    return;
                }
                case 15: {
                    this.fFileView.createNewDirectory();
                    return;
                }
                case 140: {
                    this.fFileView.openSelectedFiles();
                    return;
                }
                case 900: {
                    this.fFileView.doCut();
                    return;
                }
                case 910: {
                    this.fFileView.doCopy();
                    return;
                }
                case 920: {
                    this.fFileView.doPaste();
                    return;
                }
                case 1070: {
                    this.fFileView.deleteSelectedFiles();
                    return;
                }
                case 1060: {
                    this.fFileView.selectAllFiles();
                    return;
                }
                case 13: {
                    this.fFileView.doRename();
                    return;
                }
                case 10: {
                    this.fFileView.runSelectedMFile();
                    return;
                }
                case 11: {
                    this.fFileView.loadSelectedFile();
                    return;
                }
                case 16: {
                    this.fFileView.editSelectedFile();
                    return;
                }
                case 14: {
                    this.fFileView.viewHelpForSelectedMFile();
                    return;
                }
                case 5: {
                    this.fFileView.goUpDir();
                    return;
                }
                case 8: {
                    this.fFileView.toggleShowCommentBlock();
                    this.setPrefs();
                    return;
                }
                case 9: {
                    this.refreshDirectory(true);
                    return;
                }
                case 2: {
                    MWReplaceDialog.invoke(this.getFrame(), 2, null, "", 0);
                    return;
                }
                case -103: {
                    this.fOwner.closeWindow();
                    return;
                }
                case 2228: {
                    this.fFileView.toggleShowMatlabFiles();
                    boolean bl2 = this.fFileView.getShowMatlabFiles();
                    this.fMenubar.setShowMatlabFiles(bl2);
                    this.enableFileFilters();
                    this.setPrefs();
                    return;
                }
                case 2229: {
                    this.fFileView.toggleShowAllFiles();
                    boolean bl3 = this.fFileView.getShowAllFiles();
                    this.fMenubar.setShowAllFiles(bl3);
                    this.enableFileFilters();
                    this.setPrefs();
                    return;
                }
                case 2220: {
                    this.fFileView.toggleShowMFiles();
                    this.fMenubar.setShowMFiles(this.fFileView.getShowMFiles());
                    this.setPrefs();
                    return;
                }
                case 2222: {
                    this.fFileView.toggleShowMatFiles();
                    this.fMenubar.setShowMatFiles(this.fFileView.getShowMatFiles());
                    this.setPrefs();
                    return;
                }
                case 2221: {
                    this.fFileView.toggleShowMexFiles();
                    this.fMenubar.setShowMexFiles(this.fFileView.getShowMexFiles());
                    this.setPrefs();
                    return;
                }
                case 2225: {
                    this.fFileView.toggleShowMdlFiles();
                    this.fMenubar.setShowMdlFiles(this.fFileView.getShowMdlFiles());
                    this.setPrefs();
                    return;
                }
                case 2223: {
                    this.fFileView.toggleShowFigFiles();
                    this.fMenubar.setShowFigFiles(this.fFileView.getShowFigFiles());
                    this.setPrefs();
                    return;
                }
                case 2224: {
                    this.fFileView.toggleShowPFiles();
                    this.fMenubar.setShowPFiles(this.fFileView.getShowPFiles());
                    this.setPrefs();
                    return;
                }
                case 2226: {
                    this.fFileView.toggleShowStateflowFiles();
                    this.fMenubar.setShowStateflowFiles(this.fFileView.getShowStateflowFiles());
                    this.setPrefs();
                    return;
                }
                case 2227: {
                    this.fFileView.toggleShowRealtimeFiles();
                    this.fMenubar.setShowRealtimeFiles(this.fFileView.getShowRealtimeFiles());
                    this.setPrefs();
                    return;
                }
                case 2230: {
                    this.fFileView.toggleShowDirectories();
                    this.fMenubar.setShowDirectories(this.fFileView.getShowDirectories());
                    this.setPrefs();
                    return;
                }
                case 30: {
                    this.fFileView.addCurrentDirectoryToPath(this.fFrame);
                    return;
                }
                case 31: {
                    this.fFileView.addSelectedFoldersToPath(this.fFrame, false);
                    return;
                }
                case 32: {
                    this.fFileView.addSelectedFoldersToPath(this.fFrame, true);
                    return;
                }
                case 33: {
                    this.fFileView.removeCurrentDirectoryFromPath();
                    return;
                }
                case 35: {
                    this.fFileView.setCWDToDisplayedDirectory();
                    return;
                }
                case 34: {
                    this.fFileView.showCWD();
                    return;
                }
            }
            bl = false;
            return;
        }
    }

    private void enableFileFilters() {
        boolean bl = this.fFileView.getShowAllFiles();
        boolean bl2 = this.fFileView.getShowMatlabFiles();
        this.fCenter.setCommandEnabled(2220, !bl && !bl2);
        this.fCenter.setCommandEnabled(2222, !bl && !bl2);
        this.fCenter.setCommandEnabled(2221, !bl && !bl2);
        this.fCenter.setCommandEnabled(2225, !bl && !bl2);
        this.fCenter.setCommandEnabled(2223, !bl && !bl2);
        this.fCenter.setCommandEnabled(2224, !bl && !bl2);
        this.fCenter.setCommandEnabled(2226, !bl && !bl2);
        this.fCenter.setCommandEnabled(2227, !bl && !bl2);
        this.fCenter.setCommandEnabled(2228, !bl);
    }

    public static void invoke(String string) {
        MLDesktop mLDesktop = MLDesktop.getMLDesktop();
        if (sFileBrowser == null) {
            sFileBrowser = new FileBrowser();
        }
        if (mLDesktop == null) {
            FileBrowser.sFileBrowser.fFrame.setVisible(true);
        } else {
            mLDesktop.showClient(sTITLE);
        }
        if (string != null) {
            sFileBrowser.setPathName(string);
        }
    }

    public static void setDisplayedColumns(boolean bl, boolean bl2, boolean bl3) {
        if (sFileBrowser != null) {
            FileBrowser.sFileBrowser.fFileView.setDisplayedColumns(bl, bl2, bl3);
        }
    }

    public static void refresh() {
        if (sFileBrowser != null) {
            sFileBrowser.refreshDirectory(false);
        }
    }

    public static void refresh(String string) {
        if (sFileBrowser == null || string == null) {
            return;
        }
        if (FileBrowser.sFileBrowser.fFileView.getCurrentDirectory().equals(string)) {
            sFileBrowser.refreshDirectory(false);
        }
    }

    private void refreshDirectory(boolean bl) {
        this.fFileView.refreshDirectory(bl);
    }

    public int desktopSaveAction() {
        return 1;
    }

    public void restoreState(DataInputStream dataInputStream) {
    }

    public void saveState(DataOutputStream dataOutputStream) {
        this.setPrefs();
    }

    public String getSplayConstraint() {
        return "";
    }

    public String getShortName() {
        return sTITLE;
    }

    public int getApplicationType() {
        return 0;
    }

    public MWMenuBar mergeMenus(MWMenuBar mWMenuBar) {
        return this.fMenubar.mergeMenus(mWMenuBar);
    }

    public static void invoke() {
        FileBrowser.invoke(null);
    }

    public static void main(String[] stringArray) {
        FileBrowser.invoke();
    }

    static /* synthetic */ FileBrowser access$3() {
        return sFileBrowser;
    }

    class FileBrowserWindowAdapter
    extends MWWindowActivater {
        public FileBrowserWindowAdapter(Component component) {
            super(component);
            FileBrowser.this = FileBrowser.this;
        }

        public void windowClosing(WindowEvent windowEvent) {
            super.windowClosing(windowEvent);
            sFileBrowser = null;
        }
    }

    private class PrefsListener
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getEventType() == 1) {
                String string = prefEvent.getPrefKey();
                if (string.equals("GeneralFont")) {
                    FileBrowser.this.setFont(Prefs.getFontPref((String)string));
                    return;
                }
                if (string.equals("FileBrowserShowCommentBlock")) {
                    FileBrowser.this.fFileView.showCommentBlock(CurrentDirectoryPrefs.getShowCommentBlock());
                }
            }
        }

        PrefsListener() {
            FileBrowser.this = FileBrowser.this;
        }
    }

    private class FileBrowserWindowOwner
    implements MWWindowOwner {
        public void setActive(boolean bl) {
        }

        public String getShortName() {
            return sTITLE;
        }

        public String getLongName() {
            if (FileBrowser.this.fFileView != null) {
                return String.valueOf(sTITLE) + ":" + FileBrowser.this.fFileView.getCurrentDirectoryName();
            }
            return sTITLE;
        }

        public boolean close() {
            return this.closeWindow() == 0;
        }

        public int closeWindow() {
            FileBrowser.this.fFrame.dispose();
            sFileBrowser = null;
            return 0;
        }

        FileBrowserWindowOwner() {
            FileBrowser.this = FileBrowser.this;
        }
    }
}

