/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.arrayeditor;

import com.mathworks.ide.arrayeditor.ArrayView;
import com.mathworks.ide.arrayeditor.ArrayViewLooper;
import com.mathworks.ide.arrayeditor.ArrayViewUtils;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.mwt.table.TableData;
import com.mathworks.mwt.table.TableDataEvent;
import java.util.StringTokenizer;

public class MatlabVariableData
extends TableData {
    public static final int FORMAT_SHORT = 0;
    public static final int FORMAT_SHORT_E = 1;
    public static final int FORMAT_SHORT_G = 2;
    public static final int FORMAT_LONG = 3;
    public static final int FORMAT_LONG_E = 4;
    public static final int FORMAT_LONG_G = 5;
    public static final int NUM_FORMATS = 6;
    protected static final int STATUS_INIT = 0;
    protected static final int STATUS_OK = 1;
    protected static final int STATUS_NONEXISTENT = 2;
    protected static final int STATUS_UNSUPPORTED = 3;
    protected static final int STATUS_TOO_LARGE = 4;
    protected static final int STATUS_OUT_OF_SCOPE = 5;
    protected static final int STATUS_ERROR = 6;
    protected static final int STATUS_EMPTY = 7;
    protected static final int STATUS_NOT_2D = 8;
    protected static final int STATUS_NO_VARIABLE = 9;
    protected static final String[] SUPPORTED_FORMATS = new String[]{"short", "shortE", "shortG", "long", "longE", "longG"};
    protected static final int MAX_ELEMENTS = 10000;
    private static final int NO_INDEX = -1;
    private static final String NEWLINE = System.getProperty("line.separator");
    private String fName;
    private MLArrayRef fRef;
    private MLArrayRef fPendingRef;
    private int fFormat;
    private int fType;
    private int fWidth;
    private int fHeight;
    private int fVarWidth;
    private int fVarHeight;
    private String fFactor;
    private String[] fData;
    private String fStack;
    private String fCurStack;
    private int fStatus;

    public MatlabVariableData(String string) {
        this.fName = string;
        this.fPendingRef = null;
        this.fRef = null;
        this.fFormat = 2;
        this.initialize();
    }

    public MatlabVariableData(MLArrayRef mLArrayRef) {
        this.fPendingRef = mLArrayRef;
        this.fRef = null;
        this.fName = null;
        this.fFormat = 2;
        this.initialize();
    }

    private void initialize() {
        this.fType = this.fRef == null ? 0 : this.fRef.getType();
        this.fWidth = 0;
        this.fHeight = 0;
        this.fVarWidth = 0;
        this.fVarHeight = 0;
        this.fFactor = "";
        this.fData = null;
        this.fStack = null;
        this.fCurStack = null;
        this.fStatus = 0;
    }

    protected void registerInterests() {
        ArrayViewLooper.register(this);
        this.refresh();
    }

    protected void unregisterInterests() {
        ArrayViewLooper.unregister(this);
    }

    public int getType() {
        return this.fType;
    }

    public String getVariableName() {
        if (this.fName != null) {
            return this.fName;
        }
        return "";
    }

    public void setVariableName(String string) {
        this.fName = string != null && string.equals("") ? null : string;
        if (this.fRef != null) {
            this.fRef.dispose();
            this.fRef = null;
        }
        this.initialize();
        this.refresh();
    }

    public MLArrayRef getVariableRef() {
        return this.fRef;
    }

    public void setVariableRef(MLArrayRef mLArrayRef) {
        this.fName = null;
        if (this.fRef != null) {
            this.fRef.dispose();
        }
        this.fPendingRef = mLArrayRef;
        this.fRef = null;
        this.initialize();
        this.refresh();
    }

    public int getFormat() {
        return this.fFormat;
    }

    public void setFormat(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.fFormat = n;
                this.refresh();
                return;
            }
        }
    }

    public String getFactor() {
        return this.fFactor;
    }

    public String getStack() {
        return this.fStack;
    }

    public String getCurrentStack() {
        return this.fCurStack;
    }

    protected int getStringSize() {
        int n;
        int n2 = n = this.fType == 1 ? 15 : 8;
        if (this.fData != null) {
            int n3 = 0;
            while (n3 < this.fData.length) {
                if (this.fData[n3] != null && this.fData[n3].length() + 1 > n) {
                    n = this.fData[n3].length() + 1;
                }
                ++n3;
            }
        }
        return n;
    }

    protected int getStatus() {
        return this.fStatus;
    }

    public Object getData(int n, int n2) {
        int n3 = this.getIndex(n, n2);
        String string = null;
        if (n3 != -1 && this.fData != null && n3 < this.fData.length) {
            string = this.fData[n3];
        }
        return string;
    }

    public void setData(int n, int n2, Object object) {
        this.setData(n, n2, object, null);
    }

    public void setData(int n, int n2, Object object, ArrayView arrayView) {
        String string = null;
        if (object instanceof String) {
            if (this.fName != null) {
                switch (this.fType) {
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        string = String.valueOf(this.fName) + "(" + (n + 1) + "," + (n2 + 1) + ") = " + object + ";";
                        break;
                    }
                    case 1: {
                        string = String.valueOf(this.fName) + "{" + (n + 1) + "," + (n2 + 1) + "} = '" + this.quoteQuotes((String)object) + "';";
                        break;
                    }
                    case 4: {
                        string = String.valueOf(this.fName) + " = '" + this.quoteQuotes((String)object) + "';";
                        break;
                    }
                }
                if (string != null) {
                    ArrayViewLooper.eval(string, arrayView.getFrame());
                    return;
                }
            } else if (this.fRef != null) {
                double[] dArray = new double[]{n + 1};
                double[] dArray2 = new double[]{n2 + 1};
                Object[] objectArray = new Object[]{dArray, dArray2};
                ArrayViewLooper.setValue(this.fRef, objectArray, (String)object, this, arrayView.getFrame());
            }
        }
    }

    private String quoteQuotes(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        String string2 = string;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '\'') {
                ++n;
            }
            ++n2;
        }
        if (n > 0) {
            char[] cArray2 = new char[cArray.length + n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < cArray.length) {
                cArray2[n3++] = cArray[n4];
                if (cArray[n4] == '\'') {
                    cArray2[n3++] = cArray[n4];
                }
                ++n4;
            }
            string2 = new String(cArray2);
        }
        return string2;
    }

    public void setPort(Object object, int n, int n2, int n3, int n4) {
    }

    public int getWidth() {
        return this.fWidth;
    }

    public void setWidth(int n) {
    }

    protected int getVarWidth() {
        return this.fVarWidth;
    }

    protected void setVarWidth(int n, ArrayView arrayView) {
        if (this.fName != null) {
            String string = null;
            String string2 = null;
            switch (this.fType) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    string2 = "0";
                    break;
                }
                case 1: {
                    string2 = "{''}";
                    break;
                }
            }
            if (string2 != null) {
                if (n > this.fVarWidth) {
                    string = String.valueOf(this.fName) + "(:,end+1:" + n + ") = " + string2 + ";";
                } else if (n < this.fVarWidth) {
                    string = String.valueOf(this.fName) + "(:," + n + "+1:end) = [];";
                }
            }
            if (string != null) {
                this.fVarWidth = n;
                ArrayViewLooper.eval(string, null);
                return;
            }
        } else if (this.fRef != null) {
            ArrayViewLooper.setVarWidth(this.fRef, n, this, arrayView.getFrame());
        }
    }

    public int getHeight() {
        return this.fHeight;
    }

    public void setHeight(int n) {
    }

    protected int getVarHeight() {
        return this.fVarHeight;
    }

    protected void setVarHeight(int n, ArrayView arrayView) {
        if (this.fName != null) {
            String string = null;
            String string2 = null;
            switch (this.fType) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    string2 = "0";
                    break;
                }
                case 1: {
                    string2 = "{''}";
                    break;
                }
            }
            if (string2 != null) {
                if (n > this.fVarHeight) {
                    string = String.valueOf(this.fName) + "(end+1:" + n + ",:) = " + string2 + ";";
                } else if (n < this.fVarHeight) {
                    string = String.valueOf(this.fName) + "(" + n + "+1:end,:) = [];";
                }
            }
            if (string != null) {
                this.fVarHeight = n;
                ArrayViewLooper.eval(string, null);
                return;
            }
        } else if (this.fRef != null) {
            ArrayViewLooper.setVarHeight(this.fRef, n, this, arrayView.getFrame());
        }
    }

    public void addRows(int n, int n2) {
    }

    public void addColumns(int n, int n2) {
    }

    public void removeRows(int n, int n2) {
    }

    public void removeColumns(int n, int n2) {
    }

    protected static String supportedType(MLArrayRef mLArrayRef) {
        String string = null;
        switch (mLArrayRef.getType()) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                if (mLArrayRef.getN() * mLArrayRef.getM() <= 10000) break;
                string = ArrayViewUtils.getResource("status.TooLarge", Integer.toString(10000));
                break;
            }
            case 1: {
                if (!mLArrayRef.isCellStr()) {
                    string = ArrayViewUtils.getResource("status.Unsupported");
                    break;
                }
                if (mLArrayRef.getN() * mLArrayRef.getM() <= 10000) break;
                string = ArrayViewUtils.getResource("status.TooLarge", Integer.toString(10000));
                break;
            }
            default: {
                string = ArrayViewUtils.getResource("status.Unsupported");
            }
            case 4: 
        }
        return string;
    }

    protected void gotStack(String string, boolean bl) {
        if (bl) {
            this.fStack = string;
        }
        this.fCurStack = string;
        if (!this.fCurStack.equals(this.fStack)) {
            this.badStatus(5);
            this.fireDataEvent(new TableDataEvent(this.fWidth, this.fHeight));
            return;
        }
        ArrayViewLooper.getRef(this, this.fName);
    }

    protected void gotSharedDataCopy(MLArrayRef mLArrayRef) {
        this.fPendingRef = null;
        if (mLArrayRef != null) {
            this.fRef = mLArrayRef;
            this.gotRef(this.fRef, true, false);
            return;
        }
        this.fRef = null;
        this.badStatus(6);
        this.fireDataEvent(new TableDataEvent(this.fWidth, this.fHeight));
    }

    protected void gotRef(MLArrayRef mLArrayRef, boolean bl, boolean bl2) {
        boolean bl3 = true;
        this.fVarWidth = 0;
        this.fVarHeight = 0;
        if (mLArrayRef != null) {
            this.fType = mLArrayRef.getType();
            this.fVarWidth = mLArrayRef.getN();
            this.fVarHeight = mLArrayRef.getM();
            switch (this.fType) {
                case 1: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    if (mLArrayRef.getNDimensions() != 2) {
                        this.badStatus(3);
                        break;
                    }
                    int n = mLArrayRef.getM() * mLArrayRef.getN();
                    int n2 = 1;
                    if (n == 0) {
                        n2 = 7;
                    } else if (n > 10000) {
                        n2 = 4;
                    }
                    if (n2 == 1) {
                        this.fStatus = 1;
                        this.fWidth = mLArrayRef.getN();
                        this.fHeight = mLArrayRef.getM();
                        break;
                    }
                    this.badStatus(n2);
                    break;
                }
                case 4: {
                    if (mLArrayRef.getNDimensions() != 2 || mLArrayRef.getM() != 1) {
                        this.badStatus(3);
                        break;
                    }
                    this.fStatus = 1;
                    this.fWidth = 1;
                    this.fHeight = 1;
                    break;
                }
                default: {
                    this.badStatus(3);
                }
            }
            if (this.fWidth == 0 || this.fHeight == 0) {
                this.fData = null;
            }
            if (this.fStatus == 1) {
                ArrayViewLooper.getData(this, mLArrayRef, SUPPORTED_FORMATS[this.fFormat], bl2);
                bl3 = false;
            } else if (bl2) {
                mLArrayRef.dispose();
            }
        } else if (bl) {
            this.badStatus(3);
        } else {
            this.badStatus(2);
        }
        if (bl3) {
            this.fireDataEvent(new TableDataEvent(this.fWidth, this.fHeight));
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    protected void gotData(String var1_1) {
        if (var1_1 == null) ** GOTO lbl38
        var4_2 = this.fWidth * this.fHeight;
        if (this.fData == null || this.fData.length != var4_2) {
            this.fData = new String[var4_2];
        }
        switch (this.fType) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                var2_3 = 0;
                var5_5 = true;
                var3_6 = new StringTokenizer(var1_1, MatlabVariableData.NEWLINE);
                while (var3_6.hasMoreTokens() && var2_3 < this.fData.length) {
                    var6_9 = var3_6.nextToken();
                    if (var5_5) {
                        if (var6_9.endsWith("*")) {
                            this.fFactor = var6_9.trim();
                        } else {
                            this.fFactor = "";
                            this.fData[var2_3++] = MatlabVariableData.compact(var6_9);
                        }
                        var5_5 = false;
                        continue;
                    }
                    this.fData[var2_3++] = MatlabVariableData.compact(var6_9);
                }
                break;
            }
            case 1: {
                this.fFactor = "";
                var3_7 = new StringTokenizer(var1_1, MatlabVariableData.NEWLINE);
                var2_4 = 0;
                while (var3_7.hasMoreTokens() && var2_4 < this.fData.length) {
                    var6_10 = var3_7.nextToken();
                    this.fData[var2_4++] = var6_10.substring(0, var6_10.length() - 1);
                }
                break;
            }
            case 4: {
                this.fFactor = "";
                var3_8 = new StringTokenizer(var1_1, MatlabVariableData.NEWLINE);
                if (!var3_8.hasMoreTokens()) break;
                this.fData[0] = var3_8.nextToken();
                break;
            }
lbl38:
            // 1 sources

            if (this.fType == 1) {
                this.badStatus(3);
                break;
            }
            if (this.fType == 4) {
                this.badStatus(3);
                break;
            }
            this.badStatus(6);
            break;
        }
        this.fireDataEvent(new TableDataEvent(this.fWidth, this.fHeight));
    }

    protected void gotInterest(int n) {
        if (this.fName != null) {
            switch (n) {
                case -2147483648: {
                    ArrayViewLooper.getStack(this, false);
                    return;
                }
            }
            if (this.fStatus != 5) {
                ArrayViewLooper.getRef(this, this.fName);
                return;
            }
        }
    }

    private void refresh() {
        if (this.fName != null) {
            ArrayViewLooper.getStack(this, this.fCurStack == null);
            return;
        }
        if (this.fPendingRef != null) {
            ArrayViewLooper.getSharedDataCopy(this, this.fPendingRef);
            return;
        }
        if (this.fRef != null) {
            this.gotRef(this.fRef, true, false);
            return;
        }
        this.badStatus(9);
        this.fireDataEvent(new TableDataEvent(this.fWidth, this.fHeight));
    }

    private static final String compact(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = 0;
        String string2 = string;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = n == 0 ? stringTokenizer.nextToken() : String.valueOf(string2) + " " + stringTokenizer.nextToken();
            ++n;
        }
        return string2;
    }

    private void badStatus(int n) {
        this.fStatus = n;
        this.fData = null;
        this.fFactor = "";
        this.fWidth = 0;
        this.fHeight = 0;
    }

    private int getIndex(int n, int n2) {
        int n3 = -1;
        if (n >= 0 && n < this.fHeight && n2 >= 0 && n2 < this.fWidth) {
            n3 = n2 * this.fHeight + n;
        }
        return n3;
    }
}

