/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.arrayeditor;

import com.mathworks.ide.arrayeditor.ArrayEditor;
import com.mathworks.ide.arrayeditor.ArrayViewUtils;
import com.mathworks.ide.arrayeditor.MatlabVariableData;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.message.MWMessage;
import java.awt.Frame;
import java.util.Vector;

final class ArrayViewLooper {
    private static boolean sAvailable;
    private static Matlab sMatlab;
    private static MWLooper sLooper;
    private static Vector sMVDList;
    static /* synthetic */ Class class$java$lang$Integer;

    protected static void invoke(String string, Frame frame) {
        if (sAvailable && string != null) {
            sMatlab.eval("dbstack", (CompletionObserver)new InvokeHandler(string, frame));
        }
    }

    protected static void getStack(MatlabVariableData matlabVariableData, boolean bl) {
        if (sAvailable) {
            sMatlab.eval("dbstack", (CompletionObserver)new GetStackHandler(matlabVariableData, bl));
        }
    }

    protected static void setValue(MLArrayRef mLArrayRef, Object[] objectArray, String string, MatlabVariableData matlabVariableData, Frame frame) {
        if (sAvailable) {
            Object[] objectArray2 = new Object[4];
            int n = 0;
            objectArray2[n++] = "setdata";
            objectArray2[n++] = mLArrayRef;
            objectArray2[n++] = objectArray;
            objectArray2[n++] = string;
            sMatlab.feval("arrayviewfunc", objectArray2, 1, (CompletionObserver)new RefSetHandler(matlabVariableData, frame));
        }
    }

    protected static void setVarWidth(MLArrayRef mLArrayRef, int n, MatlabVariableData matlabVariableData, Frame frame) {
        if (sAvailable) {
            Object[] objectArray = new Object[3];
            int n2 = 0;
            objectArray[n2++] = "setvarwidth";
            objectArray[n2++] = mLArrayRef;
            objectArray[n2++] = new Integer(n);
            sMatlab.feval("arrayviewfunc", objectArray, 1, (CompletionObserver)new RefSetHandler(matlabVariableData, frame));
        }
    }

    protected static void setVarHeight(MLArrayRef mLArrayRef, int n, MatlabVariableData matlabVariableData, Frame frame) {
        if (sAvailable) {
            Object[] objectArray = new Object[3];
            int n2 = 0;
            objectArray[n2++] = "setvarheight";
            objectArray[n2++] = mLArrayRef;
            objectArray[n2++] = new Integer(n);
            sMatlab.feval("arrayviewfunc", objectArray, 1, (CompletionObserver)new RefSetHandler(matlabVariableData, frame));
        }
    }

    protected static void eval(String string) {
        if (sAvailable) {
            sMatlab.evalConsoleOutput(string);
        }
    }

    protected static void eval(String string, Frame frame) {
        if (sAvailable) {
            if (frame != null) {
                sMatlab.eval(string, (CompletionObserver)new EvalHandler(frame));
                return;
            }
            sMatlab.eval(string, null);
        }
    }

    protected static void getData(MatlabVariableData matlabVariableData, MLArrayRef mLArrayRef, String string, boolean bl) {
        if (sAvailable) {
            Object[] objectArray = new Object[3];
            int n = 0;
            objectArray[n++] = "getdata";
            objectArray[n++] = mLArrayRef;
            objectArray[n++] = string;
            sMatlab.feval("arrayviewfunc", objectArray, 1, (CompletionObserver)new GetDataHandler(matlabVariableData, mLArrayRef, bl));
        }
    }

    protected static void getRef(MatlabVariableData matlabVariableData, String string) {
        ArrayViewLooper.getExist(string, new GetRefHandler(matlabVariableData, string));
    }

    protected static void getSharedDataCopy(MatlabVariableData matlabVariableData, MLArrayRef mLArrayRef) {
        if (sAvailable) {
            Object[] objectArray = new Object[2];
            int n = 0;
            double[] dArray = new double[]{45.0};
            objectArray[n++] = dArray;
            objectArray[n++] = mLArrayRef;
            sMatlab.feval("system_dependent", objectArray, 1, (CompletionObserver)new GetSharedDataCopyHandler(matlabVariableData));
        }
    }

    protected static void register(MatlabVariableData matlabVariableData) {
        Vector vector = sMVDList;
        synchronized (vector) {
            if (!sMVDList.contains((Object)matlabVariableData)) {
                sMVDList.addElement(matlabVariableData);
            }
            return;
        }
    }

    protected static void unregister(MatlabVariableData matlabVariableData) {
        Vector vector = sMVDList;
        synchronized (vector) {
            if (sMVDList.contains((Object)matlabVariableData)) {
                sMVDList.removeElement((Object)matlabVariableData);
            }
            return;
        }
    }

    private static void getExist(String string, CompletionObserver completionObserver) {
        if (sAvailable && string != null) {
            Object[] objectArray = new Object[1];
            int n = 0;
            objectArray[n++] = string;
            sMatlab.feval("exist", objectArray, 1, completionObserver);
        }
    }

    private static void getRef(String string, CompletionObserver completionObserver) {
        if (sAvailable && string != null) {
            Object[] objectArray = new Object[1];
            int n = 0;
            objectArray[n++] = "system_dependent(45," + string + ")";
            sMatlab.feval("eval", objectArray, 1, completionObserver);
        }
    }

    private static String gotStack(int n, Object object) {
        String string = null;
        if (ArrayViewLooper.successful(n) && object instanceof String) {
            string = ArrayViewUtils.getCurrentStack((String)object);
        }
        return string;
    }

    private static boolean gotExist(int n, Object object) {
        double[] dArray;
        boolean bl = false;
        if (ArrayViewLooper.successful(n) && object instanceof double[] && (dArray = (double[])object).length == 1) {
            bl = dArray[0] == 1.0;
        }
        return bl;
    }

    private static MLArrayRef gotRef(int n, Object object) {
        MLArrayRef mLArrayRef = null;
        if (ArrayViewLooper.successful(n) && object instanceof MLArrayRef) {
            mLArrayRef = (MLArrayRef)object;
        }
        return mLArrayRef;
    }

    private static final boolean successful(int n) {
        return Matlab.getExecutionStatus((int)n) == 0;
    }

    ArrayViewLooper() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        sMVDList = new Vector();
        if (Matlab.isMatlabAvailable()) {
            sAvailable = true;
            sLooper = new MWLooper("Array View Looper");
            sMatlab = new Matlab(sLooper);
            InterestHandler interestHandler = new InterestHandler();
            sMatlab.registerInterest(3, Integer.MIN_VALUE, (CompletionObserver)interestHandler);
            sMatlab.registerInterest(3, 0x40000000, (CompletionObserver)interestHandler);
            sMatlab.registerInterest(3, 0x20000000, (CompletionObserver)interestHandler);
            sMatlab.registerInterest(3, 0x10000000, (CompletionObserver)interestHandler);
            sMatlab.registerInterest(3, 1, (CompletionObserver)interestHandler);
        }
    }

    private static class InvokeHandler
    implements CompletionObserver {
        private int fStep;
        private String fName;
        private Frame fFrame;
        private String fCurStack;

        InvokeHandler(String string, Frame frame) {
            this.fName = string;
            this.fFrame = frame;
            this.fCurStack = null;
            this.fStep = 0;
        }

        public void completed(int n, Object object) {
            switch (this.fStep) {
                case 0: {
                    this.fCurStack = ArrayViewLooper.gotStack(n, object);
                    if (this.fCurStack != null) {
                        ++this.fStep;
                        ArrayViewLooper.getExist(this.fName, this);
                        return;
                    }
                    ArrayEditor.completeInvoke(this.fName, null, null, false, this.fFrame);
                    return;
                }
                case 1: {
                    if (ArrayViewLooper.gotExist(n, object)) {
                        ++this.fStep;
                        ArrayViewLooper.getRef(this.fName, this);
                        return;
                    }
                    ArrayEditor.completeInvoke(this.fName, this.fCurStack, null, false, this.fFrame);
                    return;
                }
                case 2: {
                    ArrayEditor.completeInvoke(this.fName, this.fCurStack, ArrayViewLooper.gotRef(n, object), true, this.fFrame);
                    return;
                }
            }
        }
    }

    private static class GetStackHandler
    implements CompletionObserver {
        private boolean fInitialRequest;
        private MatlabVariableData fData;

        GetStackHandler(MatlabVariableData matlabVariableData, boolean bl) {
            this.fData = matlabVariableData;
            this.fInitialRequest = bl;
        }

        public void completed(int n, Object object) {
            if (ArrayViewLooper.successful(n) && object instanceof String) {
                String string = ArrayViewUtils.getCurrentStack((String)object);
                if (this.fData != null) {
                    this.fData.gotStack(string, this.fInitialRequest);
                }
            }
        }
    }

    private static class RefSetHandler
    implements CompletionObserver {
        private MatlabVariableData fData;
        private Frame fFrame;

        RefSetHandler(MatlabVariableData matlabVariableData, Frame frame) {
            this.fData = matlabVariableData;
            this.fFrame = frame;
        }

        public void completed(int n, Object object) {
            if (this.fData == null) {
                if (!ArrayViewLooper.successful(n) && object instanceof String && this.fFrame != null) {
                    ArrayViewUtils.arrayViewAlert(this.fFrame, (String)object);
                    return;
                }
            } else {
                if (object instanceof String && this.fFrame != null) {
                    ArrayViewUtils.arrayViewAlert(this.fFrame, (String)object);
                    return;
                }
                if (object instanceof MLArrayRef) {
                    this.fData.setVariableRef((MLArrayRef)object);
                }
            }
        }
    }

    private static class EvalHandler
    implements CompletionObserver {
        private Frame fFrame;

        EvalHandler(Frame frame) {
            this.fFrame = frame;
        }

        public void completed(int n, Object object) {
            if (!ArrayViewLooper.successful(n) && object instanceof String && this.fFrame != null) {
                ArrayViewUtils.arrayViewAlert(this.fFrame, (String)object);
            }
        }
    }

    private static class GetDataHandler
    implements CompletionObserver {
        private MatlabVariableData fData;
        private MLArrayRef fRef;

        GetDataHandler(MatlabVariableData matlabVariableData, MLArrayRef mLArrayRef, boolean bl) {
            this.fData = matlabVariableData;
            if (bl) {
                this.fRef = mLArrayRef;
                return;
            }
            this.fRef = null;
        }

        public void completed(int n, Object object) {
            if (ArrayViewLooper.successful(n) && this.fData != null) {
                if (object instanceof String) {
                    this.fData.gotData((String)object);
                } else {
                    this.fData.gotData(null);
                }
            }
            if (this.fRef != null) {
                this.fRef.dispose();
            }
        }
    }

    private static class GetRefHandler
    implements CompletionObserver {
        private MatlabVariableData fData;
        private String fName;
        private int fStep;

        GetRefHandler(MatlabVariableData matlabVariableData, String string) {
            this.fData = matlabVariableData;
            this.fName = string;
            this.fStep = 0;
        }

        public void completed(int n, Object object) {
            switch (this.fStep) {
                case 0: {
                    if (ArrayViewLooper.gotExist(n, object)) {
                        this.fStep = 1;
                        ArrayViewLooper.getRef(this.fName, this);
                        return;
                    }
                    this.fData.gotRef(null, false, true);
                    return;
                }
                case 1: {
                    this.fData.gotRef(ArrayViewLooper.gotRef(n, object), true, true);
                    return;
                }
            }
        }
    }

    private static class GetSharedDataCopyHandler
    implements CompletionObserver {
        private MatlabVariableData fData;

        GetSharedDataCopyHandler(MatlabVariableData matlabVariableData) {
            this.fData = matlabVariableData;
        }

        public void completed(int n, Object object) {
            if (this.fData != null) {
                if (ArrayViewLooper.successful(n) && object instanceof MLArrayRef) {
                    this.fData.gotSharedDataCopy((MLArrayRef)object);
                    return;
                }
                this.fData.gotSharedDataCopy(null);
            }
        }
    }

    private static class InterestHandler
    implements CompletionObserver {
        public void completed(int n, Object object) {
            MWMessage mWMessage = (MWMessage)object;
            int n2 = (Integer)mWMessage.findData("familyid", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = ArrayViewLooper.class$("java.lang.Integer")));
            int n3 = (Integer)mWMessage.findData("eventid", class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = ArrayViewLooper.class$("java.lang.Integer")));
            if (n2 == 3) {
                Vector vector;
                Vector vector2 = sMVDList;
                synchronized (vector2) {
                    vector = (Vector)sMVDList.clone();
                }
                int n4 = 0;
                while (n4 < vector.size()) {
                    MatlabVariableData matlabVariableData = (MatlabVariableData)((Object)vector.elementAt(n4));
                    if (matlabVariableData != null) {
                        matlabVariableData.gotInterest(n3);
                    }
                    ++n4;
                }
            }
        }

        InterestHandler() {
        }
    }
}

