/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.arrayeditor;

import com.mathworks.ide.arrayeditor.ArrayViewCellText;
import com.mathworks.ide.arrayeditor.ArrayViewUtils;
import com.mathworks.ide.arrayeditor.MatlabVariableData;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.mwt.MWTable;
import com.mathworks.mwt.table.Cell;
import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.table.TableData;
import com.mathworks.mwt.table.TableDataEvent;
import com.mathworks.mwt.table.TableDataListener;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ArrayView
extends MWTable {
    public static final int STATUS_INIT = 0;
    public static final int STATUS_OK = 1;
    public static final int STATUS_NONEXISTENT = 2;
    public static final int STATUS_UNSUPPORTED = 3;
    public static final int STATUS_TOO_LARGE = 4;
    public static final int STATUS_OUT_OF_SCOPE = 5;
    public static final int STATUS_ERROR = 6;
    public static final int STATUS_EMPTY = 7;
    public static final int STATUS_NOT_2D = 8;
    public static final int STATUS_NO_VARIABLE = 9;
    private static final int STATUS_MARGIN = 4;
    private Font fFactorFont;
    private ActionListener fArrayViewListener;

    public ArrayView(MLArrayRef mLArrayRef) {
        super((TableData)new MatlabVariableData(mLArrayRef));
        this.setupTable();
        this.fArrayViewListener = null;
    }

    public ArrayView(String string) {
        super((TableData)new MatlabVariableData(string));
        this.setupTable();
        this.fArrayViewListener = null;
    }

    private void setupTable() {
        this.getColumnOptions().setAutoLabel(2);
        this.getColumnOptions().setResizable(true);
        this.getRowOptions().setAutoLabel(2);
        this.getColumnOptions().setHeaderSelectable(true);
        this.getRowOptions().setHeaderSelectable(true);
        this.getSelectionOptions().setMode(2);
        this.getTableStyle().setHAlignment(2);
        this.getVScrollbarOptions().setOverlappingHeader(true);
        this.getHScrollbarOptions().setOverlappingHeader(true);
        this.getTableStyle().setEditable(true);
        this.setCursorType(0);
        this.registerCellType(Table.class$java$lang$String != null ? Table.class$java$lang$String : (Table.class$java$lang$String = ArrayView.class$("java.lang.String")), (Cell)new ArrayViewCellText((Table)this));
        this.getData().addDataListener((TableDataListener)new MyDataListener());
        this.updateFactorFont();
    }

    public ArrayView() {
        this((String)null);
    }

    public int getType() {
        return this.getMVD().getType();
    }

    public int getFormat() {
        return this.getMVD().getFormat();
    }

    public int getVarWidth() {
        return this.getMVD().getVarWidth();
    }

    public void setVarWidth(int n) {
        this.getMVD().setVarWidth(n, this);
    }

    public int getVarHeight() {
        return this.getMVD().getVarHeight();
    }

    public void setVarHeight(int n) {
        this.getMVD().setVarHeight(n, this);
    }

    public void setFormat(int n) {
        this.getMVD().setFormat(n);
        this.updateColumnWidths();
    }

    public int getStatus() {
        return this.getMVD().getStatus();
    }

    public void addArrayViewListener(ActionListener actionListener) {
        this.fArrayViewListener = AWTEventMulticaster.add(this.fArrayViewListener, actionListener);
    }

    public void removeArrayViewListener(ActionListener actionListener) {
        this.fArrayViewListener = AWTEventMulticaster.remove(this.fArrayViewListener, actionListener);
    }

    public String getStatusString() {
        String string = null;
        switch (this.getStatus()) {
            case 0: {
                string = ArrayViewUtils.getResource("status.Initializing");
                break;
            }
            case 2: {
                string = ArrayViewUtils.getResource("status.Nonexistent");
                break;
            }
            case 3: {
                string = ArrayViewUtils.getResource("status.Unsupported");
                break;
            }
            case 4: {
                string = ArrayViewUtils.getResource("status.TooLarge", Integer.toString(10000));
                break;
            }
            case 5: {
                string = ArrayViewUtils.getResource("status.OutOfScope");
                break;
            }
            case 6: {
                string = ArrayViewUtils.getResource("status.Error");
                break;
            }
            case 7: {
                string = ArrayViewUtils.getResource("status.Empty");
                break;
            }
            case 9: {
                string = ArrayViewUtils.getResource("status.NoVariable");
                break;
            }
        }
        return string;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updateFactorFont();
        this.updateColumnWidths();
    }

    private void updateFactorFont() {
        String string = this.getFont().getName();
        int n = this.getFont().getSize();
        this.fFactorFont = new Font(string, 2, n);
    }

    private void updateColumnWidths() {
        if (this.getStatus() == 1) {
            Object object;
            int n = this.getMVD().getStringSize();
            int n2 = this.getMVD().getType();
            Insets insets = this.getTableStyle().getMargins();
            Font font = this.getTableStyle().getFont();
            if (font != null) {
                object = ((Component)((Object)this)).getFontMetrics(font);
                int n3 = ((FontMetrics)object).charWidth('3') * n + insets.left + insets.right;
                this.getColumnOptions().setDefaultWidth(n3);
                n3 = ((FontMetrics)object).charWidth('3') * 11 + insets.left + insets.right;
                this.getRowOptions().setHeaderWidth(n3);
            }
            if (n2 == 4) {
                object = this.getData().getDataAsText(0, 0);
                if (object != null) {
                    String string = String.valueOf(((String)object).length()) + " Characters";
                    this.setColumnHeaderData(0, string);
                    this.setCellData(-1, 0, string);
                    this.setAutoExpandColumn(0);
                }
            } else if (n2 == 1 && this.getMVD().getWidth() == 1) {
                this.setColumnHeaderData(0, null);
                this.setAutoExpandColumn(0);
            } else {
                this.setColumnHeaderData(0, null);
                int n4 = this.getAutoExpandColumn();
                this.setAutoExpandColumn(-1);
                if (n4 != -2 && n4 != -1) {
                    this.setColumnWidth(n4, -1);
                }
            }
            this.layoutScrollbars();
        }
    }

    public String getVariableName() {
        return this.getMVD().getVariableName();
    }

    public void setVariableName(String string) {
        this.getMVD().setVariableName(string);
    }

    public MLArrayRef getVariableRef() {
        return this.getMVD().getVariableRef();
    }

    public void setVariableRef(MLArrayRef mLArrayRef) {
        this.getMVD().setVariableRef(mLArrayRef);
    }

    public String getStack() {
        return this.getMVD().getStack();
    }

    public String getFactor() {
        return this.getMVD().getFactor();
    }

    public void addNotify() {
        super.addNotify();
        this.getMVD().registerInterests();
    }

    public void removeNotify() {
        super.removeNotify();
        this.getMVD().unregisterInterests();
    }

    private final MatlabVariableData getMVD() {
        return (MatlabVariableData)this.getData();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = this.getData().getWidth();
        int n2 = this.getData().getHeight();
        int n3 = this.getStatus();
        if ((n3 == 2 || n3 == 5) && this.getSelectedRows().length != 0) {
            this.deselectAll();
        }
        if (n3 != 1 && n == 0 && n2 == 0) {
            Font font = this.getFont();
            FontMetrics fontMetrics = ((Component)((Object)this)).getFontMetrics(font);
            Insets insets = this.getInsets();
            int n4 = insets.left + 4;
            int n5 = insets.top + 4 + fontMetrics.getMaxAscent();
            graphics.setColor(this.getForeground());
            graphics.setFont(font);
            graphics.drawString(this.getStatusString(), n4, n5);
            return;
        }
        String string = this.getFactor();
        if (string != null && string.length() > 0) {
            Font font = this.fFactorFont;
            FontMetrics fontMetrics = ((Component)((Object)this)).getFontMetrics(font);
            Insets insets = this.getInsets();
            int n6 = this.getColumnOptions().getHeaderHeight();
            int n7 = this.getRowOptions().getHeaderWidth();
            int n8 = fontMetrics.getHeight();
            int n9 = fontMetrics.stringWidth(string);
            int n10 = fontMetrics.getAscent();
            int n11 = insets.left + (n7 - n9) / 2;
            int n12 = insets.top + (n6 - n8) / 2 + n10;
            graphics.setColor(this.getForeground());
            graphics.setFont(this.fFactorFont);
            graphics.drawString(string, n11, n12);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MyDataListener
    implements TableDataListener {
        public void dataChanged(TableDataEvent tableDataEvent) {
        }

        public void dataBoundsChanging(TableDataEvent tableDataEvent) {
        }

        public void dataBoundsChanged(TableDataEvent tableDataEvent) {
            if (ArrayView.this.getStatus() == 1) {
                ArrayView.this.updateColumnWidths();
                switch (ArrayView.this.getMVD().getType()) {
                    case 1: 
                    case 4: {
                        ArrayView.this.getTableStyle().setHAlignment(0);
                        break;
                    }
                    default: {
                        ArrayView.this.getTableStyle().setHAlignment(2);
                        break;
                    }
                }
            }
            if (ArrayView.this.fArrayViewListener != null) {
                ActionEvent actionEvent = new ActionEvent((Object)ArrayView.this, 1001, "ArrayViewUpdated");
                ArrayView.this.fArrayViewListener.actionPerformed(actionEvent);
            }
        }

        public void rowsAdded(TableDataEvent tableDataEvent) {
        }

        public void rowsRemoved(TableDataEvent tableDataEvent) {
        }

        MyDataListener() {
            ArrayView.this = ArrayView.this;
        }
    }
}

