/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.arrayeditor;

import com.mathworks.ide.arrayeditor.ArrayEditor;
import com.mathworks.ide.prefs.PrefsDialog;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Enumeration;

class ArrayEditorPrefs
implements PrefListener {
    protected static final String USE_DT_FONT_KEY = "ArrayEditorUseDesktopFont";
    protected static final String FONT_KEY = "ArrayEditorFont";
    protected static final String DT_FONT_KEY = "GeneralFont";
    protected static final String FORMAT_KEY = "ArrayEditorFormat";
    protected static final String EXTERNAL_KEY = "ArrayEditorExternal";
    protected static final String BOUNDS_KEY = "ArrayEditorWindowBounds";
    protected static final String PATH_KEY = "ArrayEditorDockPath";
    private static final boolean USE_DT_FONT = true;
    private static final Font FONT = new Font("Monospaced", 0, 12);
    private static final int FORMAT = 2;
    private static final boolean EXTERNAL = true;
    private static final Rectangle BOUNDS = new Rectangle(50, 50, 600, 400);
    private static final String PATH = "EN";
    private boolean fCached = false;
    private boolean fUseDTFont;
    private Font fFont;
    private Font fDesktopFont;
    private int fFormat;
    private boolean fExternal;
    private Rectangle fBounds;
    private String fPath;

    ArrayEditorPrefs() {
        Prefs.addListener((PrefListener)this, (String)"ArrayEditor");
        Prefs.addListener((PrefListener)this, (String)DT_FONT_KEY);
    }

    protected void stopListening() {
        Prefs.removeListener((PrefListener)this, (String)"ArrayEditor");
        Prefs.removeListener((PrefListener)this, (String)DT_FONT_KEY);
    }

    public void prefChanged(PrefEvent prefEvent) {
        this.fCached = false;
        Enumeration enumeration = ArrayEditor.getOpenArrayEditors();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                ArrayEditor arrayEditor = (ArrayEditor)enumeration.nextElement();
                if (this.getUseDesktopFont()) {
                    arrayEditor.getArrayView().setFont(this.getDesktopFont());
                } else {
                    arrayEditor.getArrayView().setFont(this.getFont());
                }
                ((Component)((Object)arrayEditor.getArrayView())).repaint();
            }
        }
    }

    protected boolean getUseDesktopFont() {
        this.cachePrefs();
        return this.fUseDTFont;
    }

    protected void setUseDesktopFont(boolean bl) {
        Prefs.setBooleanPref((String)USE_DT_FONT_KEY, (boolean)bl);
    }

    protected Font getFont() {
        this.cachePrefs();
        return this.fFont;
    }

    protected Font getDesktopFont() {
        this.cachePrefs();
        return this.fDesktopFont;
    }

    protected void setFont(Font font) {
        if (font != null) {
            Prefs.setFontPref((String)FONT_KEY, (Font)font);
            return;
        }
        Prefs.setFontPref((String)FONT_KEY, (Font)FONT);
    }

    protected int getFormat() {
        this.cachePrefs();
        return this.fFormat;
    }

    protected void setFormat(int n) {
        Prefs.setIntegerPref((String)FORMAT_KEY, (int)n);
    }

    protected boolean isExternal() {
        this.cachePrefs();
        return this.fExternal;
    }

    protected void setExternal(boolean bl) {
        Prefs.setBooleanPref((String)EXTERNAL_KEY, (boolean)bl);
    }

    protected Rectangle getBounds() {
        this.cachePrefs();
        return this.fBounds;
    }

    protected void setBounds(Rectangle rectangle) {
        if (rectangle != null) {
            Prefs.setRectanglePref((String)BOUNDS_KEY, (Rectangle)rectangle);
            return;
        }
        Prefs.setRectanglePref((String)BOUNDS_KEY, (Rectangle)BOUNDS);
    }

    protected String getPath() {
        this.cachePrefs();
        return this.fPath;
    }

    protected void setPath(String string) {
        if (string != null && string.length() > 0) {
            Prefs.setStringPref((String)PATH_KEY, (String)string);
            return;
        }
        Prefs.setStringPref((String)PATH_KEY, (String)PATH);
    }

    protected static void showPrefsDialog() {
        PrefsDialog.showPrefsDialog();
    }

    private final void cachePrefs() {
        if (!this.fCached) {
            this.fUseDTFont = Prefs.getBooleanPref((String)USE_DT_FONT_KEY, (boolean)true);
            this.fFont = Prefs.getFontPref((String)FONT_KEY, (Font)FONT);
            try {
                this.fDesktopFont = Prefs.getFontPref((String)DT_FONT_KEY);
            }
            catch (Exception exception) {
                this.fDesktopFont = new Font("monospaced", 0, 12);
            }
            this.fFormat = Prefs.getIntegerPref((String)FORMAT_KEY, (int)2);
            this.fExternal = Prefs.getBooleanPref((String)EXTERNAL_KEY, (boolean)true);
            this.fBounds = Prefs.getRectanglePref((String)BOUNDS_KEY, (Rectangle)BOUNDS);
            this.fPath = Prefs.getStringPref((String)PATH_KEY, (String)PATH);
            this.fCached = true;
        }
    }
}

