/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.arrayeditor;

import com.mathworks.ide.arrayeditor.ArrayEditorPrefs;
import com.mathworks.ide.arrayeditor.ArrayView;
import com.mathworks.ide.arrayeditor.ArrayViewLooper;
import com.mathworks.ide.arrayeditor.ArrayViewUtils;
import com.mathworks.ide.arrayeditor.FormatChoice;
import com.mathworks.ide.arrayeditor.MatlabVariableData;
import com.mathworks.ide.desktop.DTApplication;
import com.mathworks.ide.desktop.DTClient;
import com.mathworks.ide.desktop.DTDockPath;
import com.mathworks.ide.desktop.Desktop;
import com.mathworks.ide.desktop.MLDesktop;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.mwt.MWCloseBox;
import com.mathworks.mwt.MWContainer;
import com.mathworks.mwt.MWFrameProxy;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTabPanel;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.MWToolbar;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.mwt.window.WindowRegistry;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ResLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class ArrayEditor
extends MWContainer
implements MWWindowOwner,
MWCommandTarget,
DTApplication {
    private static final int EDIT_PREFS = 101;
    private static final String DELIM = "-";
    private static final String MY_NAME = "Array Editor";
    private static Image sWindowIcon = null;
    private static Matlab sMatlab = null;
    private static Hashtable sEditors = null;
    private static ArrayEditorPrefs sPreferences;
    private ArrayView fArrayView;
    private ArrayEditorToolbar fToolbar;
    private MWTextField fWidthField;
    private MWTextField fHeightField;
    private MWFrameProxy fFrame;
    private DTClient fClient;
    private MWCommandCenter fCommandCenter;

    public ArrayEditor(String string, MWFrameProxy mWFrameProxy) {
        if (sPreferences == null) {
            sPreferences = new ArrayEditorPrefs();
        }
        this.fCommandCenter = new MWCommandCenter((MWCommandTarget)this);
        this.fCommandCenter.setCommandEnabled(-203, false);
        this.fCommandCenter.setCommandEnabled(-204, false);
        this.fCommandCenter.setCommandEnabled(-205, false);
        this.fCommandCenter.setCommandEnabled(-201, false);
        this.fCommandCenter.setCommandEnabled(-202, false);
        this.fCommandCenter.setCommandEnabled(101, true);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.fArrayView = new ArrayView(string);
        if (PlatformInfo.getAppearance() != 1) {
            this.fArrayView.setBorderStyle(0);
        }
        ((Container)((Object)this)).add((Component)((Object)this.fArrayView), "Center");
        if (sPreferences.getUseDesktopFont()) {
            this.fArrayView.setFont(sPreferences.getDesktopFont());
        } else {
            this.fArrayView.setFont(sPreferences.getFont());
        }
        this.fArrayView.setFormat(sPreferences.getFormat());
        this.fToolbar = new ArrayEditorToolbar(this.fCommandCenter);
        this.fArrayView.addArrayViewListener(this.fToolbar);
        ((Container)((Object)this)).add((Component)((Object)this.fToolbar), "North");
        this.fFrame = mWFrameProxy == null ? new MWFrameProxy((MWWindowOwner)this, this.getLongName()) : mWFrameProxy;
        WindowRegistry.getRegistry().register((MWWindowOwner)this);
        Rectangle rectangle = sPreferences.getBounds();
        if (sWindowIcon == null) {
            ResLoader resLoader = new ResLoader((Component)((Object)this));
            sWindowIcon = PlatformInfo.isWindows() ? resLoader.loadImage("resources/arrayeditor32.gif") : resLoader.loadImage("resources/arrayeditor48.gif");
            resLoader.waitForPendingImages();
        }
        this.fFrame.setIconImage(sWindowIcon);
        this.fFrame.setFrameLimits(300, 100, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.fFrame.setFrameLocation(rectangle.x, rectangle.y);
        this.fFrame.setFrameSize(rectangle.width, rectangle.height);
        this.fFrame.add((Component)((Object)this), "Center");
    }

    public ArrayEditor(String string) {
        this(string, null);
    }

    public void doCommand(int n) {
        switch (n) {
            case 101: {
                this.doEditPrefs();
                return;
            }
            case -103: {
                this.closeWindow();
                return;
            }
        }
    }

    private void doEditPrefs() {
        ArrayEditorPrefs.showPrefsDialog();
    }

    public void requestFocus() {
        this.fArrayView.requestFocus();
    }

    public int closeWindow() {
        if (this.fFrame != null) {
            Object object;
            this.fArrayView.commitEditingCell();
            if (this.fClient != null && (object = this.fClient.getDockPath()) != null) {
                boolean bl = ((DTDockPath)object).getContainerID() != 0;
                sPreferences.setExternal(bl);
                if (bl) {
                    sPreferences.setBounds(((DTDockPath)object).getFrameBounds());
                } else {
                    sPreferences.setPath(((DTDockPath)object).getPathString());
                    Container container = this.fFrame.getParent();
                    if (container instanceof MWTabPanel) {
                        container = container.getParent();
                    }
                    Dimension dimension = container != null ? container.getSize() : ((Component)((Object)this)).getSize();
                    Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
                    sPreferences.setBounds(rectangle);
                }
            }
            this.fFrame.setVisible(false);
            WindowRegistry.getRegistry().unregister((MWWindowOwner)this);
            this.fFrame.dispose();
            if (sEditors != null) {
                object = String.valueOf(this.fArrayView.getVariableName()) + DELIM + this.fArrayView.getStack();
                if (sEditors.containsKey(object)) {
                    sEditors.remove(object);
                }
                if (sPreferences != null && sEditors.size() == 0) {
                    sPreferences.stopListening();
                    sPreferences = null;
                }
            }
        }
        return 0;
    }

    public void setActive(boolean bl) {
    }

    public String getShortName() {
        return "Array Editor: " + this.getArrayView().getVariableName();
    }

    public String getLongName() {
        return "Array Editor: " + this.getArrayView().getVariableName();
    }

    public int desktopSaveAction() {
        return 2;
    }

    public void restoreState(DataInputStream dataInputStream) {
    }

    public int getApplicationType() {
        return 2;
    }

    public void saveState(DataOutputStream dataOutputStream) {
    }

    public String getSplayConstraint() {
        return "";
    }

    public MWMenuBar mergeMenus(MWMenuBar mWMenuBar) {
        return mWMenuBar;
    }

    protected static ArrayEditorPrefs getPreferences() {
        if (sPreferences == null) {
            sPreferences = new ArrayEditorPrefs();
        }
        return sPreferences;
    }

    protected ArrayView getArrayView() {
        return this.fArrayView;
    }

    protected static void completeInvoke(String string, String string2, MLArrayRef mLArrayRef, boolean bl, Frame frame) {
        ArrayEditor arrayEditor = null;
        String string3 = null;
        if (string2 == null) {
            string3 = ArrayViewUtils.getResource("status.Error");
        } else if (mLArrayRef == null) {
            string3 = bl ? ArrayViewUtils.getResource("status.Unsupported") : ArrayViewUtils.getResource("status.Nonexistent");
        } else {
            String string4 = String.valueOf(string) + DELIM + string2;
            arrayEditor = ArrayEditor.getExistingEditor(string4);
            string3 = MatlabVariableData.supportedType(mLArrayRef);
        }
        if (string3 == null || arrayEditor != null) {
            ArrayEditor.createArrayEditor(string, string2);
            return;
        }
        if (frame == null) {
            ArrayViewLooper.eval("error('Array Editor: " + string3 + "')");
            return;
        }
        ArrayViewUtils.arrayViewAlert(frame, string3);
    }

    private static void createArrayEditor(String string, String string2) {
        String string3 = String.valueOf(string) + DELIM + string2;
        ArrayEditor arrayEditor = ArrayEditor.getExistingEditor(string3);
        MLDesktop mLDesktop = MLDesktop.getMLDesktop();
        if (arrayEditor == null) {
            DTDockPath dTDockPath;
            arrayEditor = new ArrayEditor(string);
            ArrayEditor arrayEditor2 = ArrayEditor.getMasterEditor();
            MWFrameProxy mWFrameProxy = arrayEditor.fFrame;
            if (arrayEditor2 != null && arrayEditor2.fClient != null) {
                dTDockPath = arrayEditor2.fClient.getDockPath();
            } else {
                sPreferences.isExternal();
                String string4 = sPreferences.getPath();
                if (!sPreferences.isExternal() && string4 != null && string4.length() > 0) {
                    Rectangle rectangle = sPreferences.getBounds();
                    ((Component)((Object)arrayEditor)).setSize(rectangle.width, rectangle.height);
                    arrayEditor.fFrame.setSize(rectangle.width, rectangle.height);
                    dTDockPath = new DTDockPath(string4);
                } else {
                    dTDockPath = new DTDockPath(mWFrameProxy);
                }
            }
            DTClient dTClient = mLDesktop != null ? mLDesktop.addClient((Component)((Object)arrayEditor), dTDockPath, arrayEditor.getLongName(), true) : Desktop.addClient((Component)((Object)arrayEditor), dTDockPath, arrayEditor.getLongName());
            arrayEditor.fClient = dTClient;
            sEditors.put(string3, arrayEditor);
            return;
        }
        MWFrameProxy mWFrameProxy = (MWFrameProxy)((Component)((Object)arrayEditor)).getParent();
        mWFrameProxy.toFront();
    }

    private static ArrayEditor getMasterEditor() {
        Enumeration enumeration;
        ArrayEditor arrayEditor = null;
        if (sEditors != null && sEditors.size() > 0 && (enumeration = sEditors.elements()).hasMoreElements()) {
            arrayEditor = (ArrayEditor)enumeration.nextElement();
        }
        return arrayEditor;
    }

    private static ArrayEditor getExistingEditor(String string) {
        ArrayEditor arrayEditor = null;
        if (sEditors == null) {
            sEditors = new Hashtable();
        }
        if (sEditors.containsKey(string)) {
            arrayEditor = (ArrayEditor)sEditors.get(string);
        }
        return arrayEditor;
    }

    protected static Enumeration getOpenArrayEditors() {
        Enumeration enumeration = null;
        if (sEditors != null) {
            enumeration = sEditors.elements();
        }
        return enumeration;
    }

    public static void invoke(String string) {
        ArrayEditor.invoke(string, null);
    }

    public static void invoke(String string, Frame frame) {
        ArrayViewLooper.invoke(string, frame);
    }

    private class ArrayEditorToolbar
    extends MWPanel
    implements ActionListener {
        private FormatChoice fChoice;

        ArrayEditorToolbar(MWCommandCenter mWCommandCenter) {
            ArrayEditor.this = ArrayEditor.this;
            ((Container)((Object)this)).setLayout(new BorderLayout());
            MWToolbar mWToolbar = new MWToolbar();
            this.fChoice = new FormatChoice(ArrayEditor.this.fArrayView.getFormat());
            this.fChoice.addItemListener(new FormatChanger());
            mWToolbar.addComponent((Component)((Object)this.fChoice));
            mWToolbar.addSpacer();
            mWToolbar.addComponent((Component)this.fieldPanel());
            MWToolbar mWToolbar2 = new MWToolbar();
            MWCloseBox mWCloseBox = new MWCloseBox(mWCommandCenter, "Close current variable");
            mWCloseBox.setFocusBehavior(false);
            mWToolbar2.addComponent((Component)mWCloseBox);
            if (PlatformInfo.getAppearance() != 1) {
                mWToolbar2.addSpacer(5);
            }
            ((Container)((Object)this)).add((Component)mWToolbar, "Center");
            ((Container)((Object)this)).add((Component)mWToolbar2, "East");
        }

        private MWPanel fieldPanel() {
            MWPanel mWPanel = new MWPanel((LayoutManager)new FlowLayout(0, 4, 0));
            SizeChanger sizeChanger = new SizeChanger();
            SizeChanger sizeChanger2 = new SizeChanger();
            ArrayEditor.this.fWidthField = new MWTextField(6);
            ArrayEditor.this.fWidthField.addActionListener((ActionListener)sizeChanger);
            ArrayEditor.this.fWidthField.addFocusListener((FocusListener)sizeChanger);
            ArrayEditor.this.fHeightField = new MWTextField(6);
            ArrayEditor.this.fHeightField.addActionListener((ActionListener)sizeChanger2);
            ArrayEditor.this.fHeightField.addFocusListener((FocusListener)sizeChanger2);
            mWPanel.add((Component)new MWLabel(ArrayViewUtils.getResource("label.Size")));
            mWPanel.add((Component)ArrayEditor.this.fHeightField);
            mWPanel.add((Component)new MWLabel(ArrayViewUtils.getResource("label.By")));
            mWPanel.add((Component)ArrayEditor.this.fWidthField);
            return mWPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.updateControls();
        }

        void updateControls() {
            int n = ArrayEditor.this.fArrayView.getType();
            int n2 = ArrayEditor.this.fArrayView.getVarWidth();
            int n3 = ArrayEditor.this.fArrayView.getVarHeight();
            ArrayEditor.this.fHeightField.setText(Integer.toString(n3));
            ArrayEditor.this.fWidthField.setText(Integer.toString(n2));
            switch (n) {
                case 1: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    int n4 = ArrayEditor.this.fArrayView.getStatus();
                    boolean bl = n != 1;
                    boolean bl2 = n4 == 1 || n4 == 4 || n4 == 7;
                    this.fChoice.setEnabled(bl && bl2);
                    ArrayEditor.this.fHeightField.setEnabled(bl2);
                    ArrayEditor.this.fWidthField.setEnabled(bl2);
                    return;
                }
            }
            this.fChoice.setEnabled(false);
            ArrayEditor.this.fHeightField.setEnabled(false);
            ArrayEditor.this.fWidthField.setEnabled(false);
        }
    }

    private class SizeChanger
    extends FocusAdapter
    implements ActionListener,
    Runnable {
        private boolean fDealingWithIt = false;
        private MWTextField fField;
        private int fNewValue;
        private int fOldValue;

        public void actionPerformed(ActionEvent actionEvent) {
            this.updateViaTextField((MWTextField)actionEvent.getSource());
        }

        public void focusLost(FocusEvent focusEvent) {
            MWTextField mWTextField = (MWTextField)focusEvent.getSource();
            mWTextField.setSel(0, 0);
            this.updateViaTextField(mWTextField);
        }

        public void run() {
            String string = ArrayViewUtils.getResource("alert.WarnOfDeletion");
            Frame frame = (Frame)MWUtils.getTopLevelWindow((Component)((Object)ArrayEditor.this));
            if (ArrayViewUtils.askUser(frame, string)) {
                if (this.fField == ArrayEditor.this.fWidthField) {
                    ArrayEditor.this.fArrayView.setVarWidth(this.fNewValue);
                } else {
                    ArrayEditor.this.fArrayView.setVarHeight(this.fNewValue);
                }
            } else {
                this.fField.setText(Integer.toString(this.fOldValue));
            }
            this.fDealingWithIt = false;
        }

        private void updateViaTextField(MWTextField mWTextField) {
            if (!this.fDealingWithIt) {
                this.fDealingWithIt = true;
                boolean bl = true;
                String string = mWTextField.getText();
                int n = -1;
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {}
                int n2 = mWTextField == ArrayEditor.this.fWidthField ? ArrayEditor.this.fArrayView.getVarWidth() : ArrayEditor.this.fArrayView.getVarHeight();
                if (n >= 0) {
                    if (n < n2) {
                        bl = false;
                        this.fField = mWTextField;
                        this.fNewValue = n;
                        this.fOldValue = n2;
                        Thread thread = new Thread((Runnable)this, "Array Editor Alert Thread");
                        thread.start();
                    } else if (n != n2) {
                        if (mWTextField == ArrayEditor.this.fWidthField) {
                            ArrayEditor.this.fArrayView.setVarWidth(n);
                        } else {
                            ArrayEditor.this.fArrayView.setVarHeight(n);
                        }
                    }
                } else {
                    mWTextField.setText(Integer.toString(n2));
                }
                this.fDealingWithIt = !bl;
            }
        }

        SizeChanger() {
            ArrayEditor.this = ArrayEditor.this;
        }
    }

    private class FormatChanger
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            FormatChoice formatChoice = (FormatChoice)itemEvent.getItemSelectable();
            ArrayEditor.this.fArrayView.setFormat(formatChoice.getFormat());
            ArrayEditor.this.fArrayView.requestFocus();
        }

        FormatChanger() {
            ArrayEditor.this = ArrayEditor.this;
        }
    }
}

