/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide;

import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWChoice;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTList;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.mwt.window.MWWindowResizer;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowListener;
import java.lang.reflect.Method;

public class DemoIDE
extends MWPanel
implements ActionListener,
ItemListener {
    private MWTList fDemoList;
    private MWButton fLaunchButton;
    private MWButton fQuitButton;
    private MWChoice fAppearanceMenu;

    private void launchItems() {
        int n = this.fDemoList.getFirstSelectedItem();
        while (n != -1) {
            String string = this.fDemoList.getItemString(n);
            try {
                Class<?> clazz = Class.forName(string);
                Class[] classArray = new Class[]{Class.forName("[Ljava.lang.String;")};
                Method method = clazz.getMethod("main", classArray);
                Object[] objectArray = new Object[]{new String[0]};
                method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            n = this.fDemoList.getNextSelectedItem(n);
        }
    }

    private void appearanceChange() {
        int n = this.fAppearanceMenu.getSelectedIndex();
        if (n == 0) {
            PlatformInfo.setAppearance((int)1);
            return;
        }
        if (n == 1) {
            PlatformInfo.setAppearance((int)2);
            return;
        }
        if (n == 2) {
            PlatformInfo.setAppearance((int)0);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Launch") {
            this.launchItems();
            return;
        }
        if (string == "Quit") {
            System.exit(0);
            return;
        }
        if (string == "Garbage") {
            System.gc();
            System.runFinalization();
        }
    }

    private void hiliteLaunchButton() {
        this.fLaunchButton.setEnabled(this.fDemoList.hasSelection());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this.fDemoList) {
            this.hiliteLaunchButton();
            return;
        }
        if (itemEvent.getItemSelectable() == this.fAppearanceMenu) {
            this.appearanceChange();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.hiliteLaunchButton();
        } else {
            this.fLaunchButton.setEnabled(bl);
        }
        if (this.fQuitButton != null) {
            this.fQuitButton.setEnabled(bl);
        }
        this.fAppearanceMenu.setEnabled(bl);
    }

    public Insets getInsets() {
        return new Insets(0, 5, 0, 5);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void populateList() {
        this.fDemoList.add("com.mathworks.ide.desktop.MLDesktop");
        this.fDemoList.add("com.mathworks.ide.browsers.PathBrowser");
        this.fDemoList.add("com.mathworks.ide.browsers.FileBrowser");
        this.fDemoList.add("com.mathworks.ide.editor.EditorApplication");
        this.fDemoList.add("com.mathworks.ide.layout.LayoutEditor");
        this.fDemoList.add("com.mathworks.ide.inspector.Inspector");
        this.fDemoList.add("com.mathworks.ide.objectbrowser.ObjectBrowser");
        this.fDemoList.add("com.mathworks.ide.workspace.WorkspaceBrowser");
        this.fDemoList.add("com.mathworks.ide.help.HelpBrowser");
        this.fDemoList.add("com.mathworks.test.ThreadList");
        this.fDemoList.add("com.mathworks.test.PropertyList");
        this.fDemoList.add("com.mathworks.test.ObjectRegistrySniffer");
    }

    private void initializeAppearance() {
        int n = PlatformInfo.getAppearance();
        if (n == 1) {
            this.fAppearanceMenu.select(0);
            return;
        }
        if (n == 2) {
            this.fAppearanceMenu.select(1);
            return;
        }
        if (n == 0) {
            this.fAppearanceMenu.select(2);
        }
    }

    public DemoIDE() {
        this.setOpaque(false);
        ((Component)((Object)this)).setSize(400, 300);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.fDemoList = new MWTList();
        this.fDemoList.addActionListener((ActionListener)this);
        this.fDemoList.setActionCommand("Launch");
        this.fDemoList.addItemListener((ItemListener)this);
        this.fDemoList.setWholeItemHilite(true);
        this.fDemoList.setWholeItemSelect(true);
        this.fDemoList.setHiliteItemHilite(true);
        this.fDemoList.setMultiSelection(true);
        this.fDemoList.setHeader("Pick an application:");
        this.fDemoList.setFont(new Font("Dialog", 0, 12));
        ((Container)((Object)this)).add((Component)this.fDemoList, "Center");
        MWPanel mWPanel = new MWPanel();
        mWPanel.setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)mWPanel, "South");
        MWPanel mWPanel2 = new MWPanel();
        mWPanel2.setLayout(new FlowLayout(0));
        mWPanel.add((Component)mWPanel2, "West");
        MWPanel mWPanel3 = new MWPanel();
        mWPanel3.setLayout(new FlowLayout(2));
        mWPanel.add((Component)mWPanel3, "East");
        this.fAppearanceMenu = new MWChoice();
        this.fAppearanceMenu.add("Windows");
        this.fAppearanceMenu.add("Unix");
        this.fAppearanceMenu.add("Macintosh");
        this.fAppearanceMenu.addItemListener((ItemListener)this);
        this.fAppearanceMenu.setEnabled(true);
        mWPanel2.add((Component)this.fAppearanceMenu);
        if (PlatformInfo.getPlatform() == 0) {
            this.fQuitButton = new MWButton("Garbage");
            this.fQuitButton.addActionListener((ActionListener)this);
            this.fQuitButton.setEnabled(true);
            this.fQuitButton.setActionCommand("Garbage");
            mWPanel3.add((Component)this.fQuitButton);
        } else {
            this.fQuitButton = new MWButton("Quit");
            this.fQuitButton.addActionListener((ActionListener)this);
            this.fQuitButton.setEnabled(true);
            this.fQuitButton.setActionCommand("Quit");
            mWPanel3.add((Component)this.fQuitButton);
        }
        this.fLaunchButton = new MWButton("Launch");
        this.fLaunchButton.addActionListener((ActionListener)this);
        this.fLaunchButton.setEnabled(false);
        this.fLaunchButton.setActionCommand("Launch");
        mWPanel3.add((Component)this.fLaunchButton);
        this.populateList();
        this.initializeAppearance();
    }

    public static void main(String[] stringArray) {
        MWFrame mWFrame = new MWFrame("Demo IDE");
        mWFrame.setSize(400, 300);
        DemoIDE demoIDE = new DemoIDE();
        mWFrame.add((Component)((Object)demoIDE), "Center");
        mWFrame.addWindowListener((WindowListener)new MWWindowActivater((Component)((Object)demoIDE)));
        mWFrame.addComponentListener((ComponentListener)new MWWindowResizer(300, 120));
        mWFrame.show();
    }
}

