/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide;

import com.mathworks.ide.QuitListener;
import com.mathworks.ide.desktop.DTApplication;
import com.mathworks.ide.desktop.DTMenu;
import com.mathworks.ide.desktop.DTMenuBar;
import com.mathworks.ide.editor.EditorApplication;
import com.mathworks.ide.prefs.GeneralPrefsColorPanel;
import com.mathworks.ide.widgets.Highlighter;
import com.mathworks.ide.widgets.MatlabCommandWidget;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWMenu;
import com.mathworks.mwt.MWMenuBar;
import com.mathworks.mwt.MWMenuComponent;
import com.mathworks.mwt.MWMenuItem;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTList;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.command.MWCommandCenterOwner;
import com.mathworks.mwt.command.MWCommandSource;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.dialog.MWAlert;
import com.mathworks.mwt.dnd.DragItem;
import com.mathworks.mwt.dnd.StringsSelection;
import com.mathworks.mwt.window.MWWindowHider;
import com.mathworks.mwt.window.MWWindowOwner;
import com.mathworks.mwt.window.MWWindowResizer;
import com.mathworks.mwt.window.WindowRegistry;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.XSelection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class CommandHistory
extends MWPanel
implements ComponentListener,
MWCommandCenterOwner,
MWCommandTarget,
MWWindowOwner,
DTApplication {
    public static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.ide.resources.RES_CommandHistory");
    public static final int NO_ITEM = -1;
    private static final int CREATE_MFILE = 100;
    private static final int DELETE_SEL = 101;
    private static final int DELETE_TO_HERE = 102;
    private static final int DELETE_ALL = 103;
    private static final String HISTORY_FILE_NAME = "history.m";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String MY_NAME = sRes.getString("CommandHistory");
    private static final int HISTORY_SIZE = 20000;
    private static CommandHistory sTheHistory = null;
    private MWFrame fFrame;
    private HistoryList fHistoryList;
    private MWCommandCenter fCenter;
    private boolean fFirstPaint;
    private boolean fSelfExecuting;
    private MWMenu fContextMenu;

    public static CommandHistory getInstance() {
        return sTheHistory;
    }

    public static int getPriorHistoryMatch(String string, int n) {
        if (sTheHistory == null) {
            new CommandHistory();
            return CommandHistory.getPriorHistoryMatch(string, n);
        }
        int n2 = n == -1 ? CommandHistory.sTheHistory.fHistoryList.getLastItem() : CommandHistory.sTheHistory.fHistoryList.getPreviousItem(n);
        while (n2 != -1) {
            String string2 = CommandHistory.sTheHistory.fHistoryList.getItemString(n2);
            if (string2.regionMatches(false, 0, string, 0, string.length())) {
                return n2;
            }
            n2 = CommandHistory.sTheHistory.fHistoryList.getPreviousItem(n2);
        }
        return -1;
    }

    public static int getNextHistoryMatch(String string, int n) {
        if (sTheHistory == null) {
            new CommandHistory();
            return CommandHistory.getNextHistoryMatch(string, n);
        }
        if (n == -1) {
            return -1;
        }
        int n2 = CommandHistory.sTheHistory.fHistoryList.getNextItem(n);
        while (n2 != -1) {
            String string2 = CommandHistory.sTheHistory.fHistoryList.getItemString(n2);
            if (string2.regionMatches(false, 0, string, 0, string.length())) {
                return n2;
            }
            n2 = CommandHistory.sTheHistory.fHistoryList.getNextItem(n2);
        }
        return -1;
    }

    public static String getHistoryLine(int n) {
        if (sTheHistory == null) {
            new CommandHistory();
            return CommandHistory.getHistoryLine(n);
        }
        return CommandHistory.sTheHistory.fHistoryList.getItemString(n);
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.fHistoryList.showBottom();
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.fHistoryList.hasSelection()) {
            this.fHistoryList.showLastSelectedItem();
            return;
        }
        this.fHistoryList.showBottom();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.fHistoryList.setEnabled(bl);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.fFirstPaint) {
            this.fFirstPaint = false;
            this.fHistoryList.showBottom();
            this.fHistoryList.remove(this.fHistoryList.getLastItem());
        }
        super.paint(graphics);
    }

    public static void quit() {
        if (sTheHistory != null) {
            sTheHistory.saveHistory();
            sTheHistory = null;
        }
    }

    public int closeWindow() {
        return 0;
    }

    public void setActive(boolean bl) {
        if (bl) {
            ((Component)((Object)this.fHistoryList)).requestFocus();
        }
    }

    public String getShortName() {
        return MY_NAME;
    }

    public String getLongName() {
        return MY_NAME;
    }

    public MWCommandCenter getCommandCenter() {
        return this.fCenter;
    }

    public int desktopSaveAction() {
        return 1;
    }

    public void restoreState(DataInputStream dataInputStream) {
    }

    public void saveState(DataOutputStream dataOutputStream) {
    }

    public String getSplayConstraint() {
        return "";
    }

    public int getApplicationType() {
        return 0;
    }

    public MWMenuBar mergeMenus(MWMenuBar mWMenuBar) {
        int n = 0;
        while (n < mWMenuBar.getMenuCount()) {
            DTMenu dTMenu;
            MWMenu mWMenu = mWMenuBar.getMenu(n);
            if (mWMenu instanceof DTMenu && ((dTMenu = (DTMenu)mWMenu).getLabel().equals(DTMenuBar.sRes.getString("menu.Edit")) || dTMenu.getLabel().equals(DTMenuBar.sRes.getString("menu.EditNoAmpersand")))) {
                dTMenu.addMenuItem(this.fCenter, 910);
                dTMenu.addMenuItem(this.fCenter, 1060);
            }
            ++n;
        }
        return mWMenuBar;
    }

    private void doCut() {
        this.doCopy();
        this.doClear();
    }

    private void doCopy() {
        String string = "";
        String[] stringArray = (String[])this.fHistoryList.getSelectedObjects();
        int n = 0;
        while (n < stringArray.length) {
            string = String.valueOf(string) + stringArray[n];
            if (n < stringArray.length - 1) {
                string = String.valueOf(string) + "\n";
            }
            ++n;
        }
        if (string.length() > 0) {
            if (PlatformInfo.isUnix()) {
                XSelection.setSelection((String)string);
                return;
            }
            StringSelection stringSelection = new StringSelection(string);
            ((Component)((Object)this)).getToolkit().getSystemClipboard().setContents(stringSelection, null);
        }
    }

    private void doClear() {
        int[] nArray = this.fHistoryList.getSelectedIds();
        int n = 0;
        while (n < nArray.length) {
            this.fHistoryList.remove(nArray[n]);
            ++n;
        }
    }

    private void doCreateMFile() {
        String string = "";
        String[] stringArray = (String[])this.fHistoryList.getSelectedObjects();
        int n = 0;
        while (n < stringArray.length) {
            string = String.valueOf(string) + stringArray[n];
            if (n < stringArray.length - 1) {
                string = String.valueOf(string) + NEWLINE;
            }
            ++n;
        }
        EditorApplication.newDocumentWithString(string);
    }

    private void doDeleteToHere() {
        int n = this.fHistoryList.getFirstSelectedItem();
        int[] nArray = this.fHistoryList.getChildren(-1);
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) break;
            this.fHistoryList.remove(nArray[n2]);
            ++n2;
        }
    }

    public static void deleteAllHistory() {
        if (sTheHistory == null) {
            new CommandHistory();
        }
        CommandHistory.sTheHistory.fHistoryList.removeAll();
    }

    private void doDeleteAll() {
        MWAlert mWAlert = new MWAlert(this.getFrame(), MY_NAME, sRes.getString("AreYouSureDeleteEntireHistory"), 3);
        if (mWAlert.getReply() == 1) {
            this.fHistoryList.removeAll();
        }
    }

    private void doSelectAll() {
        int n = this.fHistoryList.getFirstItem();
        while (n != -1) {
            this.fHistoryList.selectItem(n);
            n = this.fHistoryList.getNextItem();
        }
    }

    public void doCommand(int n) {
        if (this.fCenter.getCommandEnabled(n)) {
            switch (n) {
                case -203: {
                    this.doCut();
                    break;
                }
                case -204: 
                case 910: {
                    this.doCopy();
                    break;
                }
                case -206: {
                    this.doClear();
                    break;
                }
                case 1502: {
                    this.evalHistoryItems();
                    break;
                }
                case 100: {
                    this.doCreateMFile();
                    break;
                }
                case 101: {
                    this.doClear();
                    break;
                }
                case 102: {
                    this.doDeleteToHere();
                    break;
                }
                case 103: {
                    this.doDeleteAll();
                    break;
                }
                case 1060: {
                    this.doSelectAll();
                    break;
                }
            }
            this.enableSelectionDependentCommands();
        }
    }

    public static void addLine(String string) {
        if (sTheHistory == null) {
            new CommandHistory();
            CommandHistory.addLine(string);
            return;
        }
        if (string.equals("")) {
            return;
        }
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3 = n;
            while (n < n2 && string.charAt(n) != '\n' && string.charAt(n) != '\r') {
                ++n;
            }
            String string2 = string.substring(n3, n).trim();
            while (n < n2 && (string.charAt(n) == '\n' || string.charAt(n) == '\r')) {
                ++n;
            }
            if (string2.length() <= 0) continue;
            CommandHistory.sTheHistory.fHistoryList.add(new String(string2));
        }
        if (!CommandHistory.sTheHistory.fSelfExecuting) {
            CommandHistory.sTheHistory.fHistoryList.showBottom();
            return;
        }
        CommandHistory.sTheHistory.fSelfExecuting = false;
    }

    private void evalHistoryItems() {
        String[] stringArray = (String[])this.fHistoryList.getSelectedObjects();
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            string = String.valueOf(string) + stringArray[n] + NEWLINE;
            ++n;
        }
        this.fSelfExecuting = true;
        MatlabCommandWidget.executeCommand(string);
    }

    private File getHistoryFile() {
        return new File(Prefs.getPropertyDirectory(), HISTORY_FILE_NAME);
    }

    /*
     * Unable to fully structure code
     */
    private void loadHistory() {
        block10: {
            var7_1 = this.getHistoryFile();
            if (!var7_1.exists()) break block10;
            try {
                var1_2 = new RandomAccessFile(var7_1, "r");
                var5_3 = var1_2.length();
                if (var5_3 > 20000L) {
                    var1_2.seek(var5_3 - 20000L);
                    var5_3 = 20000L;
                    var8_4 = true;
                } else {
                    var8_4 = false;
                }
                var2_5 = new byte[(int)var5_3];
                var1_2.read(var2_5);
                var1_2.close();
                var3_6 = 0;
                if (var8_4) {
                    while (var3_6 < var2_5.length && var2_5[var3_6] != 10 && var2_5[var3_6] != 13) {
                        ++var3_6;
                    }
                    while (var3_6 < var2_5.length && (var2_5[var3_6] == 10 || var2_5[var3_6] == 13)) {
                        ++var3_6;
                    }
                }
                var4_7 = var3_6;
                ** GOTO lbl34
                {
                    ++var3_6;
                    do {
                        if (var3_6 < var2_5.length && var2_5[var3_6] != 10 && var2_5[var3_6] != 13) continue block4;
                        this.fHistoryList.add(new String(var2_5, var4_7, var3_6 - var4_7));
                        while (var3_6 < var2_5.length && (var2_5[var3_6] == 10 || var2_5[var3_6] == 13)) {
                            ++var3_6;
                        }
                        var4_7 = var3_6;
lbl34:
                        // 2 sources

                    } while (var3_6 < var2_5.length);
                }
            }
            catch (Exception v0) {}
        }
        this.addStartingTagLine();
        this.fHistoryList.add("  ");
    }

    private void saveHistory() {
        File file = this.getHistoryFile();
        try {
            file.delete();
            FileWriter fileWriter = new FileWriter(file);
            int n = this.fHistoryList.getFirstItem();
            while (n != -1) {
                String string = this.fHistoryList.getItemString(n);
                fileWriter.write(string, 0, string.length());
                fileWriter.write(NEWLINE);
                n = this.fHistoryList.getNextItem();
            }
            fileWriter.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void addStartingTagLine() {
        String string = NativeMatlab.getHistoryDate();
        if (string != null && !string.equals("")) {
            this.fHistoryList.add(string);
            return;
        }
        Date date = new Date();
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        dateFormat.setTimeZone(TimeZone.getDefault());
        String string2 = dateFormat.format(date);
        dateFormat = DateFormat.getTimeInstance(3);
        dateFormat.setTimeZone(TimeZone.getDefault());
        String string3 = dateFormat.format(date);
        if (string3.length() == 7) {
            string3 = " " + string3;
        }
        this.fHistoryList.add("%-- " + string3 + " " + string2 + " --%");
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fHistoryList.setFont(font);
        ((Component)((Object)this)).repaint();
    }

    private void createContextMenu() {
        this.fContextMenu = new MWMenu(sRes.getString("CommandHistory"));
        MWMenuItem mWMenuItem = new MWMenuItem(sRes.getString("Copy"));
        this.getCommandCenter().addCommandSource((MWCommandSource)mWMenuItem, -204);
        this.fContextMenu.add((MWMenuComponent)mWMenuItem);
        mWMenuItem = new MWMenuItem(sRes.getString("EvaluateSelection"));
        this.getCommandCenter().addCommandSource((MWCommandSource)mWMenuItem, 1502);
        this.fContextMenu.add((MWMenuComponent)mWMenuItem);
        mWMenuItem = new MWMenuItem(sRes.getString("CreateMFile"));
        this.getCommandCenter().addCommandSource((MWCommandSource)mWMenuItem, 100);
        this.fContextMenu.add((MWMenuComponent)mWMenuItem);
        this.fContextMenu.addSeparator();
        mWMenuItem = new MWMenuItem(sRes.getString("DeleteSelection"));
        this.getCommandCenter().addCommandSource((MWCommandSource)mWMenuItem, 101);
        this.fContextMenu.add((MWMenuComponent)mWMenuItem);
        mWMenuItem = new MWMenuItem(sRes.getString("DeletetoSelection"));
        this.getCommandCenter().addCommandSource((MWCommandSource)mWMenuItem, 102);
        this.fContextMenu.add((MWMenuComponent)mWMenuItem);
        mWMenuItem = new MWMenuItem(sRes.getString("DeleteEntireHistory"));
        this.getCommandCenter().addCommandSource((MWCommandSource)mWMenuItem, 103);
        this.fContextMenu.add((MWMenuComponent)mWMenuItem);
        this.fContextMenu.attachTo((Component)((Object)this));
    }

    private void doContextMenu(MouseEvent mouseEvent) {
        this.fContextMenu.show((Component)((Object)this), mouseEvent.getX(), mouseEvent.getY());
    }

    private void enableSelectionDependentCommands() {
        boolean bl = this.fHistoryList.hasSelection();
        this.getCommandCenter().setCommandEnabled(-204, bl);
        this.getCommandCenter().setCommandEnabled(910, bl);
        this.getCommandCenter().setCommandEnabled(1502, bl);
        this.getCommandCenter().setCommandEnabled(132, bl);
        this.getCommandCenter().setCommandEnabled(100, bl);
        this.getCommandCenter().setCommandEnabled(101, bl);
        this.getCommandCenter().setCommandEnabled(102, bl);
    }

    public CommandHistory() {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.setOpaque(false);
        this.fHistoryList = new HistoryList();
        ((Container)((Object)this)).add((Component)((Object)this.fHistoryList), "Center");
        ((Component)((Object)this.fHistoryList)).addMouseListener(new HistoryListMouseAdapter());
        this.fHistoryList.setWholeItemSelect(true);
        this.fHistoryList.setWholeItemHilite(true);
        this.fHistoryList.setMultiSelection(true);
        this.fHistoryList.setImmediateClick(true);
        this.fHistoryList.setFont(Prefs.getFontPref((String)"GeneralFont", (Font)new Font("Monospaced", 0, 10)));
        this.fHistoryList.addItemListener(new SelChangeListener());
        ((Component)((Object)this.fHistoryList)).addComponentListener(this);
        this.fCenter = new MWCommandCenter((MWCommandTarget)this);
        this.fCenter.addCommand(-203, true, 88);
        this.fCenter.addCommand(-204, true, 67);
        this.fCenter.addCommand(-206, true, 12);
        this.createContextMenu();
        this.loadHistory();
        Matlab.addListener((MatlabListener)new QuitListener());
        Prefs.addListener((PrefListener)new FontChangeListener(), (String)"GeneralFont");
        sTheHistory = this;
        this.fFirstPaint = true;
        this.fSelfExecuting = false;
        this.enableSelectionDependentCommands();
    }

    public CommandHistory(MWFrame mWFrame) {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.setOpaque(false);
        this.fFrame = mWFrame;
        this.fFrame.addComponentListener(this);
        this.fHistoryList = new HistoryList();
        ((Container)((Object)this)).add((Component)((Object)this.fHistoryList), "Center");
        ((Component)((Object)this.fHistoryList)).addMouseListener(new HistoryListMouseAdapter());
        this.fHistoryList.setWholeItemSelect(true);
        this.fHistoryList.setWholeItemHilite(true);
        this.fHistoryList.setMultiSelection(true);
        this.fHistoryList.setFont(Prefs.getFontPref((String)"GeneralFont", (Font)new Font("Monospaced", 0, 10)));
        this.fHistoryList.addItemListener(new SelChangeListener());
        this.fCenter = new MWCommandCenter((MWCommandTarget)this);
        this.fCenter.addCommand(-203, true, 88);
        this.fCenter.addCommand(-204, true, 67);
        this.fCenter.addCommand(-206, true, 12);
        this.createContextMenu();
        this.loadHistory();
        Matlab.addListener((MatlabListener)new QuitListener());
        Prefs.addListener((PrefListener)new FontChangeListener(), (String)"GeneralFont");
        if (this.fFrame != null) {
            WindowRegistry.getRegistry().register((MWWindowOwner)this);
        }
        sTheHistory = this;
        this.enableSelectionDependentCommands();
    }

    public static void main(String[] stringArray) {
        if (sTheHistory == null) {
            try {
                MWFrame mWFrame = new MWFrame(MY_NAME);
                mWFrame.setSize(200, 300);
                sTheHistory = new CommandHistory(mWFrame);
                mWFrame.add((Component)((Object)sTheHistory), "Center");
                mWFrame.addWindowListener((WindowListener)new MWWindowHider((Component)((Object)sTheHistory)));
                mWFrame.addComponentListener((ComponentListener)new MWWindowResizer(100, 100, true));
                mWFrame.setVisible(true);
                mWFrame.toBack();
                return;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return;
            }
        }
    }

    private class HistoryListMouseAdapter
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (PlatformInfo.getPlatform() == 2) {
                this.doStuff(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (PlatformInfo.getPlatform() != 2) {
                this.doStuff(mouseEvent);
            }
        }

        public void doStuff(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                CommandHistory.this.doContextMenu(mouseEvent);
                return;
            }
            if (mouseEvent.getClickCount() == 2) {
                CommandHistory.this.evalHistoryItems();
            }
        }

        HistoryListMouseAdapter() {
            CommandHistory.this = CommandHistory.this;
        }
    }

    private class FontChangeListener
    implements PrefListener {
        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getEventType() == 1) {
                CommandHistory.this.setFont(Prefs.getFontPref((String)"GeneralFont"));
            }
        }

        FontChangeListener() {
            CommandHistory.this = CommandHistory.this;
        }
    }

    private class SelChangeListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            CommandHistory.this.enableSelectionDependentCommands();
        }

        SelChangeListener() {
            CommandHistory.this = CommandHistory.this;
        }
    }

    private class HistoryList
    extends MWTList
    implements PrefListener {
        private Color fCommentColor = this.getCommentColorPref();

        public HistoryList() {
            CommandHistory.this = CommandHistory.this;
            Prefs.addListener((PrefListener)this, (String)("Syncolor" + Highlighter.CATEGORIES[2]));
        }

        private Color getCommentColorPref() {
            Color color;
            block2: {
                Color color2 = GeneralPrefsColorPanel.getSyntaxHighlightingStyles()[2].getColor();
                String string = Prefs.getStringPref((String)("Syncolor" + Highlighter.CATEGORIES[2]), (String)new Integer(color2.getRGB()).toString());
                color = SystemColor.textText;
                if (string == null || string.equals("Automatic")) break block2;
                try {
                    color = Color.decode(string);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return color;
        }

        public void prefChanged(PrefEvent prefEvent) {
            Color color = this.getCommentColorPref();
            if (!this.fCommentColor.equals(color)) {
                this.fCommentColor = new Color(color.getRGB());
                ((Component)((Object)this)).repaint(5L);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 127 || n == 8) {
                CommandHistory.this.doCommand(-206);
                return;
            }
            if (n == 10) {
                CommandHistory.this.evalHistoryItems();
                return;
            }
            super.keyPressed(keyEvent);
        }

        public boolean clickItem(MouseEvent mouseEvent, int n, int n2, Rectangle rectangle) {
            int[] nArray;
            if (mouseEvent.isPopupTrigger()) {
                return !PlatformInfo.isUnix();
            }
            if (this.isSelected(n) && (nArray = this.getSelectedIds()).length > 0) {
                if (nArray.length > 1) {
                    Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
                    String[] stringArray = new String[nArray.length];
                    int n3 = 0;
                    while (n3 < nArray.length) {
                        stringArray[n3] = this.getItemString(nArray[n3]);
                        Rectangle rectangle3 = this.getItemRect(nArray[n3], 0);
                        if (rectangle2.width == 0) {
                            rectangle2.x = rectangle3.x;
                            rectangle2.y = rectangle3.y;
                            rectangle2.width = rectangle3.width;
                            rectangle2.height = rectangle3.height;
                        } else {
                            if (rectangle3.y < rectangle2.y) {
                                rectangle2.y = rectangle3.y;
                            }
                            if (rectangle3.y + rectangle3.height > rectangle2.y + rectangle2.height) {
                                rectangle2.height = rectangle3.y + rectangle3.height - rectangle2.y;
                            }
                        }
                        ++n3;
                    }
                    if (rectangle2.width > ((Component)((Object)this)).getBounds().width) {
                        rectangle2.width = ((Component)((Object)this)).getBounds().width;
                    }
                    StringsSelection stringsSelection = new StringsSelection(stringArray);
                    new DragItem((Component)((Object)this), rectangle2, mouseEvent.getPoint(), (Transferable)stringsSelection);
                } else {
                    Rectangle rectangle4 = new Rectangle(rectangle);
                    if (rectangle4.width > ((Component)((Object)this)).getBounds().width) {
                        rectangle4.width = ((Component)((Object)this)).getBounds().width;
                    }
                    StringSelection stringSelection = new StringSelection(this.getItemString(n));
                    new DragItem((Component)((Object)this), rectangle4, mouseEvent.getPoint(), (Transferable)stringSelection);
                }
            }
            return false;
        }

        public void drawItem(Graphics graphics, int n, int n2, Rectangle rectangle, boolean bl) {
            String string = this.getItemString(n, n2);
            if (this.isSelected(n)) {
                if (bl) {
                    graphics.setColor(Decorations.getColor((int)5));
                } else {
                    graphics.setColor(Color.black);
                }
            } else if (string.charAt(0) == '%') {
                graphics.setColor(this.fCommentColor);
            }
            int n3 = rectangle.x;
            FontMetrics fontMetrics = ((Component)((Object)this)).getFontMetrics(this.getFont());
            int n4 = rectangle.y + (this.getCellHeight() - fontMetrics.getAscent() - fontMetrics.getDescent()) / 2 + 1 + fontMetrics.getAscent();
            graphics.drawString(string, n3, n4);
        }
    }
}

