/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.beans.editors.ApplyPropertyEditor;
import com.mathworks.beans.editors.EnhancedPropertyEditor;
import com.mathworks.hg.types.HGLineStyles;
import com.mathworks.hg.types.HGLineStylesEditPanel;
import com.mathworks.util.ResLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;

public class HGLineStylesEditor
extends PropertyEditorSupport
implements EnhancedPropertyEditor,
ApplyPropertyEditor {
    private static final String ICON = "resources/LineStylesIconColor16.gif";
    private static Image sIcon = null;
    private HGLineStylesEditPanel fEditPanel;

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        HGLineStyles hGLineStyles = (HGLineStyles)this.getValue();
        if (hGLineStyles != null) {
            Rectangle rectangle2 = new Rectangle(rectangle);
            rectangle2.grow(-3, -2);
            if (rectangle2.width > 60) {
                rectangle2.width = 60;
            }
            graphics.setColor(Color.black);
            graphics.drawLine(rectangle2.x + 1, rectangle2.y + rectangle2.height / 2, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height / 2);
            graphics.drawLine(rectangle2.x + 1, rectangle2.y + rectangle2.height / 2 + 1, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height / 2 + 1);
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        this.fEditPanel = new HGLineStylesEditPanel((HGLineStyles)this.getValue());
        return this.fEditPanel;
    }

    public void apply() {
        if (this.fEditPanel != null) {
            this.setValue(this.fEditPanel.getData());
        }
    }

    public boolean hasAttachedData() {
        return false;
    }

    public String getDataKey() {
        return null;
    }

    public void setData(Object object) {
    }

    public void setFrame(Frame frame) {
    }

    public Image getIcon() {
        if (sIcon == null) {
            ResLoader resLoader = new ResLoader(this.getClass());
            sIcon = resLoader.loadImage(ICON);
        }
        return sIcon;
    }
}

