/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.hg.types.EditPanelWithTable;
import com.mathworks.hg.types.HGLineStyleEnum;
import com.mathworks.hg.types.HGLineStyles;
import com.mathworks.hg.types.HGMarkerStyleEnum;
import com.mathworks.mwt.table.Style;
import com.mathworks.util.IntVector;

public class HGLineStylesEditPanel
extends EditPanelWithTable {
    private IntVector fLines = new IntVector(15, 20);
    private IntVector fMarkers = new IntVector(15, 20);
    private static final int LINE_COL = 0;
    private static final int MARKER_COL = 2;
    private static final int SEL_COL = 1;
    private static final int NUM_COL = 3;

    public HGLineStylesEditPanel(HGLineStyles hGLineStyles) {
        super(10, 3);
        Style style = new Style(256);
        style.setHAlignment(1);
        int n = 0;
        while (n < 3) {
            this.getTable().setColumnStyle(n, style);
            ++n;
        }
        this.getTable().getColumnOptions().setDefaultWidth(120);
        this.getTable().setColumnWidth(2, 50);
        this.getTable().setColumnWidth(1, 15);
        this.getTable().getColumnOptions().setHeaderVisible(true);
        this.getTable().getColumnOptions().setResizable(false);
        this.getTable().setColumnHeaderData(0, (Object)"Line Style");
        this.getTable().setColumnHeaderData(2, (Object)"Marker Style");
        if (hGLineStyles != null) {
            int n2;
            int[] nArray = hGLineStyles.getLineStyles();
            if (nArray != null) {
                n2 = 0;
                while (n2 < nArray.length) {
                    this.fLines.addElement(nArray[n2]);
                    ++n2;
                }
            }
            if ((nArray = hGLineStyles.getMarkers()) != null) {
                n2 = 0;
                while (n2 < nArray.length) {
                    this.fMarkers.addElement(nArray[n2]);
                    ++n2;
                }
            }
        }
        int n3 = Math.max(this.fLines.getSize(), this.fMarkers.getSize());
        Object[] objectArray = new Object[3];
        int n4 = 0;
        while (n4 < n3) {
            objectArray[0] = n4 < this.fLines.getSize() ? new HGLineStyleEnum(this.fLines.elementAt(n4)) : new HGLineStyleEnum();
            objectArray[2] = n4 < this.fMarkers.getSize() ? new HGMarkerStyleEnum(this.fMarkers.elementAt(n4)) : new HGMarkerStyleEnum();
            this.addDataRow(n4, objectArray);
            ++n4;
        }
    }

    public HGLineStyles getData() {
        int[] nArray = new int[this.fLines.getSize()];
        this.fLines.copyInto(nArray);
        int[] nArray2 = new int[this.fMarkers.getSize()];
        this.fMarkers.copyInto(nArray2);
        return new HGLineStyles(nArray, nArray2);
    }

    public void doAppend() {
        if (this.fLines.getSize() == 0) {
            this.fLines.addElement(0);
            this.fMarkers.addElement(13);
        } else {
            this.fLines.addElement(this.fLines.lastElement());
            this.fMarkers.addElement(this.fMarkers.lastElement());
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = new HGLineStyleEnum(this.fLines.lastElement());
        objectArray[2] = new HGMarkerStyleEnum(this.fMarkers.lastElement());
        this.addDataRow(this.getLastRowIndex() + 1, objectArray);
    }

    public void doInsert(int n) {
        this.fLines.insertElementAt(this.fLines.elementAt(n), n);
        this.fMarkers.insertElementAt(this.fMarkers.elementAt(n), n);
        Object[] objectArray = new Object[3];
        objectArray[0] = new HGLineStyleEnum(this.fLines.elementAt(n));
        objectArray[2] = new HGMarkerStyleEnum(this.fMarkers.elementAt(n));
        this.addDataRow(n, objectArray);
    }

    public void doDelete(int n) {
        this.fLines.removeElementAt(n);
        this.fMarkers.removeElementAt(n);
    }

    public boolean valueChanged(int n, int n2, Object object) {
        if (n2 == 0) {
            this.fLines.setElementAt(((HGLineStyleEnum)((Object)object)).getCurrentValue(), n);
        } else if (n2 == 2) {
            this.fMarkers.setElementAt(((HGMarkerStyleEnum)((Object)object)).getCurrentValue(), n);
        }
        return true;
    }
}

