/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.beans.editors.ColorPicker;
import com.mathworks.beans.editors.MWPropertyEditorSupport;
import com.mathworks.hg.types.HGColor;
import com.mathworks.util.ResLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;

public class HGColorEditor
extends MWPropertyEditorSupport {
    private static final int COLOR_PICKER_STEPS = 1000;
    private static final String ICON = "/com/mathworks/beans/editors/resources/ColorIcon.gif";
    private static Image sIcon = null;
    private ColorPicker fPicker = null;

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        HGColor hGColor = (HGColor)((PropertyEditorSupport)((Object)this)).getValue();
        rectangle2.grow(-3, -2);
        if (rectangle2.width > 60) {
            rectangle2.width = 60;
        }
        if (hGColor != null) {
            int n = (int)(hGColor.getRed() * 255.0);
            int n2 = (int)(hGColor.getGreen() * 255.0);
            int n3 = (int)(hGColor.getBlue() * 255.0);
            if (n < 0) {
                n = 0;
            } else if (n > 255) {
                n = 255;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > 255) {
                n2 = 255;
            }
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 > 255) {
                n3 = 255;
            }
            graphics.setColor(new Color(n, n2, n3));
            graphics.fillRect(rectangle2.x + 1, rectangle2.y + 1, rectangle2.width - 2, rectangle2.height - 2);
            graphics.setColor(Color.black);
            graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
            graphics.setColor(Color.darkGray);
            graphics.drawLine(rectangle2.x + 1, rectangle2.y + rectangle2.height, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
            graphics.drawLine(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, rectangle2.x + rectangle2.width, rectangle2.y + 1);
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        HGColor hGColor;
        if (this.fPicker == null) {
            this.fPicker = new ColorPicker(0, 0, 0, 1000);
        }
        if ((hGColor = (HGColor)((PropertyEditorSupport)((Object)this)).getValue()) != null) {
            int n = (int)(hGColor.getRed() * 1000.0);
            int n2 = (int)(hGColor.getGreen() * 1000.0);
            int n3 = (int)(hGColor.getBlue() * 1000.0);
            this.fPicker.setSelectedColor(n, n2, n3);
            this.fPicker.setInitialColor(n, n2, n3);
        } else {
            this.fPicker.setSelectedColor(0, 0, 0);
            this.fPicker.setInitialColor(0, 0, 0);
        }
        return this.fPicker;
    }

    public Image getIcon() {
        if (sIcon == null) {
            ResLoader resLoader = new ResLoader(((Object)((Object)this)).getClass());
            sIcon = resLoader.loadImage(ICON);
        }
        return sIcon;
    }

    public boolean canExpand() {
        return true;
    }

    public boolean canApply() {
        return true;
    }

    public void apply() {
        if (this.fPicker != null) {
            double d = (double)this.fPicker.getRed() / 1000.0;
            double d2 = (double)this.fPicker.getGreen() / 1000.0;
            double d3 = (double)this.fPicker.getBlue() / 1000.0;
            ((PropertyEditorSupport)((Object)this)).setValue(new HGColor(d, d2, d3));
            return;
        }
        ((PropertyEditorSupport)((Object)this)).setValue(null);
    }
}

