/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.beans.editors.ApplyPropertyEditor;
import com.mathworks.beans.editors.EnhancedPropertyEditor;
import com.mathworks.hg.types.HGColor;
import com.mathworks.hg.types.HGColorArrayEditPanel;
import com.mathworks.util.ResLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;

public class HGColorArrayEditor
extends PropertyEditorSupport
implements EnhancedPropertyEditor,
ApplyPropertyEditor {
    private static final String ICON = "resources/ColorArrayIconColor16.gif";
    private static Image sIcon = null;
    private HGColorArrayEditPanel fEditPanel;

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        HGColor[] hGColorArray = (HGColor[])this.getValue();
        if (hGColorArray != null) {
            Rectangle rectangle2 = new Rectangle(rectangle);
            rectangle2.grow(-3, -2);
            if (hGColorArray.length <= 20 && rectangle2.width > 60) {
                rectangle2.width = 60;
            }
            int n = Math.min(hGColorArray.length, rectangle2.width);
            int n2 = rectangle2.width / n;
            int n3 = rectangle2.x + 1;
            int n4 = 0;
            while (n4 < n) {
                graphics.setColor(HGColor.getColor(hGColorArray[n4]));
                graphics.fillRect(n3, rectangle2.y + 1, n2, rectangle2.height - 2);
                n3 += n2;
                ++n4;
            }
            graphics.setColor(Color.black);
            graphics.drawRect(rectangle2.x, rectangle2.y, n3 - rectangle2.x, rectangle2.height - 1);
            graphics.setColor(Color.darkGray);
            graphics.drawLine(rectangle2.x + 1, rectangle2.y + rectangle2.height, n3, rectangle2.y + rectangle2.height);
            graphics.drawLine(n3 + 1, rectangle2.y + rectangle2.height, n3 + 1, rectangle2.y + 1);
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        this.fEditPanel = new HGColorArrayEditPanel((HGColor[])this.getValue());
        return this.fEditPanel;
    }

    public void apply() {
        if (this.fEditPanel != null) {
            this.setValue(this.fEditPanel.getArray());
        }
    }

    public boolean hasAttachedData() {
        return false;
    }

    public String getDataKey() {
        return null;
    }

    public void setData(Object object) {
    }

    public void setFrame(Frame frame) {
    }

    public Image getIcon() {
        if (sIcon == null) {
            ResLoader resLoader = new ResLoader(this.getClass());
            sIcon = resLoader.loadImage(ICON);
        }
        return sIcon;
    }
}

