/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.hg.types.EditPanelWithTable;
import com.mathworks.hg.types.HGColor;
import java.util.Vector;

public class HGColorArrayEditPanel
extends EditPanelWithTable {
    private Vector fColorVector;

    public HGColorArrayEditPanel(HGColor[] hGColorArray) {
        super(10, 4);
        this.getTable().getColumnOptions().setHeaderVisible(true);
        this.getTable().getColumnOptions().setResizable(false);
        this.getTable().setColumnHeaderData(0, (Object)"red");
        this.getTable().setColumnHeaderData(1, (Object)"green");
        this.getTable().setColumnHeaderData(2, (Object)"blue");
        this.getTable().setColumnHeaderData(3, (Object)"Swatch");
        if (hGColorArray != null) {
            this.fColorVector = new Vector(hGColorArray.length, 20);
            int n = 0;
            while (n < hGColorArray.length) {
                this.addColor(n, hGColorArray[n]);
                this.fColorVector.addElement(hGColorArray[n]);
                ++n;
            }
        }
    }

    public HGColor[] getArray() {
        Object[] objectArray = null;
        if (this.fColorVector != null && this.fColorVector.size() > 0) {
            objectArray = new HGColor[this.fColorVector.size()];
            this.fColorVector.copyInto(objectArray);
        }
        return objectArray;
    }

    private void addColor(int n, HGColor hGColor) {
        this.addDataRow(n, new Object[]{Double.toString(hGColor.getRed()), Double.toString(hGColor.getGreen()), Double.toString(hGColor.getBlue()), HGColor.getColor(hGColor)});
    }

    public void doAppend() {
        HGColor hGColor = null;
        if (this.fColorVector == null || this.fColorVector.size() == 0) {
            this.fColorVector = new Vector(10, 20);
            hGColor = new HGColor(1.0, 1.0, 1.0);
        } else {
            hGColor = (HGColor)this.fColorVector.lastElement();
            hGColor = new HGColor(hGColor.getRed(), hGColor.getGreen(), hGColor.getBlue());
        }
        this.addColor(this.getLastRowIndex() + 1, hGColor);
        this.fColorVector.addElement(hGColor);
    }

    public void doInsert(int n) {
        HGColor hGColor = (HGColor)this.fColorVector.elementAt(n);
        hGColor = new HGColor(hGColor.getRed(), hGColor.getGreen(), hGColor.getBlue());
        this.fColorVector.insertElementAt(hGColor, n);
        this.addColor(n, hGColor);
    }

    public void doDelete(int n) {
        this.fColorVector.removeElementAt(n);
    }

    public boolean valueChanged(int n, int n2, Object object) {
        boolean bl;
        block8: {
            bl = false;
            String string = (String)object;
            if (string == null || string.length() == 0) break block8;
            try {
                double d = Double.valueOf(string);
                if (d >= 0.0 && d <= 1.0) {
                    HGColor hGColor = (HGColor)this.fColorVector.elementAt(n);
                    if (n2 == 0) {
                        hGColor.setRed(d);
                    } else if (n2 == 1) {
                        hGColor.setGreen(d);
                    } else if (n2 == 2) {
                        hGColor.setBlue(d);
                    }
                    bl = true;
                    this.setCellData(n, 3, HGColor.getColor(hGColor));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bl;
    }
}

