/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors.iconeditor;

import com.mathworks.beans.editors.iconeditor.BevelPanel;
import com.mathworks.beans.editors.iconeditor.ColorSwatch;
import com.mathworks.beans.editors.iconeditor.IconEditorArea;
import com.mathworks.beans.editors.iconeditor.PaletteLayout;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWExclusiveGroup;
import com.mathworks.util.ResLoader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class ToolPalette
extends BevelPanel
implements ItemListener {
    static final int MARQUEE_SELECT = 0;
    static final int LASSO_SELECT = 1;
    static final int PENCIL = 2;
    static final int PAINTBRUSH = 3;
    static final int ERASER = 4;
    static final int EYEDROPPER = 5;
    static final int PAINTBUCKET = 6;
    static final int TEXT = 7;
    static final int LINE = 8;
    static final int RECTANGLE = 9;
    static final int ROUND_RECT = 10;
    static final int OVAL = 11;
    static final int NUM_TOOLS = 12;
    private static final String[] RES = new String[]{"resources/marqueeselect.gif", "resources/lassoselect.gif", "resources/pencil.gif", "resources/paintbrush.gif", "resources/eraser.gif", "resources/eyedropper.gif", "resources/paintbucket.gif", "resources/text.gif", "resources/line.gif", "resources/rectangle.gif", "resources/roundrect.gif", "resources/oval.gif"};
    private static Image[] sIcons = null;
    private MWExclusiveGroup fGroup;
    private MWButton[] fButtons;
    private int fSelectedTool;
    private ColorSwatch fSwatch;
    private IconEditorArea fArea;

    ToolPalette() {
        this.setOpaque(false);
        ((Container)((Object)this)).setLayout(new PaletteLayout(2, 6, 8));
        if (sIcons == null) {
            this.initIcons();
        }
        this.fSelectedTool = 2;
        this.fGroup = new MWExclusiveGroup();
        this.fButtons = new MWButton[12];
        int n = 0;
        while (n < 12) {
            this.fButtons[n] = new MWButton(sIcons[n], this.fGroup);
            this.fButtons[n].addItemListener((ItemListener)this);
            ((Container)((Object)this)).add((Component)this.fButtons[n], "Gridded");
            this.fButtons[n].setEnabled(false);
            ++n;
        }
        this.fButtons[2].setEnabled(true);
        this.fButtons[3].setEnabled(true);
        this.fButtons[4].setEnabled(true);
        this.fButtons[6].setEnabled(true);
        this.fButtons[5].setEnabled(true);
        this.fButtons[8].setEnabled(true);
        this.fButtons[9].setEnabled(true);
        this.fButtons[this.fSelectedTool].setState(true);
        this.fSwatch = new ColorSwatch();
        ((Container)((Object)this)).add((Component)((Object)this.fSwatch), "Flowed");
    }

    void setArea(IconEditorArea iconEditorArea) {
        this.fArea = iconEditorArea;
    }

    int getSelectedTool() {
        return this.fSelectedTool;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (itemEvent.getStateChange() == 1) {
            int n = 0;
            while (n < 12) {
                if (this.fButtons[n] == object) {
                    this.fSelectedTool = n;
                    if (this.fArea == null) break;
                    this.fArea.setTool(this.fSelectedTool);
                    return;
                }
                ++n;
            }
        }
    }

    byte getSelectedFG() {
        return this.fSwatch.getSelectedFG();
    }

    void setSelectedFG(byte by) {
        this.fSwatch.setSelectedFG(by);
        ((Component)((Object)this.fSwatch)).repaint(5L);
    }

    byte getSelectedBG() {
        return this.fSwatch.getSelectedBG();
    }

    void setSelectedBG(byte by) {
        this.fSwatch.setSelectedBG(by);
        ((Component)((Object)this.fSwatch)).repaint(5L);
    }

    private void initIcons() {
        ResLoader resLoader = new ResLoader((Component)((Object)this));
        if (sIcons == null) {
            sIcons = new Image[12];
        }
        int n = 0;
        while (n < RES.length) {
            ToolPalette.sIcons[n] = resLoader.loadImage(RES[n]);
            ++n;
        }
        resLoader.waitForPendingImages();
    }
}

