/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors.iconeditor;

import com.mathworks.beans.editors.iconeditor.ColorMap;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;

class PixMap {
    private static final int DEFAULT_SIZE = 32;
    private ColorMap fColorMap = ColorMap.newColorMap(2);
    private byte[] fPixMap;
    private Dimension fSize;
    private MemoryImageSource fSource;
    private Image fImage;

    PixMap(int n, int n2) {
        byte by = this.fColorMap.getTransparentPixel() >= 0 ? (byte)this.fColorMap.getTransparentPixel() : (byte)0;
        this.fSize = new Dimension(n, n2);
        this.fPixMap = new byte[this.fSize.width * this.fSize.height];
        int n3 = 0;
        while (n3 < this.fPixMap.length) {
            if (this.fColorMap.getTransparentPixel() >= 0) {
                this.fPixMap[n3] = by;
            }
            ++n3;
        }
        this.fSource = null;
        this.fImage = null;
    }

    PixMap(Dimension dimension) {
        this(dimension.width, dimension.height);
    }

    PixMap() {
        this(32, 32);
    }

    ColorMap getColorMap() {
        return this.fColorMap;
    }

    Dimension getSize() {
        return new Dimension(this.fSize.width, this.fSize.height);
    }

    int getPixelValue(int n, int n2) {
        if (this.isValidPixel(n, n2)) {
            return this.fColorMap.getColorValue(this.fPixMap[n2 * this.fSize.width + n]);
        }
        return -16777216;
    }

    byte getPixelIndex(int n, int n2) {
        if (this.isValidPixel(n, n2)) {
            return this.fPixMap[n2 * this.fSize.width + n];
        }
        return 0;
    }

    void setPixel(int n, int n2, byte by) {
        if (this.isValidPixel(n, n2)) {
            this.fPixMap[n2 * this.fSize.width + n] = by;
        }
    }

    void setPixels(int n, int n2, int n3, int n4, byte by) {
        int n5 = n;
        while (n5 < n + n3) {
            int n6 = n2;
            while (n6 < n2 + n4) {
                if (this.isValidPixel(n5, n6)) {
                    this.fPixMap[n6 * this.fSize.width + n5] = by;
                }
                ++n6;
            }
            ++n5;
        }
    }

    void newPixels() {
        if (this.fSource != null) {
            this.fSource.newPixels();
        }
    }

    boolean isPixelTransparent(int n, int n2) {
        return this.getPixelIndex(n, n2) == this.fColorMap.getTransparentPixel();
    }

    void clear() {
        int n = 0;
        while (n < this.fPixMap.length) {
            this.fPixMap[n] = (byte)this.fColorMap.getTransparentPixel();
            ++n;
        }
    }

    Image getImage() {
        if (this.fImage == null || this.fSource == null) {
            ColorModel colorModel = this.fColorMap.getColorModel();
            this.fSource = new MemoryImageSource(this.fSize.width, this.fSize.height, colorModel, this.fPixMap, 0, this.fSize.width);
            this.fSource.setAnimated(true);
            this.fSource.setFullBufferUpdates(true);
            this.fImage = Toolkit.getDefaultToolkit().createImage(this.fSource);
        }
        return this.fImage;
    }

    private boolean isValidPixel(int n, int n2) {
        return n > -1 && n < this.fSize.width && n2 > -1 && n2 < this.fSize.height;
    }
}

