/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors.iconeditor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.Vector;

class PaletteLayout
implements LayoutManager2 {
    static final String GRIDDED = "Gridded";
    static final String FLOWED = "Flowed";
    private static final int DEFAULT_GAP = 4;
    private static final int DEFAULT_COLS = 2;
    private Vector fGriddedComponents;
    private Vector fFlowedComponents;
    private int fColumnCount;
    private int fHGap;
    private int fVGap;

    PaletteLayout(int n, int n2, int n3) {
        this.fColumnCount = n;
        this.fHGap = n2;
        this.fVGap = n3;
        this.fGriddedComponents = new Vector();
        this.fFlowedComponents = new Vector();
    }

    PaletteLayout(int n, int n2) {
        this(2, 4, 4);
    }

    PaletteLayout(int n) {
        this(n, 4, 4);
    }

    PaletteLayout() {
        this(2, 4, 4);
    }

    public Dimension minimumLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        int n3 = this.fGriddedComponents.size();
        int n4 = 0;
        while (n4 < n3) {
            Component component = (Component)this.fGriddedComponents.elementAt(n4);
            n = Math.max(n, component.getPreferredSize().width);
            n2 = Math.max(n2, component.getPreferredSize().height);
            ++n4;
        }
        int n5 = this.fColumnCount * n;
        int n6 = n2 * (n3 / this.fColumnCount + n3 % this.fColumnCount);
        int n7 = 0;
        while (n7 < this.fFlowedComponents.size()) {
            Component component = (Component)this.fFlowedComponents.elementAt(n7);
            n5 = Math.max(n5, component.getMinimumSize().width);
            n6 += this.fVGap + component.getMinimumSize().height;
            ++n7;
        }
        return new Dimension(n5 += 2 * this.fHGap, n6 += 2 * this.fVGap);
    }

    public Dimension preferredLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        int n3 = this.fGriddedComponents.size();
        int n4 = 0;
        while (n4 < n3) {
            Component component = (Component)this.fGriddedComponents.elementAt(n4);
            n = Math.max(n, component.getPreferredSize().width);
            n2 = Math.max(n2, component.getPreferredSize().height);
            ++n4;
        }
        int n5 = this.fColumnCount * n;
        int n6 = n2 * (n3 / this.fColumnCount + n3 % this.fColumnCount);
        int n7 = 0;
        while (n7 < this.fFlowedComponents.size()) {
            Component component = (Component)this.fFlowedComponents.elementAt(n7);
            n5 = Math.max(n5, component.getPreferredSize().width);
            n6 += this.fVGap + component.getPreferredSize().height;
            ++n7;
        }
        return new Dimension(n5 += 2 * this.fHGap, n6 += 2 * this.fVGap);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        int n = this.fVGap;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.fGriddedComponents.size()) {
            Component component = (Component)this.fGriddedComponents.elementAt(n4);
            n2 = Math.max(n2, component.getPreferredSize().width);
            n3 = Math.max(n3, component.getPreferredSize().height);
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.fGriddedComponents.size()) {
            Component component = (Component)this.fGriddedComponents.elementAt(n5);
            int n6 = n5 % this.fColumnCount;
            component.setBounds(this.fHGap + n6 * n2, n, n2, n3);
            if (n5 == this.fGriddedComponents.size() - 1 || n6 == this.fColumnCount - 1) {
                n += n3;
            }
            ++n5;
        }
        int n7 = 0;
        while (n7 < this.fFlowedComponents.size()) {
            Component component = (Component)this.fFlowedComponents.elementAt(n7);
            n2 = component.getPreferredSize().width;
            n3 = component.getPreferredSize().height;
            component.setBounds(this.fHGap, n += this.fVGap, n2, n3);
            n += n3;
            ++n7;
        }
    }

    public void removeLayoutComponent(Component component) {
        if (this.fGriddedComponents.contains(component)) {
            this.fGriddedComponents.removeElement(component);
            return;
        }
        if (this.fFlowedComponents.contains(component)) {
            this.fFlowedComponents.removeElement(component);
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (string.equals(GRIDDED)) {
                this.fGriddedComponents.addElement(component);
                return;
            }
            if (string.equals(FLOWED)) {
                this.fFlowedComponents.addElement(component);
                return;
            }
            throw new IllegalArgumentException("cannot add to layout: unknown constraint " + string);
        }
        throw new IllegalArgumentException("cannot add to layout: constraint must be a string");
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }
}

