/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors.iconeditor;

import com.mathworks.beans.editors.iconeditor.IconEditorArea;
import com.mathworks.beans.editors.iconeditor.PaintTool;
import java.awt.Point;
import java.awt.event.MouseEvent;

class PaintToolRectangle
extends PaintTool {
    private Point fStartPoint = null;
    private Point fEndPoint = null;

    PaintToolRectangle(IconEditorArea iconEditorArea) {
        super(iconEditorArea);
    }

    private void doRectTool(Point point) {
        point = this.getArea().areaToPixMap(point.x, point.y);
        if (this.fEndPoint == null) {
            this.fStartPoint = new Point(point);
            this.fEndPoint = new Point(point);
        } else if (!this.fEndPoint.equals(point)) {
            byte by = (byte)this.getArea().getWetPaint().getColorMap().getTransparentPixel();
            this.drawRect(true, by, by);
            this.fEndPoint.x = point.x;
            this.fEndPoint.y = point.y;
        }
        this.drawRect(true, this.getArea().getSelectedFG(), this.getArea().getSelectedBG());
    }

    private void drawRect(boolean bl, byte by, byte by2) {
        Point point = new Point(Math.min(this.fStartPoint.x, this.fEndPoint.x), Math.min(this.fStartPoint.y, this.fEndPoint.y));
        Point point2 = new Point(Math.max(this.fStartPoint.x, this.fEndPoint.x), Math.max(this.fStartPoint.y, this.fEndPoint.y));
        int n = point2.x - point.x;
        int n2 = point2.y - point.y;
        if (bl) {
            this.getArea().drawWetLine(point.x, point.y, point2.x, point.y, by, true);
            this.getArea().drawWetLine(point2.x, point.y, point2.x, point2.y, by, true);
            this.getArea().drawWetLine(point2.x, point2.y, point.x, point2.y, by, true);
            this.getArea().drawWetLine(point.x, point2.y, point.x, point.y, by, true);
            if (n > 1 && n2 > 1) {
                this.getArea().fillWetRect(point.x + 1, point.y + 1, n - 1, n2 - 1, by2, true);
                return;
            }
        } else {
            this.getArea().drawLine(point.x, point.y, point2.x, point.y, by, true);
            this.getArea().drawLine(point2.x, point.y, point2.x, point2.y, by, true);
            this.getArea().drawLine(point2.x, point2.y, point.x, point2.y, by, true);
            this.getArea().drawLine(point.x, point2.y, point.x, point.y, by, true);
            if (n > 1 && n2 > 1) {
                this.getArea().fillRect(point.x + 1, point.y + 1, n - 1, n2 - 1, by2, true);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.getArea().inEditorArea(mouseEvent.getPoint())) {
            this.doRectTool(mouseEvent.getPoint());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.doRectTool(mouseEvent.getPoint());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.doRectTool(mouseEvent.getPoint());
        this.getArea().getWetPaint().clear();
        this.drawRect(false, this.getArea().getSelectedFG(), this.getArea().getSelectedBG());
        this.fStartPoint = null;
        this.fEndPoint = null;
    }
}

