/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors.iconeditor;

import com.mathworks.beans.editors.iconeditor.IconEditorArea;
import com.mathworks.beans.editors.iconeditor.PaintTool;
import java.awt.Point;
import java.awt.event.MouseEvent;

class PaintToolLine
extends PaintTool {
    private Point fStartPoint = null;
    private Point fEndPoint = null;
    private byte fColor;

    PaintToolLine(IconEditorArea iconEditorArea) {
        super(iconEditorArea);
    }

    private void doLineTool(Point point) {
        point = this.getArea().areaToPixMap(point.x, point.y);
        if (this.fEndPoint == null) {
            this.fColor = this.getArea().getSelectedFG();
            this.fStartPoint = new Point(point);
            this.fEndPoint = new Point(point);
            this.getArea().drawWetLine(this.fStartPoint.x, this.fStartPoint.y, this.fEndPoint.x, this.fEndPoint.y, this.fColor, true);
        } else if (!this.fEndPoint.equals(point)) {
            byte by = (byte)this.getArea().getWetPaint().getColorMap().getTransparentPixel();
            this.getArea().drawWetLine(this.fStartPoint.x, this.fStartPoint.y, this.fEndPoint.x, this.fEndPoint.y, by, true);
            this.fEndPoint.x = point.x;
            this.fEndPoint.y = point.y;
        }
        this.getArea().drawWetLine(this.fStartPoint.x, this.fStartPoint.y, this.fEndPoint.x, this.fEndPoint.y, this.fColor, true);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.getArea().inEditorArea(mouseEvent.getPoint())) {
            this.doLineTool(mouseEvent.getPoint());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.doLineTool(mouseEvent.getPoint());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.doLineTool(mouseEvent.getPoint());
        this.getArea().getWetPaint().clear();
        this.getArea().drawLine(this.fStartPoint.x, this.fStartPoint.y, this.fEndPoint.x, this.fEndPoint.y, this.fColor, true);
        this.fStartPoint = null;
        this.fEndPoint = null;
    }
}

