/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors.iconeditor;

import com.mathworks.beans.editors.iconeditor.IconEditorArea;
import com.mathworks.beans.editors.iconeditor.PaintTool;
import java.awt.Point;
import java.awt.event.MouseEvent;

class PaintToolBrush
extends PaintTool {
    private int fMode;
    private Point fLastPoint;
    private byte fColor;

    PaintToolBrush(IconEditorArea iconEditorArea, int n) {
        super(iconEditorArea);
        this.fMode = n;
        this.fLastPoint = null;
    }

    private void doPencilTool(Point point) {
        point = this.getArea().areaToPixMap(point.x, point.y);
        if (this.fLastPoint == null) {
            switch (this.fMode) {
                case 2: {
                    if (this.getArea().getPixelIndex(point.x, point.y) == this.getArea().getSelectedFG()) {
                        this.fColor = this.getArea().getSelectedBG();
                        break;
                    }
                    this.fColor = this.getArea().getSelectedFG();
                    break;
                }
                case 3: {
                    this.fColor = this.getArea().getSelectedFG();
                    break;
                }
                case 4: {
                    this.fColor = this.getArea().getSelectedBG();
                    break;
                }
            }
            this.getArea().setPixel(point.x, point.y, this.fColor, true);
        } else if (!this.fLastPoint.equals(point)) {
            this.getArea().drawLine(this.fLastPoint.x, this.fLastPoint.y, point.x, point.y, this.fColor, true);
        }
        this.fLastPoint = point;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.getArea().inEditorArea(mouseEvent.getPoint())) {
            this.doPencilTool(mouseEvent.getPoint());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.doPencilTool(mouseEvent.getPoint());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.doPencilTool(mouseEvent.getPoint());
        this.fLastPoint = null;
    }
}

