/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors.iconeditor;

import com.mathworks.beans.editors.iconeditor.PaintTool;
import com.mathworks.beans.editors.iconeditor.PixMap;
import com.mathworks.beans.editors.iconeditor.ToolPalette;
import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWImageCanvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;

class IconEditorArea
extends MWCanvas {
    private static final int BORDER = 16;
    private static final boolean USE_OFFSCREEN = true;
    private static final byte TRANSPARENT = 0;
    private static final byte FOREGROUND = 1;
    private static final byte BACKGROUND = 2;
    private PixMap fPixMap = new PixMap();
    private PixMap fWetPaint = new PixMap();
    private Image fOffscreen;
    private Graphics fOffscreenG;
    private ToolPalette fPalette;
    private MWImageCanvas fPreview;
    private PaintTool fTool;

    IconEditorArea(ToolPalette toolPalette, MWImageCanvas mWImageCanvas) {
        this.fPalette = toolPalette;
        this.fPreview = mWImageCanvas;
        this.fOffscreen = null;
        this.fOffscreenG = null;
        this.fPreview.setImage(this.fPixMap.getImage());
        this.setTool(this.fPalette.getSelectedTool());
    }

    MWImageCanvas getPreview() {
        return this.fPreview;
    }

    PixMap getPixMap() {
        return this.fPixMap;
    }

    PixMap getWetPaint() {
        return this.fWetPaint;
    }

    void setTool(int n) {
        if (this.fTool != null) {
            this.fTool.dispose();
        }
        this.fTool = PaintTool.newPaintTool(n, this);
    }

    byte getSelectedFG() {
        return this.fPalette.getSelectedFG();
    }

    void setSelectedFG(byte by) {
        this.fPalette.setSelectedFG(by);
    }

    byte getSelectedBG() {
        return this.fPalette.getSelectedBG();
    }

    void setSelectedBG(byte by) {
        this.fPalette.setSelectedBG(by);
    }

    byte getPixelIndex(int n, int n2) {
        return this.fPixMap.getPixelIndex(n, n2);
    }

    void setPixel(int n, int n2, byte by, boolean bl) {
        this.fPixMap.setPixel(n, n2, by);
        if (bl) {
            Point point = this.pixMapToArea(n, n2);
            int n3 = this.getCellSize();
            this.fPixMap.newPixels();
            ((Component)((Object)this)).repaint(point.x, point.y, n3, n3);
            this.fPreview.repaint();
        }
    }

    void fillRect(int n, int n2, int n3, int n4, byte by, boolean bl) {
        this.setPixels(n, n2, n3, n4, by, this.fPixMap, bl);
    }

    void fillWetRect(int n, int n2, int n3, int n4, byte by, boolean bl) {
        this.setPixels(n, n2, n3, n4, by, this.fWetPaint, bl);
    }

    private void setPixels(int n, int n2, int n3, int n4, byte by, PixMap pixMap, boolean bl) {
        pixMap.setPixels(n, n2, n3, n4, by);
        if (bl) {
            Point point = this.pixMapToArea(n, n2);
            int n5 = this.getCellSize();
            pixMap.newPixels();
            ((Component)((Object)this)).repaint(point.x, point.y, n3 * n5, n4 * n5);
            this.fPreview.repaint();
        }
    }

    void drawLine(int n, int n2, int n3, int n4, byte by, boolean bl) {
        this.drawLine(n, n2, n3, n4, by, this.fPixMap, bl);
    }

    void drawWetLine(int n, int n2, int n3, int n4, byte by, boolean bl) {
        this.drawLine(n, n2, n3, n4, by, this.fWetPaint, bl);
    }

    private void drawLine(int n, int n2, int n3, int n4, byte by, PixMap pixMap, boolean bl) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        int n7 = Math.abs(n5) * 2;
        int n8 = Math.abs(n6) * 2;
        int n9 = n5 > 0 ? 1 : -1;
        int n10 = n6 > 0 ? 1 : -1;
        int n11 = n;
        int n12 = n2;
        boolean bl2 = false;
        if (n7 > n8) {
            int n13 = n8 - (n7 >> 1);
            while (!bl2) {
                pixMap.setPixel(n11, n12, by);
                if (n11 == n3) {
                    bl2 = true;
                }
                if (n13 >= 0) {
                    n12 += n10;
                    n13 -= n7;
                }
                n11 += n9;
                n13 += n8;
            }
        } else {
            int n14 = n7 - (n8 >> 1);
            while (!bl2) {
                pixMap.setPixel(n11, n12, by);
                if (n12 == n4) {
                    bl2 = true;
                }
                if (n14 >= 0) {
                    n11 += n9;
                    n14 -= n8;
                }
                n12 += n10;
                n14 += n7;
            }
        }
        if (bl) {
            int n15;
            int n16;
            Point point = this.pixMapToArea(n, n2);
            Point point2 = this.pixMapToArea(n3, n4);
            int n17 = this.getCellSize();
            if (n < n3) {
                n11 = point.x;
                n16 = point2.x - point.x + n17;
            } else {
                n11 = point2.x;
                n16 = point.x - point2.x + n17;
            }
            if (n2 < n4) {
                n12 = point.y;
                n15 = point2.y - point.y + n17;
            } else {
                n12 = point2.y;
                n15 = point.y - point2.y + n17;
            }
            pixMap.newPixels();
            ((Component)((Object)this)).repaint(n11, n12, n16, n15);
            this.fPreview.repaint();
        }
    }

    Point areaToPixMap(int n, int n2) {
        int n3 = this.getCellSize();
        this.fPixMap.getSize();
        Point point = new Point();
        point.x = (n - 16) / n3;
        point.y = (n2 - 16) / n3;
        return point;
    }

    Point pixMapToArea(int n, int n2) {
        int n3 = this.getCellSize();
        Point point = new Point();
        point.x = n * n3 + 16;
        point.y = n2 * n3 + 16;
        return point;
    }

    boolean inEditorArea(Point point) {
        Dimension dimension = this.getAreaSize();
        Rectangle rectangle = new Rectangle(16, 16, dimension.width, dimension.height);
        return rectangle.contains(point);
    }

    private int getCellSize() {
        Dimension dimension = this.fPixMap.getSize();
        int n = 8;
        n = dimension.width <= 16 ? 16 : (dimension.width <= 48 ? 8 : 4);
        return n;
    }

    private Dimension getAreaSize() {
        Dimension dimension = this.fPixMap.getSize();
        dimension.width *= this.getCellSize();
        dimension.height *= this.getCellSize();
        return dimension;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getAreaSize();
        int n = Math.max(dimension.width + 32, 288);
        int n2 = Math.max(dimension.height + 32, 288);
        return new Dimension(n, n2);
    }

    public void paint(Graphics graphics) {
        int n;
        Dimension dimension = this.fPixMap.getSize();
        Dimension dimension2 = this.getAreaSize();
        int n2 = this.getCellSize();
        int n3 = 0;
        int n4 = 0;
        if (this.fOffscreen == null) {
            this.buildOffscreen();
        }
        if (this.fOffscreenG == null) {
            return;
        }
        this.fOffscreenG.setColor(Color.white);
        this.fOffscreenG.fillRect(n3, n4, dimension2.width + 1, dimension2.height + 1);
        int n5 = 0;
        while (n5 < dimension.height) {
            n = n4 + n5 * n2 + 1;
            int n6 = 0;
            while (n6 < dimension.width) {
                int n7 = n3 + n6 * n2 + 1;
                PixMap pixMap = this.fPixMap;
                if (!this.fWetPaint.isPixelTransparent(n6, n5)) {
                    pixMap = this.fWetPaint;
                }
                if (pixMap.isPixelTransparent(n6, n5)) {
                    this.fOffscreenG.setColor(Color.gray);
                    this.fOffscreenG.drawRect(n7, n, n2 - 2, n2 - 2);
                } else {
                    this.fOffscreenG.setColor(new Color(pixMap.getPixelValue(n6, n5)));
                    this.fOffscreenG.fillRect(n7, n, n2 - 1, n2 - 1);
                }
                ++n6;
            }
            ++n5;
        }
        graphics.drawImage(this.fOffscreen, 16, 16, (ImageObserver)((Object)this));
        graphics.setColor(Color.black);
        graphics.drawRect(15, 15, dimension2.width + 2, dimension2.height + 2);
        if (dimension.width % 4 == 0) {
            n3 = (dimension.width >> 2) * n2;
            n = 16 + n3;
            graphics.drawLine(n, 16, n, 16);
            graphics.drawLine(n, dimension2.height + 16, n, dimension2.height + 16);
            graphics.drawLine(n += n3, 16, n, 16);
            graphics.drawLine(n, dimension2.height + 16, n, dimension2.height + 16);
            graphics.drawLine(n += n3, 16, n, 16);
            graphics.drawLine(n, dimension2.height + 16, n, dimension2.height + 16);
        }
        if (dimension.height % 4 == 0) {
            n4 = (dimension.height >> 2) * n2;
            n = 16 + n4;
            graphics.drawLine(16, n, 16, n);
            graphics.drawLine(dimension2.width + 16, n, dimension2.width + 16, n);
            graphics.drawLine(16, n += n4, 16, n);
            graphics.drawLine(dimension2.width + 16, n, dimension2.width + 16, n);
            graphics.drawLine(16, n += n4, 16, n);
            graphics.drawLine(dimension2.width + 16, n, dimension2.width + 16, n);
        }
    }

    private void buildOffscreen() {
        Dimension dimension = this.getAreaSize();
        this.fOffscreen = ((Component)((Object)this)).createImage(dimension.width + 1, dimension.height + 1);
        if (this.fOffscreen != null) {
            this.fOffscreenG = this.fOffscreen.getGraphics();
        }
    }
}

