/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors.iconeditor;

import com.mathworks.beans.editors.iconeditor.ColorMap;
import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWColorPopup;
import com.mathworks.mwt.floater.DragForwarder;
import com.mathworks.mwt.floater.Floater;
import com.mathworks.mwt.floater.FloaterOwner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class ColorSwatch
extends MWCanvas
implements MouseListener,
FloaterOwner,
ItemListener,
MouseMotionListener {
    private static final int NO_PART = -1;
    private static final int FG_PART = 0;
    private static final int BG_PART = 1;
    private static final int SWAP_PART = 2;
    private byte fSelectedFG = 1;
    private byte fSelectedBG;
    private ColorMap fColorMap = ColorMap.newColorMap(2);
    private MWColorPopup fPopupFG;
    private MWColorPopup fPopupBG;
    private boolean fTracking;
    private boolean fHiliteSwap;

    ColorSwatch() {
        super(48, 40);
        this.fSelectedBG = this.fColorMap.getTransparentPixel() >= 0 ? (byte)this.fColorMap.getTransparentPixel() : (byte)0;
        int n = 0xFF & this.fSelectedFG;
        int n2 = 0xFF & this.fSelectedBG;
        this.fPopupFG = new MWColorPopup();
        this.fPopupFG.setFloaterOwner((FloaterOwner)this);
        this.fPopupFG.addItemListener((ItemListener)this);
        this.fillPopup(this.fPopupFG);
        this.fPopupFG.setSelectedIndex(n);
        this.fPopupBG = new MWColorPopup();
        this.fPopupBG.setFloaterOwner((FloaterOwner)this);
        this.fPopupBG.addItemListener((ItemListener)this);
        this.fillPopup(this.fPopupBG);
        this.fPopupBG.setSelectedIndex(n2);
        this.fTracking = false;
        this.fHiliteSwap = false;
        ((Component)((Object)this)).addMouseListener(this);
        ((Component)((Object)this)).addMouseMotionListener(this);
        DragForwarder dragForwarder = new DragForwarder((Floater)this.fPopupFG);
        ((Component)((Object)this)).addMouseListener((MouseListener)dragForwarder);
        ((Component)((Object)this)).addMouseMotionListener((MouseMotionListener)dragForwarder);
        dragForwarder = new DragForwarder((Floater)this.fPopupBG);
        ((Component)((Object)this)).addMouseListener((MouseListener)dragForwarder);
        ((Component)((Object)this)).addMouseMotionListener((MouseMotionListener)dragForwarder);
    }

    private void fillPopup(MWColorPopup mWColorPopup) {
        int n = this.fColorMap.getTransparentPixel();
        int n2 = 0;
        while (n2 < this.fColorMap.getMapSize()) {
            if (n2 == n) {
                mWColorPopup.addColor(0);
            } else {
                mWColorPopup.addColor(this.fColorMap.getColor((byte)n2));
            }
            ++n2;
        }
    }

    ColorMap getColorMap() {
        return this.fColorMap;
    }

    byte getSelectedFG() {
        return this.fSelectedFG;
    }

    void setSelectedFG(byte by) {
        this.fSelectedFG = by;
        this.fPopupFG.setSelectedIndex(0xFF & by);
    }

    byte getSelectedBG() {
        return this.fSelectedBG;
    }

    void setSelectedBG(byte by) {
        this.fSelectedBG = by;
        this.fPopupBG.setSelectedIndex(0xFF & by);
    }

    public void paint(Graphics graphics) {
        int n = ((Component)((Object)this)).getSize().width;
        int n2 = ((Component)((Object)this)).getSize().height;
        int n3 = n / 3;
        int n4 = n2 / 3;
        int n5 = n3 * 2;
        int n6 = n4 * 2;
        this.drawSwatch(graphics, this.fSelectedBG, n3, n4, n - n3, n2 - n4);
        this.drawSwatch(graphics, this.fSelectedFG, 0, 0, n5, n6);
        this.drawSwap(graphics, 1, n6 + 1, n3 - 2, n2 - n6 - 2);
    }

    private void drawSwap(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.translate(n, n2);
        if (this.fHiliteSwap) {
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, n3, n4);
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(((Component)((Object)this)).getBackground());
            graphics.fillRect(0, 0, n3, n4);
            graphics.setColor(Color.black);
        }
        graphics.drawLine(3, 1, 3, 1);
        graphics.drawLine(2, 2, 4, 2);
        graphics.drawLine(1, 3, 5, 3);
        graphics.drawLine(n3 - 2, n4 - 4, n3 - 2, n4 - 4);
        graphics.drawLine(n3 - 3, n4 - 5, n3 - 3, n4 - 3);
        graphics.drawLine(n3 - 4, n4 - 6, n3 - 4, n4 - 2);
        graphics.drawLine(3, 4, 3, n4 - 4);
        graphics.drawLine(n3 - 5, n4 - 4, 4, n4 - 4);
        graphics.translate(-n, -n2);
    }

    private void drawSwatch(Graphics graphics, byte by, int n, int n2, int n3, int n4) {
        graphics.translate(n, n2);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, n3 - 2, n4 - 2);
        graphics.drawLine(2, n4 - 1, n3 - 1, n4 - 1);
        graphics.drawLine(n3 - 1, 2, n3 - 1, n4 - 2);
        if (by == this.fColorMap.getTransparentPixel()) {
            graphics.setColor(Color.white);
            graphics.fillRect(1, 1, n3 - 3, n4 - 3);
            graphics.setColor(Color.black);
            graphics.drawRect(4, 4, n3 - 17, n4 - 13);
            graphics.drawRect(7, 7, n3 - 17, n4 - 13);
        } else {
            graphics.setColor(this.fColorMap.getColor(by));
            graphics.fillRect(1, 1, n3 - 3, n4 - 3);
            if (this.fColorMap.getColor(by).equals(Color.black)) {
                graphics.setColor(Color.white);
            } else {
                graphics.setColor(Color.black);
            }
        }
        int n5 = n4 / 2 - 1;
        graphics.drawLine(n3 - 5, n5, n3 - 5, n5);
        graphics.drawLine(n3 - 6, n5 - 1, n3 - 6, n5 + 1);
        graphics.drawLine(n3 - 7, n5 - 2, n3 - 7, n5 + 2);
        graphics.translate(-n, -n2);
    }

    private int findPart(Point point) {
        int n = -1;
        int n2 = ((Component)((Object)this)).getSize().width;
        int n3 = ((Component)((Object)this)).getSize().height;
        int n4 = n2 / 3;
        int n5 = n3 / 3;
        int n6 = n4 * 2;
        int n7 = n5 * 2;
        if (point.x < n6 && point.y < n7) {
            n = 0;
        } else if (point.x >= n4 && point.y >= n5) {
            n = 1;
        } else if (point.x < n4 && point.y >= n7 && point.x >= 0 && point.y < n3) {
            n = 2;
        }
        return n;
    }

    public void floaterAutoCollapsed(Floater floater) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.fPopupFG) {
            this.fSelectedFG = (byte)this.fPopupFG.getSelectedIndex();
        } else if (itemSelectable == this.fPopupBG) {
            this.fSelectedBG = (byte)this.fPopupBG.getSelectedIndex();
        }
        ((Component)((Object)this)).repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.findPart(mouseEvent.getPoint());
        switch (n) {
            case 0: {
                if (this.fPopupBG.isShowing()) {
                    this.fPopupBG.collapse();
                }
                if (this.fPopupFG.isShowing()) {
                    this.fPopupFG.collapse();
                    return;
                }
                this.fPopupFG.show((Component)((Object)this), ((Component)((Object)this)).getSize().width / 3 * 2 - 1, 0);
                return;
            }
            case 1: {
                if (this.fPopupFG.isShowing()) {
                    this.fPopupFG.collapse();
                }
                if (this.fPopupBG.isShowing()) {
                    this.fPopupBG.collapse();
                    return;
                }
                this.fPopupBG.show((Component)((Object)this), ((Component)((Object)this)).getSize().width - 1, ((Component)((Object)this)).getSize().height / 3);
                return;
            }
            case 2: {
                if (this.fPopupFG.isShowing()) {
                    this.fPopupFG.collapse();
                }
                if (this.fPopupBG.isShowing()) {
                    this.fPopupBG.collapse();
                }
                this.fTracking = true;
                this.fHiliteSwap = true;
                ((Component)((Object)this)).repaint();
                return;
            }
        }
        if (this.fPopupFG.isShowing()) {
            this.fPopupFG.collapse();
        }
        if (this.fPopupBG.isShowing()) {
            this.fPopupBG.collapse();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.fTracking) {
            boolean bl;
            boolean bl2 = bl = this.findPart(mouseEvent.getPoint()) == 2;
            if (bl != this.fHiliteSwap) {
                this.fHiliteSwap = bl;
                ((Component)((Object)this)).repaint();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.fTracking) {
            boolean bl = this.findPart(mouseEvent.getPoint()) == 2;
            this.fTracking = false;
            if (this.fHiliteSwap) {
                this.fHiliteSwap = false;
                ((Component)((Object)this)).repaint();
            }
            if (bl) {
                byte by = this.fSelectedBG;
                this.fSelectedBG = this.fSelectedFG;
                this.fSelectedFG = by;
                ((Component)((Object)this)).repaint();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

