/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors.iconeditor;

import com.mathworks.beans.editors.iconeditor.ColorMapMacIcon;
import com.mathworks.beans.editors.iconeditor.ColorMapWeb;
import com.mathworks.beans.editors.iconeditor.ColorMapWindows16;
import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

class ColorMap {
    static final int WINDOWS_16 = 0;
    static final int WEB = 1;
    static final int MAC_ICON = 2;
    private int[] fColorMap;
    private int fTransparentPixel;
    private ColorModel fColorModel = null;

    ColorMap(int n) {
        this.fColorMap = new int[n];
        this.fTransparentPixel = 0;
    }

    ColorMap() {
        this(0);
    }

    void setColorMap(int[] nArray, int n) {
        this.fColorMap = nArray;
        this.fTransparentPixel = n;
    }

    void setColorMap(int[] nArray) {
        this.fColorMap = nArray;
    }

    int getTransparentPixel() {
        return this.fTransparentPixel;
    }

    int getMapSize() {
        return this.fColorMap.length;
    }

    int[] getColorMap() {
        return this.fColorMap;
    }

    int getColorValue(byte by) {
        int n = 0xFF & by;
        int n2 = -16777216;
        if (n > 0 && n < this.fColorMap.length) {
            n2 = this.fColorMap[n];
        }
        return n2;
    }

    Color getColor(byte by) {
        return new Color(this.getColorValue(by));
    }

    ColorModel getColorModel() {
        if (this.fColorModel == null) {
            byte[] byArray = new byte[this.fColorMap.length];
            byte[] byArray2 = new byte[this.fColorMap.length];
            byte[] byArray3 = new byte[this.fColorMap.length];
            int n = 0;
            while (n < this.fColorMap.length) {
                byArray[n] = (byte)(this.fColorMap[n] >> 16 & 0xFF);
                byArray2[n] = (byte)(this.fColorMap[n] >> 8 & 0xFF);
                byArray3[n] = (byte)(this.fColorMap[n] & 0xFF);
                ++n;
            }
            this.fColorModel = new IndexColorModel(8, this.fColorMap.length, byArray, byArray2, byArray3, this.fTransparentPixel);
        }
        return this.fColorModel;
    }

    static ColorMap newColorMap(int n) {
        ColorMap colorMap = null;
        switch (n) {
            case 0: {
                colorMap = new ColorMapWindows16();
                break;
            }
            case 1: {
                colorMap = new ColorMapWeb();
                break;
            }
            case 2: {
                colorMap = new ColorMapMacIcon();
                break;
            }
        }
        return colorMap;
    }
}

