/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.beans.editors.MWPropertyEditorSupport;
import com.mathworks.beans.editors.StringLiner;
import com.mathworks.mwt.MWTextArea;
import com.mathworks.util.ResLoader;
import java.awt.Component;
import java.awt.Image;
import java.util.Vector;

public class StringArrayEditor
extends MWPropertyEditorSupport {
    public static final String ALLOW_BLANKS = "StringArrayEditor.AllowBlanks";
    private static final String DELIM = System.getProperty("line.separator");
    private static Image sIcon = null;
    private MWTextArea fTextArea;
    private boolean fAllowBlanks = true;

    public String getAsText() {
        String string = "";
        String[] stringArray = (String[])this.getValue();
        if (stringArray != null && stringArray.length > 0) {
            string = stringArray[0];
        }
        return string;
    }

    public void setAsText(String string) {
        String[] stringArray = (String[])this.getValue();
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{string};
        }
        this.setValue(stringArray);
    }

    public boolean supportsInPlaceEditing() {
        return true;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.fTextArea == null) {
            this.fTextArea = new MWTextArea(12, 40);
        }
        this.fTextArea.requestFocus();
        this.fTextArea.setText(StringArrayEditor.arrayToDelimited((String[])this.getValue()));
        return this.fTextArea;
    }

    public boolean canApply() {
        return true;
    }

    public void apply() {
        String string = this.fTextArea != null ? this.fTextArea.getText() : "";
        String[] stringArray = StringArrayEditor.delimitedToArray(string);
        this.setValue(stringArray);
    }

    public Image getIcon() {
        if (sIcon == null) {
            ResLoader resLoader = new ResLoader(this.getClass());
            sIcon = resLoader.loadImage("resources/StringArrayIcon.gif");
        }
        return sIcon;
    }

    public boolean hasAttachedData() {
        return true;
    }

    public String getDataKey() {
        return ALLOW_BLANKS;
    }

    public void setData(Object object) {
        if (object instanceof Boolean) {
            this.fAllowBlanks = (Boolean)object;
        }
    }

    private static final String arrayToDelimited(String[] stringArray) {
        String string = "";
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                string = String.valueOf(string) + stringArray[n] + DELIM;
                ++n;
            }
        }
        return string;
    }

    private static final String[] delimitedToArray(String string) {
        Object[] objectArray = null;
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            StringLiner stringLiner = new StringLiner(string);
            while (stringLiner.hasMoreLines()) {
                vector.addElement(stringLiner.nextLine());
            }
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

