/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.beans.editors.ValueValidityEvent;
import com.mathworks.beans.editors.ValueValidityListener;
import com.mathworks.beans.editors.ValueValiditySource;
import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWListbox;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.ValueEvent;
import com.mathworks.mwt.table.ValueListener;
import com.mathworks.util.DoubleVector;
import com.mathworks.util.IntBuffer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class PrimitiveArrayEditPanel
extends MWPanel
implements ValueListener,
ValueValiditySource,
ItemListener,
ActionListener {
    private static ResourceBundle fRes = ResourceBundle.getBundle("com.mathworks.beans.editors.resources.RES_Editors");
    private static final String APPEND_TEXT = fRes.getString("button.append");
    private static final String INSERT_TXT = fRes.getString("button.insert");
    private static final String DUP_CMD = "AppendInsert";
    private static final String DEL_TXT = fRes.getString("button.delete");
    private static final String DEL_CMD = "Delete";
    private DoubleVector fDoubleArray;
    private IntBuffer fIntArray;
    private MWListbox fTable;
    private Vector fEars = new Vector(2, 5);
    private boolean fValid;
    private boolean[] fValidByRow;
    private Style fErrorStyle = new Style(2);
    private MWButton fDeleteButton;
    private MWButton fAppendInsertBtn;

    public PrimitiveArrayEditPanel(double[] dArray) {
        super((LayoutManager)new BorderLayout());
        this.fDoubleArray = new DoubleVector(dArray);
        this.fTable = new MWListbox();
        if (dArray != null) {
            this.initDouble(dArray);
        }
        this.finishSetup();
    }

    public PrimitiveArrayEditPanel(int[] nArray) {
        super((LayoutManager)new BorderLayout());
        this.fIntArray = new IntBuffer();
        this.fTable = new MWListbox();
        if (nArray != null) {
            this.initInt(nArray);
        }
        this.finishSetup();
    }

    private void initDouble(double[] dArray) {
        this.fValidByRow = new boolean[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            this.fTable.addItem(Double.toString(dArray[n]));
            this.fValidByRow[n] = true;
            ++n;
        }
    }

    private void initInt(int[] nArray) {
        this.fIntArray.append(nArray);
        this.fValidByRow = new boolean[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            this.fTable.addItem(Integer.toString(nArray[n]));
            this.fValidByRow[n] = true;
            ++n;
        }
    }

    private void finishSetup() {
        this.fValid = true;
        this.fErrorStyle.setForeground(Color.red);
        Style style = new Style(1024);
        style.setEditable(true);
        this.fTable.setColumnStyle(0, style);
        this.fTable.setPreferredTableSize(10, 1);
        this.fTable.setHeaderVisible(false);
        this.fTable.addValueListener((ValueListener)this);
        this.fTable.addItemListener((ItemListener)this);
        ((Container)((Object)this)).add((Component)this.fTable, "Center");
        this.fAppendInsertBtn = new MWButton(APPEND_TEXT);
        this.fAppendInsertBtn.setActionCommand(DUP_CMD);
        this.fAppendInsertBtn.addActionListener((ActionListener)this);
        this.fDeleteButton = new MWButton(DEL_TXT);
        this.fDeleteButton.setActionCommand(DEL_CMD);
        this.fDeleteButton.addActionListener((ActionListener)this);
        this.fDeleteButton.setEnabled(false);
        MWPanel mWPanel = new MWPanel((LayoutManager)new FlowLayout(0));
        mWPanel.add((Component)this.fAppendInsertBtn);
        mWPanel.add((Component)this.fDeleteButton);
        ((Container)((Object)this)).add((Component)mWPanel, "South");
    }

    public double[] getDoubleArray() {
        double[] dArray = null;
        if (this.fTable.getItemCount() > 0) {
            dArray = new double[this.fDoubleArray.getSize()];
            this.fDoubleArray.copyInto(dArray);
        }
        return dArray;
    }

    public int[] getIntArray() {
        int[] nArray = null;
        if (this.fTable.getItemCount() > 0) {
            int[] nArray2 = this.fIntArray.getRawBuf();
            nArray = new int[this.fIntArray.length()];
            System.arraycopy(nArray2, 0, nArray, 0, this.fIntArray.length());
        }
        return nArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.fTable.getFirstSelectedRow();
        if (DUP_CMD.equals(actionEvent.getActionCommand())) {
            if (this.fValidByRow == null) {
                if (this.fDoubleArray != null) {
                    double[] dArray = new double[1];
                    this.initDouble(dArray);
                } else if (this.fIntArray != null) {
                    int[] nArray = new int[1];
                    this.initInt(nArray);
                }
            } else {
                int n2;
                String string = "";
                if (this.fDoubleArray != null) {
                    double d;
                    n2 = this.fDoubleArray.getSize();
                    if (n < 0) {
                        d = 0.0;
                        this.fDoubleArray.addElement(d);
                    } else {
                        d = this.fDoubleArray.elementAt(n);
                        this.fDoubleArray.insertElementAt(d, n);
                    }
                    string = Double.toString(d);
                } else if (this.fIntArray != null) {
                    int n3;
                    n2 = this.fIntArray.length();
                    if (n < 0) {
                        n3 = 0;
                        this.fIntArray.append(n3);
                    } else {
                        n3 = this.fIntArray.getAt(n);
                        this.fIntArray.insert(n, n3);
                    }
                    string = Integer.toString(n3);
                }
                if (n >= 0) {
                    this.fTable.addItem(string, n);
                } else {
                    this.fTable.addItem(string);
                }
                n2 = this.fValidByRow.length;
                boolean[] blArray = new boolean[n2 + 1];
                if (n < 0) {
                    System.arraycopy(this.fValidByRow, 0, blArray, 0, this.fValidByRow.length);
                    blArray[n2] = true;
                } else {
                    System.arraycopy(this.fValidByRow, 0, blArray, 0, n);
                    blArray[n] = true;
                    System.arraycopy(this.fValidByRow, n, blArray, n + 1, n2 - n);
                }
                int n4 = 0;
                while (n4 < blArray.length) {
                    this.fTable.setCellStyle(n4, 0, blArray[n4] ? null : this.fErrorStyle);
                    ++n4;
                }
                this.fValidByRow = blArray;
            }
        } else if (DEL_CMD.equals(actionEvent.getActionCommand())) {
            this.fTable.removeItem(n);
            if (this.fDoubleArray != null) {
                this.fDoubleArray.removeElementAt(n);
            } else if (this.fIntArray != null) {
                this.fIntArray.delete(n, n + 1);
            }
            boolean[] blArray = new boolean[this.fValidByRow.length - 1];
            int n5 = n;
            while (n5-- > 0) {
                blArray[n5] = this.fValidByRow[n5];
                this.fTable.setCellStyle(n5, 0, blArray[n5] ? null : this.fErrorStyle);
            }
            n5 = n;
            while (n5 < blArray.length) {
                blArray[n5++] = this.fValidByRow[n5];
                this.fTable.setCellStyle(n5 - 1, 0, this.fValidByRow[n5] ? null : this.fErrorStyle);
            }
            this.fValidByRow = blArray;
            this.fAppendInsertBtn.setLabel(APPEND_TEXT);
            this.fDeleteButton.setEnabled(false);
            int n6 = this.fTable.getItemCount();
            if (n6 > 0) {
                this.fTable.setSelectedIndex(Math.min(n6, n));
            }
        }
        this.validityChanged();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.fTable.getFirstSelectedRow();
        this.fAppendInsertBtn.setEnabled(n >= 0);
        this.fDeleteButton.setEnabled(n >= 0);
        this.fAppendInsertBtn.setLabel(n >= 0 ? INSERT_TXT : APPEND_TEXT);
    }

    public boolean isValueValid() {
        return this.fValid;
    }

    public void addValueValidityListener(ValueValidityListener valueValidityListener) {
        this.fEars.addElement(valueValidityListener);
    }

    public void removeValueValidityListener(ValueValidityListener valueValidityListener) {
        this.fEars.removeElement(valueValidityListener);
    }

    private synchronized void fireValidityEvent(boolean bl) {
        Enumeration enumeration = this.fEars.elements();
        ValueValidityEvent valueValidityEvent = new ValueValidityEvent(this, bl);
        while (enumeration.hasMoreElements()) {
            ((ValueValidityListener)enumeration.nextElement()).valueValidityChanged(valueValidityEvent);
        }
    }

    public void valueChanged(ValueEvent valueEvent) {
        boolean bl = false;
        Style style = null;
        String string = (String)this.fTable.getCellData(valueEvent.getRow(), valueEvent.getColumn());
        if (string != null && string.length() != 0) {
            try {
                if (this.fDoubleArray != null) {
                    double d = Double.valueOf(string);
                    this.fDoubleArray.setElementAt(d, valueEvent.getRow());
                } else if (this.fIntArray != null) {
                    int n = Integer.parseInt(string);
                    this.fIntArray.setAt(valueEvent.getRow(), n);
                }
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                style = this.fErrorStyle;
            }
        }
        if (this.fValidByRow[valueEvent.getRow()] != bl) {
            this.fValidByRow[valueEvent.getRow()] = bl;
            this.validityChanged();
        }
        this.fTable.setCellStyle(valueEvent.getRow(), valueEvent.getColumn(), style);
    }

    private void validityChanged() {
        boolean bl = true;
        int n = 0;
        while (bl && n < this.fValidByRow.length) {
            bl = this.fValidByRow[n++];
        }
        if (bl != this.fValid) {
            this.fValid = bl;
            this.fireValidityEvent(bl);
        }
    }
}

