/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.beans.editors.CompoundPropertyEditor;
import com.mathworks.beans.editors.EditablePoint;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;

public class PointEditor
extends PropertyEditorSupport
implements CompoundPropertyEditor {
    private static Image sIcon = null;

    public String getAsText() {
        String string = "";
        Point point = (Point)this.getValue();
        if (point != null) {
            string = "( " + point.x + ", " + point.y + " )";
        }
        return string;
    }

    public Object getIntrospectableValue() {
        return new EditablePoint((Point)this.getValue());
    }

    public void setIntrospectableValue(Object object) {
        if (object instanceof EditablePoint) {
            EditablePoint editablePoint = (EditablePoint)object;
            this.setValue(editablePoint.getLocation());
            return;
        }
        if (object instanceof String) {
            throw new IllegalArgumentException((String)object);
        }
        throw new IllegalArgumentException();
    }

    public boolean isTopLevelEditable() {
        return false;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Point point = (Point)this.getValue();
        String string = "(x, y)";
        if (point != null) {
            string = "( " + point.x + ", " + point.y + " )";
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = rectangle.y + (rectangle.height - fontMetrics.getAscent()) / 2 + fontMetrics.getAscent();
        graphics.drawString(string, rectangle.x, n);
    }
}

