/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.beans.editors.BasicFontPicker;
import com.mathworks.beans.editors.EnhancedFontPicker;
import com.mathworks.mwt.MWFontHandler;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.decorations.Decorations;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;

public class FontPicker
extends MWPanel
implements ItemSelectable {
    protected static final String[] SIZES = new String[]{"9", "10", "12", "14", "18", "24", "36", "48"};
    protected static final String[] STYLES = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};
    protected static final String[] NAMES = MWFontHandler.getFontList();
    private Font fSelectedFont;
    private Component fPicker;
    private ItemListener fItemListener;
    protected static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.beans.editors.resources.RES_Editors");

    public FontPicker(Font font, boolean bl) {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.fSelectedFont = font == null ? Decorations.getFont((int)0) : font;
        this.fPicker = bl ? new EnhancedFontPicker(this) : new BasicFontPicker(this);
        ((Container)((Object)this)).add(this.fPicker, "Center");
    }

    public FontPicker(Font font) {
        this(font, false);
    }

    public FontPicker() {
        this(null, false);
    }

    public Font getSelectedFont() {
        return this.fSelectedFont;
    }

    public void setSelectedFont(Font font) {
        this.fSelectedFont = font;
        this.updateControls();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateControls();
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray = new Object[]{this.getSelectedFont()};
        return objectArray;
    }

    public void addItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.add(this.fItemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.remove(this.fItemListener, itemListener);
    }

    private void updateControls() {
        if (this.fPicker instanceof BasicFontPicker) {
            ((BasicFontPicker)((Object)this.fPicker)).updateControls();
            return;
        }
        if (this.fPicker instanceof EnhancedFontPicker) {
            ((EnhancedFontPicker)((Object)this.fPicker)).updateControls();
        }
    }

    protected void fireItemEvent() {
        if (this.fItemListener != null) {
            ItemEvent itemEvent = new ItemEvent(this, 701, this.getSelectedFont(), 1);
            this.fItemListener.itemStateChanged(itemEvent);
        }
    }

    public void addNotify() {
        super.addNotify();
        MWFontHandler.checkFontAvailability((Component)((Object)this));
    }
}

