/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.beans.editors.FontPicker;
import com.mathworks.beans.editors.IntrospectableFont;
import com.mathworks.beans.editors.MWPropertyEditorSupport;
import com.mathworks.util.ResLoader;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;

public class FontEditor
extends MWPropertyEditorSupport {
    private static Image sIcon = null;
    private FontPicker fPicker;

    public String getAsText() {
        IntrospectableFont introspectableFont = (IntrospectableFont)this.getIntrospectableValue();
        String string = introspectableFont.getName();
        string = String.valueOf(string) + ", " + introspectableFont.getSize() + " point";
        if (introspectableFont.isBold()) {
            string = String.valueOf(string) + ", bold";
        }
        if (introspectableFont.isItalic()) {
            string = String.valueOf(string) + ", italic";
        }
        return string;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        Font font;
        if (this.fPicker == null) {
            this.fPicker = new FontPicker(null, true);
        }
        if ((font = (Font)this.getValue()) == null) {
            font = new Font("Dialog", 0, 12);
        }
        this.fPicker.setSelectedFont(font);
        return this.fPicker;
    }

    public Image getIcon() {
        if (sIcon == null) {
            ResLoader resLoader = new ResLoader(this.getClass());
            sIcon = resLoader.loadImage("resources/FontIcon.gif");
        }
        return sIcon;
    }

    public boolean canExpand() {
        return true;
    }

    public Object getIntrospectableValue() {
        return new IntrospectableFont((Font)this.getValue());
    }

    public void setIntrospectableValue(Object object) {
        if (object instanceof IntrospectableFont) {
            IntrospectableFont introspectableFont = (IntrospectableFont)object;
            this.setValue(introspectableFont.fontValue());
            return;
        }
        if (object instanceof String) {
            throw new IllegalArgumentException((String)object);
        }
        throw new IllegalArgumentException();
    }

    public boolean canApply() {
        return true;
    }

    public void apply() {
        Font font = this.fPicker != null ? this.fPicker.getSelectedFont() : null;
        this.setValue(font);
    }
}

