/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.beans.editors.ColorBar;
import com.mathworks.beans.editors.ColorSwatch;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWSlider;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.decorations.Decorations;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;

public class ColorPicker
extends MWPanel
implements ItemSelectable {
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final int NCOLORS = 3;
    private static final int RED_MASK = 1;
    private static final int GREEN_MASK = 2;
    private static final int BLUE_MASK = 4;
    private static final int ALL_MASK = 7;
    private static final int GAP = 8;
    private ColorBar[] fBars;
    private MWSlider[] fSliders;
    private MWTextField[] fFields;
    private int fMaxValue;
    private int fR;
    private int fG;
    private int fB;
    private ColorSwatch fOriginal;
    private ColorSwatch fSelected;
    private EventHandler fHandler;
    private transient ItemListener fItemListener;
    private static ResourceBundle sRes = null;

    public ColorPicker(int n, int n2, int n3, int n4) {
        MWLabel[] mWLabelArray = new MWLabel[3];
        if (sRes == null) {
            sRes = ResourceBundle.getBundle("com.mathworks.beans.editors.resources.RES_Editors");
        }
        this.fHandler = new EventHandler();
        this.fMaxValue = n4;
        this.fR = n;
        this.fG = n2;
        this.fB = n3;
        this.fOriginal = new ColorSwatch(this.fR, this.fG, this.fB, this.fMaxValue);
        MWPanel mWPanel = this.makeSwatchPanel(this.fOriginal, "Original");
        this.fSelected = new ColorSwatch(this.fR, this.fG, this.fB, this.fMaxValue);
        MWPanel mWPanel2 = this.makeSwatchPanel(this.fSelected, "New");
        ((Container)((Object)this)).setLayout(new BorderLayout(8, 8));
        this.setInsets(new Insets(8, 8, 8, 8));
        MWPanel mWPanel3 = new MWPanel((LayoutManager)new GridLayout(2, 1, 8, 8));
        mWPanel3.add((Component)mWPanel2);
        mWPanel3.add((Component)mWPanel);
        this.fSliders = new MWSlider[3];
        this.fBars = new ColorBar[3];
        this.fFields = new MWTextField[3];
        this.fSliders[0] = this.makeColorSlider(this.fR);
        this.fBars[0] = new ColorBar(-1, this.valueToNative(this.fG), this.valueToNative(this.fB), this.fSliders[0].sliderThumbLength() / 2);
        this.fFields[0] = this.makeColorField(this.valueToPercent(this.fR));
        mWLabelArray[0] = new MWLabel(sRes.getString("label.red"));
        this.fSliders[1] = this.makeColorSlider(this.fG);
        this.fBars[1] = new ColorBar(this.valueToNative(this.fR), -1, this.valueToNative(this.fB), this.fSliders[1].sliderThumbLength() / 2);
        this.fFields[1] = this.makeColorField(this.valueToPercent(this.fG));
        mWLabelArray[1] = new MWLabel(sRes.getString("label.green"));
        this.fSliders[2] = this.makeColorSlider(this.fB);
        this.fBars[2] = new ColorBar(this.valueToNative(this.fR), this.valueToNative(this.fG), -1, this.fSliders[2].sliderThumbLength() / 2);
        this.fFields[2] = this.makeColorField(this.valueToPercent(this.fB));
        mWLabelArray[2] = new MWLabel(sRes.getString("label.blue"));
        MWPanel mWPanel4 = new MWPanel((LayoutManager)new GridLayout(3, 1, 8, 8));
        mWPanel4.setUseBackingStore(true);
        int n5 = 0;
        while (n5 < 3) {
            MWPanel mWPanel5 = new MWPanel((LayoutManager)new BorderLayout());
            mWPanel5.add((Component)this.fSliders[n5], "Center");
            mWPanel5.add((Component)((Object)this.fBars[n5]), "South");
            MWPanel mWPanel6 = new MWPanel((LayoutManager)new FlowLayout(2));
            mWPanel6.add((Component)mWLabelArray[n5]);
            mWPanel6.add((Component)mWPanel5);
            mWPanel6.add((Component)this.fFields[n5]);
            mWPanel6.add((Component)new MWLabel("%"));
            mWPanel4.add((Component)mWPanel6);
            ++n5;
        }
        ((Container)((Object)this)).add((Component)mWPanel4, "Center");
        ((Container)((Object)this)).add((Component)mWPanel3, "East");
    }

    public ColorPicker(Color color) {
        this(color.getRed(), color.getGreen(), color.getBlue(), 255);
    }

    public ColorPicker() {
        this(0, 0, 0, 100);
    }

    public int getRed() {
        return this.fR;
    }

    public int getGreen() {
        return this.fG;
    }

    public int getBlue() {
        return this.fB;
    }

    public Color getSelectedColor() {
        int n = 255 * this.fR / this.fMaxValue;
        int n2 = 255 * this.fG / this.fMaxValue;
        int n3 = 255 * this.fB / this.fMaxValue;
        return new Color(n, n2, n3);
    }

    public void setSelectedColor(int n, int n2, int n3) {
        this.fR = n;
        this.fG = n2;
        this.fB = n3;
        if (this.fR < 0) {
            this.fR = 0;
        } else if (this.fR > this.fMaxValue) {
            this.fR = this.fMaxValue;
        }
        if (this.fG < 0) {
            this.fG = 0;
        } else if (this.fG > this.fMaxValue) {
            this.fG = this.fMaxValue;
        }
        if (this.fB < 0) {
            this.fB = 0;
        } else if (this.fB > this.fMaxValue) {
            this.fB = this.fMaxValue;
        }
        this.fSelected.setColor(this.fR, this.fG, this.fB, this.fMaxValue);
        this.updateSliders(7);
        this.updateTextFields(7);
        this.updateColorBars(7);
    }

    public void setInitialColor(int n, int n2, int n3) {
        if (n < 0) {
            n = 0;
        } else if (n > this.fMaxValue) {
            n = this.fMaxValue;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.fMaxValue) {
            n2 = this.fMaxValue;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > this.fMaxValue) {
            n3 = this.fMaxValue;
        }
        this.fOriginal.setColor(n, n2, n3, this.fMaxValue);
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray = new Object[]{this.getSelectedColor()};
        return objectArray;
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.add(this.fItemListener, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.remove(this.fItemListener, itemListener);
    }

    private void updateSliders(int n) {
        if ((n & 1) != 0) {
            this.fSliders[0].setValue(this.fR);
            this.fSliders[0].repaint();
        }
        if ((n & 2) != 0) {
            this.fSliders[1].setValue(this.fG);
            this.fSliders[1].repaint();
        }
        if ((n & 4) != 0) {
            this.fSliders[2].setValue(this.fB);
            this.fSliders[2].repaint();
        }
    }

    private void updateTextFields(int n) {
        if ((n & 1) != 0) {
            this.fFields[0].setText(String.valueOf(this.valueToPercent(this.fR)));
        }
        if ((n & 2) != 0) {
            this.fFields[1].setText(String.valueOf(this.valueToPercent(this.fG)));
        }
        if ((n & 4) != 0) {
            this.fFields[2].setText(String.valueOf(this.valueToPercent(this.fB)));
        }
    }

    private void updateColorBars(int n) {
        if ((n & 1) != 0) {
            this.fBars[0].applyFilter(-1, this.valueToNative(this.fG), this.valueToNative(this.fB));
            ((Component)((Object)this.fBars[0])).repaint();
        }
        if ((n & 2) != 0) {
            this.fBars[1].applyFilter(this.valueToNative(this.fR), -1, this.valueToNative(this.fB));
            ((Component)((Object)this.fBars[1])).repaint();
        }
        if ((n & 4) != 0) {
            this.fBars[2].applyFilter(this.valueToNative(this.fR), this.valueToNative(this.fG), -1);
            ((Component)((Object)this.fBars[2])).repaint();
        }
    }

    private void fireItemStateChanged() {
        if (this.fItemListener != null) {
            ItemEvent itemEvent = new ItemEvent(this, 701, this.getSelectedColor(), 1);
            this.fItemListener.itemStateChanged(itemEvent);
        }
    }

    private MWPanel makeSwatchPanel(ColorSwatch colorSwatch, String string) {
        MWPanel mWPanel = new MWPanel((LayoutManager)new BorderLayout());
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new FlowLayout(1));
        mWPanel2.add((Component)new MWLabel(string));
        mWPanel.add((Component)((Object)colorSwatch), "Center");
        mWPanel.add((Component)mWPanel2, "South");
        return mWPanel;
    }

    private MWTextField makeColorField(int n) {
        MWTextField mWTextField = new MWTextField(String.valueOf(n), 3);
        mWTextField.setFont(Decorations.getFont((int)0));
        mWTextField.addActionListener((ActionListener)this.fHandler);
        mWTextField.addFocusListener((FocusListener)this.fHandler);
        return mWTextField;
    }

    private MWSlider makeColorSlider(int n) {
        MWSlider mWSlider = new MWSlider(0, n, 0, this.fMaxValue);
        mWSlider.setBlockIncrement(this.fMaxValue / 15);
        mWSlider.addAdjustmentListener((AdjustmentListener)this.fHandler);
        return mWSlider;
    }

    private final int valueToPercent(int n) {
        return 100 * n / this.fMaxValue;
    }

    private final int valueToNative(int n) {
        return 255 * n / this.fMaxValue;
    }

    private final int percentToValue(int n) {
        return this.fMaxValue * n / 100;
    }

    private final int getValFromString(String string, int n) {
        int n2 = n;
        try {
            n2 = this.percentToValue(Integer.parseInt(string));
        }
        catch (Exception exception) {
            n2 = n;
        }
        return n2;
    }

    private void updateViaField(Object object) {
        String string = this.fFields[0].getText();
        String string2 = this.fFields[1].getText();
        String string3 = this.fFields[2].getText();
        int n = 7;
        if (object == this.fFields[0]) {
            if (string.equals("")) {
                this.fR = 0;
            } else {
                this.fR = this.getValFromString(string, this.fR);
                if (this.fR < 0) {
                    this.fR = 0;
                } else if (this.fR > this.fMaxValue) {
                    this.fR = this.fMaxValue;
                }
            }
            n = 1;
        } else if (object == this.fFields[1]) {
            if (string2.equals("")) {
                this.fG = 0;
            } else {
                this.fG = this.getValFromString(string2, this.fG);
                if (this.fG < 0) {
                    this.fG = 0;
                } else if (this.fG > this.fMaxValue) {
                    this.fG = this.fMaxValue;
                }
            }
            n = 2;
        } else if (object == this.fFields[2]) {
            if (string3.equals("")) {
                this.fB = 0;
            } else {
                this.fB = this.getValFromString(string3, this.fB);
                if (this.fB < 0) {
                    this.fB = 0;
                } else if (this.fB > this.fMaxValue) {
                    this.fB = this.fMaxValue;
                }
            }
            n = 4;
        }
        this.fSelected.setColor(this.fR, this.fG, this.fB, this.fMaxValue);
        ((Component)((Object)this.fSelected)).repaint();
        this.updateTextFields(n);
        this.updateSliders(n);
        this.updateColorBars(~n);
        this.fireItemStateChanged();
    }

    public static void main(String[] stringArray) {
        try {
            MWFrame mWFrame = new MWFrame("Color Picker");
            ColorPicker colorPicker = new ColorPicker();
            mWFrame.add((Component)((Object)colorPicker), "Center");
            mWFrame.setResizable(false);
            mWFrame.pack();
            mWFrame.setVisible(true);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    static /* synthetic */ int access$1() {
        return 7;
    }

    static /* synthetic */ int access$3() {
        return 0;
    }

    static /* synthetic */ int access$6() {
        return 1;
    }

    static /* synthetic */ int access$7() {
        return 1;
    }

    static /* synthetic */ int access$10() {
        return 2;
    }

    static /* synthetic */ int access$11() {
        return 2;
    }

    static /* synthetic */ int access$14() {
        return 4;
    }

    private class EventHandler
    extends FocusAdapter
    implements ActionListener,
    AdjustmentListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ColorPicker.this.updateViaField(actionEvent.getSource());
        }

        public void focusLost(FocusEvent focusEvent) {
            ColorPicker.this.updateViaField(focusEvent.getSource());
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Adjustable adjustable = adjustmentEvent.getAdjustable();
            int n = ColorPicker.access$1();
            if (adjustable == ColorPicker.this.fSliders[ColorPicker.access$3()]) {
                ColorPicker.this.fR = ColorPicker.this.fSliders[ColorPicker.access$3()].getValue();
                n = ColorPicker.access$6();
            } else if (adjustable == ColorPicker.this.fSliders[ColorPicker.access$7()]) {
                ColorPicker.this.fG = ColorPicker.this.fSliders[ColorPicker.access$7()].getValue();
                n = ColorPicker.access$10();
            } else if (adjustable == ColorPicker.this.fSliders[ColorPicker.access$11()]) {
                ColorPicker.this.fB = ColorPicker.this.fSliders[ColorPicker.access$11()].getValue();
                n = ColorPicker.access$14();
            }
            ColorPicker.this.fSelected.setColor(ColorPicker.this.fR, ColorPicker.this.fG, ColorPicker.this.fB, ColorPicker.this.fMaxValue);
            ((Component)((Object)ColorPicker.this.fSelected)).repaint();
            ColorPicker.this.updateTextFields(n);
            ColorPicker.this.updateColorBars(~n);
            ColorPicker.this.fireItemStateChanged();
        }

        EventHandler() {
            ColorPicker.this = ColorPicker.this;
        }
    }
}

