/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.decorations.Decorations;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;

class ColorBar
extends MWCanvas {
    private static final int HEIGHT = 4;
    private static final int FOURTH = 0;
    private int[] fPixData;
    private Dimension fCachedSize;
    private int fLength;
    private int fFourth;
    private MemoryImageSource fSource;
    private Image fImage;
    private int fR;
    private int fG;
    private int fB;
    private int fHGap;
    private boolean fFilterPending;
    private int fPr;
    private int fPg;
    private int fPb;

    ColorBar(int n, int n2, int n3, int n4) {
        Font font = Decorations.getFont((int)0);
        ((Component)((Object)this)).setFont(new Font(font.getName(), font.getStyle(), 9));
        this.fPixData = new int[4];
        this.fR = n;
        this.fG = n2;
        this.fB = n3;
        this.fHGap = n4;
        this.fLength = 0;
        this.fFourth = 0;
        this.fSource = null;
        this.fImage = null;
        this.fCachedSize = null;
        this.fFilterPending = false;
    }

    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = ((Component)((Object)this)).getFontMetrics(((Component)((Object)this)).getFont());
        int n = ((Component)((Object)this)).getSize().width;
        int n2 = ((Component)((Object)this)).getSize().height;
        if (this.fCachedSize == null || !this.fCachedSize.equals(((Component)((Object)this)).getSize())) {
            this.fCachedSize = ((Component)((Object)this)).getSize();
            this.calculateBarMetrics();
            this.buildImage(this.fR, this.fG, this.fB);
            if (this.fFilterPending) {
                this.applyFilter(this.fPr, this.fPg, this.fPb);
            }
        }
        graphics.drawImage(this.fImage, this.fHGap, 0, (ImageObserver)((Object)this));
        graphics.setColor(Color.white);
        int n3 = this.fHGap + this.fFourth;
        graphics.drawLine(n3, 0, n3, 4);
        graphics.drawLine(n3 += this.fFourth, 0, n3, 4);
        graphics.drawLine(n3 += this.fFourth, 0, n3, 4);
        graphics.setColor(((Component)((Object)this)).getBackground());
        graphics.fillRect(0, 0, this.fHGap, n2);
        graphics.fillRect(n - this.fHGap, 0, this.fHGap, n2);
        graphics.fillRect(this.fHGap, 4, n - 2 * this.fHGap, n2 - 4);
        int n4 = 4 + fontMetrics.getLeading() + fontMetrics.getAscent();
        graphics.setColor(Color.black);
        graphics.setFont(((Component)((Object)this)).getFont());
        int n5 = fontMetrics.stringWidth("0");
        n3 = n5 / 2 > this.fHGap ? 0 : this.fHGap - n5 / 2;
        graphics.drawString("0", n3, n4);
        n5 = fontMetrics.stringWidth("25");
        n3 = this.fHGap + this.fFourth - n5 / 2;
        graphics.drawString("25", n3, n4);
        n5 = fontMetrics.stringWidth("50");
        n3 = this.fHGap + 2 * this.fFourth - n5 / 2;
        graphics.drawString("50", n3, n4);
        n5 = fontMetrics.stringWidth("75");
        n3 = this.fHGap + 3 * this.fFourth - n5 / 2;
        graphics.drawString("75", n3, n4);
        n5 = fontMetrics.stringWidth("100");
        n3 = n5 / 2 > this.fHGap ? n - n5 : n - this.fHGap - n5 / 2;
        graphics.drawString("100", n3, n4);
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = ((Component)((Object)this)).getFontMetrics(((Component)((Object)this)).getFont());
        return new Dimension(100, 4 + fontMetrics.getHeight());
    }

    private void calculateBarMetrics() {
        this.fLength = ((Component)((Object)this)).getSize().width - 2 * this.fHGap;
        this.fFourth = this.fLength / 4;
    }

    void applyFilter(int n, int n2, int n3) {
        if (this.fSource != null) {
            int n4 = 0;
            while (n4 < this.fPixData.length) {
                int n5 = this.fPixData[n4];
                int n6 = this.fR == -1 ? n5 >> 16 & 0xFF : n;
                int n7 = this.fG == -1 ? n5 >> 8 & 0xFF : n2;
                int n8 = this.fB == -1 ? n5 & 0xFF : n3;
                this.fPixData[n4] = n5 = n5 & 0xFF000000 | n6 << 16 | n7 << 8 | n8;
                ++n4;
            }
            this.fSource.newPixels();
            this.fFilterPending = false;
            return;
        }
        this.fFilterPending = true;
        this.fPr = n;
        this.fPg = n2;
        this.fPb = n3;
    }

    private void buildImage(int n, int n2, int n3) {
        int n4 = -16777216;
        this.fPixData = new int[this.fLength * 4];
        this.fSource = new MemoryImageSource(this.fLength, 4, this.fPixData, 0, this.fLength);
        this.fSource.setAnimated(true);
        this.fSource.setFullBufferUpdates(true);
        int n5 = 0;
        while (n5 < this.fPixData.length) {
            int n6 = n5 % this.fLength;
            int n7 = 255 * n6 / this.fLength;
            if (n == -1) {
                this.fPixData[n5] = n4 | n7 << 16 | n2 << 8 | n3;
            } else if (n2 == -1) {
                this.fPixData[n5] = n4 | n << 16 | n7 << 8 | n3;
            } else if (n3 == -1) {
                this.fPixData[n5] = n4 | n << 16 | n2 << 8 | n7;
            }
            ++n5;
        }
        this.fImage = ((Component)((Object)this)).createImage(this.fSource);
    }
}

