/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.beans.editors.EnhancedPropertyEditor;
import com.mathworks.util.ResLoader;
import java.awt.Frame;
import java.awt.Image;
import java.beans.PropertyEditorSupport;

public class BooleanEditor
extends PropertyEditorSupport
implements EnhancedPropertyEditor {
    private static Image sTrueIcon = null;
    private static Image sFalseIcon = null;
    private static Image sMixedIcon = null;
    private Boolean fValue;

    public Object getValue() {
        return this.fValue;
    }

    public void setValue(Object object) {
        if (object == null || object instanceof Boolean) {
            this.fValue = (Boolean)object;
            this.firePropertyChange();
            return;
        }
        if (object instanceof String) {
            throw new IllegalArgumentException((String)object);
        }
        throw new IllegalArgumentException();
    }

    public String getAsText() {
        if (this.fValue.booleanValue()) {
            return "True";
        }
        return "False";
    }

    public void setAsText(String string) {
        this.setValue(new Boolean(string.equals("True")));
    }

    public String[] getTags() {
        String[] stringArray = new String[]{"True", "False"};
        return stringArray;
    }

    public Image getIcon() {
        Image image = null;
        this.initIcons();
        Object object = this.getValue();
        if (object == null) {
            image = sMixedIcon;
        } else if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            image = bl == null ? sMixedIcon : (bl != false ? sTrueIcon : sFalseIcon);
        }
        return image;
    }

    public void setFrame(Frame frame) {
    }

    public boolean hasAttachedData() {
        return false;
    }

    public String getDataKey() {
        return null;
    }

    public void setData(Object object) {
    }

    private void initIcons() {
        if (sTrueIcon == null || sFalseIcon == null) {
            ResLoader resLoader = new ResLoader(this.getClass());
            if (sTrueIcon == null) {
                sTrueIcon = resLoader.loadImage("resources/LightbulbOnIcon.gif");
            }
            if (sFalseIcon == null) {
                sFalseIcon = resLoader.loadImage("resources/LightbulbOffIcon.gif");
            }
            if (sMixedIcon == null) {
                sMixedIcon = resLoader.loadImage("resources/LightbulbMixedIcon.gif");
            }
        }
    }
}

