/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.beans.editors.FontPicker;
import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWChoice;
import com.mathworks.mwt.MWCombobox;
import com.mathworks.mwt.MWFontHandler;
import com.mathworks.mwt.MWPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

class BasicFontPicker
extends MWPanel {
    private FontPicker fOwner;
    private MWChoice fNameChoice;
    private MWChoice fStyleChoice;
    private MWCombobox fSizeCombo;

    BasicFontPicker(FontPicker fontPicker) {
        this.fOwner = fontPicker;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ChoiceHandler choiceHandler = new ChoiceHandler();
        this.fNameChoice = new MWChoice();
        this.fNameChoice.setRestrictWidth(false);
        this.fNameChoice.addItemListener((ItemListener)choiceHandler);
        int n = 0;
        while (n < FontPicker.NAMES.length) {
            this.fNameChoice.add(FontPicker.NAMES[n]);
            ++n;
        }
        ((Container)((Object)this)).add((Component)this.fNameChoice, "Center");
        MWPanel mWPanel = new MWPanel((LayoutManager)new FlowLayout(1, 0, 0));
        mWPanel.add((Component)new MWCanvas(4, 4));
        this.fStyleChoice = new MWChoice();
        this.fStyleChoice.addItemListener((ItemListener)choiceHandler);
        int n2 = 0;
        while (n2 < FontPicker.STYLES.length) {
            this.fStyleChoice.add(FontPicker.STYLES[n2]);
            ++n2;
        }
        mWPanel.add((Component)this.fStyleChoice);
        mWPanel.add((Component)new MWCanvas(4, 4));
        this.fSizeCombo = new MWCombobox(FontPicker.SIZES[0], FontPicker.SIZES);
        this.fSizeCombo.addTextListener((TextListener)choiceHandler);
        this.fSizeCombo.addActionListener((ActionListener)choiceHandler);
        mWPanel.add((Component)this.fSizeCombo);
        ((Container)((Object)this)).add((Component)mWPanel, "East");
        this.updateControls();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width > 275) {
            dimension.width = 275;
        }
        return dimension;
    }

    protected void updateControls() {
        Font font = this.fOwner.getSelectedFont();
        String string = MWFontHandler.getJavaFontName((String)font.getName());
        int n = font.getStyle();
        int n2 = font.getSize();
        int n3 = 0;
        while (n3 < this.fNameChoice.getItemCount()) {
            String string2 = MWFontHandler.getJavaFontName((String)this.fNameChoice.getItem(n3));
            if (string.equals(string2)) {
                this.fNameChoice.select(n3);
                break;
            }
            ++n3;
        }
        this.fStyleChoice.select(n);
        this.fSizeCombo.setText(Integer.toString(n2));
        this.fNameChoice.setEnabled(((Component)((Object)this.fOwner)).isEnabled());
        this.fStyleChoice.setEnabled(((Component)((Object)this.fOwner)).isEnabled());
        this.fSizeCombo.setEnabled(((Component)((Object)this.fOwner)).isEnabled());
    }

    private boolean updateSelectedFont() {
        int n;
        String string = this.fNameChoice.getSelectedItem();
        int n2 = this.fStyleChoice.getSelectedIndex();
        Font font = this.fOwner.getSelectedFont();
        boolean bl = false;
        try {
            n = Integer.parseInt(this.fSizeCombo.getText());
            if (n < 0) {
                n = font.getSize();
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = font.getSize();
        }
        if (!(string = MWFontHandler.getJavaFontName((String)string)).equals(MWFontHandler.getJavaFontName((String)font.getName())) || n2 != font.getStyle() || n != font.getSize()) {
            this.fOwner.setSelectedFont(new Font(string, n2, n));
            bl = true;
        }
        return bl;
    }

    private class ChoiceHandler
    implements ItemListener,
    TextListener,
    ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicFontPicker.this.updateSelectedFont()) {
                BasicFontPicker.this.fOwner.fireItemEvent();
                return;
            }
            BasicFontPicker.this.updateControls();
        }

        public void textValueChanged(TextEvent textEvent) {
            if (BasicFontPicker.this.updateSelectedFont()) {
                BasicFontPicker.this.fOwner.fireItemEvent();
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (BasicFontPicker.this.updateSelectedFont()) {
                BasicFontPicker.this.fOwner.fireItemEvent();
            }
        }

        ChoiceHandler() {
            BasicFontPicker.this = BasicFontPicker.this;
        }
    }
}

