/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans;

import com.mathworks.beans.ServiceClient;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class ServiceRegistry {
    private Hashtable fTable = new Hashtable();

    public void registerService(String string, Object object) {
        ServiceEntry serviceEntry = (ServiceEntry)this.fTable.get(string);
        if (serviceEntry == null) {
            serviceEntry = new ServiceEntry();
            serviceEntry.services = new Vector(1);
            serviceEntry.services.addElement(object);
            this.fTable.put(string, serviceEntry);
            return;
        }
        if (serviceEntry.services == null) {
            serviceEntry.services = new Vector();
        }
        serviceEntry.services.addElement(object);
        if (serviceEntry.clients != null) {
            Enumeration enumeration = serviceEntry.clients.elements();
            while (enumeration.hasMoreElements()) {
                ServiceClient serviceClient = (ServiceClient)enumeration.nextElement();
                serviceClient.serviceRegistered(this, string, object);
            }
        }
    }

    public void unregisterService(String string, Object object) {
        ServiceEntry serviceEntry = (ServiceEntry)this.fTable.get(string);
        if (serviceEntry != null && serviceEntry.services != null && serviceEntry.services.contains(object)) {
            serviceEntry.services.removeElement(object);
            if (serviceEntry.services.isEmpty()) {
                serviceEntry.services = null;
                if (serviceEntry.clients == null) {
                    this.fTable.remove(string);
                    return;
                }
            }
            if (serviceEntry.clients != null) {
                Enumeration enumeration = serviceEntry.clients.elements();
                while (enumeration.hasMoreElements()) {
                    ServiceClient serviceClient = (ServiceClient)enumeration.nextElement();
                    serviceClient.serviceUnregistered(this, string, object);
                }
            }
        }
    }

    public int getServiceCount(String string) {
        int n = 0;
        ServiceEntry serviceEntry = (ServiceEntry)this.fTable.get(string);
        if (serviceEntry != null && serviceEntry.services != null) {
            n = serviceEntry.services.size();
        }
        return n;
    }

    public Object getService(String string, int n) {
        Object var3_3 = null;
        ServiceEntry serviceEntry = (ServiceEntry)this.fTable.get(string);
        if (serviceEntry != null && serviceEntry.services != null && n >= 0 && n < serviceEntry.services.size()) {
            var3_3 = serviceEntry.services.elementAt(n);
        }
        return var3_3;
    }

    public Object getService(String string) {
        return this.getService(string, 0);
    }

    public synchronized void requestNotification(String string, ServiceClient serviceClient) {
        ServiceEntry serviceEntry = (ServiceEntry)this.fTable.get(string);
        if (serviceEntry == null) {
            serviceEntry = new ServiceEntry();
            serviceEntry.clients = new Vector(1);
            serviceEntry.clients.addElement(serviceClient);
            this.fTable.put(string, serviceEntry);
            return;
        }
        if (serviceEntry.clients == null) {
            serviceEntry.clients = new Vector();
        }
        serviceEntry.clients.addElement(serviceClient);
    }

    public synchronized void unrequestNotification(String string, ServiceClient serviceClient) {
        ServiceEntry serviceEntry = (ServiceEntry)this.fTable.get(string);
        if (serviceEntry != null && serviceEntry.clients != null) {
            serviceEntry.clients.removeElement(serviceClient);
            if (serviceEntry.clients.size() == 0) {
                serviceEntry.clients = null;
            }
            if (serviceEntry.services == null) {
                this.fTable.remove(string);
            }
        }
    }

    private class ServiceEntry {
        Vector services;
        Vector clients;

        ServiceEntry() {
            ServiceRegistry.this = ServiceRegistry.this;
        }
    }
}

