/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;

public class ParserJavaInterface {
    public static String getObjectClassname(Object object) {
        return object.getClass().getName().replace('.', '/');
    }

    public static boolean doesMethodExist(String string, String string2) {
        boolean bl = false;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string.replace('/', '.'));
        }
        catch (Exception exception) {}
        if (clazz != null) {
            Method[] methodArray = clazz.getMethods();
            int n = 0;
            while (n < methodArray.length) {
                if (methodArray[n].getName().equals(string2)) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public static String[] getMethodNames(String string) {
        String[] stringArray = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string.replace('/', '.'));
        }
        catch (Exception exception) {}
        if (clazz != null) {
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Method[] methodArray = clazz.getMethods();
            stringArray = new String[constructorArray.length + methodArray.length];
            int n = 0;
            while (n < constructorArray.length) {
                stringArray[n] = constructorArray[n].toString();
                ++n;
            }
            n = 0;
            while (n < methodArray.length) {
                stringArray[constructorArray.length + n] = methodArray[n].toString();
                ++n;
            }
        }
        return stringArray;
    }

    private static String typeToString(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz2 = clazz;
        if (clazz.isArray()) {
            stringBuffer.append('[');
            clazz2 = clazz.getComponentType();
            stringBuffer.append(ParserJavaInterface.typeToString(clazz2));
        } else if (clazz2.isPrimitive()) {
            if (clazz2.equals(Void.TYPE)) {
                stringBuffer.append('V');
            } else if (clazz2.equals(Boolean.TYPE)) {
                stringBuffer.append('Z');
            } else if (clazz2.equals(Byte.TYPE)) {
                stringBuffer.append('B');
            } else if (clazz2.equals(Character.TYPE)) {
                stringBuffer.append('C');
            } else if (clazz2.equals(Short.TYPE)) {
                stringBuffer.append('S');
            } else if (clazz2.equals(Integer.TYPE)) {
                stringBuffer.append('I');
            } else if (clazz2.equals(Long.TYPE)) {
                stringBuffer.append('J');
            } else if (clazz2.equals(Float.TYPE)) {
                stringBuffer.append('F');
            } else if (clazz2.equals(Double.TYPE)) {
                stringBuffer.append('D');
            }
        } else {
            stringBuffer.append('L');
            stringBuffer.append(clazz2.getName().replace('.', '/'));
            stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }

    private static String makeSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(ParserJavaInterface.typeToString(classArray[n]));
            ++n;
        }
        stringBuffer.append(')');
        stringBuffer.append(ParserJavaInterface.typeToString(method.getReturnType()));
        return stringBuffer.toString();
    }

    private static String makeSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Class<?>[] classArray = constructor.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(ParserJavaInterface.typeToString(classArray[n]));
            ++n;
        }
        stringBuffer.append(')');
        stringBuffer.append('V');
        return stringBuffer.toString();
    }

    public static String[] getMethodSignatures(String string, String string2) {
        String[] stringArray;
        block8: {
            stringArray = null;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string.replace('/', '.'));
            }
            catch (Exception exception) {}
            if (clazz == null) break block8;
            if (string2 == null) {
                Constructor<?>[] constructorArray = clazz.getConstructors();
                stringArray = new String[constructorArray.length];
                int n = 0;
                while (n < constructorArray.length) {
                    stringArray[n] = ParserJavaInterface.makeSignature(constructorArray[n]);
                    ++n;
                }
            } else {
                Vector<Method> vector = new Vector<Method>();
                Method[] methodArray = clazz.getMethods();
                int n = 0;
                while (n < methodArray.length) {
                    if (methodArray[n].getName().equals(string2)) {
                        vector.addElement(methodArray[n]);
                    }
                    ++n;
                }
                int n2 = vector.size();
                stringArray = new String[n2];
                n = 0;
                while (n < n2) {
                    stringArray[n] = ParserJavaInterface.makeSignature((Method)vector.elementAt(n));
                    ++n;
                }
            }
        }
        return stringArray;
    }

    public static byte[] serializeObject(Object object) {
        byte[] byArray = null;
        if (object instanceof Serializable) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
            }
            catch (Exception exception) {}
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    public static boolean isObjectInstanceOfClass(Object object, String string) {
        boolean bl = false;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string.replace('/', '.'));
        }
        catch (Exception exception) {}
        if (clazz != null) {
            bl = clazz.isInstance(object);
        }
        return bl;
    }

    public static Object unserializeObject(byte[] byArray) {
        Object object = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {}
        return object;
    }

    public static String getExceptionMessage(Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Java exception occurred: \n");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
        throwable.printStackTrace(printWriter);
        stringBuffer.append(byteArrayOutputStream.toString());
        if (stringBuffer.charAt(stringBuffer.length() - 1) == '\n') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private static void printStrings(String[] stringArray, String string) {
        System.out.println(string);
        int n = 0;
        while (n < stringArray.length) {
            System.out.println("     " + stringArray[n]);
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        String string = new String("foo");
        Color color = new Color(0, 0, 100);
        String string2 = ParserJavaInterface.getObjectClassname(string).replace('.', '/');
        String string3 = ParserJavaInterface.getObjectClassname(color).replace('.', '/');
        System.out.println("String classname: " + string2);
        System.out.println("Color classname: " + string3);
        boolean bl = ParserJavaInterface.doesMethodExist(string2, "getClass");
        boolean bl2 = ParserJavaInterface.doesMethodExist(string2, "toString");
        boolean bl3 = ParserJavaInterface.doesMethodExist(string3, "getRed");
        boolean bl4 = ParserJavaInterface.doesMethodExist(string3, "getFooBar");
        System.out.println("method existence: " + bl + bl2 + bl3 + bl4);
        String[] stringArray2 = ParserJavaInterface.getMethodNames(string2);
        System.out.println();
        ParserJavaInterface.printStrings(stringArray2, "String methods");
        String[] stringArray3 = ParserJavaInterface.getMethodSignatures(string2, "toString");
        System.out.println();
        ParserJavaInterface.printStrings(stringArray3, "toString sigs");
        stringArray3 = ParserJavaInterface.getMethodSignatures(string3, "RGBtoHSB");
        System.out.println();
        ParserJavaInterface.printStrings(stringArray3, "RGBtoHSB sigs");
        stringArray3 = ParserJavaInterface.getMethodSignatures(string3, "getRed");
        System.out.println();
        ParserJavaInterface.printStrings(stringArray3, "getRed sigs");
        stringArray3 = ParserJavaInterface.getMethodSignatures(string3, "getColor");
        System.out.println();
        ParserJavaInterface.printStrings(stringArray3, "getColor sigs");
        Color.getColor("biteme");
        stringArray3 = ParserJavaInterface.getMethodSignatures(string3, null);
        System.out.println();
        ParserJavaInterface.printStrings(stringArray3, "Color constructor sigs");
        stringArray3 = ParserJavaInterface.getMethodSignatures("java/lang/StringBuffer", "append");
        System.out.println();
        ParserJavaInterface.printStrings(stringArray3, "append sigs");
        stringArray3 = ParserJavaInterface.getMethodSignatures(string2, "notify");
        System.out.println();
        ParserJavaInterface.printStrings(stringArray3, "notify");
        stringArray3 = ParserJavaInterface.getMethodSignatures("com/mathworks/jmi/TestClass", "testMethod");
        System.out.println();
        ParserJavaInterface.printStrings(stringArray3, "TestClass testMethod");
        stringArray3 = ParserJavaInterface.getMethodSignatures("com/mathworks/jmi/TestClass", null);
        System.out.println();
        ParserJavaInterface.printStrings(stringArray3, "TestClass constructors");
        try {
            int[] nArray = new int[5];
            nArray[6] = 10;
            return;
        }
        catch (Exception exception) {
            String string4 = ParserJavaInterface.getExceptionMessage(exception);
            System.out.println(string4);
            return;
        }
    }
}

