/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MatlabException;
import com.mathworks.jmi.MatlabLooper;
import com.mathworks.mwt.message.MWHandler;
import com.mathworks.mwt.message.MWLooper;
import com.mathworks.mwt.message.MWMessage;
import com.mathworks.mwt.window.WindowRegistry;
import java.util.Enumeration;
import java.util.Hashtable;

public class Matlab {
    public static final int EVAL = -1;
    public static final int CONSOLE_OUTPUT = 0;
    public static final int CAPTURE_OUTPUT = 1;
    public static final int STREAM_OUTPUT = 2;
    public static final int NO_OUTPUT = 4;
    public static final int RESULT = -2;
    public static final int FEVAL = -3;
    public static final int GET_VARIABLE = -4;
    public static final int SET_VARIABLE = -5;
    public static final int SEND = -6;
    public static final int REGISTER_INTEREST = -8;
    public static final int UNREGISTER_INTEREST = -9;
    public static final int INTEREST_REPLY = -10;
    public static final int INTEREST_BP_INFO = -51;
    public static final int DEBUG_FAMILY = 1;
    public static final int DEBUG_BP_ADD = Integer.MIN_VALUE;
    public static final int DEBUG_BP_CLEAR = 0x40000000;
    public static final int DEBUG_BP_DELETE = 0x20000000;
    public static final int DEBUG_EXIT = 0x10000000;
    public static final int DEBUG_GO = 0x8000000;
    public static final int DEBUG_STOP = 0x4000000;
    public static final int DEBUG_STOPIF = 0x2000000;
    public static final int DEBUG_ALL_EVENTS = 1;
    public static final int PATH_FAMILY = 2;
    public static final int PATH_CHANGE = Integer.MIN_VALUE;
    public static final int PATH_CWD_CHANGE = 0x40000000;
    public static final int PATH_ALL_EVENTS = 1;
    public static final int WORKSPACE_FAMILY = 3;
    public static final int WS_SCOPE = Integer.MIN_VALUE;
    public static final int WS_ADD = 0x40000000;
    public static final int WS_CLEAR = 0x20000000;
    public static final int WS_DELETE = 0x10000000;
    public static final int WS_ARRAY_CHANGE = 0x8000000;
    public static final int WS_ARRAY_ALL = 1;
    public static final int DEBUG_STOPIF_ERROR = 1;
    public static final int DEBUG_STOPIF_WARNING = 2;
    public static final int DEBUG_STOPIF_NANINF = 4;
    public static final String STRING_STR = "string";
    public static final String FLAGS_STR = "flags";
    public static final String RESULT_STR = "result";
    public static final String STATUS_STR = "status";
    public static final String ARGUMENTS_STR = "arguments";
    public static final String NLHS_STR = "nlhs";
    public static final String VALUE_STR = "value";
    public static final String HANDLE_STR = "handle";
    public static final String FAMILYID_STR = "familyid";
    public static final String EVENTID_STR = "eventid";
    public static final String INTEREST_STR = "interest";
    public static final String LEVEL_STR = "level";
    public static final String LINENO_STR = "lineno";
    public static final int NO = 0;
    public static final int YES = 1;
    public static final int EXECUTION_SUCCESS = 0;
    public static final int COMPILE_ERROR = 1;
    public static final int RUNTIME_ERROR = 2;
    public static final int EXECUTION_DBQUIT = 3;
    public static final int EXECUTION_CTRLC = 4;
    public static final int STREAM_STATUS = 33;
    public static final int BASE_PROMPT = 0;
    public static final int DEBUG_PROMPT = 1;
    public static final int INPUT_PROMPT = 2;
    public static final int KEYBOARD_PROMPT = 3;
    public static final int PAUSE_PROMPT = 4;
    public static final int MORE_PROMPT = 5;
    public static final int COMPLETE_CODE_BLOCK = 0;
    public static final int INCOMPLETE_CODE_BLOCK = 1;
    public static final int INVALID_CODE_BLOCK = 2;
    private static boolean sMatlabAvailable;
    private MWLooper fLooper;
    private Hashtable fInterests;
    private int fNextHash;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Integer;

    public Matlab() {
    }

    public Matlab(MWLooper mWLooper) {
        this.fLooper = mWLooper;
        mWLooper.start();
    }

    public static void setMatlabAvailable(boolean bl) {
        sMatlabAvailable = bl;
    }

    public static boolean isMatlabAvailable() {
        return sMatlabAvailable;
    }

    public static int matlabQuitting() {
        if (WindowRegistry.getRegistry().closeAllWindows() == 0) {
            return 0;
        }
        return 1;
    }

    public static final int getFigureStatus(int n) {
        return n >>> 24 & 0xFF;
    }

    public static final int getExecutionStatus(int n) {
        return n >> 16 & 0xFF;
    }

    public static final int getInputRequester(int n) {
        return n >> 8 & 0xFF;
    }

    public static final int getCodeBlockStatus(int n) {
        return n & 0xFF;
    }

    public String eval(String string) throws InterruptedException, MatlabException {
        MWMessage mWMessage = new MWMessage(-1);
        mWMessage.addData(STRING_STR, (Object)string);
        mWMessage.addInteger(FLAGS_STR, 1);
        String string2 = (String)this.postSync(mWMessage);
        if (string2 == null) {
            string2 = "";
        }
        return string2.trim();
    }

    public Object feval(String string, Object[] objectArray) throws InterruptedException, MatlabException {
        MWMessage mWMessage = new MWMessage(-3);
        mWMessage.addData(STRING_STR, (Object)string);
        mWMessage.addData(ARGUMENTS_STR, (Object)objectArray);
        return this.postSync(mWMessage);
    }

    public Object feval(String string, Object[] objectArray, int n) throws InterruptedException, MatlabException {
        MWMessage mWMessage = new MWMessage(-3);
        mWMessage.addData(STRING_STR, (Object)string);
        mWMessage.addData(ARGUMENTS_STR, (Object)objectArray);
        mWMessage.addInteger(NLHS_STR, n);
        return this.postSync(mWMessage);
    }

    public Object getVariable(String string) throws InterruptedException, MatlabException {
        MWMessage mWMessage = new MWMessage(-4);
        mWMessage.addData(STRING_STR, (Object)string);
        return this.postSync(mWMessage);
    }

    public Object setVariable(String string, Object object) throws InterruptedException, MatlabException {
        MWMessage mWMessage = new MWMessage(-5);
        mWMessage.addData(STRING_STR, (Object)string);
        mWMessage.addData(VALUE_STR, object);
        return this.postSync(mWMessage);
    }

    public void evalConsoleOutput(String string) {
        MWMessage mWMessage = new MWMessage(-1);
        mWMessage.addData(STRING_STR, (Object)string);
        MatlabLooper.postMatlabMessage(mWMessage);
    }

    public void evalNoOutput(String string) {
        MWMessage mWMessage = new MWMessage(-1);
        mWMessage.addData(STRING_STR, (Object)string);
        mWMessage.addInteger(FLAGS_STR, 4);
        MatlabLooper.postMatlabMessage(mWMessage);
    }

    public void evalStreamOutput(String string, CompletionObserver completionObserver) {
        MWMessage mWMessage = new MWMessage(-1);
        mWMessage.addData(STRING_STR, (Object)string);
        mWMessage.addInteger(FLAGS_STR, 2);
        this.postStream(mWMessage, completionObserver);
    }

    public void eval(String string, CompletionObserver completionObserver) {
        MWMessage mWMessage = new MWMessage(-1);
        mWMessage.addData(STRING_STR, (Object)string);
        mWMessage.addInteger(FLAGS_STR, 1);
        this.postAsync(mWMessage, completionObserver);
    }

    public void feval(String string, Object[] objectArray, CompletionObserver completionObserver) {
        MWMessage mWMessage = new MWMessage(-3);
        mWMessage.addData(STRING_STR, (Object)string);
        mWMessage.addData(ARGUMENTS_STR, (Object)objectArray);
        this.postAsync(mWMessage, completionObserver);
    }

    public void feval(String string, Object[] objectArray, int n, CompletionObserver completionObserver) {
        MWMessage mWMessage = new MWMessage(-3);
        mWMessage.addData(STRING_STR, (Object)string);
        mWMessage.addData(ARGUMENTS_STR, (Object)objectArray);
        mWMessage.addInteger(NLHS_STR, n);
        this.postAsync(mWMessage, completionObserver);
    }

    public void getVariable(String string, CompletionObserver completionObserver) {
        MWMessage mWMessage = new MWMessage(-4);
        mWMessage.addData(STRING_STR, (Object)string);
        this.postAsync(mWMessage, completionObserver);
    }

    public void setVariable(String string, Object object, CompletionObserver completionObserver) {
        MWMessage mWMessage = new MWMessage(-5);
        mWMessage.addData(STRING_STR, (Object)string);
        mWMessage.addData(VALUE_STR, object);
        this.postAsync(mWMessage, completionObserver);
    }

    public void send(double d, String string, Object[] objectArray) {
        MWMessage mWMessage = new MWMessage(-6);
        mWMessage.addDouble(HANDLE_STR, d);
        mWMessage.addData(STRING_STR, (Object)string);
        mWMessage.addData(ARGUMENTS_STR, (Object)objectArray);
        MatlabLooper.postMatlabMessage(mWMessage);
    }

    public Object registerInterest(int n, int n2, CompletionObserver completionObserver) {
        if (this.fLooper == null) {
            return null;
        }
        if (this.fInterests == null) {
            this.fInterests = new Hashtable();
        }
        MWMessage mWMessage = new MWMessage(-8);
        mWMessage.addInteger(FAMILYID_STR, n);
        mWMessage.addInteger(EVENTID_STR, n2);
        Integer n3 = new Integer(this.fNextHash++);
        InterestHandler interestHandler = new InterestHandler(this.fLooper, completionObserver);
        this.fInterests.put(n3, interestHandler);
        MatlabLooper.postMatlabMessage(mWMessage, interestHandler);
        return n3;
    }

    public void unregisterInterest(Object object) {
        if (this.fInterests == null) {
            return;
        }
        InterestHandler interestHandler = (InterestHandler)((Object)this.fInterests.get(object));
        if (interestHandler == null) {
            return;
        }
        MWMessage mWMessage = new MWMessage(-9);
        mWMessage.addInteger(INTEREST_STR, interestHandler.getInterestID());
        MatlabLooper.postMatlabMessage(mWMessage);
        this.fLooper.removeHandler((MWHandler)interestHandler);
        this.fInterests.remove(object);
    }

    public void unregisterAll() {
        if (this.fLooper == null) {
            return;
        }
        MWLooper mWLooper = this.fLooper;
        this.fLooper.quit();
        this.fLooper = null;
        if (this.fInterests == null) {
            return;
        }
        Enumeration enumeration = this.fInterests.elements();
        while (enumeration.hasMoreElements()) {
            InterestHandler interestHandler = (InterestHandler)((Object)enumeration.nextElement());
            mWLooper.removeHandler((MWHandler)interestHandler);
            MWMessage mWMessage = new MWMessage(-9);
            mWMessage.addInteger(INTEREST_STR, interestHandler.getInterestID());
            MatlabLooper.postMatlabMessage(mWMessage);
        }
        this.fInterests = null;
    }

    public void Interrupt() {
    }

    private Object postSync(MWMessage mWMessage) throws InterruptedException, MatlabException {
        BlockingObserver blockingObserver = new BlockingObserver();
        this.postAsync(mWMessage, blockingObserver);
        blockingObserver.waitForReply();
        if (blockingObserver.getStatus() < 0) {
            throw new MatlabException();
        }
        return blockingObserver.getResult();
    }

    private void postAsync(MWMessage mWMessage, CompletionObserver completionObserver) {
        if (this.fLooper != null) {
            CompletionHandler completionHandler = new CompletionHandler(this.fLooper, completionObserver);
            MatlabLooper.postMatlabMessage(mWMessage, completionHandler);
            return;
        }
        CompletionLooper completionLooper = new CompletionLooper(completionObserver);
        MatlabLooper.postMatlabMessage(mWMessage, (MWHandler)completionLooper);
    }

    private void postStream(MWMessage mWMessage, CompletionObserver completionObserver) {
        if (this.fLooper != null) {
            CompletionHandler completionHandler = new CompletionHandler(this.fLooper, completionObserver);
            MatlabLooper.postMatlabMessage(mWMessage, completionHandler);
            return;
        }
        StreamLooper streamLooper = new StreamLooper(completionObserver);
        MatlabLooper.postMatlabMessage(mWMessage, (MWHandler)streamLooper);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class BlockingObserver
    implements CompletionObserver {
        private int fStatus;
        private Object fResult;
        private boolean fCompleted = false;

        BlockingObserver() {
            Matlab.this = Matlab.this;
        }

        public synchronized void completed(int n, Object object) {
            this.fStatus = n;
            this.fResult = object;
            this.fCompleted = true;
            this.notifyAll();
        }

        synchronized void waitForReply() throws InterruptedException {
            while (!this.fCompleted) {
                this.wait();
            }
        }

        int getStatus() {
            return this.fStatus;
        }

        Object getResult() {
            return this.fResult;
        }
    }

    private class CompletionHandler
    extends MWHandler {
        private CompletionObserver fObserver;

        CompletionHandler(MWLooper mWLooper, CompletionObserver completionObserver) {
            Matlab.this = Matlab.this;
            this.fObserver = completionObserver;
            mWLooper.addHandler((MWHandler)this);
        }

        protected void messageReceived(MWMessage mWMessage) {
            if (mWMessage.getType() == -2 && this.fObserver != null) {
                Object object = mWMessage.findData(Matlab.RESULT_STR, class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = Matlab.class$("java.lang.Object")));
                Integer n = (Integer)mWMessage.findData(Matlab.STATUS_STR, class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = Matlab.class$("java.lang.Integer")));
                int n2 = 0;
                if (n != null) {
                    n2 = n;
                }
                this.fObserver.completed(n2, object);
            }
            this.getLooper().removeHandler((MWHandler)this);
        }
    }

    private class InterestHandler
    extends MWHandler {
        private CompletionObserver fObserver;
        private int fInterestID;
        private boolean fHaveID = false;

        InterestHandler(MWLooper mWLooper, CompletionObserver completionObserver) {
            Matlab.this = Matlab.this;
            this.fObserver = completionObserver;
            mWLooper.addHandler((MWHandler)this);
        }

        protected void messageReceived(MWMessage mWMessage) {
            if (mWMessage.getType() == -10) {
                if (!this.fHaveID) {
                    this.fHaveID = true;
                    Integer n = (Integer)mWMessage.findData(Matlab.INTEREST_STR, class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = Matlab.class$("java.lang.Integer")));
                    if (n != null) {
                        this.fInterestID = n;
                    }
                }
                this.fObserver.completed(0, mWMessage);
            }
        }

        int getInterestID() {
            return this.fInterestID;
        }
    }

    private class CompletionLooper
    extends MWLooper {
        private CompletionObserver fObserver;

        CompletionLooper(CompletionObserver completionObserver) {
            Matlab.this = Matlab.this;
            this.fObserver = completionObserver;
            this.start();
        }

        protected void messageReceived(MWMessage mWMessage) {
            if (mWMessage.getType() == -2 && this.fObserver != null) {
                Object object = mWMessage.findData(Matlab.RESULT_STR, class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = Matlab.class$("java.lang.Object")));
                Integer n = (Integer)mWMessage.findData(Matlab.STATUS_STR, class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = Matlab.class$("java.lang.Integer")));
                int n2 = 0;
                if (n != null) {
                    n2 = n;
                }
                this.fObserver.completed(n2, object);
            }
            this.quit();
        }
    }

    private class StreamLooper
    extends MWLooper {
        private CompletionObserver fObserver;

        StreamLooper(CompletionObserver completionObserver) {
            Matlab.this = Matlab.this;
            this.fObserver = completionObserver;
            this.start();
        }

        protected void messageReceived(MWMessage mWMessage) {
            if (mWMessage.getType() == -2 && this.fObserver != null) {
                Object object = mWMessage.findData(Matlab.RESULT_STR, class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = Matlab.class$("java.lang.Object")));
                Integer n = (Integer)mWMessage.findData(Matlab.STATUS_STR, class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = Matlab.class$("java.lang.Integer")));
                int n2 = 0;
                if (n != null) {
                    n2 = n;
                }
                this.fObserver.completed(n2, object);
                if (Matlab.getExecutionStatus(n2) != 33) {
                    this.quit();
                }
            }
        }
    }
}

